/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class BMC_Manage
extends JPanel {
    boolean bLoaded = false;
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    JLabel Message;
    CSession Session;
    int TabId;
    UDPSocket udpSocket;
    int ServerCount = 0;
    int iNumRec = 0;
    String[][] SNMPServers;
    String[] ColumnHead = new String[]{"IP Address", "MAC Address"};
    int[] BRate = new int[]{4800, 9600, 19200, 38400, 57600, 115200};
    String[] BKSetting = new String[2];
    String[][] BKSNMPServers;
    String BKCommunity;
    String BKSMTPServer;
    boolean[] RWChangable = new boolean[2];
    boolean AnyChangableSNMP = false;
    String IPAddress;
    String MACAddress;
    String NetMask;
    String Gateway;
    String GWMAC;
    private JPanel jPanel5;
    private JLabel jLabel4;
    private JTextField jIPAddress;
    private JLabel jLabel5;
    private JTextField jMACAddress;
    private JLabel jLabel6;
    private JTextField jNetMask;
    private JLabel jLabel7;
    private JTextField jGateway;
    private JLabel jLabel8;
    private JTextField jGWMAC;
    private JButton jUpdateLAN;
    private JLabel jLabel10;
    private JPanel jALERT;
    private JButton jUpdateSNMP;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField jCommunity;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JTable jSNMPTable;
    private JPanel jPanel2;
    private JPanel jRS232;
    private JLabel jLabel3;
    private JComboBox jComboBox1;
    private JLabel jLabel9;
    private JTextField jPPPInit;
    private JButton jUpdateRS232;
    private JPanel jPanel3;
    private JButton jRefresh;
    TableModel dataModel = new AbstractTableModel(){

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return 10;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return BMC_Manage.this.SNMPServers[row][col];
        }

        @Override
        public String getColumnName(int column) {
            return BMC_Manage.this.ColumnHead[column];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            byte[] macadd;
            if (column == 1 && ((String)aValue).length() > 0 && ((macadd = ((String)aValue).getBytes())[2] != 58 || macadd[5] != 58 || macadd[8] != 58 || macadd[11] != 58 || macadd[14] != 58)) {
                JOptionPane MBox = new JOptionPane();
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), "MAC address must be \"XX:XX:XX:XX:XX:XX\" format");
                return;
            }
            BMC_Manage.this.SNMPServers[row][column] = (String)aValue;
        }
    };

    public BMC_Manage() {
        this.initComponents();
        for (int j = 0; j < this.BRate.length; ++j) {
            this.jComboBox1.insertItemAt(new String(this.BRate[j] + ""), j);
        }
        this.jScrollPane1.setVisible(false);
    }

    public void preset(UDPSocket xSocket, CSession iSession, JLabel xMessage) {
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
        if (this.bLoaded) {
            this.Session.Loading = -1;
            return;
        }
        this.TabId = iSession.Loading;
        this.reload();
        this.bLoaded = true;
        this.Session.Loading = -1;
    }

    public void setXMessgage(JLabel message) {
        this.Message = message;
    }

    private void GetLANConfiguration() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{0, 3, 0};
        int[] length = new int[1];
        boolean intTemp = false;
        byte[] ParaSeq = new byte[]{3, 5, 6, 12, 13};
        Vector<byte[]> Para = new Vector<byte[]>(1);
        for (int i = 0; i < ParaSeq.length; ++i) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            reqdata[1] = ParaSeq[i];
            Para.addElement(reqdata);
            this.SIP = this.Session.SIP;
            switch (ParaSeq[i]) {
                case 3: {
                    this.Message.setText("Getting LAN Configuration: IP Address");
                    break;
                }
                case 5: {
                    this.Message.setText("Getting LAN Configuration: MAC Address");
                    break;
                }
                case 6: {
                    this.Message.setText("Getting LAN Configuration: Subnet Mask");
                    break;
                }
                case 12: {
                    this.Message.setText("Getting LAN Configuration: Default Gateway Address");
                    break;
                }
                case 13: {
                    this.Message.setText("Getting LAN Configuration: Default Gateway MAC Address");
                }
            }
            this.rmcpPacket.RMCPSetup((byte)7, (byte)48, (byte)2, (byte)0, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Session.IncreaseSessionSeq();
                    byte[] BMCIP = (byte[])this.rmcpPacket.retValue.get(1);
                    switch (ParaSeq[i]) {
                        case 3: {
                            this.IPAddress = (BMCIP[3] & 0xFF) + "." + (BMCIP[2] & 0xFF) + "." + (BMCIP[1] & 0xFF) + "." + (BMCIP[0] & 0xFF);
                            this.jIPAddress.setText(this.IPAddress);
                            this.Message.setText("Getting LAN Configuration succeeded: IP Address");
                            break;
                        }
                        case 5: {
                            this.MACAddress = this.ByteToMAC(BMCIP, 0);
                            this.jMACAddress.setText(this.MACAddress);
                            this.Message.setText("Getting LAN Configuration succeeded: MAC Address");
                            break;
                        }
                        case 6: {
                            this.NetMask = (BMCIP[3] & 0xFF) + "." + (BMCIP[2] & 0xFF) + "." + (BMCIP[1] & 0xFF) + "." + (BMCIP[0] & 0xFF);
                            this.jNetMask.setText(this.NetMask);
                            this.Message.setText("Getting LAN Configuration succeeded: Subnet Mask");
                            break;
                        }
                        case 12: {
                            this.Gateway = (BMCIP[3] & 0xFF) + "." + (BMCIP[2] & 0xFF) + "." + (BMCIP[1] & 0xFF) + "." + (BMCIP[0] & 0xFF);
                            this.jGateway.setText(this.Gateway);
                            this.Message.setText("Getting LAN Configuration succeeded: Default Gateway Address");
                            break;
                        }
                        case 13: {
                            this.GWMAC = this.ByteToMAC(BMCIP, 0);
                            this.jGWMAC.setText(this.GWMAC);
                            this.Message.setText("Getting LAN Configuration succeeded: Default Gateway MAC Address");
                        }
                    }
                } else {
                    switch (ParaSeq[i]) {
                        case 3: {
                            this.Message.setText("Getting LAN Configuration failed: IP Address");
                            break;
                        }
                        case 5: {
                            this.Message.setText("Getting LAN Configuration failed: MAC Address");
                            break;
                        }
                        case 6: {
                            this.Message.setText("Getting LAN Configuration failed: Subnet Mask");
                            break;
                        }
                        case 12: {
                            this.Message.setText("Getting LAN Configuration failed: Default Gateway Address");
                            break;
                        }
                        case 13: {
                            this.Message.setText("Getting LAN Configuration failed: Default Gateway MAC Address");
                        }
                    }
                }
            } else {
                switch (ParaSeq[i]) {
                    case 3: {
                        this.Message.setText("Getting LAN Configuration failed: IP Address");
                        break;
                    }
                    case 5: {
                        this.Message.setText("Getting LAN Configuration failed: MAC Address");
                        break;
                    }
                    case 6: {
                        this.Message.setText("Getting LAN Configuration failed: Subnet Mask");
                        break;
                    }
                    case 12: {
                        this.Message.setText("Getting LAN Configuration failed: Default Gateway Address");
                        break;
                    }
                    case 13: {
                        this.Message.setText("Getting LAN Configuration failed: Default Gateway MAC Address");
                    }
                }
            }
            this.Session.releaselock();
        }
    }

    private void GetSNMPConfiguration() {
        byte[] BMCIP;
        int i;
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{0, 3, 0};
        int[] length = new int[1];
        boolean intTemp = false;
        byte[] ParaSeq = new byte[]{16, 17};
        Vector<byte[]> Para = new Vector<byte[]>(1);
        this.iNumRec = 0;
        for (i = 0; i < ParaSeq.length; ++i) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            reqdata[1] = ParaSeq[i];
            Para.addElement(reqdata);
            this.SIP = this.Session.SIP;
            switch (ParaSeq[i]) {
                case 16: {
                    this.Message.setText("Getting LAN Configuration: SNMP Community");
                    break;
                }
                case 17: {
                    this.Message.setText("Getting LAN Configuration: Number of SNMP Alerting Destinations");
                }
            }
            this.rmcpPacket.RMCPSetup((byte)7, (byte)48, (byte)2, (byte)0, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Session.IncreaseSessionSeq();
                    BMCIP = (byte[])this.rmcpPacket.retValue.get(1);
                    switch (ParaSeq[i]) {
                        case 16: {
                            ByteArrayOutputStream strout = new ByteArrayOutputStream();
                            strout.write(BMCIP, 0, BMCIP.length);
                            this.jCommunity.setText(strout.toString().trim());
                            this.BKCommunity = strout.toString();
                            this.Message.setText("Getting LAN Configuration succeeded: SNMP Community");
                            break;
                        }
                        case 17: {
                            this.iNumRec = BMCIP[0] & 0xF;
                            this.Message.setText("Getting LAN Configuration succeeded: Number of SNMP Alerting Destinations");
                        }
                    }
                } else {
                    switch (ParaSeq[i]) {
                        case 16: {
                            this.Message.setText("Getting LAN Configuration failed: SNMP Community");
                            break;
                        }
                        case 17: {
                            this.Message.setText("Getting LAN Configuration failed: Number of SNMP Alerting Destinations");
                        }
                    }
                }
            } else {
                switch (ParaSeq[i]) {
                    case 16: {
                        this.Message.setText("Getting LAN Configuration failed: SNMP Community");
                        break;
                    }
                    case 17: {
                        this.Message.setText("Getting LAN Configuration failed: Number of SNMP Alerting Destinations");
                    }
                }
            }
            this.Session.releaselock();
        }
        this.SNMPServers = new String[10][2];
        this.BKSNMPServers = new String[10][2];
        for (i = 0; i < 10; ++i) {
            this.SNMPServers[i][0] = "";
            this.SNMPServers[i][1] = "";
            this.BKSNMPServers[i][0] = "";
            this.BKSNMPServers[i][1] = "";
        }
        int j = 0;
        for (i = 0; i < this.iNumRec; ++i) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            reqdata[1] = 19;
            reqdata[2] = (byte)(i & 0xFF);
            Para.addElement(reqdata);
            this.SIP = this.Session.SIP;
            this.Message.setText("Getting LAN Configuration: SNMP Alerting Destinations (" + (i + 1) + ")");
            this.rmcpPacket.RMCPSetup((byte)7, (byte)48, (byte)2, (byte)0, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Session.IncreaseSessionSeq();
                    this.Message.setText("Getting LAN Configuration succeeded: SNMP Alerting Destinations (" + (i + 1) + ")");
                    BMCIP = (byte[])this.rmcpPacket.retValue.get(1);
                    if (BMCIP[0] + BMCIP[1] + BMCIP[2] + BMCIP[3] + BMCIP[4] + BMCIP[5] + BMCIP[6] + BMCIP[7] + BMCIP[8] + BMCIP[9] + BMCIP[10] != 0) {
                        String xxt;
                        this.SNMPServers[j][0] = xxt = (BMCIP[6] & 0xFF) + "." + (BMCIP[5] & 0xFF) + "." + (BMCIP[4] & 0xFF) + "." + (BMCIP[3] & 0xFF);
                        this.BKSNMPServers[j][0] = xxt;
                        this.SNMPServers[j][1] = xxt = this.ByteToMAC(BMCIP, 7);
                        this.BKSNMPServers[j][1] = xxt;
                        ++j;
                    }
                } else {
                    this.Message.setText("Getting LAN Configuration failed: SNMP Alerting Destinations (" + (i + 1) + ")");
                }
            } else {
                this.Message.setText("Getting LAN Configuration failed: SNMP Alerting Destinations (" + (i + 1) + ")");
            }
            this.Session.releaselock();
        }
        String[] toolTipStr = new String[]{"SNMP trap receiver's IP address", "SNMP trap receiver's MAC address"};
        this.jSNMPTable = new JTable(this.SNMPServers, this.ColumnHead);
        this.jSNMPTable.setAutoResizeMode(0);
        this.jSNMPTable.setModel(this.dataModel);
        this.jScrollPane1.setVisible(true);
        ToolTipHeader header = new ToolTipHeader(this.jSNMPTable.getColumnModel());
        header.setToolTipStrings(toolTipStr);
        header.setToolTipText("Default ToolTip TEXT");
        this.jSNMPTable.setTableHeader(header);
        TableColumn tc = this.jSNMPTable.getColumn("IP Address");
        tc.setPreferredWidth(120);
        tc = this.jSNMPTable.getColumn("MAC Address");
        tc.setPreferredWidth(140);
        this.jSNMPTable.setFont(new Font("Courier New", 0, 12));
        this.jSNMPTable.setForeground(Color.blue);
        this.jScrollPane1.setViewportView(this.jSNMPTable);
    }

    private void SetLANConfiguration(byte Selector, byte[] value) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{0, 0};
        int[] length = new int[1];
        boolean intTemp = false;
        boolean iNumRec = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        this.Session.lockout();
        Para.removeAllElements();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        reqdata[1] = Selector;
        Para.addElement(reqdata);
        Para.addElement(value);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)48, (byte)1, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
            }
        }
        this.Session.releaselock();
    }

    private boolean LongAsciiCmd(String Keyword) {
        Vector[] retValue = new Vector[1];
        boolean bFirst = true;
        boolean bResult = false;
        int offset = 0;
        while (Keyword.length() > 0) {
            if (Keyword.length() > 36) {
                String tempString = Keyword.substring(0, 36);
                bResult = bFirst ? this._LongAsciiCmd(tempString, bFirst, false, Keyword.length()) : this._LongAsciiCmd(tempString, bFirst, false, offset);
                Keyword = Keyword.substring(36);
                offset += 36;
                bFirst = false;
                continue;
            }
            bResult = this._LongAsciiCmd(Keyword, bFirst, true, offset);
            Keyword = "";
        }
        return bResult;
    }

    private boolean _LongAsciiCmd(String Keyword, boolean bFirst, boolean bLast, int length_offset) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        int stroutlen = Keyword.length();
        byte[] cmddata = new byte[stroutlen + 2];
        cmddata[0] = (byte)(length_offset >> 8 & 0xFFF);
        cmddata[0] = (byte)(cmddata[0] | (byte)((bFirst ? 128 : 0) | (bLast ? 64 : 0)));
        cmddata[1] = (byte)(length_offset & 0xFFFFFFFF);
        System.arraycopy(Keyword.getBytes(), 0, cmddata, 2, stroutlen);
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(cmddata);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)48, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean LongAsciiCmdGo(Vector retValue) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Vector retTemp = new Vector(1);
        boolean bResult = false;
        String retString = "";
        byte[] cmddata = new byte[]{0, 0};
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(cmddata);
        this.SIP = this.Session.SIP;
        byte retbyte = 0;
        do {
            this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)48, (byte)0, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Session.IncreaseSessionSeq();
                    retTemp = this.rmcpPacket.retValue;
                    bResult = true;
                }
                byte[] retbytes = (byte[])retTemp.get(0);
                retbyte = retbytes[0];
                retString = retString + (String)retTemp.get(1);
            }
            cmddata[0] = (byte)(cmddata[0] | (byte)(retString.length() >> 8 & 0xFFFFFFFF));
            cmddata[1] = (byte)(retString.length() & 0xFFFFFFFF);
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(cmddata);
        } while ((retbyte & 0x40) == 0);
        this.Session.releaselock();
        cmddata[0] = (byte)(retString.length() >> 8 & 0xFFFFFFFF);
        cmddata[1] = (byte)(retString.length() & 0xFFFFFFFF);
        retValue.removeAllElements();
        retValue.addElement(cmddata);
        retValue.addElement(retString);
        return bResult;
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jIPAddress = new JTextField();
        this.jLabel5 = new JLabel();
        this.jMACAddress = new JTextField();
        this.jLabel6 = new JLabel();
        this.jNetMask = new JTextField();
        this.jLabel7 = new JLabel();
        this.jGateway = new JTextField();
        this.jLabel8 = new JLabel();
        this.jGWMAC = new JTextField();
        this.jUpdateLAN = new JButton();
        this.jLabel10 = new JLabel();
        this.jALERT = new JPanel();
        this.jUpdateSNMP = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jCommunity = new JTextField();
        this.jPanel6 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jSNMPTable = new JTable();
        this.jPanel2 = new JPanel();
        this.jRS232 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel9 = new JLabel();
        this.jPPPInit = new JTextField();
        this.jUpdateRS232 = new JButton();
        this.jPanel3 = new JPanel();
        this.jRefresh = new JButton();
        this.setLayout(new GridLayout(3, 0));
        this.jPanel5.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel5.setBorder(new TitledBorder("BMC LAN Configuration"));
        this.jLabel4.setText("IP Address");
        this.jLabel4.setHorizontalAlignment(4);
        this.jPanel5.add((Component)this.jLabel4, new AbsoluteConstraints(12, 30, 80, -1));
        this.jIPAddress.setForeground(Color.blue);
        this.jPanel5.add((Component)this.jIPAddress, new AbsoluteConstraints(100, 30, 110, -1));
        this.jLabel5.setText("LAN MAC");
        this.jLabel5.setHorizontalAlignment(4);
        this.jPanel5.add((Component)this.jLabel5, new AbsoluteConstraints(230, 30, 80, -1));
        this.jMACAddress.setForeground(Color.blue);
        this.jPanel5.add((Component)this.jMACAddress, new AbsoluteConstraints(320, 30, 110, -1));
        this.jLabel6.setText("Subnet Mask");
        this.jLabel6.setHorizontalAlignment(4);
        this.jPanel5.add((Component)this.jLabel6, new AbsoluteConstraints(10, 90, 80, -1));
        this.jNetMask.setForeground(Color.blue);
        this.jPanel5.add((Component)this.jNetMask, new AbsoluteConstraints(100, 90, 110, -1));
        this.jLabel7.setText("Gateway IP");
        this.jLabel7.setHorizontalAlignment(4);
        this.jPanel5.add((Component)this.jLabel7, new AbsoluteConstraints(10, 60, 80, -1));
        this.jGateway.setForeground(Color.blue);
        this.jPanel5.add((Component)this.jGateway, new AbsoluteConstraints(100, 60, 110, -1));
        this.jLabel8.setText("Gateway MAC");
        this.jLabel8.setHorizontalAlignment(4);
        this.jPanel5.add((Component)this.jLabel8, new AbsoluteConstraints(230, 60, 80, -1));
        this.jGWMAC.setForeground(Color.blue);
        this.jPanel5.add((Component)this.jGWMAC, new AbsoluteConstraints(320, 60, 110, -1));
        this.jUpdateLAN.setText("Update");
        this.jUpdateLAN.setEnabled(false);
        this.jUpdateLAN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BMC_Manage.this.jUpdateLANActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.jUpdateLAN, new AbsoluteConstraints(460, 30, -1, -1));
        this.jLabel10.setText("LAN MAC must be correct while update");
        this.jLabel10.setForeground(Color.magenta);
        this.jLabel10.setBackground(Color.white);
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setBorder(new EtchedBorder());
        this.jLabel10.setOpaque(true);
        this.jPanel5.add((Component)this.jLabel10, new AbsoluteConstraints(220, 90, 260, -1));
        this.add(this.jPanel5);
        this.jALERT.setLayout((LayoutManager)new AbsoluteLayout());
        this.jALERT.setBorder(new TitledBorder("SNMP"));
        this.jUpdateSNMP.setText("Update");
        this.jUpdateSNMP.setEnabled(false);
        this.jUpdateSNMP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BMC_Manage.this.jUpdateSNMPActionPerformed(evt);
            }
        });
        this.jALERT.add((Component)this.jUpdateSNMP, new AbsoluteConstraints(460, 20, -1, -1));
        this.jLabel1.setText("Community");
        this.jLabel1.setHorizontalAlignment(4);
        this.jALERT.add((Component)this.jLabel1, new AbsoluteConstraints(30, 20, 120, -1));
        this.jLabel2.setText("SNMP Trap Receivers");
        this.jLabel2.setHorizontalAlignment(4);
        this.jALERT.add((Component)this.jLabel2, new AbsoluteConstraints(30, 50, -1, -1));
        this.jCommunity.setForeground(Color.blue);
        this.jALERT.add((Component)this.jCommunity, new AbsoluteConstraints(170, 20, 150, -1));
        this.jPanel6.setLayout(new FlowLayout(0));
        this.jScrollPane1.setPreferredSize(new Dimension(278, 96));
        this.jSNMPTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}){
            Class[] types;
            {
                this.types = new Class[]{Object.class, Object.class, Object.class, Object.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jSNMPTable.setForeground(Color.blue);
        this.jSNMPTable.setFont(new Font("Courier New", 0, 12));
        this.jSNMPTable.setPreferredSize(new Dimension(210, 70));
        this.jSNMPTable.setPreferredScrollableViewportSize(new Dimension(210, 160));
        this.jScrollPane1.setViewportView(this.jSNMPTable);
        this.jPanel6.add(this.jScrollPane1);
        this.jALERT.add((Component)this.jPanel6, new AbsoluteConstraints(160, 50, 285, 100));
        this.add(this.jALERT);
        this.jPanel2.setLayout(new BorderLayout());
        this.jRS232.setLayout((LayoutManager)new AbsoluteLayout());
        this.jRS232.setBorder(new TitledBorder("RS232 / MODEM"));
        this.jLabel3.setText("Baud Rate");
        this.jLabel3.setHorizontalAlignment(4);
        this.jRS232.add((Component)this.jLabel3, new AbsoluteConstraints(40, 40, 120, -1));
        this.jComboBox1.setBackground(Color.white);
        this.jRS232.add((Component)this.jComboBox1, new AbsoluteConstraints(170, 40, 130, -1));
        this.jLabel9.setText("Modem Init String");
        this.jLabel9.setHorizontalAlignment(4);
        this.jRS232.add((Component)this.jLabel9, new AbsoluteConstraints(40, 80, 120, -1));
        this.jRS232.add((Component)this.jPPPInit, new AbsoluteConstraints(170, 80, 130, -1));
        this.jUpdateRS232.setText("Update");
        this.jUpdateRS232.setEnabled(false);
        this.jUpdateRS232.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BMC_Manage.this.jUpdateRS232ActionPerformed(evt);
            }
        });
        this.jRS232.add((Component)this.jUpdateRS232, new AbsoluteConstraints(460, 40, -1, -1));
        this.jPanel2.add((Component)this.jRS232, "Center");
        this.jRefresh.setText("Refresh");
        this.jRefresh.setEnabled(false);
        this.jRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BMC_Manage.this.jRefreshActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jRefresh);
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.add(this.jPanel2);
    }

    private void jUpdateRS232ActionPerformed(ActionEvent evt) {
        String[] cmd = new String[]{"BAUDRATE", "PPP_INIT"};
        Vector retValue = new Vector(1);
        this.Session.Loading = this.TabId;
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        for (int i = 0; i < cmd.length; ++i) {
            String xxs = "";
            switch (i) {
                case 0: {
                    int seli = this.jComboBox1.getSelectedIndex();
                    xxs = "0x" + Integer.toHexString(this.BRate[seli]);
                    break;
                }
                case 1: {
                    xxs = this.jPPPInit.getText();
                }
            }
            if (xxs.compareTo(this.BKSetting[i]) == 0) continue;
            String strout = "propset\u0007" + cmd[i] + '\u0007' + xxs + '\u0007';
            if (this.LongAsciiCmd(strout)) {
                this.LongAsciiCmdGo(retValue);
            }
            this.BKSetting[i] = xxs;
        }
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        this.Message.setText("RS232 Information Update done");
        this.Session.Loading = -1;
    }

    private void jUpdateSNMPActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            @Override
            public void run() {
                boolean length = false;
                boolean prindex = false;
                boolean lastpacket = false;
                boolean parseStatus = false;
                BMC_Manage.this.Session.Loading = BMC_Manage.this.TabId;
                Cursor csrTemp = new Cursor(3);
                BMC_Manage.this.setCursor(csrTemp);
                boolean Changed = false;
                Vector[] retValue = new Vector[1];
                String strout = new String();
                if (BMC_Manage.this.jCommunity.getText().compareTo(BMC_Manage.this.BKCommunity) != 0) {
                    byte[] value = new byte[18];
                    System.arraycopy(BMC_Manage.this.jCommunity.getText().getBytes(), 0, value, 0, BMC_Manage.this.jCommunity.getText().length());
                    BMC_Manage.this.SetLANConfiguration((byte)16, value);
                    Changed = true;
                }
                byte[] value1 = new byte[13];
                for (int i = 0; i < BMC_Manage.this.iNumRec; ++i) {
                    if (BMC_Manage.this.SNMPServers[i][0].compareTo(BMC_Manage.this.BKSNMPServers[i][0]) == 0 && BMC_Manage.this.SNMPServers[i][1].compareTo(BMC_Manage.this.BKSNMPServers[i][1]) == 0) continue;
                    value1[0] = (byte)(i & 0xF);
                    value1[2] = 0;
                    value1[1] = 0;
                    String IPx = (String)BMC_Manage.this.jSNMPTable.getValueAt(i, 0);
                    System.arraycopy(BMC_Manage.this.IPToByte(IPx), 0, value1, 3, 4);
                    String MACx = (String)BMC_Manage.this.jSNMPTable.getValueAt(i, 1);
                    System.arraycopy(BMC_Manage.this.MACToByte(MACx), 0, value1, 7, 6);
                    BMC_Manage.this.SetLANConfiguration((byte)19, value1);
                    Changed = true;
                }
                csrTemp = new Cursor(0);
                BMC_Manage.this.setCursor(csrTemp);
                if (Changed) {
                    BMC_Manage.this.reloadSNMPCfg();
                }
                BMC_Manage.this.Session.Loading = -1;
            }
        };
        th.start();
    }

    private void jUpdateLANActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            @Override
            public void run() {
                byte[] value;
                boolean length = false;
                boolean prindex = false;
                boolean lastpacket = false;
                boolean parseStatus = false;
                BMC_Manage.this.Session.Loading = BMC_Manage.this.TabId;
                Cursor csrTemp = new Cursor(3);
                BMC_Manage.this.setCursor(csrTemp);
                boolean Changed = false;
                if (BMC_Manage.this.jMACAddress.getText().compareTo(BMC_Manage.this.MACAddress) != 0) {
                    BMC_Manage.this.Message.setText("Changing LAN MAC Address in BMC");
                    value = new byte[6];
                    System.arraycopy(BMC_Manage.this.MACToByte(BMC_Manage.this.jMACAddress.getText()), 0, value, 0, 6);
                    BMC_Manage.this.SetLANConfiguration((byte)5, value);
                    Changed = true;
                    BMC_Manage.this.Message.setText("Changing LAN MAC Address in BMC, done");
                }
                if (BMC_Manage.this.jIPAddress.getText().compareTo(BMC_Manage.this.IPAddress) != 0) {
                    BMC_Manage.this.Message.setText("Changing LAN IP Address in BMC");
                    value = new byte[4];
                    System.arraycopy(BMC_Manage.this.IPToByte(BMC_Manage.this.jIPAddress.getText()), 0, value, 0, 4);
                    BMC_Manage.this.SetLANConfiguration((byte)3, value);
                    Changed = true;
                    BMC_Manage.this.Message.setText("Changing LAN IP Address in BMC, done");
                }
                if (BMC_Manage.this.jNetMask.getText().compareTo(BMC_Manage.this.NetMask) != 0) {
                    BMC_Manage.this.Message.setText("Changing LAN Netmask in BMC");
                    value = new byte[4];
                    System.arraycopy(BMC_Manage.this.IPToByte(BMC_Manage.this.jNetMask.getText()), 0, value, 0, 4);
                    BMC_Manage.this.SetLANConfiguration((byte)6, value);
                    Changed = true;
                    BMC_Manage.this.Message.setText("Changing LAN Netmask in BMC, done");
                }
                if (BMC_Manage.this.jGateway.getText().compareTo(BMC_Manage.this.Gateway) != 0) {
                    BMC_Manage.this.Message.setText("Changing LAN Default Gateway in BMC");
                    value = new byte[4];
                    System.arraycopy(BMC_Manage.this.IPToByte(BMC_Manage.this.jGateway.getText()), 0, value, 0, 4);
                    BMC_Manage.this.SetLANConfiguration((byte)12, value);
                    Changed = true;
                    BMC_Manage.this.Message.setText("Changing LAN Default Gateway in BMC, done");
                }
                if (BMC_Manage.this.jGWMAC.getText().compareTo(BMC_Manage.this.GWMAC) != 0) {
                    BMC_Manage.this.Message.setText("Changing LAN Default Gateway MAC Address in BMC");
                    value = new byte[6];
                    System.arraycopy(BMC_Manage.this.MACToByte(BMC_Manage.this.jGWMAC.getText()), 0, value, 0, 6);
                    BMC_Manage.this.SetLANConfiguration((byte)13, value);
                    Changed = true;
                    BMC_Manage.this.Message.setText("Changing LAN Default Gateway MAC Address in BMC, done");
                }
                csrTemp = new Cursor(0);
                BMC_Manage.this.setCursor(csrTemp);
                if (Changed) {
                    BMC_Manage.this.reloadLanCfg();
                }
                BMC_Manage.this.Session.Loading = -1;
            }
        };
        th.start();
    }

    private void jRefreshActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            @Override
            public void run() {
                BMC_Manage.this.reload();
            }
        };
        th.start();
    }

    private void reloadLanCfg() {
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        this.Message.setText("Loading LAN Configuration Information");
        this.AnyChangableSNMP = false;
        this.IPAddress = "";
        this.MACAddress = "";
        this.NetMask = "";
        this.Gateway = "";
        this.GWMAC = "";
        this.GetLANConfiguration();
        this.Message.setText("Loading LAN Configuration Information done");
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
    }

    private void reloadSNMPCfg() {
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        this.Message.setText("Loading SNMP Information");
        this.BKSMTPServer = "";
        this.BKCommunity = "";
        this.RWChangable[0] = false;
        this.RWChangable[1] = false;
        this.GetSNMPConfiguration();
        this.Message.setText("Loading SNMP Information done");
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
    }

    private void reloadRS232() {
        Cursor csrTemp;
        block21: {
            block18: {
                block19: {
                    int i;
                    String[] cmd = new String[]{"propget", "BAUDRATE", "PPP_INIT"};
                    Vector retValue = new Vector(1);
                    csrTemp = new Cursor(3);
                    this.setCursor(csrTemp);
                    this.Message.setText("Loading RS232 Information");
                    String strout = "";
                    for (i = 0; i < cmd.length; ++i) {
                        strout = strout + cmd[i] + '\u0007';
                    }
                    if (!this.LongAsciiCmd(strout)) break block18;
                    if (!this.LongAsciiCmdGo(retValue)) break block19;
                    byte[] retbytes = (byte[])retValue.get(0);
                    String retString = (String)retValue.get(1);
                    int length = retString.length();
                    int prindex = 0;
                    int parseStatus = 0;
                    while (prindex < length) {
                        int ipos;
                        block20: {
                            ipos = retString.indexOf(7, prindex);
                            if (ipos < 0) break block20;
                            String tempString = retString.substring(prindex, ipos);
                            switch (parseStatus) {
                                case 0: {
                                    for (i = 0; i < cmd.length; ++i) {
                                        if (tempString.compareTo(cmd[i]) != 0) continue;
                                        parseStatus = i + 1;
                                    }
                                    break;
                                }
                                case 1: {
                                    parseStatus = 0;
                                    break;
                                }
                                case 2: {
                                    boolean AnyChangable;
                                    if (tempString.compareTo("RW") == 0) {
                                        AnyChangable = true;
                                        this.jComboBox1.setEnabled(true);
                                    } else {
                                        this.jComboBox1.setEnabled(false);
                                    }
                                    parseStatus = 21;
                                    break;
                                }
                                case 21: {
                                    long l = 0L;
                                    try {
                                        l = Long.parseLong(tempString.substring(2), 16);
                                        for (int kk = 0; kk < this.BRate.length; ++kk) {
                                            if ((long)this.BRate[kk] != l) continue;
                                            this.jComboBox1.setSelectedIndex(kk);
                                            break;
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        // empty catch block
                                    }
                                    this.BKSetting[parseStatus / 10 - 2] = tempString;
                                    parseStatus = 0;
                                    break;
                                }
                                case 3: {
                                    boolean AnyChangable;
                                    if (tempString.compareTo("RW") == 0) {
                                        AnyChangable = true;
                                        this.jPPPInit.setEditable(true);
                                    } else {
                                        this.jPPPInit.setEditable(false);
                                    }
                                    parseStatus = 31;
                                    break;
                                }
                                case 31: {
                                    this.jPPPInit.setText(tempString);
                                    this.BKSetting[parseStatus / 10 - 2] = tempString;
                                    parseStatus = 0;
                                }
                            }
                        }
                        prindex = ipos + 1;
                    }
                    this.Message.setText("Loading RS232 Information done");
                    break block21;
                }
                this.Message.setText("Loading RS232 Information failed");
                break block21;
            }
            this.Message.setText("Loading RS232 Information failed");
        }
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
    }

    private void reload() {
        this.Session.Loading = this.TabId;
        Thread th = new Thread(){

            @Override
            public void run() {
                BMC_Manage.this.jUpdateLAN.setEnabled(false);
                BMC_Manage.this.jUpdateSNMP.setEnabled(false);
                BMC_Manage.this.jUpdateRS232.setEnabled(false);
                BMC_Manage.this.jRefresh.setEnabled(false);
            }
        };
        th.start();
        this.reloadLanCfg();
        this.reloadSNMPCfg();
        this.reloadRS232();
        th = new Thread(){

            @Override
            public void run() {
                BMC_Manage.this.jUpdateLAN.setEnabled(true);
                BMC_Manage.this.jUpdateSNMP.setEnabled(true);
                BMC_Manage.this.jUpdateRS232.setEnabled(true);
                BMC_Manage.this.jRefresh.setEnabled(true);
                BMC_Manage.this.Message.setText("Loading BMC Setting Information done");
            }
        };
        th.start();
        this.Session.Loading = -1;
    }

    private String ByteToMAC(byte[] macbyte, int offset) {
        String xx = "";
        String xxs = "0" + Integer.toHexString(macbyte[offset + 5] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2) + ":";
        xxs = "0" + Integer.toHexString(macbyte[offset + 4] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2) + ":";
        xxs = "0" + Integer.toHexString(macbyte[offset + 3] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2) + ":";
        xxs = "0" + Integer.toHexString(macbyte[offset + 2] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2) + ":";
        xxs = "0" + Integer.toHexString(macbyte[offset + 1] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2) + ":";
        xxs = "0" + Integer.toHexString(macbyte[offset] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2);
        return xx;
    }

    private byte[] MACToByte(String MACx) {
        int i;
        byte[] xx = new byte[6];
        byte[] zz = new byte[17];
        if (MACx.length() == 0) {
            return xx;
        }
        String xxt = "";
        for (i = 0; i < 5; ++i) {
            xxt = xxt + MACx.substring(i * 3, i * 3 + 2);
        }
        xxt = xxt + MACx.substring(15);
        long l = 0L;
        try {
            l = Long.parseLong(xxt, 16);
        }
        catch (NumberFormatException e) {
            JOptionPane MBox = new JOptionPane();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Invalid character in MAC");
        }
        for (i = 0; i < 6; ++i) {
            xx[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return xx;
    }

    private byte[] IPToByte(String IPx) {
        byte[] xx = new byte[4];
        if (IPx.length() == 0) {
            return xx;
        }
        int yy = IPx.indexOf(46, 0);
        try {
            xx[3] = (byte)(Integer.parseInt(IPx.substring(0, yy).trim()) & 0xFF);
            int yy1 = IPx.indexOf(46, yy + 1);
            xx[2] = (byte)(Integer.parseInt(IPx.substring(yy + 1, yy1).trim()) & 0xFF);
            yy = yy1;
            yy1 = IPx.indexOf(46, yy + 1);
            xx[1] = (byte)(Integer.parseInt(IPx.substring(yy + 1, yy1).trim()) & 0xFF);
            yy = yy1;
            xx[0] = (byte)(Integer.parseInt(IPx.substring(yy1 + 1).trim()) & 0xFF);
        }
        catch (NumberFormatException ne) {
            JOptionPane MBox = new JOptionPane();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Invalid character in IP");
        }
        return xx;
    }

    class ToolTipHeader
    extends JTableHeader {
        String[] toolTips;

        public ToolTipHeader(TableColumnModel model) {
            super(model);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            String retStr;
            int col = this.columnAtPoint(e.getPoint());
            int modelCol = this.getTable().convertColumnIndexToModel(col);
            try {
                retStr = this.toolTips[modelCol];
            }
            catch (NullPointerException ex) {
                retStr = "";
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                retStr = "";
            }
            if (retStr.length() < 1) {
                retStr = super.getToolTipText(e);
            }
            return retStr;
        }

        public void setToolTipStrings(String[] toolTips) {
            this.toolTips = toolTips;
        }
    }
}

