/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CMMBladeSystemPanel;
import IPMIView20.CMMDebug;
import IPMIView20.CMMKVMPanel;
import IPMIView20.CMMLoginPanel;
import IPMIView20.CMMSOLPanel;
import IPMIView20.CMMSessionMessageBarPanel;
import IPMIView20.CMMSessionPanel_jTabbedPane_changeAdapter;
import IPMIView20.DeviceFile;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.ReducePowerProblem;
import IPMIView20.VirtualMedia;
import IPMIView20.blade.CMMConfigPanel;
import IPMIView20.blade.SELPanel;
import IPMIView20.blade.UserManagementPanel;
import IPMIView20.help.JavaHelpWrapper;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.DisconnectListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class CMMSessionPanel
extends JPanel
implements Observer,
DisconnectListener {
    JavaHelpWrapper helpWrapper;
    public boolean isDisconnect = false;
    String hostname;
    String ip;
    String description;
    String loginID;
    String loginPassword;
    JLabel xMessage;
    DeviceFile xDeviceFile;
    Icon alertIcon = new ImageIcon(this.getClass().getResource("/images/Trap-ani.gif"));
    Icon infoIcon = new ImageIcon(this.getClass().getResource("/images/excla_dim.gif"));
    Icon disconnectedIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_close_session.gif"));
    public BladeSystemEntity bladeSystemEntity = null;
    public IPMIInterfaceConfig ipmiInterfaceConfig = null;
    public CMMLoginPanel cmmLoginPanel = new CMMLoginPanel();
    public CMMBladeSystemPanel cmmBladeSystemPanel = null;
    public CMMSOLPanel cmmSOLPanel = null;
    public CMMKVMPanel cmmKVMPanel = null;
    public SELPanel selPanel = null;
    public UserManagementPanel userManagementPanel = null;
    public CMMConfigPanel cmmConfigPanel = null;
    public VirtualMedia virtualMediaPanel = null;
    public CMMSessionMessageBarPanel sessionMessageBarPanel = new CMMSessionMessageBarPanel();
    public String reduntantMessage = L.t("cmm.login.redundant2");
    private ReducePowerProblem reducePowerProblem;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jSouthPanel = new JPanel();
    JPanel jCenterPanel = new JPanel();
    JPanel jWestPanel = new JPanel();
    JPanel jNorthPanel = new JPanel();
    JTabbedPane jTabbedPane = new JTabbedPane();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jEastPanel = new JPanel();
    JPanel jDisconnectPanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jRedundantPanel = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JLabel jLabel2 = new JLabel();
    boolean virtualMediaPanelFirstPreset = false;
    JPanel jUnavailableConnectPanel = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    JLabel jLabel3 = new JLabel();
    boolean reInitalTabing = false;
    boolean tempIsMaster = false;
    boolean lastLogoutState = true;
    int count = 0;
    int disconnectCount = 0;
    boolean enterDisconnectPhase = false;

    public CMMSessionPanel(String hostname, String ip, String description, JLabel xMessage, DeviceFile xDeviceFile) {
        this.hostname = hostname;
        this.ip = ip;
        this.description = description;
        this.xMessage = xMessage;
        this.xDeviceFile = xDeviceFile;
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setDisconnectPanelVisible(boolean isVisible) {
        if (isVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CMMSessionPanel.this.remove(CMMSessionPanel.this.jCenterPanel);
                    CMMSessionPanel.this.add((Component)CMMSessionPanel.this.jUnavailableConnectPanel, "Center");
                    CMMSessionPanel.this.jDisconnectPanel.setVisible(true);
                    CMMSessionPanel.this.cmmBladeSystemPanel.hideAllOutOfWindows();
                    CMMSessionPanel.this.invalidate();
                    CMMSessionPanel.this.validate();
                    CMMSessionPanel.this.jUnavailableConnectPanel.repaint();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CMMSessionPanel.this.remove(CMMSessionPanel.this.jUnavailableConnectPanel);
                    CMMSessionPanel.this.add((Component)CMMSessionPanel.this.jCenterPanel, "Center");
                    CMMSessionPanel.this.jDisconnectPanel.setVisible(false);
                    CMMSessionPanel.this.cmmBladeSystemPanel.showAllOutOfWindows();
                    CMMSessionPanel.this.invalidate();
                    CMMSessionPanel.this.validate();
                    CMMSessionPanel.this.jCenterPanel.repaint();
                }
            });
        }
    }

    public void setReduntantPanelVisible(boolean isVisible) {
        if (isVisible) {
            this.sessionMessageBarPanel.setOnlyMessage(true);
            this.sessionMessageBarPanel.setIcon(1);
            this.sessionMessageBarPanel.setMessage(this.reduntantMessage);
            this.sessionMessageBarPanel.setVisible(true);
        } else {
            this.sessionMessageBarPanel.setVisible(false);
        }
    }

    public void setReduntantPanelString(String message) {
        this.reduntantMessage = message;
    }

    private void updateRootPanelHelp(JavaHelpWrapper.SuperBladeTopic topic) {
        if (this.helpWrapper == null) {
            return;
        }
        switch (topic) {
            case LOGIN: {
                this.helpWrapper.enableHelpKey(this, "login.blade.system");
                this.helpWrapper.setHelpIDString(this, "login.blade.system");
                break;
            }
            case SYSTEM_VIEW: {
                this.helpWrapper.enableHelpKey(this, "blade.system.view");
                this.helpWrapper.setHelpIDString(this, "blade.system.view");
                break;
            }
            case TEXT_CONSOLE: {
                this.helpWrapper.enableHelpKey(this, "text.console");
                this.helpWrapper.setHelpIDString(this, "text.console");
                break;
            }
            case KVM_CONSOLE: {
                this.helpWrapper.enableHelpKey(this, "kvm.console");
                this.helpWrapper.setHelpIDString(this, "kvm.console");
                break;
            }
            case EVENTLOG: {
                this.helpWrapper.enableHelpKey(this, "event.log");
                this.helpWrapper.setHelpIDString(this, "event.log");
                break;
            }
            case LOGON_MANAGEMENT: {
                this.helpWrapper.enableHelpKey(this, "logon.management");
                this.helpWrapper.setHelpIDString(this, "logon.management");
                break;
            }
            case VIRTUAL_MEDIA: {
                this.helpWrapper.enableHelpKey(this, "blade.virtual.media");
                this.helpWrapper.setHelpIDString(this, "blade.virtual.media");
                break;
            }
            case CMM_SETTING: {
                this.helpWrapper.enableHelpKey(this, "cmm.setting");
                this.helpWrapper.setHelpIDString(this, "cmm.setting");
                break;
            }
        }
    }

    public void initJavaHelp(JavaHelpWrapper helpWrapper) {
        this.helpWrapper = helpWrapper;
        this.updateRootPanelHelp(JavaHelpWrapper.SuperBladeTopic.LOGIN);
    }

    public void myInit() {
        this.jDisconnectPanel.setVisible(false);
        this.sessionMessageBarPanel.setVisible(false);
        this.jTabbedPane.add((Component)this.cmmLoginPanel, L.t("cmm.session.authentication"));
        this.cmmLoginPanel.cmmLoginUI.jSystemNameLabel.setText(this.hostname);
        this.cmmLoginPanel.cmmLoginUI.jIPAddressLabel.setText(this.ip);
        this.cmmLoginPanel.cmmLoginUI.jDescriptionLabel.setText(this.description);
        this.cmmLoginPanel.preset(this, this.xMessage);
        this.sessionMessageBarPanel.preset(this, this.xMessage);
        this.reducePowerProblem = new ReducePowerProblem(this);
    }

    public void reInitialTab() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CMMSessionPanel.this.helpCloseTab();
            }
        });
    }

    public void helpCloseTab() {
        this.reInitalTabing = true;
        int tabCount = this.jTabbedPane.getTabCount();
        this.jTabbedPane.setFocusable(false);
        for (int i = 1; i < tabCount; ++i) {
            this.jTabbedPane.removeTabAt(1);
        }
        this.reInitalTabing = false;
    }

    public void createAllPanel() {
        this.cmmBladeSystemPanel = new CMMBladeSystemPanel();
        this.cmmSOLPanel = new CMMSOLPanel();
        this.cmmKVMPanel = new CMMKVMPanel();
        this.selPanel = new SELPanel();
        this.userManagementPanel = new UserManagementPanel();
        this.cmmConfigPanel = new CMMConfigPanel();
        this.virtualMediaPanel = null;
        this.virtualMediaPanelFirstPreset = false;
    }

    public void showAllTab(boolean isMaster) {
        this.tempIsMaster = isMaster;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    CMMSessionPanel.this.helpShowAllTab();
                }
            });
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private void helpShowAllTab() {
        this.cmmBladeSystemPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset cmmBladeSystemPanel ok");
        }
        this.cmmSOLPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset cmmSOLPanel ok");
        }
        this.cmmKVMPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset cmmKVMPanel ok");
        }
        this.userManagementPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset userManagementPanel ok");
        }
        this.selPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset selPanel ok");
        }
        this.virtualMediaPanel = new VirtualMedia(this.ipmiInterfaceConfig.getIp(), this.ipmiInterfaceConfig.getUserName(), this.ipmiInterfaceConfig.getPassword(), 4);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] new virtualMediaPanel-new ok");
        }
        this.virtualMediaPanel.preset(null, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] new virtualMediaPanel-present ok");
        }
        this.cmmConfigPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset cmmConfigPanel ok");
        }
        this.jTabbedPane.setFocusable(false);
        if (this.tempIsMaster) {
            this.jTabbedPane.add((Component)this.cmmBladeSystemPanel, L.t("cmm.session.blade_system"));
        }
        if (this.tempIsMaster) {
            this.jTabbedPane.add((Component)this.cmmSOLPanel, L.t("cmm.session.text_Console"));
        }
        if (this.tempIsMaster) {
            this.jTabbedPane.add((Component)this.cmmKVMPanel, L.t("cmm.session.KVM_Console"));
        }
        this.jTabbedPane.add((Component)this.selPanel, L.t("cmm.session.Event_Log"));
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.userManagementPanel, L.t("cmm.session.Logon_Management"));
        }
        if (this.ipmiInterfaceConfig.getPrivilege() == 4 && this.tempIsMaster) {
            this.jTabbedPane.add((Component)this.virtualMediaPanel, L.t("cmm.session.Virtual_Media"));
        }
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.cmmConfigPanel, L.t("cmm.session.CMM_Setting"));
        }
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] add all tabs ok");
        }
        this.cmmBladeSystemPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        this.cmmSOLPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        this.cmmKVMPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        this.selPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        this.userManagementPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        this.cmmConfigPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] set privilege ok");
        }
        this.jTabbedPane.setSelectedIndex(1);
    }

    public void changeToSlaveUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CMMSessionPanel.this.helpCloseTab();
                CMMSessionPanel.this.helpChangeToSlaveTab();
            }
        });
    }

    private void helpChangeToSlaveTab() {
        this.jTabbedPane.add((Component)this.selPanel, L.t("cmm.session.Event_Log"));
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.userManagementPanel, L.t("cmm.session.Logon_Management"));
        }
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.cmmConfigPanel, L.t("cmm.session.CMM_Setting"));
        }
        this.jTabbedPane.setSelectedIndex(1);
        this.setReduntantPanelVisible(true);
    }

    public void changeToMasterUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CMMSessionPanel.this.helpCloseTab();
                CMMSessionPanel.this.helpChangeToMasterTab();
            }
        });
    }

    private void helpChangeToMasterTab() {
        this.jTabbedPane.add((Component)this.cmmBladeSystemPanel, L.t("cmm.session.blade_system"));
        this.jTabbedPane.add((Component)this.cmmSOLPanel, L.t("cmm.session.text_Console"));
        this.jTabbedPane.add((Component)this.cmmKVMPanel, L.t("cmm.session.KVM_Console"));
        this.jTabbedPane.add((Component)this.selPanel, L.t("cmm.session.Event_Log"));
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.userManagementPanel, L.t("cmm.session.Logon_Management"));
        }
        this.jTabbedPane.add((Component)this.virtualMediaPanel, L.t("cmm.session.Virtual_Media"));
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.cmmConfigPanel, L.t("cmm.session.CMM_Setting"));
        }
        this.jTabbedPane.setSelectedIndex(1);
        this.setReduntantPanelVisible(false);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jCenterPanel.setLayout(this.borderLayout2);
        this.jTabbedPane.addChangeListener(new CMMSessionPanel_jTabbedPane_changeAdapter(this));
        this.jLabel1.setForeground(Color.white);
        this.jLabel1.setToolTipText("");
        this.jLabel1.setIcon(this.alertIcon);
        this.jLabel1.setText(L.t("cmm.session.unavailable"));
        this.jDisconnectPanel.setLayout(this.borderLayout3);
        this.jDisconnectPanel.setBackground(Color.red);
        this.jDisconnectPanel.setBorder(BorderFactory.createEtchedBorder());
        this.jRedundantPanel.setLayout(this.borderLayout4);
        this.jLabel2.setIcon(this.infoIcon);
        this.jLabel2.setText(L.t("cmm.login.redundant2"));
        this.jRedundantPanel.setBackground(Color.yellow);
        this.jUnavailableConnectPanel.setLayout(this.borderLayout5);
        this.jLabel3.setForeground(Color.gray);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setIcon(this.disconnectedIcon);
        this.jLabel3.setText(L.t("cmm.session.unable_to_connect"));
        this.add((Component)this.jCenterPanel, "Center");
        this.jDisconnectPanel.add((Component)this.jLabel1, "Center");
        this.add((Component)this.sessionMessageBarPanel, "South");
        this.jRedundantPanel.add((Component)this.jLabel2, "Center");
        this.jCenterPanel.add((Component)this.jTabbedPane, "Center");
        this.add((Component)this.jDisconnectPanel, "North");
        this.jUnavailableConnectPanel.add((Component)this.jLabel3, "Center");
        this.jTabbedPane.setTabPlacement(3);
    }

    public void closeCMM() {
        this.jTabbedPane.setSelectedIndex(0);
        if (this.jTabbedPane.getTabCount() > 1) {
            this.cmmLoginPanel.cmmLoginUI.closeLoginUI();
        } else {
            this.cmmBladeSystemPanel = null;
            this.cmmSOLPanel = null;
            this.cmmKVMPanel = null;
            this.selPanel = null;
            this.userManagementPanel = null;
            this.cmmConfigPanel = null;
            this.virtualMediaPanel = null;
        }
        while (this.jTabbedPane.getTabCount() > 1) {
            this.helpCloseTab();
        }
        this.jTabbedPane.remove(0);
        this.cmmLoginPanel.closePanel();
        this.cmmLoginPanel = null;
    }

    public void returnTOLogin() {
        this.jTabbedPane.setSelectedIndex(0);
        if (this.jTabbedPane.getTabCount() > 1) {
            this.cmmLoginPanel.cmmLoginUI.closeLoginUI();
        }
    }

    public void setDefaultButton() {
        this.cmmLoginPanel.cmmLoginUI.setDefaultButton();
        this.cmmLoginPanel.cmmLoginUI.enableFocusOnLoginID();
    }

    public void jTabbedPane_stateChanged(ChangeEvent e) {
        if (this.reInitalTabing) {
            return;
        }
        int selectedIndex = this.jTabbedPane.getSelectedIndex();
        if (selectedIndex == -1) {
            return;
        }
        String selectedTab = this.jTabbedPane.getTitleAt(selectedIndex);
        if (selectedTab.equals(L.t("cmm.session.authentication"))) {
            this.updateRootPanelHelp(JavaHelpWrapper.SuperBladeTopic.LOGIN);
            this.cmmLoginPanel.present();
        } else if (selectedTab.equals(L.t("cmm.session.blade_system"))) {
            this.updateRootPanelHelp(JavaHelpWrapper.SuperBladeTopic.SYSTEM_VIEW);
            this.cmmBladeSystemPanel.present();
        } else if (selectedTab.equals(L.t("cmm.session.text_Console"))) {
            this.updateRootPanelHelp(JavaHelpWrapper.SuperBladeTopic.TEXT_CONSOLE);
            this.cmmSOLPanel.present();
        } else if (selectedTab.equals(L.t("cmm.session.KVM_Console"))) {
            this.updateRootPanelHelp(JavaHelpWrapper.SuperBladeTopic.KVM_CONSOLE);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    CMMSessionPanel.this.cmmKVMPanel.present();
                }
            };
            thread.start();
        } else if (selectedTab.equals(L.t("cmm.session.Event_Log"))) {
            this.updateRootPanelHelp(JavaHelpWrapper.SuperBladeTopic.EVENTLOG);
            this.selPanel.present();
        } else if (selectedTab.equals(L.t("cmm.session.Logon_Management"))) {
            this.updateRootPanelHelp(JavaHelpWrapper.SuperBladeTopic.LOGON_MANAGEMENT);
            this.userManagementPanel.present();
        } else if (selectedTab.equals(L.t("cmm.session.Virtual_Media"))) {
            this.updateRootPanelHelp(JavaHelpWrapper.SuperBladeTopic.VIRTUAL_MEDIA);
            this.virtualMediaPanel.present();
        } else if (selectedTab.equals(L.t("cmm.session.CMM_Setting"))) {
            this.updateRootPanelHelp(JavaHelpWrapper.SuperBladeTopic.CMM_SETTING);
        }
    }

    public void getBladeSystemEntityData() {
        if (this.bladeSystemEntity == null) {
            this.bladeSystemEntity = new BladeSystemEntity(this.ipmiInterfaceConfig);
            this.bladeSystemEntity.addDisconnectListener(this);
        }
        this.bladeSystemEntity.getData();
    }

    public void startPoolingData() {
        if (this.bladeSystemEntity == null) {
            this.bladeSystemEntity = new BladeSystemEntity(this.ipmiInterfaceConfig);
            this.bladeSystemEntity.addDisconnectListener(this);
        }
        this.bladeSystemEntity.poolingData();
    }

    public void addCMMSessionPanelToObservable() {
        this.bladeSystemEntity.addObserver(this);
    }

    @Override
    public void update(Observable o, Object obj) {
        this.isDisconnect = false;
        if (this.bladeSystemEntity.isLogoutSuccessful != this.lastLogoutState) {
            this.setDisconnectPanelVisible(false);
        }
        this.disconnectCount = 0;
        this.enterDisconnectPhase = false;
        this.lastLogoutState = true;
        if (!this.bladeSystemEntity.getIsMaster()) {
            return;
        }
        if (this.reducePowerProblem.check()) {
            this.sessionMessageBarPanel.setVisible(true);
        } else {
            this.sessionMessageBarPanel.setVisible(false);
        }
    }

    @Override
    public void disconnect(Object o) {
        this.isDisconnect = true;
        BladeSystemEntity bladeSystemEntity = (BladeSystemEntity)o;
        if (bladeSystemEntity.isLogoutSuccessful != this.lastLogoutState) {
            this.setDisconnectPanelVisible(true);
        }
        ++this.disconnectCount;
        if (this.disconnectCount > 3) {
            if (this.enterDisconnectPhase) {
                return;
            }
            bladeSystemEntity.stopPooling();
            this.setDisconnectPanelVisible(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CMMSessionPanel.this.returnTOLogin();
                }
            });
            this.enterDisconnectPhase = true;
        }
        this.lastLogoutState = false;
    }
}

