/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ByteUtility;
import IPMIView20.ConfigAccessor;
import IPMIView20.algo.AES_CBC_128;

public class DeviceNameAccount {
    static ConfigAccessor config = new ConfigAccessor(".", "account.properties");
    static AES_CBC_128 aes = new AES_CBC_128();
    static byte[] iv = new byte[16];

    public static void save(String deviceName, String id, String password) {
        byte[] key = new byte[16];
        int deviceNameLength = deviceName.getBytes().length;
        System.arraycopy(deviceName.getBytes(), 0, key, 0, deviceNameLength > 16 ? 16 : deviceNameLength);
        byte[] input = new byte[password.getBytes().length + (16 - password.getBytes().length % 16)];
        System.arraycopy(password.getBytes(), 0, input, 0, password.getBytes().length);
        byte[] encryptedBytes = aes.encrypt(iv, key, input);
        String passwordEncoder = ByteUtility.bytesToHexNoSpace(encryptedBytes);
        config.setProperty(deviceName, id + "," + passwordEncoder);
    }

    public static void remove(String deviceName) {
        config.removeProperty(deviceName);
    }

    public static String getID(String deviceName) {
        String idPw = config.getProperty(deviceName);
        if (idPw == null) {
            return null;
        }
        return idPw.substring(0, idPw.indexOf(","));
    }

    public static String getPassword(String deviceName) {
        String idPw = config.getProperty(deviceName);
        if (idPw == null) {
            return null;
        }
        return idPw.substring(idPw.indexOf(",") + 1, idPw.length());
    }

    public static String getDecryptedPassword(String deviceName) {
        String idPw = config.getProperty(deviceName);
        if (idPw == null) {
            return null;
        }
        byte[] key = new byte[16];
        int deviceNameLength = deviceName.getBytes().length;
        System.arraycopy(deviceName.getBytes(), 0, key, 0, deviceNameLength > 16 ? 16 : deviceNameLength);
        String encryptedPassword = idPw.substring(idPw.indexOf(",") + 1, idPw.length());
        byte[] input = ByteUtility.toBinArray(encryptedPassword);
        byte[] decrypted = aes.decrypt(iv, key, input);
        return new String(decrypted).trim();
    }

    public static String getEncryptedPassword(String deviceName, String id, String password) {
        byte[] key = new byte[16];
        int deviceNameLength = deviceName.getBytes().length;
        System.arraycopy(deviceName.getBytes(), 0, key, 0, deviceNameLength > 16 ? 16 : deviceNameLength);
        byte[] input = new byte[password.getBytes().length + (16 - password.getBytes().length % 16)];
        System.arraycopy(password.getBytes(), 0, input, 0, password.getBytes().length);
        byte[] encryptedBytes = aes.encrypt(iv, key, input);
        String passwordEncoder = ByteUtility.bytesToHexNoSpace(encryptedBytes);
        return passwordEncoder;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Input  : <System Name> <Username> <Password>");
            System.out.println("Output : encrypted password for IPMIView account.properties");
            return;
        }
        String value = DeviceNameAccount.getEncryptedPassword(args[0], args[1], args[2]);
        System.out.println(value);
    }

    public static void main_test(String[] args) {
        DeviceNameAccount.save("123", "ADMIN", "ADMIN");
        DeviceNameAccount.save("456", "ADMIN", "ADMIN");
        System.out.println("id =" + DeviceNameAccount.getID("123"));
        System.out.println("pw (encrypted)=" + DeviceNameAccount.getPassword("123"));
        System.out.println("pw (decrypted)=" + DeviceNameAccount.getDecryptedPassword("123"));
        System.out.println("id =" + DeviceNameAccount.getID("456"));
        System.out.println("pw (encrypted)=" + DeviceNameAccount.getPassword("456"));
        System.out.println("pw (decrypted)=" + DeviceNameAccount.getDecryptedPassword("456"));
        System.out.println("id =" + DeviceNameAccount.getID("789"));
        System.out.println("pw (encrypted)=" + DeviceNameAccount.getPassword("789"));
        System.out.println("pw (decrypted)=" + DeviceNameAccount.getDecryptedPassword("789"));
        System.out.println("id =" + DeviceNameAccount.getID("192.168.10.241"));
        System.out.println("pw (encrypted)=" + DeviceNameAccount.getPassword("192.168.10.241"));
        System.out.println("pw (decrypted)=" + DeviceNameAccount.getDecryptedPassword("192.168.10.241"));
        System.out.println("id =" + DeviceNameAccount.getID("192.168.10.241-1"));
        System.out.println("pw (encrypted)=" + DeviceNameAccount.getPassword("192.168.10.241-1"));
        System.out.println("pw (decrypted)=" + DeviceNameAccount.getDecryptedPassword("192.168.10.241-1"));
        DeviceNameAccount.remove("123");
        DeviceNameAccount.remove("456");
        AES_CBC_128 aes = new AES_CBC_128();
        byte[] key = new byte[]{83, 85, 80, 69, 82, 77, 73, 67, 82, 79, 1, 2, 3, 4, 5, 6};
        byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        String id = "AAAAAAAAAAAAAAAAAAAAA";
        byte[] input = new byte[id.getBytes().length + (16 - id.getBytes().length % 16)];
        System.out.println("input size =" + input.length);
        System.arraycopy(id.getBytes(), 0, input, 0, id.getBytes().length);
        byte[] encryptedBytes = aes.encrypt(iv, key, input);
        System.out.println("1.encrypt =" + ByteUtility.bytesToHexNoSpace(encryptedBytes));
        byte[] decryptedByte = aes.decrypt(iv, key, encryptedBytes);
        System.out.println("1.decrypt =" + new String(decryptedByte) + ", size =" + decryptedByte.length);
    }
}

