/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.IPMIView20;
import IPMIView20.LANModePanel_jUpdateButton_actionAdapter;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class LANModePanel
extends JPanel {
    private String ip;
    private String id;
    private String password;
    private byte privilege;
    boolean isLoaded;
    TitledBorder titledBorder1 = new TitledBorder("");
    JPanel jCenterPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JRadioButton jDedicatedRadioButton = new JRadioButton();
    JRadioButton jFailOverRadioButton = new JRadioButton();
    JRadioButton jOnBoardRadioButton = new JRadioButton();
    JButton jUpdateButton = new JButton();
    JPanel jPanel1 = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public LANModePanel(String ip, String id, String password, byte privilege) {
        try {
            this.ip = ip;
            this.id = id;
            this.password = password;
            this.privilege = privilege;
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() throws Exception {
        this.buttonGroup1.add(this.jDedicatedRadioButton);
        this.buttonGroup1.add(this.jOnBoardRadioButton);
        this.buttonGroup1.add(this.jFailOverRadioButton);
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("LAN Interface");
        this.setLayout(this.gridLayout2);
        this.jCenterPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(5);
        this.jDedicatedRadioButton.setText("Dedicated");
        this.jFailOverRadioButton.setText("Failover");
        this.jOnBoardRadioButton.setText("On Board LAN1");
        this.jUpdateButton.setPreferredSize(new Dimension(65, 23));
        this.jUpdateButton.setHorizontalTextPosition(0);
        this.jUpdateButton.setText("Update");
        this.jUpdateButton.addActionListener(new LANModePanel_jUpdateButton_actionAdapter(this));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.gridLayout2.setRows(2);
        this.setBorder(null);
        this.jCenterPanel.setBorder(this.titledBorder1);
        this.jPanel1.setPreferredSize(new Dimension(65, 24));
        this.jCenterPanel.add(this.jDedicatedRadioButton);
        this.jCenterPanel.add(this.jOnBoardRadioButton);
        this.jCenterPanel.add(this.jFailOverRadioButton);
        this.jCenterPanel.add(this.jPanel1);
        this.jPanel1.add((Component)this.jUpdateButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 4, 0));
        this.jCenterPanel.add(this.jPanel4);
        this.add((Component)this.jCenterPanel, null);
        this.add(this.jPanel3);
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrivilege(byte privilege) {
        this.privilege = privilege;
    }

    public String getIp() {
        return this.ip;
    }

    public String getId() {
        return this.id;
    }

    public String getPassword() {
        return this.password;
    }

    public byte getPrivilege() {
        return this.privilege;
    }

    public boolean getIsLoaded() {
        return this.isLoaded;
    }

    public void load() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.password);
        config.setPrivilege(this.privilege);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(null);
        this.isLoaded = false;
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            throw new IPMIException("Cannot connect to host");
        }
        ipmiAMIOEMCommand.setIPMIInterface(rmcp);
        byte lanMode = ipmiAMIOEMCommand.getLANMode();
        switch (lanMode) {
            case 0: {
                this.jDedicatedRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.jOnBoardRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.jFailOverRadioButton.setSelected(true);
                break;
            }
        }
        this.isLoaded = true;
        sessionController.closeSession();
    }

    public void update() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.password);
        config.setPrivilege(this.privilege);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            throw new IPMIException("Cannot connect to host");
        }
        ipmiAMIOEMCommand.setIPMIInterface(rmcp);
        int lanMode = 0;
        int orgLANMode = ipmiAMIOEMCommand.getLANMode();
        if (this.jDedicatedRadioButton.isSelected()) {
            lanMode = 0;
        } else if (this.jOnBoardRadioButton.isSelected()) {
            lanMode = 1;
        } else if (this.jFailOverRadioButton.isSelected()) {
            lanMode = 2;
        }
        if (lanMode != orgLANMode) {
            ipmiAMIOEMCommand.setLANMode((byte)lanMode);
        }
        sessionController.closeSession();
    }

    public void jUpdateButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    LANModePanel.this.setCursor(new Cursor(3));
                    LANModePanel.this.update();
                    LANModePanel.this.setCursor(new Cursor(0));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), ex.toString());
                }
            }
        };
        thread.start();
    }
}

