/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import IPMIView20.VT100;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class TCR
extends JPanel {
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    JLabel Message;
    CSession Session;
    UDPSocket udpSocket;
    CRService CRDeamon = null;
    VT100 VTHandle = null;
    boolean TCRunning = false;
    int KeySeq = 0;
    int KeyModifier = -1;
    int LastKey = -1;
    int testseq = 0;
    int testcount = 0;
    int DaemonPort = 0;
    private JTextPane Console;
    private JCheckBox FixedPort;
    private JButton ReSync;
    private JButton Start;
    private JButton Stop;
    private JCheckBox jAutoIP;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public TCR() {
        this.initComponents();
        Font messageFont = new Font("Courier New", 0, 12);
        FontMetrics fm = this.getFontMetrics(messageFont);
        if (fm.charWidth('i') != fm.charWidth('W')) {
            messageFont = new Font("Courier", 0, 12);
        }
        this.Console.setFont(messageFont);
        this.Console.setVisible(false);
        this.Console.requestFocus();
    }

    public void preset(UDPSocket xSocket, CSession iSession, JLabel xMessage) {
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
    }

    public void setXMessgage(JLabel message) {
        this.Message = message;
    }

    public void closeTCR() {
        if (this.TCRunning) {
            this.CRCommand(new byte[]{2});
            this.CRDeamon.stopCR();
            this.Start.setEnabled(true);
            this.Stop.setEnabled(false);
            this.TCRunning = false;
            this.Console.setVisible(false);
        }
    }

    private boolean CRCommand(byte[] ReqID) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] retIP = new byte[4];
        byte[] retPort = new byte[2];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        InetAddress tempaddress = null;
        boolean bResult = false;
        this.SIP = this.Session.SIP;
        try {
            tempaddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ue) {
            return false;
        }
        retIP = tempaddress.getAddress();
        if (this.jAutoIP.isSelected()) {
            String xx = this.jAutoIP.getText().substring(4);
            xx = xx.substring(0, xx.indexOf(32));
            for (int jPos = 0; jPos < 3; ++jPos) {
                retIP[jPos] = (byte)(Integer.parseInt(xx.substring(0, xx.indexOf(46))) & 0xFF);
                xx = xx.substring(xx.indexOf(46) + 1);
            }
            retIP[jPos] = (byte)(Integer.parseInt(xx) & 0xFF);
        }
        retPort[0] = (byte)(this.DaemonPort >> 8);
        retPort[1] = (byte)(this.DaemonPort & 0xFF);
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(ReqID);
        Para.addElement(retIP);
        Para.addElement(retPort);
        this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)50, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.Message.setText("IPMI request sent successfully");
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            switch (this.rmcpPacket.compeletecode) {
                case 0: {
                    this.Session.IncreaseSessionSeq();
                    this.Message.setText("IPMI response received");
                    bResult = true;
                    break;
                }
                case -57: {
                    this.Message.setText("IPMI response received, but command failed (invalid request data size)");
                    break;
                }
                case -50: {
                    this.Message.setText("IPMI response received, but command failed (no response)");
                    break;
                }
                case -55: {
                    this.Message.setText("IPMI response received, but command failed (data out of range)");
                    break;
                }
                case -128: {
                    this.Message.setText("IPMI response received, but command failed (Text Remote Console not available)");
                }
            }
        } else {
            this.Message.setText("IPMI request sent failed");
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean CRKeyStroke(byte KeyB0, byte KeyB1, byte KeyStatus) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] Keycode = new byte[]{0, 0};
        byte[] Keystatus = new byte[]{0};
        byte[] Keyboard = new byte[]{0};
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        if (!this.TCRunning) {
            return false;
        }
        this.SIP = this.Session.SIP;
        Keycode[0] = KeyB0;
        Keycode[1] = KeyB1;
        Keystatus[0] = KeyStatus;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(Keycode);
        Para.addElement(Keystatus);
        Para.addElement(Keyboard);
        this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)51, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.Message.setText("IPMI request sent successfully");
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            switch (this.rmcpPacket.compeletecode) {
                case 0: {
                    this.Session.IncreaseSessionSeq();
                    this.Message.setText("IPMI response received");
                    bResult = true;
                    break;
                }
                case -57: {
                    this.Message.setText("IPMI response received, but command failed (invalid request data size)");
                    break;
                }
                case -50: {
                    this.Message.setText("IPMI response received, but command failed (no response)");
                }
            }
        } else {
            this.Message.setText("IPMI request sent failed");
        }
        this.Session.releaselock();
        return bResult;
    }

    private byte GetACPIPowerState() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        byte bResult = -1;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.SIP = this.Session.SIP;
        this.Message.setText("Getting ACPI Power State");
        this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)7, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                this.Message.setText("Get ACPI Power State succeeded");
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                bResult = bytex[0];
            } else {
                this.Message.setText("Get ACPI Power State failed");
            }
        } else {
            this.Message.setText("Get ACPI Power State failed");
        }
        this.Session.releaselock();
        return bResult;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.Start = new JButton();
        this.Stop = new JButton();
        this.ReSync = new JButton();
        this.jPanel3 = new JPanel();
        this.FixedPort = new JCheckBox();
        this.jAutoIP = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.Console = new JTextPane();
        this.setLayout(new BorderLayout());
        this.Start.setText("Start");
        this.Start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TCR.this.StartActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.Start);
        this.Stop.setText("Stop");
        this.Stop.setEnabled(false);
        this.Stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TCR.this.StopActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.Stop);
        this.ReSync.setText("ReSynch");
        this.ReSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TCR.this.ReSyncActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.ReSync);
        this.jPanel3.setBorder(new EtchedBorder());
        this.jPanel3.setPreferredSize(new Dimension(300, 39));
        this.FixedPort.setText("Port 6666");
        this.jPanel3.add(this.FixedPort);
        this.jAutoIP.setText("Use Specified IP");
        this.jAutoIP.setPreferredSize(new Dimension(200, 25));
        this.jAutoIP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TCR.this.jAutoIPActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jAutoIP);
        this.jPanel1.add(this.jPanel3);
        this.add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel2.setBorder(new BevelBorder(1));
        this.Console.setBorder(new EtchedBorder());
        this.Console.setBackground(Color.lightGray);
        this.Console.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TCR.this.ConsoleKeyTyped(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                TCR.this.ConsoleKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                TCR.this.ConsoleKeyReleased(evt);
            }
        });
        this.jPanel2.add((Component)this.Console, new AbsoluteConstraints(5, 5, -1, -1));
        this.add((Component)this.jPanel2, "Center");
    }

    private void jAutoIPActionPerformed(ActionEvent evt) {
        if (this.jAutoIP.isSelected()) {
            JOptionPane MBox = new JOptionPane();
            String xx = "You may specify the local IP instead of\n";
            xx = xx + "letting IPMIView detect it for you.\n\n";
            xx = xx + "Note: For some network environment (NAT)\n";
            xx = xx + "or some Linux version Java, Console\n";
            xx = xx + "data can not be sent back to this\n";
            xx = xx + "IPMIView, please check this option\n";
            xx = xx + "and fill in the IP that can be reached.\n";
            String yy = JOptionPane.showInputDialog(this, (Object)xx);
            if (yy != null) {
                this.jAutoIP.setText("Use " + yy + " as local IP");
            } else {
                this.jAutoIP.setSelected(false);
            }
        } else {
            this.jAutoIP.setText("Use Specified Local IP");
        }
    }

    private void ConsoleKeyTyped(KeyEvent evt) {
        evt.consume();
    }

    private void ConsoleKeyReleased(KeyEvent evt) {
        char xc;
        byte[] Codes = new byte[2];
        int xm = evt.getKeyCode();
        Codes = this.KeyTranslate(xm, xc = evt.getKeyChar());
        if (Codes[0] != 0 || Codes[1] != 0) {
            this.CRKeyStroke(Codes[0], Codes[1], (byte)0);
        }
        evt.consume();
    }

    private void ConsoleKeyPressed(KeyEvent evt) {
        char xc;
        byte[] Codes = new byte[2];
        int xm = evt.getKeyCode();
        Codes = this.KeyTranslate(xm, xc = evt.getKeyChar());
        if (Codes[0] != 0 || Codes[1] != 0) {
            this.CRKeyStroke(Codes[0], Codes[1], (byte)1);
        }
        evt.consume();
    }

    private void ReSyncActionPerformed(ActionEvent evt) {
        this.CRCommand(new byte[]{3});
        this.Console.requestFocus();
    }

    private void StopActionPerformed(ActionEvent evt) {
        this.CRCommand(new byte[]{2});
        this.CRDeamon.stopCR();
        this.Console.setVisible(false);
        this.Console.requestFocus();
        this.Start.setEnabled(true);
        this.FixedPort.setEnabled(true);
        this.jAutoIP.setEnabled(true);
        this.Stop.setEnabled(false);
        this.TCRunning = false;
    }

    private void StartActionPerformed(ActionEvent evt) {
        int bytex = 0;
        if (bytex == 0 || bytex == 1 || bytex == 32) {
            Cursor csrTemp = new Cursor(3);
            this.setCursor(csrTemp);
            try {
                this.CRDeamon = this.FixedPort.isSelected() ? new CRService(6666) : new CRService();
                this.CRDeamon.start();
                this.VTHandle = new VT100(this.Console);
                this.CRCommand(new byte[]{1});
                this.Start.setEnabled(false);
                this.Stop.setEnabled(true);
                this.FixedPort.setEnabled(false);
                this.jAutoIP.setEnabled(false);
                this.Console.setVisible(true);
                this.TCRunning = true;
            }
            catch (IOException e) {
                JOptionPane MBox = new JOptionPane();
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Unavailabe to create Console Redirection Daemon");
            }
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            this.Console.requestFocus();
        } else {
            JOptionPane MBox = new JOptionPane();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Managed system is just power on, please try again a few seconds later!");
        }
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    private byte[] KeyTranslate(int KeyCode, char KeyChar) {
        byte[] newcode = new byte[2];
        switch (KeyCode) {
            case 112: {
                newcode[0] = -66;
                newcode[1] = -1;
                break;
            }
            case 113: {
                newcode[0] = -65;
                newcode[1] = -1;
                break;
            }
            case 114: {
                newcode[0] = -64;
                newcode[1] = -1;
                break;
            }
            case 115: {
                newcode[0] = -63;
                newcode[1] = -1;
                break;
            }
            case 116: {
                newcode[0] = -62;
                newcode[1] = -1;
                break;
            }
            case 117: {
                newcode[0] = -61;
                newcode[1] = -1;
                break;
            }
            case 118: {
                newcode[0] = -60;
                newcode[1] = -1;
                break;
            }
            case 119: {
                newcode[0] = -59;
                newcode[1] = -1;
                break;
            }
            case 120: {
                newcode[0] = -58;
                newcode[1] = -1;
                break;
            }
            case 121: {
                newcode[0] = -57;
                newcode[1] = -1;
                break;
            }
            case 122: {
                newcode[0] = -56;
                newcode[1] = -1;
                break;
            }
            case 123: {
                newcode[0] = -55;
                newcode[1] = -1;
                break;
            }
            case 8: {
                newcode[0] = 8;
                newcode[1] = -1;
                break;
            }
            case 9: {
                newcode[0] = 9;
                newcode[1] = -1;
                break;
            }
            case 10: {
                newcode[0] = 13;
                newcode[1] = -1;
                break;
            }
            case 19: {
                newcode[0] = 19;
                newcode[1] = -1;
                break;
            }
            case 145: {
                newcode[0] = 0;
                newcode[1] = 0;
                break;
            }
            case 27: {
                newcode[0] = 27;
                newcode[1] = -1;
                break;
            }
            case 155: {
                newcode[0] = 99;
                newcode[1] = -1;
                break;
            }
            case 36: {
                newcode[0] = 80;
                newcode[1] = -1;
                break;
            }
            case 37: {
                newcode[0] = 81;
                newcode[1] = -1;
                break;
            }
            case 38: {
                newcode[0] = 82;
                newcode[1] = -1;
                break;
            }
            case 39: {
                newcode[0] = 83;
                newcode[1] = -1;
                break;
            }
            case 40: {
                newcode[0] = 84;
                newcode[1] = -1;
                break;
            }
            case 33: {
                newcode[0] = 85;
                newcode[1] = -1;
                break;
            }
            case 34: {
                newcode[0] = 86;
                newcode[1] = -1;
                break;
            }
            case 35: {
                newcode[0] = 87;
                newcode[1] = -1;
                break;
            }
            case 20: {
                newcode[0] = 0;
                newcode[1] = 0;
                break;
            }
            case 144: {
                newcode[0] = 0;
                newcode[1] = 0;
                break;
            }
            case 127: {
                newcode[0] = -1;
                newcode[1] = -1;
                break;
            }
            case 18: {
                newcode[0] = -23;
                newcode[1] = -1;
                break;
            }
            case 16: {
                newcode[0] = -31;
                newcode[1] = -1;
                break;
            }
            case 17: {
                newcode[0] = -29;
                newcode[1] = -1;
                break;
            }
            case 96: {
                newcode[0] = -80;
                newcode[1] = -1;
                break;
            }
            case 97: {
                newcode[0] = -79;
                newcode[1] = -1;
                break;
            }
            case 98: {
                newcode[0] = -78;
                newcode[1] = -1;
                break;
            }
            case 99: {
                newcode[0] = -77;
                newcode[1] = -1;
                break;
            }
            case 100: {
                newcode[0] = -76;
                newcode[1] = -1;
                break;
            }
            case 101: {
                newcode[0] = -75;
                newcode[1] = -1;
                break;
            }
            case 102: {
                newcode[0] = -74;
                newcode[1] = -1;
                break;
            }
            case 103: {
                newcode[0] = -73;
                newcode[1] = -1;
                break;
            }
            case 104: {
                newcode[0] = -72;
                newcode[1] = -1;
                break;
            }
            case 105: {
                newcode[0] = -71;
                newcode[1] = -1;
                break;
            }
            case 106: {
                newcode[0] = -86;
                newcode[1] = -1;
                break;
            }
            case 107: {
                newcode[0] = -85;
                newcode[1] = -1;
                break;
            }
            case 109: {
                newcode[0] = -83;
                newcode[1] = -1;
                break;
            }
            case 110: {
                newcode[0] = -82;
                newcode[1] = -1;
                break;
            }
            case 111: {
                newcode[0] = -81;
                newcode[1] = -1;
                break;
            }
            case 192: {
                newcode[0] = 96;
                newcode[1] = 0;
                break;
            }
            default: {
                newcode[0] = (byte)(KeyChar & 0xFF);
                newcode[1] = 0;
                int keyx = KeyChar & 0xFF;
                if (keyx < 1 || keyx > 26) break;
                newcode[0] = (byte)(keyx | 0x40);
            }
        }
        return newcode;
    }

    private class CRService
    extends Thread {
        protected DatagramSocket socket = null;
        protected BufferedReader in = null;
        protected boolean moreQuotes = true;

        public CRService() throws IOException {
            this.socket = new DatagramSocket();
            TCR.this.DaemonPort = this.socket.getLocalPort();
        }

        public CRService(int Port) throws IOException {
            this.socket = new DatagramSocket(Port);
            TCR.this.DaemonPort = this.socket.getLocalPort();
        }

        @Override
        public void run() {
            byte[] bufin = new byte[256];
            byte[] bufx = new byte[256];
            byte[] bufout = new byte[7];
            try {
                this.socket.setSoTimeout(5000);
            }
            catch (SocketException e) {
                // empty catch block
            }
            while (this.moreQuotes) {
                try {
                    DatagramPacket packet = new DatagramPacket(bufin, bufin.length);
                    this.socket.receive(packet);
                    bufx = new byte[packet.getLength() - 2];
                    System.arraycopy(bufin, 2, bufx, 0, packet.getLength() - 2);
                    switch (bufin[0]) {
                        case 0: {
                            TCR.this.VTHandle.VTe_InParse(bufx, packet.getLength() - 2);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (bufin[1] != 4) break;
                            Thread xth = new Thread(){

                                @Override
                                public void run() {
                                    JOptionPane MBox = new JOptionPane();
                                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Console Redirection is terminated,\neither the managed server switches into graphic mode or\nyou have stopped the function.");
                                }
                            };
                            xth.start();
                            TCR.this.CRDeamon.stopCR();
                            TCR.this.Console.requestFocus();
                            TCR.this.Console.setVisible(false);
                            TCR.this.Start.setEnabled(true);
                            TCR.this.Stop.setEnabled(false);
                            TCR.this.TCRunning = false;
                        }
                    }
                }
                catch (IOException e) {}
            }
            this.socket.close();
            this.socket = null;
        }

        public void stopCR() {
            this.moreQuotes = false;
        }
    }
}

