/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.IPMIView20;
import IPMIView20.Logger;
import IPMIView20.blade.LabelBladeComponent;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class LabelGigabitSwitch
extends LabelBladeComponent {
    ImageIcon labelGigabitSwitchUp = new ImageIcon(this.getClass().getResource("/images/labelGigabitSwitch-up.jpg"));
    ImageIcon labelGigabitSwitchDown = new ImageIcon(this.getClass().getResource("/images/labelGigabitSwitch-down.jpg"));
    ImageIcon labelGigabitSwitchPassThruUp = new ImageIcon(this.getClass().getResource("/images/labelGigabitSwitch_passthru-up.jpg"));
    ImageIcon labelGigabitSwitchPassThruDown = new ImageIcon(this.getClass().getResource("/images/labelGigabitSwitch_passthru-down.jpg"));
    ImageIcon labelL3SwitchUp = new ImageIcon(this.getClass().getResource("/images/labelL3Switch-up.jpg"));
    ImageIcon labelL3SwitchDown = new ImageIcon(this.getClass().getResource("/images/labelL3Switch-down.jpg"));
    ImageIcon label10GSwitch = new ImageIcon(this.getClass().getResource("/images/labelIBQDR.jpg"));
    ImageIcon labelGigabitSwitch20xPassThruUp = new ImageIcon(this.getClass().getResource("/images/labelGigabitSwitch_20xpassthru-up.jpg"));
    ImageIcon labelGigabitSwitch20xPassThruDown = new ImageIcon(this.getClass().getResource("/images/labelGigabitSwitch_20xpassthru-down.jpg"));
    BladeSystemEntity bladeSystemEntity = null;

    public LabelGigabitSwitch() {
        this.setIcon(this.labelGigabitSwitchUp);
        this.setSize(this.labelGigabitSwitchUp.getIconWidth(), this.labelGigabitSwitchUp.getIconHeight());
        this.setPowerStatus(1);
        this.setPowerVisible(true);
        this.powerIconX = 15;
        this.powerIconY = 4;
        this.alertIconX = 39;
        this.alertIconY = 4;
        if (IPMIView20.acer) {
            this.setModuleName("Acer Switch");
        } else if (IPMIView20.gateway) {
            this.setModuleName("Gateway Switch");
        } else {
            this.setModuleName("GB Switch");
        }
    }

    @Override
    public void setNumber(int number) {
        super.setNumber(number);
        if (number == 1) {
            this.setIcon(this.labelGigabitSwitchUp);
        } else {
            this.setIcon(this.labelGigabitSwitchDown);
        }
    }

    @Override
    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[LabelGigabitSwitch] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LabelGigabitSwitch.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        GigabitSwitchEntity gigabitSwitchEntity = this.bladeSystemEntity.getGigabitSwitchs()[this.number - 1];
        if (gigabitSwitchEntity.getPresent() == 0) {
            this.setVisible(false);
            if (this.labelBladeGroup.labelBladeComponentIndicatorOn == this) {
                this.labelBladeGroup.labelBladeComponentIndicatorOn = null;
            }
        } else {
            this.setVisible(true);
        }
        if (gigabitSwitchEntity.getFlag() == 0) {
            if (this.number == 1) {
                this.setIcon(this.labelGigabitSwitchUp);
            } else {
                this.setIcon(this.labelGigabitSwitchDown);
            }
        } else if (gigabitSwitchEntity.getFlag() == 2) {
            if (this.number == 1) {
                this.setIcon(this.labelL3SwitchUp);
            } else {
                this.setIcon(this.labelL3SwitchDown);
            }
        } else {
            if (gigabitSwitchEntity.getFlag() == 1) {
                if (this.number == 1) {
                    this.setIcon(this.labelGigabitSwitchPassThruUp);
                } else {
                    this.setIcon(this.labelGigabitSwitchPassThruDown);
                }
                this.setPowerStatus(0);
                this.setAlertVisible(false);
                return;
            }
            if (gigabitSwitchEntity.getFlag() == 4) {
                this.setSize(this.labelGigabitSwitch20xPassThruUp.getIconWidth(), this.labelGigabitSwitch20xPassThruUp.getIconHeight());
                if (this.number == 1) {
                    this.setIcon(this.labelGigabitSwitch20xPassThruUp);
                } else {
                    this.setIcon(this.labelGigabitSwitch20xPassThruDown);
                }
                this.setPowerStatus(0);
                this.setAlertVisible(false);
                return;
            }
        }
        if (gigabitSwitchEntity.isPowerOnCheckedByVoltage()) {
            this.setPowerStatus(0);
        } else {
            this.setPowerStatus(1);
        }
        if (gigabitSwitchEntity.isPowerOnCheckedByVoltage() && gigabitSwitchEntity.isError()) {
            this.setAlertVisible(true);
        } else {
            this.setAlertVisible(false);
        }
    }
}

