/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.Logger;
import IPMIView20.blade.LabelBladeComponent;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.IBQDREntity;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class LabelIBQDR
extends LabelBladeComponent {
    ImageIcon labelIB = new ImageIcon(this.getClass().getResource("/images/labelIBQDR.jpg"));
    BladeSystemEntity bladeSystemEntity = null;

    public LabelIBQDR() {
        this.powerIconX = 15;
        this.powerIconY = 4;
        this.alertIconX = 39;
        this.alertIconY = 4;
        this.setIcon(this.labelIB);
        this.setSize(21, 144);
        this.setPowerStatus(1);
        this.setPowerVisible(true);
        this.setModuleName("IBQDR");
    }

    @Override
    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[LabelIBQDR] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LabelIBQDR.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        IBQDREntity iBQDREntity = this.bladeSystemEntity.getIBQDRs()[this.number - 1];
        if (iBQDREntity.getPresent() != 0 && (iBQDREntity.isIBQDR() || iBQDREntity.isIBQDRPassThru())) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
            if (this.labelBladeGroup.labelBladeComponentIndicatorOn == this) {
                this.labelBladeGroup.labelBladeComponentIndicatorOn = null;
            }
        }
        if (iBQDREntity.isPowerOn()) {
            this.setPowerStatus(0);
        } else {
            this.setPowerStatus(1);
        }
    }
}

