/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMUIPanel;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.blade.SELMessageCenterObserver;
import IPMIView20.blade.SELPanel_jAllRadioButton_actionAdapter;
import IPMIView20.blade.SELPanel_jDeleteButton_actionAdapter;
import IPMIView20.blade.SELPanel_jFromRadioButton_actionAdapter;
import IPMIView20.blade.SELPanel_jGetSELButton_actionAdapter;
import IPMIView20.blade.SELPanel_jLastEventRadioButton_actionAdapter;
import IPMIView20.blade.SELPanel_jRefreshButton_actionAdapter;
import IPMIView20.blade.SELPanel_jSaveButton_actionAdapter;
import IPMIView20.blade.SWindow;
import IPMIView20.group.TableSorter;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.SessionControllerFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class SELPanel
extends CMMUIPanel {
    TableSorter ts;
    DefaultTableModel dtm;
    SELInfo selInfo = null;
    SELMessageCenterObserver selMessageCenterObserver;
    Icon refreshIcon = new ImageIcon(this.getClass().getResource("/images/Refresh24.gif"));
    Icon listIcon = new ImageIcon(this.getClass().getResource("/images/list.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon deleteIcon = new ImageIcon(this.getClass().getResource("/images/delete.gif"));
    Icon newIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_new_device.gif"));
    ButtonGroup radioButtonGroup = new ButtonGroup();
    BorderLayout borderLayout1 = new BorderLayout();
    JToolBar jToolBar1 = new JToolBar();
    JPanel jCenterPanel = new JPanel();
    JButton jGetSELButton = new JButton();
    JButton jDeleteButton = new JButton();
    JButton jSaveButton = new JButton();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jSELInfoPanel = new JPanel();
    JPanel jSELTablePanel = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable = new JTable();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jSELDetailInfoPanel = new JPanel();
    JPanel jSELFilterPanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    TitledBorder titledBorder2 = new TitledBorder("");
    TitledBorder titledBorder3 = new TitledBorder("");
    GridLayout gridLayout2 = new GridLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    GridLayout gridLayout4 = new GridLayout();
    GridLayout gridLayout5 = new GridLayout();
    GridLayout gridLayout6 = new GridLayout();
    GridLayout gridLayout7 = new GridLayout();
    JLabel jSELVersionStringLabel = new JLabel();
    JLabel jSELVersionLabel = new JLabel();
    JLabel jTotalEntriesStringLabel = new JLabel();
    JLabel jTotalEntriesLabel = new JLabel();
    JLabel jFreeSpaceStringLabel = new JLabel();
    JLabel jFreeSpaceLabel = new JLabel();
    JLabel jRecentEntryAddedStringLabel = new JLabel();
    JLabel jRecentEntryAddedLabel = new JLabel();
    JLabel jRecentEntryErasedStringLabel = new JLabel();
    JLabel jRecentEntryErasedLabel = new JLabel();
    GridLayout gridLayout8 = new GridLayout();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JPanel jPanel8 = new JPanel();
    JRadioButton jAllRadioButton = new JRadioButton();
    BorderLayout borderLayout3 = new BorderLayout();
    JRadioButton jFromRadioButton = new JRadioButton();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanel9 = new JPanel();
    JTextField jFromSELEndTextField = new JTextField();
    JLabel jLabel1 = new JLabel();
    JTextField jFromSELBeginTextField = new JTextField();
    BorderLayout borderLayout5 = new BorderLayout();
    boolean isLoadSELInfo = false;
    JButton jRefreshButton = new JButton();
    SWindow sWindow = null;
    JPanel jSELDetailMainPanel = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    JRadioButton jLastEventRadioButton = new JRadioButton();
    BorderLayout borderLayout7 = new BorderLayout();
    JTextField jLastSELTextField = new JTextField();
    JPanel jPanel10 = new JPanel();
    JLabel jLabel2 = new JLabel();
    String pathName = null;
    static JFileChooser fileChooser;

    public SELPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() {
        this.radioButtonGroup.add(this.jAllRadioButton);
        this.radioButtonGroup.add(this.jFromRadioButton);
        this.radioButtonGroup.add(this.jLastEventRadioButton);
        this.selMessageCenterObserver = new SELMessageCenterObserver(this);
        this.showHeader();
    }

    @Override
    public void setUserPrivilege() {
        this.jDeleteButton.setEnabled(false);
    }

    @Override
    public void setOperatorPrivilege() {
        this.jDeleteButton.setEnabled(true);
    }

    @Override
    public void setAdministratorPrivilege() {
        this.jDeleteButton.setEnabled(true);
    }

    private void jbInit() throws Exception {
        this.titledBorder3 = new TitledBorder(L.t("cmm.SEL.SEL_Events"));
        this.titledBorder2 = new TitledBorder(L.t("cmm.SEL.Parameter_SEL"));
        this.titledBorder1 = new TitledBorder(L.t("cmm.SEL.SEL_Information"));
        this.setLayout(this.borderLayout1);
        this.jGetSELButton.setToolTipText(L.t("cmm.SEL.Get_SEL_Records"));
        this.jGetSELButton.setIcon(this.listIcon);
        this.jGetSELButton.setMargin(new Insets(0, 0, 0, 0));
        this.jGetSELButton.setText(L.t("cmm.SEL.Get_SEL"));
        this.jGetSELButton.addActionListener(new SELPanel_jGetSELButton_actionAdapter(this));
        this.jDeleteButton.setToolTipText(L.t("cmm.SEL.Delete_SEL_Records"));
        this.jDeleteButton.setIcon(this.deleteIcon);
        this.jDeleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.jDeleteButton.setText(L.t("cmm.SEL.Delete"));
        this.jDeleteButton.addActionListener(new SELPanel_jDeleteButton_actionAdapter(this));
        this.jToolBar1.setFloatable(false);
        this.jSaveButton.setToolTipText(L.t("cmm.SEL.Save_SEL_Records"));
        this.jSaveButton.setIcon(this.saveIcon);
        this.jSaveButton.setMargin(new Insets(0, 0, 0, 0));
        this.jSaveButton.setText(L.t("cmm.SEL.Save"));
        this.jSaveButton.addActionListener(new SELPanel_jSaveButton_actionAdapter(this));
        this.jCenterPanel.setLayout(this.borderLayout2);
        this.jSELInfoPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.jSELDetailInfoPanel.setBorder(this.titledBorder1);
        this.jSELDetailInfoPanel.setLayout(this.gridLayout2);
        this.jSELFilterPanel.setBorder(this.titledBorder2);
        this.jSELFilterPanel.setLayout(this.gridLayout8);
        this.jSELTablePanel.setBorder(this.titledBorder3);
        this.jSELTablePanel.setLayout(this.borderLayout5);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(5);
        this.jPanel5.setLayout(this.gridLayout3);
        this.jPanel4.setLayout(this.gridLayout4);
        this.jPanel3.setLayout(this.gridLayout5);
        this.jPanel2.setLayout(this.gridLayout6);
        this.jPanel1.setLayout(this.gridLayout7);
        this.gridLayout3.setColumns(2);
        this.gridLayout4.setColumns(2);
        this.gridLayout5.setColumns(2);
        this.gridLayout6.setColumns(2);
        this.gridLayout7.setColumns(2);
        this.jSELVersionStringLabel.setForeground(Color.blue);
        this.jSELVersionStringLabel.setText(L.t("cmm.SEL.SEL_Version"));
        this.jTotalEntriesStringLabel.setForeground(Color.blue);
        this.jTotalEntriesStringLabel.setText(L.t("cmm.SEL.Total_Entries"));
        this.jFreeSpaceStringLabel.setForeground(Color.blue);
        this.jFreeSpaceStringLabel.setText(L.t("cmm.SEL.Free_Space"));
        this.jRecentEntryAddedStringLabel.setForeground(Color.blue);
        this.jRecentEntryAddedStringLabel.setText(L.t("cmm.SEL.Recent_Entry_Added"));
        this.jRecentEntryErasedStringLabel.setForeground(Color.blue);
        this.jRecentEntryErasedStringLabel.setText(L.t("cmm.SEL.Recent_Entry_Erased"));
        this.gridLayout8.setColumns(1);
        this.gridLayout8.setRows(3);
        this.jAllRadioButton.setSelected(true);
        this.jAllRadioButton.setText(L.t("cmm.SEL.All"));
        this.jAllRadioButton.addActionListener(new SELPanel_jAllRadioButton_actionAdapter(this));
        this.jPanel8.setLayout(this.borderLayout3);
        this.jFromRadioButton.setText(L.t("cmm.SEL.From"));
        this.jFromRadioButton.addActionListener(new SELPanel_jFromRadioButton_actionAdapter(this));
        this.jPanel7.setLayout(this.borderLayout4);
        this.jFromSELEndTextField.setEnabled(false);
        this.jFromSELEndTextField.setPreferredSize(new Dimension(50, 20));
        this.jLabel1.setText(L.t("cmm.SEL.To"));
        this.jFromSELBeginTextField.setEnabled(false);
        this.jFromSELBeginTextField.setPreferredSize(new Dimension(50, 20));
        this.jRefreshButton.setToolTipText(L.t("cmm.SEL.Refresh_SEL_Information"));
        this.jRefreshButton.setIcon(this.refreshIcon);
        this.jRefreshButton.setMargin(new Insets(0, 0, 0, 0));
        this.jRefreshButton.setText(L.t("cmm.SEL.Refresh"));
        this.jRefreshButton.addActionListener(new SELPanel_jRefreshButton_actionAdapter(this));
        this.jSELDetailMainPanel.setLayout(this.borderLayout6);
        this.jLastEventRadioButton.setText(L.t("cmm.SEL.Last"));
        this.jLastEventRadioButton.addActionListener(new SELPanel_jLastEventRadioButton_actionAdapter(this));
        this.jPanel6.setLayout(this.borderLayout7);
        this.jLastSELTextField.setEnabled(false);
        this.jLastSELTextField.setPreferredSize(new Dimension(60, 20));
        this.jLabel2.setText(L.t("cmm.SEL.events"));
        this.add((Component)this.jCenterPanel, "Center");
        this.jToolBar1.add(this.jGetSELButton);
        this.jToolBar1.add(this.jRefreshButton);
        this.jToolBar1.add(this.jSaveButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.jDeleteButton);
        this.jPanel5.add(this.jSELVersionStringLabel);
        this.jPanel5.add(this.jSELVersionLabel);
        this.jSELDetailInfoPanel.add(this.jPanel4);
        this.jSELDetailInfoPanel.add(this.jPanel5);
        this.jPanel4.add(this.jTotalEntriesStringLabel);
        this.jPanel4.add(this.jTotalEntriesLabel);
        this.jSELDetailInfoPanel.add(this.jPanel3);
        this.jPanel3.add(this.jFreeSpaceStringLabel);
        this.jPanel3.add(this.jFreeSpaceLabel);
        this.jSELDetailInfoPanel.add(this.jPanel2);
        this.jPanel2.add(this.jRecentEntryAddedStringLabel);
        this.jPanel2.add(this.jRecentEntryAddedLabel);
        this.jSELDetailInfoPanel.add(this.jPanel1);
        this.jPanel1.add(this.jRecentEntryErasedStringLabel);
        this.jPanel1.add(this.jRecentEntryErasedLabel);
        this.jSELInfoPanel.add(this.jSELDetailMainPanel);
        this.jSELInfoPanel.add(this.jSELFilterPanel);
        this.jSELFilterPanel.add(this.jPanel8);
        this.jSELFilterPanel.add(this.jPanel7);
        this.jSELFilterPanel.add(this.jPanel6);
        this.jScrollPane1.getViewport().add(this.jTable);
        this.jPanel8.add((Component)this.jAllRadioButton, "Center");
        this.jPanel7.add((Component)this.jFromRadioButton, "West");
        this.jPanel7.add((Component)this.jPanel9, "Center");
        this.jPanel9.add(this.jFromSELBeginTextField);
        this.jPanel9.add(this.jLabel1);
        this.jPanel9.add(this.jFromSELEndTextField);
        this.jSELTablePanel.add((Component)this.jScrollPane1, "Center");
        this.jSELDetailMainPanel.add((Component)this.jSELDetailInfoPanel, "Center");
        this.jCenterPanel.add((Component)this.jSELTablePanel, "Center");
        this.jCenterPanel.add((Component)this.jSELInfoPanel, "South");
        this.jPanel6.add((Component)this.jLastEventRadioButton, "West");
        this.jPanel10.add(this.jLastSELTextField);
        this.jPanel10.add(this.jLabel2);
        this.jCenterPanel.add((Component)this.jToolBar1, "North");
        this.jPanel6.add((Component)this.jPanel10, "Center");
    }

    @Override
    public void present() {
        if (!this.isLoadSELInfo) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SELPanel.this.loadSELInfo();
                }
            };
            thread.start();
            this.isLoadSELInfo = true;
        }
    }

    private void loadSELInfo() {
        ISessionController sessionController = null;
        try {
            IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
            sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiSELCommand);
            if (sessionController == null) {
                return;
            }
            this.selInfo = ipmiSELCommand.getSELInfoModal();
            this.jSELVersionLabel.setText(this.selInfo.getSELVersionString());
            this.jTotalEntriesLabel.setText("" + this.selInfo.getLogEntries());
            this.jFreeSpaceLabel.setText(this.selInfo.getFreeSpace() + " " + L.t("cmm.SEL.bytes"));
            this.jRecentEntryAddedLabel.setText(ByteUtility.fourByteToDate(this.selInfo.getMostRecentAdditionTimeStamp()));
            this.jRecentEntryErasedLabel.setText(ByteUtility.fourByteToDate(this.selInfo.getMostRecentEraseTimeStamp()));
            sessionController.closeSession();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.findParentFrame(), e.toString());
            return;
        }
    }

    public void showHeader() {
        ArrayList headerList = this.getHeader();
        DefaultTableModel dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(dtm);
        this.jTable.setModel(this.ts);
    }

    public ArrayList getHeader() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(L.t("cmm.SEL.Event") + "    ");
        headerList.add(L.t("cmm.SEL.Time_Stamp") + "    ");
        headerList.add(L.t("cmm.SEL.Type"));
        headerList.add(L.t("cmm.SEL.Sensor"));
        headerList.add(L.t("cmm.SEL.Event_Type") + " ");
        return headerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSEL() {
        int count = 1;
        MessageCenter.getInstance().addObserver(this.selMessageCenterObserver);
        ISessionController sessionController = null;
        this.setCursor(new Cursor(3));
        ArrayList headerList = this.getHeader();
        this.dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(this.dtm);
        try {
            IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
            IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
            sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiSELCommand);
            if (sessionController == null) {
                return;
            }
            ipmiSDRCommand.setIPMIInterface(ipmiSELCommand.getIPMIInterface());
            SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
            ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
            SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
            if (selInfo == null) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.SEL.Get_SEL_failed"));
                return;
            }
            if (selInfo.getLogEntries() == 0) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.SEL.SEL_is_empty"));
                return;
            }
            this.sWindow.setVisible(true);
            this.sWindow.setMessage(L.t("cmm.SEL.Loading_SEL") + " ...", "", "");
            ArrayList list = null;
            if (this.jAllRadioButton.isSelected()) {
                list = ipmiSELCommand.getSELEntries(selInfo.getLogEntries());
            } else if (this.jFromRadioButton.isSelected()) {
                int from = Integer.parseInt(this.jFromSELBeginTextField.getText());
                int to = Integer.parseInt(this.jFromSELEndTextField.getText());
                list = ipmiSELCommand.getSELEntriesByRange(from, to);
                count = from;
            } else if (this.jLastEventRadioButton.isSelected()) {
                int last = Integer.parseInt(this.jLastSELTextField.getText());
                list = ipmiSELCommand.getSELEntriesByRange(selInfo.getLogEntries() - last + 1, selInfo.getLogEntries());
                count = selInfo.getLogEntries() - last + 1;
            }
            if (list.size() != 0) {
                for (SELRecord item : list) {
                    ArrayList<String> raw = new ArrayList<String>();
                    raw.add("" + count);
                    raw.add(ByteUtility.fourByteToDate(item.getTimeStamp()));
                    raw.add(GlobalDefine.getSensorType(item.getSensorType() & 0xFF));
                    if ((item.getSensorType() & 0xFF) >= 193 && (item.getSensorType() & 0xFF) <= 197) {
                        raw.add(GlobalDefine.getSensorType(item.getSensorType() & 0xFF) + " " + (byte)(item.getSensorNumber() & 0xFF));
                    } else {
                        raw.add((String)SDRRecord.sensorNumberToSensorName.get("" + (item.getSensorNumber() & 0xFF)));
                    }
                    raw.add(GlobalDefine.getEventType((byte)(item.getEventDir() | item.getEventType()), item.getSensorType(), item.getEventData1(), item.getEventData2(), item.getEventData3()));
                    ((DefaultTableModel)this.ts.getTableModel()).addRow(raw.toArray());
                    ++count;
                }
                this.sWindow.setMessage(L.t("cmm.SEL.Finished"), "", "");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            } else {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.SEL.SEL_is_Failed"));
                return;
            }
            this.sWindow.setMessage("", "", "");
            this.xMessage.setText(" ");
            this.jTable.setModel(this.ts);
            this.ts.setTableHeader(this.jTable.getTableHeader());
            this.jTable.getColumnModel().getColumn(0).setPreferredWidth(80);
            this.jTable.getColumnModel().getColumn(1).setPreferredWidth(140);
            this.jTable.getColumnModel().getColumn(2).setPreferredWidth(50);
            this.jTable.getColumnModel().getColumn(3).setPreferredWidth(80);
            this.jTable.getColumnModel().getColumn(4).setPreferredWidth(300);
            this.jTable.invalidate();
            sessionController.closeSession();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.findParentFrame(), e.getMessage());
            return;
        }
        finally {
            this.setCursor(new Cursor(0));
            MessageCenter.getInstance().deleteObserver(this.selMessageCenterObserver);
        }
    }

    public void jGetSELButton_actionPerformed(ActionEvent e) {
        if (!this.checkGetParameter()) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (SELPanel.this.sWindow == null) {
                    SELPanel.this.sWindow = new SWindow(IPMIView20.getInstance(), L.t("cmm.SEL.Loading_SEL") + " ...", "", "");
                }
                SELPanel.this.loadSEL();
                SELPanel.this.sWindow.setVisible(false);
            }
        };
        thread.start();
    }

    private boolean checkGetParameter() {
        if (this.jFromRadioButton.isSelected()) {
            int from = 0;
            int to = 0;
            try {
                from = Integer.parseInt(this.jFromSELBeginTextField.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage(), L.t("cmm.SEL.Warning"), 2);
                return false;
            }
            try {
                to = Integer.parseInt(this.jFromSELEndTextField.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage(), L.t("cmm.SEL.Warning"), 2);
                return false;
            }
            if (from <= 0 || to <= 0 || from > to) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.SEL.Input_data_invalid"), L.t("cmm.SEL.Warning"), 2);
                return false;
            }
            if (from > this.selInfo.getLogEntries() || to > this.selInfo.getLogEntries()) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.SEL.Parameter_out_range"), L.t("cmm.SEL.Warning"), 2);
                return false;
            }
        } else if (this.jLastEventRadioButton.isSelected()) {
            int last = 0;
            try {
                last = Integer.parseInt(this.jLastSELTextField.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage(), L.t("cmm.SEL.Warning"), 2);
                return false;
            }
            if (last <= 0) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.SEL.Input_data_invalid"), L.t("cmm.SEL.Warning"), 2);
                return false;
            }
            if (last > this.selInfo.getLogEntries()) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.SEL.Parameter_out_range"), L.t("cmm.SEL.Warning"), 2);
                return false;
            }
        }
        return true;
    }

    public void handleMessageCenterObserver(Observable o, Object arg) {
        MessageCenter.ClassMessage classMessage = (MessageCenter.ClassMessage)arg;
        if (classMessage.from.equals("com.supermicro.ipmi.IPMISELCommand") || classMessage.from.equals("com.supermicro.ipmi.IPMISDRCommand")) {
            this.xMessage.setText(classMessage.content);
        }
    }

    public void jAllRadioButton_actionPerformed(ActionEvent e) {
        this.jFromSELBeginTextField.setEnabled(false);
        this.jFromSELEndTextField.setEnabled(false);
        this.jLastSELTextField.setEnabled(false);
    }

    public void jFromRadioButton_actionPerformed(ActionEvent e) {
        this.jFromSELBeginTextField.setEnabled(true);
        this.jFromSELEndTextField.setEnabled(true);
        this.jLastSELTextField.setEnabled(false);
    }

    public void jLastEventRadioButton_actionPerformed(ActionEvent e) {
        this.jFromSELBeginTextField.setEnabled(false);
        this.jFromSELEndTextField.setEnabled(false);
        this.jLastSELTextField.setEnabled(true);
    }

    public void jRefreshButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                SELPanel.this.loadSELInfo();
                SELPanel.this.xMessage.setText(L.t("cmm.SEL.SEL_Information_refreshed"));
            }
        };
        thread.start();
    }

    public void jSaveButton_actionPerformed(ActionEvent e) {
        int rowCount = this.jTable.getModel().getRowCount();
        if (rowCount == 0) {
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("group.table.toolbar.No_data"));
            return;
        }
        boolean save = false;
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        if (fileChooser.showSaveDialog(null) == 0) {
            this.pathName = fileChooser.getSelectedFile().getAbsolutePath();
            File xfi = new File(this.pathName);
            if (xfi.exists()) {
                int ret = JOptionPane.showConfirmDialog(this.findParentFrame(), L.t("group.table.toolbar.Do_you_want_to_overwrite_it"), L.t("group.table.toolbar.Request_Confirmation"), 0);
                if (ret == 0) {
                    save = true;
                }
            } else {
                save = true;
            }
        }
        if (!save) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int i;
                StringBuffer sb = new StringBuffer();
                ArrayList list = SELPanel.this.getHeader();
                for (i = 0; i < list.size(); ++i) {
                    sb.append(list.get(i));
                    if (i == list.size() - 1) continue;
                    sb.append(",");
                }
                sb.append("\n");
                for (i = 0; i < SELPanel.this.jTable.getRowCount(); ++i) {
                    for (int j = 0; j < SELPanel.this.jTable.getColumnCount(); ++j) {
                        sb.append((String)((TableSorter)SELPanel.this.jTable.getModel()).getValueAt(i, j));
                        if (j == SELPanel.this.jTable.getColumnCount() - 1) continue;
                        sb.append(",");
                    }
                    sb.append("\n");
                }
                try {
                    PrintWriter pw = new PrintWriter(new File(SELPanel.this.pathName), "UTF-8");
                    pw.println(sb.toString());
                    pw.close();
                    JOptionPane.showMessageDialog(SELPanel.this.findParentFrame(), L.t("group.table.toolbar.save_to") + " " + SELPanel.this.pathName + " " + L.t("group.table.toolbar.completed"));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(SELPanel.this.findParentFrame(), L.t("group.table.toolbar.Cannot_save_to_file_It_probably_is_locked_or_read-only"), L.t("group.table.toolbar.Warning"), 0);
                }
            }
        };
        thread.start();
    }

    public void jDeleteButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(SELPanel.this.findParentFrame(), L.t("cmm.SEL.Are_delete_logs"), L.t("cmm.SEL.Confirmation"), 0);
                if (result == 1) {
                    return;
                }
                SELPanel.this.deleteAllSEL();
            }
        };
        thread.start();
    }

    private void deleteAllSEL() {
        ISessionController sessionController = null;
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiSELCommand);
        if (sessionController == null) {
            return;
        }
        ipmiSELCommand.clearSEL();
        sessionController.closeSession();
        this.showHeader();
        this.loadSELInfo();
    }

    private void deletePartial() throws NumberFormatException {
        ISessionController sessionController = null;
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiSELCommand);
        if (sessionController == null) {
            return;
        }
        int[] selectedRows = this.jTable.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            String s = (String)this.jTable.getValueAt(selectedRows[i], 0);
            int eventNumber = Integer.parseInt(s);
            boolean result = ipmiSELCommand.deleteSEL(eventNumber);
            System.out.println("" + eventNumber + " =" + result);
        }
        sessionController.closeSession();
        this.loadSELInfo();
        this.loadSEL();
    }

    @Override
    public void closePanel() {
        this.cmmSessionPanel = null;
    }
}

