/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap;

import IPMIView20.Logger;
import IPMIView20.trap.Trap;
import java.util.ArrayList;
import java.util.Observable;
import java.util.SortedMap;
import java.util.TreeMap;

public class TrapCollector
extends Observable {
    ArrayList traps = new ArrayList();
    SortedMap sender = new TreeMap();
    SortedMap community = new TreeMap();
    SortedMap sensor = new TreeMap();

    public void put(Trap trap) {
        trap.setNum(this.traps.size() + 1);
        this.traps.add(trap);
        this.classification(trap);
        this.setChanged();
        this.notifyObservers(trap);
        Logger.writeLog("trapSize =" + this.traps.size() + ",community =" + this.community.size() + ",sender=" + this.sender.size() + ",sensor=" + this.sensor.size());
    }

    public ArrayList getTraps() {
        return this.traps;
    }

    public void classification(Trap trap) {
        this.classifySender(trap);
        this.classifyCommunity(trap);
        this.classifySensor(trap);
    }

    public void classifySender(Trap trap) {
        if (this.sender.get(trap.getIp()) == null) {
            ArrayList<Trap> list = new ArrayList<Trap>();
            list.add(trap);
            this.sender.put(trap.getIp(), list);
        } else {
            ArrayList list = (ArrayList)this.sender.get(trap.getIp());
            list.add(trap);
        }
    }

    public void classifyCommunity(Trap trap) {
        if (this.community.get(trap.getCommunity()) == null) {
            ArrayList<Trap> list = new ArrayList<Trap>();
            list.add(trap);
            this.community.put(trap.getCommunity(), list);
        } else {
            ArrayList list = (ArrayList)this.community.get(trap.getCommunity());
            list.add(trap);
        }
    }

    public void classifySensor(Trap trap) {
        if (this.sensor.get(trap.getSensor()) == null) {
            ArrayList<Trap> list = new ArrayList<Trap>();
            list.add(trap);
            String sensorStr = trap.getSensor();
            if (sensorStr == "" || sensorStr.length() == 0) {
                sensorStr = "None";
            }
            this.sensor.put(sensorStr, list);
        } else {
            ArrayList list = (ArrayList)this.sensor.get(trap.getSensor());
            list.add(trap);
        }
    }

    public void save(String filename) {
    }

    public void load(String filename) {
    }

    public SortedMap getCommunity() {
        return this.community;
    }

    public SortedMap getSender() {
        return this.sender;
    }

    public SortedMap getSensorType() {
        return this.sensor;
    }

    public void clear() {
        this.traps.clear();
        this.sender.clear();
        this.community.clear();
        this.sensor.clear();
    }
}

