/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap;

import IPMIView20.GlobalDefine;
import IPMIView20.L;
import IPMIView20.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class TrapTree {
    public DefaultTreeModel treeModel;
    public DefaultMutableTreeNode rootNode;
    BerDecoder berDecoder = new BerDecoder();
    GlobalDefine gd = new GlobalDefine();

    public TrapTree() {
        this.rootNode = new DefaultMutableTreeNode(L.t("trap.tree.SNMP_Trap"));
        this.treeModel = new DefaultTreeModel(this.rootNode);
    }

    public void decodeTrap(byte[] databuff, int datalength) {
        int offset = 0;
        offset = this.getMessagePreamble(this.rootNode, databuff, offset);
        offset = this.getPDUHeader(this.rootNode, databuff, offset);
        offset = this.getPDUBody(this.rootNode, databuff, offset, datalength);
    }

    private int getMessagePreamble(DefaultMutableTreeNode TrapNode, byte[] databuff, int offset) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(L.t("trap.tree.SNMP_Header"));
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        try {
            offset = this.getMessageLength(childNode, this.berDecoder.parseHeader(databuff, offset));
            offset = this.getMessageVersion(childNode, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getCommunity(childNode, this.berDecoder.parseString(databuff, offset));
        }
        catch (AsnDecodingException ae) {
            // empty catch block
        }
        return offset;
    }

    private int getPDUHeader(DefaultMutableTreeNode TrapNode, byte[] databuff, int offset) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(L.t("trap.tree.PDU_Header"));
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        try {
            offset = this.getPDUType(childNode, this.berDecoder.parseHeader(databuff, offset));
            offset = this.getEnterpriseMIB(childNode, this.berDecoder.parseObjectId(databuff, offset));
            offset = this.getAgentIP(childNode, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getGTrapType(childNode, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getSTrapType(childNode, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getTimeStamp(childNode, this.berDecoder.parseUInteger64(databuff, offset));
        }
        catch (AsnDecodingException ae) {
            // empty catch block
        }
        return offset;
    }

    private int getPDUBody(DefaultMutableTreeNode TrapNode, byte[] databuff, int offset, int datalength) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(L.t("trap.tree.PDU_Body"));
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        try {
            offset = this.getLengthBind(childNode, this.berDecoder.parseHeader(databuff, offset));
            while (offset < datalength) {
                DefaultMutableTreeNode childNode1 = new DefaultMutableTreeNode(L.t("trap.tree.Bind"));
                this.treeModel.insertNodeInto(childNode1, childNode, childNode.getChildCount());
                offset = this.getBindLength(childNode1, this.berDecoder.parseHeader(databuff, offset));
                offset = this.getBind(childNode1, databuff, offset);
            }
        }
        catch (AsnDecodingException ae) {
            // empty catch block
        }
        return offset;
    }

    private int getMessageLength(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String(L.t("trap.tree.Message_Length") + ": " + xx);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getMessageVersion(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String(L.t("trap.tree.Message_Version") + ": v" + (xx + 1));
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getCommunity(DefaultMutableTreeNode TrapNode, Object[] value) {
        ByteArrayOutputStream strout = new ByteArrayOutputStream();
        try {
            strout.write((byte[])value[2]);
        }
        catch (IOException ie) {
            // empty catch block
        }
        String yy = strout.toString();
        String string = new String(L.t("trap.tree.Community") + ": " + yy);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        int xx = (Integer)value[0];
        return xx;
    }

    private int getPDUType(DefaultMutableTreeNode TrapNode, Object[] value) {
        byte zz = (Byte)value[1];
        String string = zz == -92 ? new String(L.t("trap.tree.Type") + ":" + L.t("trap.tree.Trap")) : new String(L.t("trap.tree.Type") + ":" + L.t("trap.tree.unknown"));
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        int xx = (Integer)value[2];
        string = new String(L.t("trap.tree.length") + ": " + xx);
        childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getEnterpriseMIB(DefaultMutableTreeNode TrapNode, Object[] value) {
        String string = new String("");
        int[] xx = (int[])value[2];
        int xxl = xx.length;
        string = "" + xx[0];
        for (int i = 1; i < xxl; ++i) {
            string = string + "." + xx[i];
        }
        string = new String(L.t("trap.tree.Enterprise") + ": " + string);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        int yy = (Integer)value[0];
        return yy;
    }

    private int getAgentIP(DefaultMutableTreeNode TrapNode, Object[] value) {
        String string = new String("");
        int xx = (Integer)value[2];
        StringBuffer buf = new StringBuffer();
        buf.append(xx >> 24 & 0xFF);
        buf.append('.');
        buf.append(xx >> 16 & 0xFF);
        buf.append('.');
        buf.append(xx >> 8 & 0xFF);
        buf.append('.');
        buf.append(xx & 0xFF);
        string = new String(L.t("trap.tree.Agent_IP") + ": " + buf);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getGTrapType(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String(L.t("trap.tree.Generic_Trap_Type") + ": " + xx);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getSTrapType(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String(L.t("trap.tree.Specific_Trap_Type") + ": " + xx);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getTimeStamp(DefaultMutableTreeNode TrapNode, Object[] value) {
        long yy = ((BigInteger)value[2]).longValue();
        String string = new String(L.t("trap.tree.Timeticks") + ": " + yy);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        int xx = (Integer)value[0];
        return xx;
    }

    private int getLengthBind(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String(L.t("trap.tree.Total_Length_of_Variable_Binding") + ": " + xx);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getBindLength(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String(L.t("trap.tree.Length_of_Binding") + ": " + xx);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getBind(DefaultMutableTreeNode TrapNode, byte[] databuff, int offset) {
        Object[] value = new Object[3];
        String string = new String("");
        Logger.writeLog(new String(databuff));
        try {
            value = this.berDecoder.parseObjectId(databuff, offset);
            int[] xx = (int[])value[2];
            int xxl = xx.length;
            string = "" + xx[0];
            for (int i = 1; i < xxl; ++i) {
                string = string + "." + xx[i];
            }
            string = new String("OID: " + string);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
            this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
            offset = (Integer)value[0];
            value = this.berDecoder.parseString(databuff, offset);
            if (string.compareTo("OID: 1.3.6.1.4.1.3183.1.1.1") == 0) {
                childNode = new DefaultMutableTreeNode(L.t("trap.tree.PET_Data"));
                this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
                this.parsePET(childNode, (byte[])value[2]);
            } else {
                ByteArrayOutputStream strout = new ByteArrayOutputStream();
                try {
                    strout.write((byte[])value[2]);
                }
                catch (IOException ie) {
                    // empty catch block
                }
                String yy = strout.toString();
                string = new String(L.t("trap.tree.Value") + ": " + yy);
                if (yy != null) {
                    // empty if block
                }
                childNode = new DefaultMutableTreeNode(string);
                this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
            }
            offset = (Integer)value[0];
        }
        catch (AsnDecodingException ae) {
            // empty catch block
        }
        return offset;
    }

    private void parsePET(DefaultMutableTreeNode TrapNode, byte[] value) {
        DefaultMutableTreeNode childNode;
        ByteArrayOutputStream strout = new ByteArrayOutputStream();
        byte[] eventData = null;
        byte genericOffset = 0;
        byte sensorNumber = 0;
        int length = 0;
        byte recordType = 0;
        byte sensorType = 0;
        byte[] sensorName = null;
        String description = null;
        for (int j = 0; j < value.length; ++j) {
            if ((value[j] & 0xFF) != 128) continue;
            eventData = new byte[3];
            System.arraycopy(value, 31, eventData, 0, 3);
            genericOffset = (byte)(eventData[0] & 0xF);
            sensorNumber = value[29];
            length = value[j + 1] & 0x3F;
            if (length < 0) continue;
            recordType = value[j + 2];
            sensorType = value[j + 3];
            sensorName = new byte[length];
            description = sensorType == 1 || sensorType == 2 || sensorType == 3 || sensorType == 4 ? this.gd.LookupEventType(1, genericOffset) : this.gd.LookupSensorType(sensorType, genericOffset);
            System.arraycopy(value, j + 4, sensorName, 0, length);
            String xMessage = "[ " + new String(sensorName) + " ] " + description;
            childNode = new DefaultMutableTreeNode(xMessage);
            this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
            break;
        }
        String string = "";
        boolean quota = false;
        boolean square = false;
        for (int i = 0; i < value.length; ++i) {
            if (value[i] < 32 || value[i] > 126) {
                if (!square) {
                    if (quota) {
                        string = string + "\"";
                        quota = false;
                    }
                    string = string + "[";
                    square = true;
                }
                string = string + "x" + new String(Integer.toHexString(this.byteToInt(value[i]))).toUpperCase();
                continue;
            }
            if (!quota) {
                if (square) {
                    string = string + "]";
                    square = false;
                }
                string = string + "\"";
                quota = true;
            }
            strout.write(value, i, 1);
            String yy = strout.toString();
            string = string + yy;
        }
        if (square) {
            string = string + "]";
        }
        if (quota) {
            string = string + "\"";
        }
        childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
    }

    public int byteToInt(byte b) {
        return b < 0 ? 256 + b : b;
    }

    public class AsnDecodingException
    extends Exception {
        public AsnDecodingException() {
        }

        public AsnDecodingException(String why) {
            super(why);
        }
    }

    public class BerDecoder {
        private static final byte LONG_LENGTH = -128;
        private static final byte HIGH_BIT = -128;
        private static final byte EXTENSION_ID = 31;
        private static final byte CONSTRUCTOR = 32;

        public Object[] ASNDecode(byte[] databuff, int[] startoffset) {
            Object[] rVar;
            int n = startoffset[0];
            startoffset[0] = n + 1;
            switch (databuff[n]) {
                case 2: {
                    rVar = new Object[1];
                    break;
                }
                default: {
                    rVar = new Object[2];
                }
            }
            return rVar;
        }

        protected int byteToInt(byte b) {
            return b < 0 ? 256 + b : b;
        }

        protected long byteToLong(byte b) {
            return b < 0 ? 256L + (long)b : (long)b;
        }

        protected boolean isConstructor(byte b) {
            return (b & 0x20) == 32;
        }

        protected boolean isExtensionId(byte b) {
            return (b & 0x1F) == 31;
        }

        public Object[] parseLength(byte[] buf, int startOffset) throws AsnDecodingException {
            byte numBytes;
            if (buf.length - startOffset < 1) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            Object[] retVals = new Object[2];
            if (((numBytes = buf[startOffset++]) & 0xFFFFFF80) == 0) {
                numBytes = (byte)(numBytes & 0x7F);
                retVals[1] = new Integer(this.byteToInt(numBytes));
            } else if ((numBytes = (byte)(numBytes & 0x7F)) == 1) {
                if (buf.length - startOffset < 1) {
                    throw new AsnDecodingException("Buffer underflow error");
                }
                retVals[1] = new Integer(this.byteToInt(buf[startOffset++]));
            } else if (numBytes == 2) {
                if (buf.length - startOffset < 2) {
                    throw new AsnDecodingException("Buffer underflow error");
                }
                int val = this.byteToInt(buf[startOffset++]) << 8 | this.byteToInt(buf[startOffset++]);
                retVals[1] = new Integer(val);
            } else {
                throw new AsnDecodingException("Invalid ASN.1 length");
            }
            retVals[0] = new Integer(startOffset);
            return retVals;
        }

        public Object[] parseHeader(byte[] buf, int startOffset) throws AsnDecodingException {
            byte asnType;
            if (buf.length - startOffset < 1) {
                throw new AsnDecodingException("Insufficent buffer length");
            }
            if (this.isExtensionId(asnType = buf[startOffset++])) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            Object[] lenVals = this.parseLength(buf, startOffset);
            Object[] rVals = new Object[]{lenVals[0], new Byte(asnType), lenVals[1]};
            return rVals;
        }

        public Object[] parseInteger32(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength > 4) {
                throw new AsnDecodingException("Integer too large: cannot decode");
            }
            int asnValue = 0;
            if ((buf[startOffset] & 0xFFFFFF80) == -128) {
                asnValue = -1;
            }
            while (asnLength-- > 0) {
                asnValue = asnValue << 8 | this.byteToInt(buf[startOffset++]);
            }
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, new Integer(asnValue)};
            return rVals;
        }

        public Object[] parseUInteger32(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength > 5) {
                throw new AsnDecodingException("Integer too large: cannot decode");
            }
            long asnValue = 0L;
            if ((buf[startOffset] & 0xFFFFFF80) == -128) {
                asnValue = -1L;
            }
            while (asnLength-- > 0) {
                asnValue = asnValue << 8 | this.byteToLong(buf[startOffset++]);
            }
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, new Long(asnValue &= 0xFFFFFFFFL)};
            return rVals;
        }

        public Object[] parseUInteger64(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength > 9) {
                throw new AsnDecodingException("Integer too large: cannot decode");
            }
            byte[] asnBuf = new byte[asnLength];
            for (int i = 0; i < asnLength; ++i) {
                asnBuf[i] = buf[startOffset++];
            }
            BigInteger asnValue = new BigInteger(asnBuf);
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, asnValue};
            return rVals;
        }

        public Object[] parseNull(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            if ((Integer)hdrVals[2] != 0) {
                throw new AsnDecodingException("Malformed ASN.1 Type");
            }
            Object[] rVals = new Object[]{hdrVals[0], hdrVals[1]};
            return rVals;
        }

        public Object[] parseString(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Insufficent buffer length");
            }
            byte[] opaque = new byte[asnLength];
            try {
                this.copy(buf, startOffset, opaque, 0, asnLength);
            }
            catch (ArrayIndexOutOfBoundsException err) {
                throw new AsnDecodingException("Buffer underflow exception");
            }
            Object[] rVals = new Object[]{new Integer(startOffset + asnLength), asnType, opaque};
            return rVals;
        }

        public Object[] parseObjectId(byte[] buf, int startOffset) throws AsnDecodingException {
            int[] retOids;
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength == 0) {
                int[] ids = new int[2];
                ids[1] = 0;
                ids[0] = 0;
                Object[] rVals = new Object[]{new Integer(startOffset), asnType, ids};
                return rVals;
            }
            int idsOff = 0;
            int[] ids = new int[asnLength + 1];
            --asnLength;
            int oid = this.byteToInt(buf[startOffset++]);
            ids[idsOff++] = oid / 40;
            ids[idsOff++] = oid % 40;
            while (asnLength > 0) {
                oid = 0;
                boolean done = false;
                do {
                    --asnLength;
                    byte b = buf[startOffset++];
                    oid = oid << 7 | b & 0x7F;
                    if ((b & 0xFFFFFF80) != 0) continue;
                    done = true;
                } while (!done);
                ids[idsOff++] = oid;
            }
            if (idsOff == ids.length) {
                retOids = ids;
            } else {
                retOids = new int[idsOff];
                this.copy(ids, 0, retOids, 0, idsOff);
            }
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, retOids};
            return rVals;
        }

        protected void copy(byte[] src, int srcOff, byte[] dest, int destOff, int bytesToCopy) throws ArrayIndexOutOfBoundsException {
            if (dest.length - destOff < bytesToCopy || src.length - srcOff < bytesToCopy) {
                throw new ArrayIndexOutOfBoundsException("Destination or source buffer is insufficent");
            }
            for (int x = bytesToCopy - 1; x >= 0; --x) {
                dest[destOff + x] = src[srcOff + x];
            }
        }

        protected void copy(int[] src, int srcOff, int[] dest, int destOff, int intsToCopy) throws ArrayIndexOutOfBoundsException {
            if (dest.length - destOff < intsToCopy || src.length - srcOff < intsToCopy) {
                throw new ArrayIndexOutOfBoundsException("Destination or source buffer is insufficent");
            }
            for (int x = intsToCopy - 1; x >= 0; --x) {
                dest[destOff + x] = src[srcOff + x];
            }
        }
    }
}

