/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.update;

import IPMIView20.BrowserControl;
import IPMIView20.update.CheckUpdate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class Updater
extends JFrame
implements Observer {
    int runType = 0;
    boolean downloading = false;
    ImageIcon img = new ImageIcon(this.getClass().getResource("/images/domain.gif"));
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel jTtileLabel = new JLabel();
    JPanel jPanel1 = new JPanel();
    JProgressBar jDownloadProgressBar = new JProgressBar();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jMessageLabel = new JLabel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();

    public Updater(int runType) {
        this.runType = runType;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLookAndFeel();
        this.getContentPane().setLayout(this.borderLayout1);
        this.setTitle("Upgrade");
        this.jTtileLabel.setFont(new Font("Times New Roman", 1, 16));
        this.jTtileLabel.setForeground(Color.blue);
        this.jTtileLabel.setHorizontalAlignment(0);
        this.jTtileLabel.setText("IPMIView Upgrade Process");
        this.jPanel1.setPreferredSize(new Dimension(435, 65));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.setLayout(this.borderLayout2);
        this.getContentPane().add((Component)this.jMessageLabel, "South");
        this.getContentPane().add((Component)this.jTtileLabel, "North");
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.jPanel1.add((Component)this.jPanel3, "West");
        this.jPanel1.add((Component)this.jDownloadProgressBar, "North");
        this.setSize(new Dimension(435, 95));
        this.setIconImage(this.img.getImage());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        Thread thread = new Thread(){

            @Override
            public void run() {
                Updater.this.upgradeProcedure();
            }
        };
        thread.start();
    }

    public void upgradeProcedure() {
        this.downloading = true;
        String backupedFilename = "";
        CheckUpdate checkUpdate = new CheckUpdate();
        this.jDownloadProgressBar.setValue(0);
        this.jMessageLabel.setText("Ready to upgrade IPMIView");
        this.sleepMe(4000);
        this.jMessageLabel.setText("Backup IPMIView original version");
        this.sleepMe(1000);
        try {
            backupedFilename = checkUpdate.renameIPMIView();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
            System.exit(0);
        }
        this.jMessageLabel.setText("Downloading latest IPMIView ...");
        try {
            boolean result = checkUpdate.downloadIPMIView2(this);
            if (!result) {
                JOptionPane.showMessageDialog(this, "Download process failed");
                checkUpdate.restoreIPMIView(backupedFilename);
                System.exit(0);
            }
        }
        catch (Exception ex1) {
            JOptionPane.showMessageDialog(this, ex1.getMessage());
            checkUpdate.restoreIPMIView(backupedFilename);
            System.exit(0);
        }
        this.jMessageLabel.setText("Upgrade IPMIView Successfully");
        this.sleepMe(1000);
        this.downloading = false;
        int result = JOptionPane.showConfirmDialog(this, "Upgrade finished. Would you like to restart IPMIView ?", "Confirmation", 0);
        if (result == 0) {
            this.restartIPMIView();
        }
        System.exit(0);
    }

    public void restartIPMIView() {
        int osType = 0;
        osType = BrowserControl.isWindowsPlatform() ? 1 : 2;
        try {
            switch (this.runType) {
                case 1: {
                    Runtime.getRuntime().exec("java -jar IPMIView20.jar");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {}
                    break;
                }
                case 2: {
                    if (osType == 1) {
                        Runtime.getRuntime().exec("IPMIView20.exe");
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException ex) {}
                        break;
                    }
                    if (osType != 2) break;
                    Runtime.getRuntime().exec("./IPMIView20.bin");
                    try {
                        Thread.sleep(5000L);
                        break;
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        Integer integer = (Integer)arg;
        int percent = integer;
        this.jDownloadProgressBar.setValue(percent);
    }

    public void sleepMe(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIManager.put("InternalFrame.titleFont", new Font("Serif", 1, 12));
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        System.out.println("download =" + this.downloading);
        if (e.getID() == 201) {
            if (this.downloading) {
                JOptionPane.showMessageDialog(this, "Please wait for the update process finished");
                return;
            }
        } else {
            super.processWindowEvent(e);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("error");
            return;
        }
        int runType = 0;
        try {
            runType = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            System.out.println("error");
            return;
        }
        Updater updater = new Updater(runType);
        updater.setVisible(true);
    }
}

