/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.KeyBoardMouseSetting;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.StringTokenizer;

public class IPMICMMOEMCommand
extends IPMICommand {
    public static final byte CMM_TIME_MODE_LOCAL_TIME = 0;
    public static final byte CMM_TIME_MODE_NTP = 1;
    public static final byte FAN_CONTROL_MODE_AUTOMATIC = 0;
    public static final byte FAN_CONTROL_MODE_MANUAL = 1;
    public static final byte BLADE_MODE_ENTERPRISE = 0;
    public static final byte BLADE_MODE_OFFICE = 1;
    public static final byte BURST_POWER_DOWN = 0;
    public static final byte BURST_POWER_UP = 1;
    public static final byte BURST_POWER_RESET = 2;
    public static final byte BURST_POWER_GRACEFUL_POWER_DOWN = 3;

    public IPMICMMOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public void COMMAND____________________() {
    }

    public IPMIMessage detectSIMCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage is3VPowerGoodCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableP12VCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerRequestCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearPowerRequestCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{5, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getKVMRequestCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{6, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearKVMRequestCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{7, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableM1KVMCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{8, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableM2KVMCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage resetBladeCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3];
        data[0] = 10;
        data[1] = bladeIndex;
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isPowerSupplyOnForBladeCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{11, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getOverheatCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setBladeUIDCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{13, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage requestRemoteKVMCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3];
        data[0] = 14;
        data[1] = bladeIndex;
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setBladeReduceOrFullPowerCommand(byte mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{18, 70, 82, mode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage checkIfEnoughPowerForBladesCommand(byte[] bladeBits) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{19, bladeBits[0], bladeBits[1]};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerConsumptionStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{20};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBladeHWInfoCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{21, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage detectPowerSupplyCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerSupplyStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPowerSupplyFanSpeedCommand(byte powerIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3, powerIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage testPowerSupplyFanSpeedCommand(byte powerIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, powerIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enablePowerSupplyCommand(byte powerIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, powerIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getTotalRemainingPowerCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{6};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setAllPowerSupplyFanSpeedCommand(byte speed) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{7, speed};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setFanControlModeCommand(byte mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9, mode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFanControlModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableInfiniBandPowerCommand(byte bandIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, bandIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage resetInfiniBandCommand(byte bandIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, bandIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getInfiniBandPresentCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3};
        ipmiMessage.setCommandAndData((byte)-64, (byte)50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getInfiniBandAllSensorsCommand(byte bandIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, bandIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage resetGigabitSwitchCommand(byte switchIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, switchIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableGigabitSwitchPowerCommand(byte switchIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, switchIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGigabitSwitchStatusCommand(byte switchIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3, switchIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSystemInfoCommand(byte param) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2];
        data[0] = param;
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage testBladeErrorLEDCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCMMSlotCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage SetCMMTimeCommand(byte year, byte month, byte date, byte day, byte hr, byte min, byte sec) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, sec, min, hr, day, date, month, year};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCMMTimeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBIPCommand(byte gbIndex, byte[] ip) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        data[0] = 5;
        data[1] = gbIndex;
        System.arraycopy(ip, 0, data, 2, ip.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBNetMaskCommand(byte gbIndex, byte[] netMask) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        data[0] = 6;
        data[1] = gbIndex;
        System.arraycopy(netMask, 0, data, 2, netMask.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBGateWayCommand(byte gbIndex, byte[] gateWay) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        data[0] = 7;
        data[1] = gbIndex;
        System.arraycopy(gateWay, 0, data, 2, gateWay.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBUsernameCommand(byte gbIndex, byte[] username) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + username.length];
        data[0] = 8;
        data[1] = gbIndex;
        data[2] = (byte)username.length;
        System.arraycopy(username, 0, data, 3, username.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBPasswordCommand(byte gbIndex, byte[] password) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + password.length];
        data[0] = 9;
        data[1] = gbIndex;
        data[2] = (byte)password.length;
        System.arraycopy(password, 0, data, 3, password.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBTimeCommand(byte gbIndex, byte sec, byte min, byte hour, byte day, byte date, byte month, byte year, byte century) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, gbIndex, sec, min, hour, day, date, month, year, century};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBCommitCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{17, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBIPModeCommand(byte gbIndex, byte mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{19, gbIndex, mode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBResetToDefaultCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{20, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBBootUpImageCommand(byte gbIndex, byte imageIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{21, gbIndex, imageIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBRestartCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{22, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBIPModeCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{23, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBBootUpImageCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{24, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBIPCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{11, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBNetMaskCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBGatewayCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{13, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBUsernameCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{14, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBPasswordCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{15, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBTimeCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{16, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getOtherCMMIPCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{6};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCMMTimeSyncModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isCMMSupportIPMBCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage gracefulPowerDownBladeCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{16, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage testReplyCommand(byte[] bytes) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + bytes.length];
        data[0] = 8;
        System.arraycopy(bytes, 0, data, 1, bytes.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBIOSFirmwareStateCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = null;
        ipmiMessage.setCommandAndData((byte)-64, (byte)102, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPCA9xxxSlaveAddrCommand(byte state) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{state};
        ipmiMessage.setCommandAndData((byte)-64, (byte)103, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPCA9xxxSlaveAddrCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{60};
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPCA9xxxInfoCommand(byte bladeIndex, byte slaveAddr) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9, bladeIndex, slaveAddr, 0, 8};
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPCA955StatisticCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12};
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage writeMiddlePlaneFRUCommand(byte[] offset, byte[] fru) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[fru.length + 3];
        data[0] = 64;
        data[1] = offset[0];
        data[2] = offset[1];
        System.arraycopy(fru, 0, data, 3, fru.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage readMiddlePlaneFRUCommand(byte[] offset, byte bytesToRead) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{63, offset[0], offset[1], bytesToRead};
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getKeyboardMouseSettingCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)56, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setKeyboardMouseSettingCommand(byte[] setting) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[setting.length + 1];
        data[0] = 2;
        System.arraycopy(setting, 0, data, 1, setting.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)56, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getUTCOffsetCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setUTCOffsetCommand(byte offset) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{13, offset};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNTPServerPrimaryCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{14};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNTPServerSecondaryCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{15};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNTPServerPrimaryCommand(String server) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + server.getBytes().length];
        data[0] = 16;
        System.arraycopy(server.getBytes(), 0, data, 1, server.getBytes().length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNTPServerSecondaryCommand(String server) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + server.getBytes().length];
        data[0] = 17;
        System.arraycopy(server.getBytes(), 0, data, 1, server.getBytes().length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNTPModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{20};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setAllNTPServerCommand(String ntp1, String ntp2) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        if (ntp1 == null) {
            ntp1 = "";
        }
        if (ntp2 == null) {
            ntp2 = "";
        }
        byte ntp1Length = (byte)ntp1.length();
        byte ntp2Length = (byte)ntp2.length();
        byte[] data = new byte[2 + ntp1Length + ntp2Length];
        data[0] = 21;
        data[1] = ntp1Length;
        System.arraycopy(ntp1.getBytes(), 0, data, 2, ntp1Length);
        System.arraycopy(ntp2.getBytes(), 0, data, 2 + ntp1Length, ntp2Length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setAllNTPServerCommand(byte UTCOffset, String ntp1, String ntp2) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        if (ntp1 == null) {
            ntp1 = "";
        }
        if (ntp2 == null) {
            ntp2 = "";
        }
        byte ntp1Length = (byte)ntp1.length();
        byte ntp2Length = (byte)ntp2.length();
        byte[] data = new byte[3 + ntp1Length + ntp2Length];
        data[0] = 21;
        data[1] = UTCOffset;
        data[2] = ntp1Length;
        System.arraycopy(ntp1.getBytes(), 0, data, 3, ntp1Length);
        System.arraycopy(ntp2.getBytes(), 0, data, 3 + ntp1Length, ntp2Length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setBladeModeCommand(byte bladeMode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{25, bladeMode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBladeModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{26};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage sendMessageOEMCommand(byte channel, byte[] messageData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + messageData.length];
        data[0] = channel;
        data[0] = (byte)(data[0] | 0x80);
        System.arraycopy(messageData, 0, data, 1, messageData.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)66, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setEnabledNormalFunctionCommand(boolean isEnabled) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{isEnabled ? (byte)5 : 6};
        ipmiMessage.setCommandAndData((byte)-64, (byte)64, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setBladeNameCommand(byte bladeIndex, byte[] bladeName) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2 + bladeName.length];
        data[0] = 23;
        data[1] = bladeIndex;
        System.arraycopy(bladeName, 0, data, 2, bladeName.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBladeNameCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{24, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage burstPowerControlCommand(byte type, byte[] bladeIndexes) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2 + bladeIndexes.length];
        data[0] = 28;
        data[1] = type;
        System.arraycopy(bladeIndexes, 0, data, 2, bladeIndexes.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getStructureMetaDataCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-16};
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSystemInfoByBatchCommand(byte type, byte[] offset, byte[] length) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-15, type, offset[0], offset[1], length[0], length[1]};
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void API_________________________________() {
    }

    public byte[] detectSIM() throws IPMIException {
        IPMIMessage resMessage = this.detectSIMCommand();
        if (resMessage == null) {
            throw new IPMIException("call detectSIMCommand failed");
        }
        if (resMessage.completionCode == 0) {
            byte[] sim = new byte[4];
            System.arraycopy(resMessage.data, 0, sim, 0, sim.length);
            return sim;
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public byte[] is3VPowerGood() throws IPMIException {
        IPMIMessage resMessage = this.is3VPowerGoodCommand();
        if (resMessage == null) {
            throw new IPMIException("call is3VPowerGoodCommand failed");
        }
        if (resMessage.completionCode == 0) {
            byte[] sim = new byte[4];
            System.arraycopy(resMessage.data, 0, sim, 0, sim.length);
            return sim;
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public int enableP12V(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enableP12VCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call enableP12VCommand failed");
        }
        if (resMessage.completionCode == 0) {
            if (resMessage.data[0] == 0) {
                return 0;
            }
            if (resMessage.data[0] == 1) {
                return 1;
            }
            return 99;
        }
        return 99;
    }

    public byte getPowerRequest(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.getPowerRequestCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call getPowerRequestCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean clearPowerRequest(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.clearPowerRequestCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call clearPowerRequestCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte getKVMRequest(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.getKVMRequestCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call getKVMRequestCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean clearKVMRequest(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.clearKVMRequestCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call clearKVMRequestCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean enableM1KVM(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enableM1KVMCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call enableM1KVMCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean enableM2KVM(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enableM2KVMCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call enableM2KVMCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean resetBlade(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.resetBladeCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call resetBladeCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean requestKVM(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.requestRemoteKVMCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call requestKVM failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte isPowerSupplyOnForBlade(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.isPowerSupplyOnForBladeCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call isPowerSupplyOnForBladeCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public byte getOverheat(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.getOverheatCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call getOverheatCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean setBladeUID(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.setBladeUIDCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call setBladeUIDCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte detectPowerSupply() throws IPMIException {
        IPMIMessage resMessage = this.detectPowerSupplyCommand();
        if (resMessage == null) {
            throw new IPMIException("call detectPowerSupplyCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public byte getPowerSupplyStatus() throws IPMIException {
        IPMIMessage resMessage = this.getPowerSupplyStatusCommand();
        if (resMessage == null) {
            throw new IPMIException("call getPowerSupplyStatusCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean setPowerSupplyFanSpeed(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.setPowerSupplyFanSpeedCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call setPowerSupplyFanSpeedCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean testPowerSupplyFanSpeed(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.testPowerSupplyFanSpeedCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call setPowerSupplyFanSpeedCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean enablePowerSupply(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enablePowerSupplyCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call enablePowerSupplyCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public int getTotalRemainingPower() throws IPMIException {
        IPMIMessage resMessage = this.getTotalRemainingPowerCommand();
        if (resMessage == null) {
            throw new IPMIException("call getTotalRemainingPowerCommand failed");
        }
        if (resMessage.completionCode == 0) {
            int remainingPower = ByteUtility.twoBytesToIntMSB(resMessage.data);
            return remainingPower;
        }
        throw new IPMIException("call getTotalRemainingPowerCommand failed");
    }

    public boolean setAllPowerSupplyFanSpeed(byte speed) throws IPMIException {
        IPMIMessage resMessage = this.setAllPowerSupplyFanSpeedCommand(speed);
        if (resMessage == null) {
            throw new IPMIException("call setAllPowerSupplyFanSpeedCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call setAllPowerSupplyFanSpeedCommand failed");
    }

    public boolean enableInfinibandPower(byte bandIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enableInfiniBandPowerCommand(bandIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call setInfiniBandPowerCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean resetInfiniband(byte bandIndex) throws IPMIException {
        IPMIMessage resMessage = this.resetInfiniBandCommand(bandIndex);
        if (resMessage == null) {
            throw new IPMIException("call resetInfiniBandCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte getInfinibandPresent() throws IPMIException {
        IPMIMessage resMessage = this.getInfiniBandPresentCommand();
        if (resMessage == null) {
            throw new IPMIException("call getInfiniBandPresentCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public byte[] getInfinibandAllSensors(byte bandIndex) throws IPMIException {
        IPMIMessage resMessage = this.getInfiniBandAllSensorsCommand(bandIndex);
        if (resMessage == null) {
            throw new IPMIException("call getInfiniBandAllSensorsCommand failed");
        }
        if (resMessage.completionCode == 0) {
            byte[] byte6 = new byte[6];
            System.arraycopy(resMessage.data, 0, byte6, 0, byte6.length);
            return byte6;
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean resetGigabitSwitch(byte switchIndex) throws IPMIException {
        IPMIMessage resMessage = this.resetGigabitSwitchCommand(switchIndex);
        if (resMessage == null) {
            throw new IPMIException("call resetGigabitSwitchCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean enableGigabitSwitchPower(byte switchIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enableGigabitSwitchPowerCommand(switchIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call enableGigabitSwitchPower failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte getGigabitSwitchStatus(byte switchIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGigabitSwitchStatusCommand(switchIndex);
        if (resMessage == null) {
            throw new IPMIException("call getGigabitSwitchStatusCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public InfiniBandSensors getInfiniBandSensors(byte bandIndex) throws IPMIException {
        IPMIMessage resMessage = this.getInfiniBandAllSensorsCommand(bandIndex);
        if (resMessage == null) {
            throw new IPMIException("call getInfiniBandAllSensorsCommand failed");
        }
        if (resMessage.completionCode == 0) {
            InfiniBandSensors infiniBandSensors = new InfiniBandSensors();
            if (infiniBandSensors.fromRaw(resMessage.data)) {
                return infiniBandSensors;
            }
            throw new IPMIException("Raw data error");
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean testBladeErrorLED(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.testBladeErrorLEDCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call testBladeErrorLEDCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public int getCMMSlot() throws IPMIException {
        IPMIMessage resMessage = this.getCMMSlotCommand();
        if (resMessage == null) {
            throw new IPMIException("call getCMMSlot failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("return an error data from getCMMSlot");
    }

    public String getCMMTime() throws IPMIException {
        IPMIMessage resMessage = this.getCMMTimeCommand();
        if (resMessage == null) {
            throw new IPMIException("call getCMMTime failed");
        }
        if (resMessage.completionCode == 0) {
            if (resMessage.data.length == 8 && resMessage.data[7] == 1) {
                throw new IPMIException("Cannot get CMM time! CMM is busy for time synchronization. \nPlease retry later.");
            }
            int sec = ByteUtility.bcdToInt(resMessage.data[0]);
            int min = ByteUtility.bcdToInt(resMessage.data[1]);
            int hr = ByteUtility.bcdToInt(resMessage.data[2]);
            int day = ByteUtility.bcdToInt(resMessage.data[3]);
            int date = ByteUtility.bcdToInt(resMessage.data[4]);
            int month = ByteUtility.bcdToInt(resMessage.data[5]) - 1;
            int year = ByteUtility.bcdToInt(resMessage.data[6]);
            Calendar c = Calendar.getInstance();
            c.set(2000 + year, month, date, hr, min, sec);
            SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            String dateStr = f.format(c.getTime());
            return dateStr;
        }
        throw new IPMIException("return an error data from getCMMTime");
    }

    public Calendar getCMMTimeByCalendar() throws IPMIException {
        IPMIMessage resMessage = this.getCMMTimeCommand();
        if (resMessage == null) {
            throw new IPMIException("call getCMMTime failed");
        }
        if (resMessage.completionCode == 0) {
            int sec = ByteUtility.bcdToInt(resMessage.data[0]);
            int min = ByteUtility.bcdToInt(resMessage.data[1]);
            int hr = ByteUtility.bcdToInt(resMessage.data[2]);
            int day = ByteUtility.bcdToInt(resMessage.data[3]);
            int date = ByteUtility.bcdToInt(resMessage.data[4]);
            int month = ByteUtility.bcdToInt(resMessage.data[5]) - 1;
            int year = ByteUtility.bcdToInt(resMessage.data[6]);
            Calendar c = Calendar.getInstance();
            c.set(2000 + year, month, date, hr, min, sec);
            return c;
        }
        throw new IPMIException("return an error data from getCMMTime");
    }

    public boolean setCMMTime(Calendar c) throws IPMIException {
        c.get(1);
        byte sec = ByteUtility.intToBCD(c.get(13));
        byte min = ByteUtility.intToBCD(c.get(12));
        byte hr = ByteUtility.intToBCD(c.get(11));
        byte day = ByteUtility.intToBCD(c.get(7));
        byte date = ByteUtility.intToBCD(c.get(5));
        byte month = (byte)(ByteUtility.intToBCD(c.get(2)) + 1);
        byte year = ByteUtility.intToBCD(c.get(1) - 2000);
        IPMIMessage resMessage = this.SetCMMTimeCommand(year, month, date, day, hr, min, sec);
        if (resMessage == null) {
            throw new IPMIException("call setCMMTime failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("return an error data from setCMMTime");
    }

    public boolean setGBIP(byte gbIndex, String ip) throws IPMIException {
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(ip)) {
            throw new IPMIException("IP format error!");
        }
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IPMIException("IP format error!");
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setGBIPCommand(gbIndex, data);
        if (resMessage == null) {
            throw new IPMIException("call Set GB IP failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBNetMask(byte gbIndex, String netMask) throws IPMIException {
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(netMask)) {
            throw new IPMIException("netmask format error!");
        }
        StringTokenizer st = new StringTokenizer(netMask, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IPMIException("netmask format error!");
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setGBNetMaskCommand(gbIndex, data);
        if (resMessage == null) {
            throw new IPMIException("call Set GB Netmask failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBGateway(byte gbIndex, String gateway) throws IPMIException {
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(gateway)) {
            throw new IPMIException("gateway format error!");
        }
        StringTokenizer st = new StringTokenizer(gateway, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IPMIException("gateway format error!");
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setGBGateWayCommand(gbIndex, data);
        if (resMessage == null) {
            throw new IPMIException("call Set GB gateway failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBUsername(byte gbIndex, String username) throws IPMIException {
        byte[] data = username.getBytes();
        IPMIMessage resMessage = this.setGBUsernameCommand(gbIndex, data);
        if (resMessage == null) {
            throw new IPMIException("call Set GB username failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBPassword(byte gbIndex, String password) throws IPMIException {
        byte[] data = password.getBytes();
        IPMIMessage resMessage = this.setGBPasswordCommand(gbIndex, data);
        if (resMessage == null) {
            throw new IPMIException("call Set GB password failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBTime(byte gbIndex, Calendar c) throws IPMIException {
        byte sec = (byte)c.get(13);
        byte min = (byte)c.get(12);
        byte hour = (byte)c.get(11);
        byte day = (byte)c.get(7);
        byte date = (byte)c.get(5);
        byte month = (byte)(c.get(2) + 1);
        int yyyy = c.get(1);
        byte year = 0;
        byte centry = 0;
        if (yyyy >= 2000) {
            centry = 20;
            year = (byte)(yyyy - 2000);
        } else {
            centry = 19;
            year = (byte)(yyyy - 1900);
        }
        IPMIMessage resMessage = this.setGBTimeCommand(gbIndex, sec, min, hour, day, date, month, year, centry);
        if (resMessage == null) {
            throw new IPMIException("call Set GB time failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBCommit(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.setGBCommitCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call set GB Commit failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBIPMode(byte gbIndex, byte mode) throws IPMIException {
        IPMIMessage resMessage = this.setGBIPModeCommand(gbIndex, mode);
        if (resMessage == null) {
            throw new IPMIException("call set GB IP Mode failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBResetToDefault(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.setGBResetToDefaultCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call set GB reset to default failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBBootUpImage(byte gbIndex, byte imageIndex) throws IPMIException {
        IPMIMessage resMessage = this.setGBBootUpImageCommand(gbIndex, imageIndex);
        if (resMessage == null) {
            throw new IPMIException("call set GB Boot Up Image failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBRestart(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.setGBRestartCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call set GB Restart failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte getGBIPMode(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBIPModeCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB IP Mode failed 1");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[1];
        }
        throw new IPMIException("call get GB IP Mode failed 2");
    }

    public byte getGBBootUpImage(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBBootUpImageCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB Boot Up Image failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[1];
        }
        throw new IPMIException("call get GB Boot Up Image failed");
    }

    public String getGBIP(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBIPCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB IP failed");
        }
        if (resMessage.completionCode == 0) {
            byte length = resMessage.data[0];
            int p1 = resMessage.data[1] & 0xFF;
            int p2 = resMessage.data[2] & 0xFF;
            int p3 = resMessage.data[3] & 0xFF;
            int p4 = resMessage.data[4] & 0xFF;
            String ip = "" + p1 + "." + p2 + "." + p3 + "." + p4;
            return ip;
        }
        throw new IPMIException("call get GB IP failed");
    }

    public String getGBNetMask(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBNetMaskCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB NetMask failed");
        }
        if (resMessage.completionCode == 0) {
            byte length = resMessage.data[0];
            int p1 = resMessage.data[1] & 0xFF;
            int p2 = resMessage.data[2] & 0xFF;
            int p3 = resMessage.data[3] & 0xFF;
            int p4 = resMessage.data[4] & 0xFF;
            String ip = "" + p1 + "." + p2 + "." + p3 + "." + p4;
            return ip;
        }
        throw new IPMIException("call get GB NetMask failed");
    }

    public String getGBGateway(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBGatewayCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB Gateway failed");
        }
        if (resMessage.completionCode == 0) {
            byte length = resMessage.data[0];
            int p1 = resMessage.data[1] & 0xFF;
            int p2 = resMessage.data[2] & 0xFF;
            int p3 = resMessage.data[3] & 0xFF;
            int p4 = resMessage.data[4] & 0xFF;
            String ip = "" + p1 + "." + p2 + "." + p3 + "." + p4;
            return ip;
        }
        throw new IPMIException("call get GB Gateway failed");
    }

    public String getGBUsername(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBUsernameCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB username failed");
        }
        if (resMessage.completionCode == 0) {
            byte length = resMessage.data[0];
            byte[] data = new byte[length];
            System.arraycopy(resMessage.data, 1, data, 0, data.length);
            return new String(data);
        }
        throw new IPMIException("call get GB username failed");
    }

    public String getGBPassword(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBPasswordCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB password failed");
        }
        if (resMessage.completionCode == 0) {
            byte length = resMessage.data[0];
            byte[] data = new byte[length];
            System.arraycopy(resMessage.data, 1, data, 0, data.length);
            return new String(data);
        }
        throw new IPMIException("call get GB password failed");
    }

    public Calendar getGBTime(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBTimeCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB time failed");
        }
        if (resMessage.completionCode == 0) {
            if (resMessage.data.length == 0) {
                throw new IPMIException("GB Time data error. Length = 0");
            }
            byte length = resMessage.data[0];
            byte sec = resMessage.data[1];
            byte min = resMessage.data[2];
            byte hour = resMessage.data[3];
            byte day = resMessage.data[4];
            byte date = resMessage.data[5];
            byte month = resMessage.data[6];
            byte year = resMessage.data[7];
            byte century = resMessage.data[8];
            Calendar c = Calendar.getInstance();
            c.set(century * 100 + year, month - 1, date, hour, min, sec);
            return c;
        }
        throw new IPMIException("call get GB time failed");
    }

    public String getCMMOtherIP() throws IPMIException {
        IPMIMessage resMessage = this.getOtherCMMIPCommand();
        if (resMessage == null) {
            throw new IPMIException("call get CMM other IP failed");
        }
        if (resMessage.completionCode == 0) {
            String ip = (resMessage.data[0] & 0xFF) + "." + (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF);
            return ip;
        }
        throw new IPMIException("call get CMM other IP failed");
    }

    public boolean gracefulPowerDownBlade(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.gracefulPowerDownBladeCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call graceful shutdown failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call graceful shutdown failed");
    }

    public boolean setFanControlMode(byte mode) throws IPMIException {
        IPMIMessage resMessage = this.setFanControlModeCommand(mode);
        if (resMessage == null) {
            throw new IPMIException("call set Fan Control Mode failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call set Fan Control Mode failed");
    }

    public byte getFanControlMode() throws IPMIException {
        IPMIMessage resMessage = this.getFanControlModeCommand();
        if (resMessage == null) {
            throw new IPMIException("call get Fan Control Mode failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("call get Fan Control Mode failed");
    }

    public byte getCMMTimeSyncMode() throws IPMIException {
        IPMIMessage resMessage = this.getCMMTimeSyncModeCommand();
        if (resMessage == null) {
            throw new IPMIException("call getCMMTimeSyncModeCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("call getCMMTimeSyncModeCommand failed");
    }

    public boolean isCMMSupportIPMB() throws IPMIException {
        IPMIMessage resMessage = this.isCMMSupportIPMBCommand();
        if (resMessage == null) {
            throw new IPMIException("call isCMMSupportIPMB failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0] == 1;
        }
        throw new IPMIException("call isCMMSupportIPMB failed");
    }

    public boolean checkIfEnoughPowerForBlades(byte[] bladeBits) throws IPMIException {
        IPMIMessage resMessage = this.checkIfEnoughPowerForBladesCommand(bladeBits);
        if (resMessage == null) {
            throw new IPMIException("call checkIfEnoughPowerForBlades failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0] == 1;
        }
        throw new IPMIException("call checkIfEnoughPowerForBlades failed");
    }

    public PowerConsumptionStatus getPowerConsumptionStatus() throws IPMIException {
        IPMIMessage resMessage = this.getPowerConsumptionStatusCommand();
        if (resMessage == null) {
            throw new IPMIException("call readPowerConsumptionStatusCommand failed");
        }
        if (resMessage.completionCode == 0) {
            PowerConsumptionStatus p = new PowerConsumptionStatus();
            p.totalPower = ByteUtility.twoBytesToIntMSB(new byte[]{resMessage.data[0], resMessage.data[1]});
            p.peripheralPowerReserved = ByteUtility.twoBytesToIntMSB(new byte[]{resMessage.data[2], resMessage.data[3]});
            p.serverBladePowerReserved = ByteUtility.twoBytesToIntMSB(new byte[]{resMessage.data[4], resMessage.data[5]});
            return p;
        }
        return null;
    }

    public BladeHWInfo getBladeHWInfo(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.getBladeHWInfoCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call getBladeHWInfoCommand failed");
        }
        if (resMessage.completionCode == 0) {
            BladeHWInfo bladeHWInfo = new BladeHWInfo(resMessage.data);
            return bladeHWInfo;
        }
        throw new IPMIException("call getBladeHWInfoCommand failed");
    }

    public boolean setBladeReduceOrFullPower(byte mode) throws IPMIException {
        IPMIMessage resMessage = this.setBladeReduceOrFullPowerCommand(mode);
        if (resMessage == null) {
            throw new IPMIException("call setReduceOrFullPower failed");
        }
        return resMessage.completionCode == 0;
    }

    public KeyBoardMouseSetting getKeyBoardMouseSetting() throws IPMIException {
        KeyBoardMouseSetting km;
        boolean result;
        IPMIMessage resMessage = this.getKeyboardMouseSettingCommand();
        if (resMessage == null) {
            throw new IPMIException("call getKeyboardMouseSettingCommand failed");
        }
        if (resMessage.completionCode == 0 && (result = (km = new KeyBoardMouseSetting()).fromRaw(resMessage.data))) {
            return km;
        }
        throw new IPMIException("call getKeyboardMouseSettingCommand failed");
    }

    public boolean setKeyBoardMouseSetting(KeyBoardMouseSetting km) throws IPMIException {
        IPMIMessage resMessage = this.setKeyboardMouseSettingCommand(km.toRaw());
        if (resMessage == null) {
            throw new IPMIException("call setKeyboardMouseSettingCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call setKeyboardMouseSettingCommand failed");
    }

    public byte getUTCOffset() throws IPMIException {
        IPMIMessage resMessage = this.getUTCOffsetCommand();
        if (resMessage == null) {
            throw new IPMIException("call getUTCOffsetCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("call getUTCOffsetCommand failed");
    }

    public boolean setUTCOffset(byte offset) throws IPMIException {
        IPMIMessage resMessage = this.setUTCOffsetCommand(offset);
        if (resMessage == null) {
            throw new IPMIException("call setUTCOffsetCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call setUTCOffsetCommand failed");
    }

    public String getNTPServerPrimary() throws IPMIException {
        IPMIMessage resMessage = this.getNTPServerPrimaryCommand();
        if (resMessage == null) {
            throw new IPMIException("call getNTPServerPrimaryCommand failed");
        }
        if (resMessage.completionCode == 0) {
            if (resMessage.data.length == 1 && resMessage.data[0] == 1) {
                throw new IPMIException("CMM is busy for time synchronization. Please retry later.");
            }
            return new String(resMessage.data);
        }
        throw new IPMIException("call getNTPServerPrimaryCommand failed");
    }

    public String getNTPServerSecondary() throws IPMIException {
        IPMIMessage resMessage = this.getNTPServerSecondaryCommand();
        if (resMessage == null) {
            throw new IPMIException("call getNTPServerSecondaryCommand failed");
        }
        if (resMessage.completionCode == 0) {
            if (resMessage.data.length == 1 && resMessage.data[0] == 1) {
                throw new IPMIException("CMM is busy for time synchronization. Please retry later.");
            }
            return new String(resMessage.data);
        }
        throw new IPMIException("call getNTPServerSecondaryCommand failed");
    }

    public boolean setNTPServerPrimary(String server) throws IPMIException {
        IPMIMessage resMessage = this.setNTPServerPrimaryCommand(server);
        if (resMessage == null) {
            throw new IPMIException("call setNTPServerPrimaryCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call setNTPServerPrimaryCommand failed");
    }

    public boolean setNTPServerSecondary(String server) throws IPMIException {
        IPMIMessage resMessage = this.setNTPServerSecondaryCommand(server);
        if (resMessage == null) {
            throw new IPMIException("call setNTPServerSecondaryCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call setNTPServerSecondaryCommand failed");
    }

    public boolean setNTPMode() throws IPMIException {
        IPMIMessage resMessage = this.setNTPModeCommand();
        if (resMessage == null) {
            throw new IPMIException("call setNTPModeCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call setNTPModeCommand failed");
    }

    public boolean setAllNTPServer(byte UTCOffset, String ntp1, String ntp2) throws IPMIException {
        IPMIMessage resMessage = this.setAllNTPServerCommand(UTCOffset, ntp1, ntp2);
        if (resMessage == null) {
            throw new IPMIException("call setAllNTPServerCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call setAllNTPServerCommand failed");
    }

    public boolean setBladeMode(byte bladeMode) throws IPMIException {
        IPMIMessage resMessage = this.setBladeModeCommand(bladeMode);
        if (resMessage == null) {
            throw new IPMIException("call setBladeModeCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call setBladeModeCommand failed");
    }

    public byte getBladeMode() throws IPMIException {
        IPMIMessage resMessage = this.getBladeModeCommand();
        if (resMessage == null) {
            throw new IPMIException("call getBladeModeCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("call getBladeModeCommand failed");
    }

    public void setEnabledNormalFunction(boolean isEnabled) throws IPMIException {
        IPMIMessage resMessage = this.setEnabledNormalFunctionCommand(isEnabled);
        if (resMessage == null) {
            throw new IPMIException("call setEnabledNormalFunction failed");
        }
        if (resMessage.completionCode == 0) {
            return;
        }
        throw new IPMIException("call setEnabledNormalFunction failed");
    }

    public void setBladeName(byte index, String bladeName) throws IPMIException {
        IPMIMessage resMessage = this.setBladeNameCommand(index, bladeName.getBytes());
        if (resMessage == null) {
            throw new IPMIException("call setBladeNameCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return;
        }
        throw this.ccode2Exception(resMessage);
    }

    public String getBladeName(byte index) throws IPMIException {
        IPMIMessage resMessage = this.getBladeNameCommand(index);
        if (resMessage == null) {
            throw new IPMIException("call getBladeNameCommand failed");
        }
        if (resMessage.completionCode == 0) {
            String bladeName = null;
            if (resMessage.data.length != 0) {
                byte length = resMessage.data[0];
                byte[] nameBytes = new byte[length];
                System.arraycopy(resMessage.data, 1, nameBytes, 0, length);
                bladeName = new String(nameBytes);
                bladeName = bladeName.trim();
            }
            return bladeName;
        }
        throw this.ccode2Exception(resMessage);
    }

    public byte burstPowerControl(byte type, byte[] bladeIndexes) throws IPMIException {
        IPMIMessage resMessage = this.burstPowerControlCommand(type, bladeIndexes);
        if (resMessage == null) {
            throw new IPMIException("call burstPowerControlCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw this.ccode2Exception(resMessage);
    }

    public DeviceStructureInfoManager getStructureMetaData() throws IPMIException {
        IPMIMessage resMessage = this.getStructureMetaDataCommand();
        if (resMessage == null) {
            throw new IPMIException("call getStructureMetaData failed");
        }
        if (resMessage.completionCode == 0) {
            DeviceStructureInfoManager infoManager = new DeviceStructureInfoManager();
            if (infoManager.fromRaw(resMessage.data)) {
                return infoManager;
            }
            throw new IPMIException("call getStructureMetaData failed (data invalid)");
        }
        throw this.ccode2Exception(resMessage);
    }

    public byte[] getSystemInfoByBatch(byte type, int offset, int length) throws IPMIException {
        byte[] offsetBytes = new byte[2];
        byte[] lengthBytes = new byte[2];
        ByteUtility.intTo2Bytes(offsetBytes, 0, offset);
        ByteUtility.intTo2Bytes(lengthBytes, 0, length);
        IPMIMessage resMessage = this.getSystemInfoByBatchCommand(type, offsetBytes, lengthBytes);
        if (resMessage == null) {
            throw new IPMIException("call getSystemInfoByBatchCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data;
        }
        throw this.ccode2Exception(resMessage);
    }

    public static void main(String[] args) {
        IPMICMMOEMCommand.main_baldeName(args);
    }

    public static void main_baldeName(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("172.31.10.186");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiCMMOEMCommand.setIPMIInterface(rmcp);
        try {
            DeviceStructureInfoManager m = ipmiCMMOEMCommand.getStructureMetaData();
            DeviceStructureInfo info = m.getDeviceStructureInfo((byte)6);
            System.out.println(info.type);
            System.out.println(info.structureNumber);
            System.out.println(info.structureLength);
        }
        catch (IPMIException ex1) {
            ex1.printStackTrace();
        }
        sessionController.closeSession();
    }

    public static void main_test(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.216");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiCMMOEMCommand.setIPMIInterface(rmcp);
        try {
            PowerConsumptionStatus p = ipmiCMMOEMCommand.getPowerConsumptionStatus();
            System.out.println("totalPower = " + p.totalPower);
            System.out.println("serverBladePowerReserved = " + p.serverBladePowerReserved);
            System.out.println("peripheralPowerReserved = " + p.peripheralPowerReserved);
            BladeHWInfo bladeHWInfo = ipmiCMMOEMCommand.getBladeHWInfo((byte)8);
            System.out.println(bladeHWInfo.toString());
        }
        catch (IPMIException ex1) {
            ex1.printStackTrace();
        }
        sessionController.closeSession();
    }

    public static void main_fanCtrl(String[] args) throws Exception {
        String ip = "";
        String u = "";
        String p = "";
        int n = 0;
        int s = 0;
        if (args.length == 10) {
            for (int i = 0; i < args.length; i += 2) {
                if (args[i].equals("-ip")) {
                    ip = args[i + 1];
                    continue;
                }
                if (args[i].equals("-u")) {
                    u = args[i + 1];
                    continue;
                }
                if (args[i].equals("-p")) {
                    p = args[i + 1];
                    continue;
                }
                if (args[i].equals("-n")) {
                    n = Integer.parseInt(args[i + 1]);
                    continue;
                }
                if (args[i].equals("-s")) {
                    if (args[i + 1].length() == 4) {
                        s = new BigInteger(args[i + 1].substring(2), 16).intValue();
                        continue;
                    }
                    System.out.println("Incorrect fan speed value (0x00 -- 0xFF)!");
                    System.exit(0);
                    continue;
                }
                System.out.println("Unknown command: " + args[i]);
                IPMICMMOEMCommand.usage();
                System.exit(0);
            }
        } else {
            IPMICMMOEMCommand.usage();
            System.exit(0);
        }
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(u);
        config.setPassword(p);
        config.setPrivilege((byte)4);
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiCMMOEMCommand);
        if (sessionController == null) {
            return;
        }
        IPMIMessage resMessage = ipmiCMMOEMCommand.testPowerSupplyFanSpeedCommand((byte)n, (byte)s);
        if (resMessage == null) {
            System.out.println("Set power supply fan speed command failed!");
        }
        sessionController.closeSession();
    }

    private static void usage() {
        System.out.println("Usage: PSFANCTRL -ip 192.168.1.115 -u ADMIN -p ADMIN -n 1 -s 0x05");
        System.out.println("-ip\tThe IP address of a CMM to connect.");
        System.out.println("-u\tA valid username which has the administration privilege.");
        System.out.println("-p\tPassword.");
        System.out.println("-n\tThe Power Supply number.");
        System.out.println("-s\tThe fan speed value (0x00 -- 0xFF).");
    }

    public class DeviceStructureInfo {
        public byte type;
        public int structureLength;
        public int structureNumber;

        public String toString() {
            String a = "type =" + this.type + "\n";
            String b = "structureLength =" + this.structureLength + "\n";
            String c = "structureNumber =" + this.structureNumber + "\n";
            return a + b + c;
        }

        public void fromRaw(byte[] raw) {
            this.type = raw[0];
            byte[] tempByte = new byte[]{raw[1], raw[2]};
            this.structureLength = ByteUtility.twoBytesToIntLSB(tempByte);
            tempByte[0] = raw[3];
            tempByte[1] = raw[4];
            this.structureNumber = ByteUtility.twoBytesToIntLSB(tempByte);
        }
    }

    public class DeviceStructureInfoManager {
        public static final byte DEVICE_TYPE_BLADE_SERVER = 1;
        public static final byte DEVICE_TYPE_CMM = 2;
        public static final byte DEVICE_TYPE_PS = 3;
        public static final byte DEVICE_TYPE_GB = 4;
        public static final byte DEVICE_TYPE_IB = 5;
        public static final byte DEVICE_TYPE_BLADESENSOR = 6;
        public static final byte DEVICE_TYPE_10GPASS = 8;
        public static final byte DEVICE_TYPE_BLADE = 9;
        ArrayList<DeviceStructureInfo> deviceStructureInfos = new ArrayList();

        public boolean fromRaw(byte[] raw) {
            int DEVICE_TYPE = 8;
            int LENGTH = 5;
            if (raw == null || raw.length != DEVICE_TYPE * LENGTH) {
                return false;
            }
            for (int i = 0; i < DEVICE_TYPE; ++i) {
                byte[] aRaw = new byte[LENGTH];
                System.arraycopy(raw, i * LENGTH, aRaw, 0, LENGTH);
                DeviceStructureInfo info = new DeviceStructureInfo();
                info.fromRaw(aRaw);
                this.addDeviceStructureInfo(info);
            }
            return true;
        }

        public void addDeviceStructureInfo(DeviceStructureInfo info) {
            this.deviceStructureInfos.add(info);
        }

        public DeviceStructureInfo getDeviceStructureInfo(byte type) {
            for (DeviceStructureInfo item : this.deviceStructureInfos) {
                if (item.type != type) continue;
                return item;
            }
            return null;
        }
    }

    class InfiniBandSensors {
        byte[] raw;
        public double vvdd;
        public double v3_3v_AUX;
        public double v1_8v;
        public double v3_3v;
        public double v1_2v;
        public double temperature;

        public boolean fromRaw(byte[] raw) {
            if (raw.length != 6) {
                return false;
            }
            this.raw = raw;
            this.vvdd = (double)raw[0] * 3.333 / 256.0;
            this.v3_3v_AUX = (double)raw[1] * 3.333 / 256.0;
            this.v1_8v = (double)raw[2] * 6.66 / 256.0;
            this.v3_3v = raw[3] * 16 / 256;
            this.v1_2v = (double)raw[4] * 3.6 / 256.0;
            this.temperature = raw[5];
            return true;
        }
    }

    public class BladeHWInfo {
        byte[] raw;

        public BladeHWInfo(byte[] raw) {
            this.raw = raw;
        }

        public boolean isDataReady() {
            return (this.raw[0] & 1) == 1;
        }

        public String getSignature() {
            if (!this.isDataReady()) {
                return "unknown";
            }
            return ByteUtility.byteToHex(this.raw[1]);
        }

        public String getPowerConsumption() {
            if (!this.isDataReady()) {
                return "unknown";
            }
            return "" + this.raw[2] * 25 + "W";
        }

        public String getCPUID() {
            if (!this.isDataReady()) {
                return "unknown";
            }
            if (this.raw[1] == -78 || this.raw[1] == -74 || this.raw[1] == -68) {
                return "AMD Opteron";
            }
            if (this.raw[3] == 97 && this.raw[4] == 15) {
                return "Dempsey B0";
            }
            if (this.raw[3] == 98 && this.raw[4] == 15) {
                return "Dempsey B1";
            }
            if (this.raw[3] == 99 && this.raw[4] == 15) {
                return "Dempsey B2";
            }
            if (this.raw[3] == 100 && this.raw[4] == 15) {
                return "Dempsey C1";
            }
            if (this.raw[3] == 101 && this.raw[4] == 15) {
                return "Dempsey D0";
            }
            if (this.raw[3] == -10 && this.raw[4] == 6) {
                return "Woodcrest B2";
            }
            if (this.raw[3] == -5 && this.raw[4] == 6) {
                return "Woodcrest/Clovertown G0";
            }
            if (this.raw[3] == -9 && this.raw[4] == 6) {
                return "Clovertown B3";
            }
            if (this.raw[3] == 118 && this.raw[4] == 6) {
                return "Harpertown/Wolfdale-DP C0";
            }
            if (this.raw[3] == 122 && this.raw[4] == 6) {
                return "Harpertown/Wolfdale-DP E0";
            }
            if (this.raw[3] == -92 && this.raw[4] == 6) {
                return "Nehalem-EP C1";
            }
            if (this.raw[3] == -91 && this.raw[4] == 6) {
                return "Nehalem-EP D0";
            }
            if (this.raw[3] == -64 && this.raw[4] == 6) {
                return "Westmere";
            }
            if (this.raw[3] == -63 && this.raw[4] == 6) {
                return "Westmere";
            }
            if (this.raw[3] == -62 && this.raw[4] == 6) {
                return "Westmere";
            }
            if (this.raw[3] == -61 && this.raw[4] == 6) {
                return "Westmere";
            }
            if (this.raw[3] == -96 && this.raw[4] == 6) {
                return "Nehalem-EP";
            }
            if (this.raw[3] == -95 && this.raw[4] == 6) {
                return "Nehalem-EP";
            }
            if (this.raw[3] == -94 && this.raw[4] == 6) {
                return "Nehalem-EP";
            }
            if (this.raw[3] == -93 && this.raw[4] == 6) {
                return "Nehalem-EP";
            }
            if (this.raw[3] == -112 && this.raw[4] == 15) {
                return "AMD G34";
            }
            if (this.raw[3] == -111 && this.raw[4] == 15) {
                return "AMD G34";
            }
            if (this.raw[3] == -47 && this.raw[4] == 6) {
                return "Sandy Bridge";
            }
            if (this.raw[3] == -46 && this.raw[4] == 6) {
                return "Sandy Bridge";
            }
            if (this.raw[3] == -45 && this.raw[4] == 6) {
                return "Sandy Bridge";
            }
            if (this.raw[3] == -44 && this.raw[4] == 6) {
                return "Sandy Bridge";
            }
            if (this.raw[3] == -43 && this.raw[4] == 6) {
                return "Sandy Bridge";
            }
            if (this.raw[3] == -42 && this.raw[4] == 6) {
                return "Sandy Bridge";
            }
            if (this.raw[3] == -41 && this.raw[4] == 6) {
                return "Sandy Bridge";
            }
            if (this.raw[3] == -40 && this.raw[4] == 6) {
                return "Sandy Bridge";
            }
            if (this.raw[3] == -39 && this.raw[4] == 6) {
                return "Sandy Bridge";
            }
            if (this.raw[3] == -38 && this.raw[4] == 6) {
                return "Sandy Bridge";
            }
            return "undefined";
        }

        public String getNumberOfCPUInstalled() {
            if (!this.isDataReady()) {
                return "unknown";
            }
            return "" + this.raw[5];
        }

        public String getCPUSpeeed() {
            if (!this.isDataReady()) {
                return "unknown";
            }
            DecimalFormat d = new DecimalFormat("#.##");
            d.setMinimumFractionDigits(2);
            return d.format((double)this.raw[6] / 10.0) + "Ghz";
        }

        public String getMemorySize() {
            String sizeStr;
            block8: {
                if (!this.isDataReady()) {
                    return "unknown";
                }
                sizeStr = "";
                if (this.raw[1] == -79 || this.raw[1] == -78 || this.raw[1] == -77 || this.raw[1] == -76 || this.raw[1] == -75 || this.raw[1] == -74 || this.raw[1] == -73 || this.raw[1] == -72) {
                    sizeStr = (this.raw[7] & 0xFF) * 256 + "MB";
                } else if ((byte)(this.raw[10] & 0x80) == -128) {
                    try {
                        int value = this.raw[27] & 0xFF;
                        value <<= 8;
                        double size = (double)(value += this.raw[7] & 0xFF) * 0.5;
                        if (Math.floor(size) == size) {
                            sizeStr = (int)size + "GB";
                            break block8;
                        }
                        sizeStr = size + "GB";
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        sizeStr = (this.raw[7] & 0xFF) * 512 + "MB";
                    }
                } else {
                    sizeStr = (this.raw[7] & 0xFF) * 512 + "MB";
                }
            }
            return sizeStr;
        }

        public String getNumberOfDIMMsInstalled() {
            if (!this.isDataReady()) {
                return "unknown";
            }
            return "" + this.raw[8];
        }

        public String getMemorySpeed() {
            if (!this.isDataReady()) {
                return "unknown";
            }
            String speed = null;
            switch (this.raw[9]) {
                case 0: {
                    speed = "533Mhz";
                    break;
                }
                case 1: {
                    speed = "667Mhz";
                    break;
                }
                case 2: {
                    speed = "800Mhz";
                    break;
                }
                case 3: {
                    speed = "1066Mhz";
                    break;
                }
                case 4: {
                    speed = "1333Mhz";
                    break;
                }
                case 5: {
                    speed = "1600Mhz";
                    break;
                }
                case 6: {
                    speed = "1866Mhz";
                    break;
                }
                default: {
                    speed = "undefined";
                }
            }
            return speed;
        }

        public String getNumberOfOnboardLan() {
            if (!this.isDataReady() || this.raw[10] == 0) {
                return "unknown";
            }
            return "" + (byte)(this.raw[10] & 0x7F);
        }

        public int getNumberOfOnboardLanValue() {
            if (!this.isDataReady() || this.raw[10] <= 0) {
                return 0;
            }
            return this.raw[10];
        }

        public String getMAC(int lanIndex) {
            if (!this.isDataReady()) {
                return "unknown";
            }
            return ByteUtility.byteToHex(this.raw[11]) + ":" + ByteUtility.byteToHex(this.raw[12]) + ":" + ByteUtility.byteToHex(this.raw[13]) + ":" + ByteUtility.byteToHex(this.raw[14]) + ":" + ByteUtility.byteToHex(this.raw[15]) + ":" + ByteUtility.byteToHex((byte)(this.raw[16] + lanIndex));
        }

        public String getMBSerialNumber() {
            if (this.raw.length < 26) {
                return null;
            }
            byte[] serial = new byte[this.raw.length - 17];
            System.arraycopy(this.raw, 17, serial, 0, this.raw.length - 17);
            return new String(serial);
        }

        public String toFormatString() {
            String retStr = "MB ID           = " + this.getSignature() + "\n" + "Pwr Consumption = " + this.getPowerConsumption() + "\n" + "CPUs            = " + this.getNumberOfCPUInstalled() + "\n" + "CPU Type        = " + this.getCPUID() + "\n" + "CPU Speed       = " + this.getCPUSpeeed() + "\n" + "DIMMs           = " + this.getNumberOfDIMMsInstalled() + "\n" + "Memory Size     = " + this.getMemorySize() + "\n" + "Memory Speed    = " + this.getMemorySpeed() + "\n";
            if (this.getNumberOfOnboardLanValue() > 0) {
                retStr = retStr + "LANs            = " + this.getNumberOfOnboardLan() + "\n";
                for (int i = 0; i < this.getNumberOfOnboardLanValue(); ++i) {
                    retStr = retStr + "LAN " + (i + 1) + " MAC       = " + this.getMAC(i) + "\n";
                }
            }
            retStr = retStr + "MB SN           = " + this.getMBSerialNumber() + "\n";
            return retStr;
        }

        public String toString() {
            String retStr = "Signature       = " + this.getSignature() + "\n" + "Pwr Consumption = " + this.getPowerConsumption() + "\n" + "CPUID           = " + this.getCPUID() + "\n" + "CPUs            = " + this.getNumberOfCPUInstalled() + "\n" + "CPU Speed       = " + this.getCPUSpeeed() + "\n" + "Memory Size     = " + this.getMemorySize() + "\n" + "DIMMs           = " + this.getNumberOfDIMMsInstalled() + "\n" + "Memory Speed    = " + this.getMemorySpeed() + "\n" + "LANs            = " + this.getNumberOfOnboardLan() + "\n" + "LAN 1 MAC       = " + this.getMAC(0) + "\n" + "LAN 2 MAC       = " + this.getMAC(1) + "\n" + "MB serial No    = " + this.getMBSerialNumber() + "\n" + "Raw             = " + ByteUtility.bytesToHex(this.raw);
            return retStr;
        }
    }

    public class PowerConsumptionStatus {
        public int totalPower;
        public int serverBladePowerReserved;
        public int peripheralPowerReserved;
    }
}

