/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.HostSyncAccess;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIOEMLocCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.ProxyConfig;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.algo.AES_CBC_128;
import com.supermicro.ipmi.loc.TagLocSDR;
import com.supermicro.ipmi.text.StatusPrompt;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IPMIInterfaceConfig
implements Serializable,
Comparable {
    public static final int RMCP = 0;
    public static final int RMCPPlus = 1;
    public static final int KCS = 2;
    public static final int SMIC = 3;
    public static final byte PRIVILEGE_CALLBACK = 1;
    public static final byte PRIVILEGE_USER = 2;
    public static final byte PRIVILEGE_OPERATOR = 3;
    public static final byte PRIVILEGE_ADMINISTRATOR = 4;
    public static final byte PRIVILEGE_OEM = 5;
    private int type;
    private String userName;
    private String password;
    private byte privilege = (byte)4;
    private String ip;
    private int port = 623;
    private int timeout = 5;
    private int retry = 5;
    private byte cipherSuiteID = (byte)3;
    private ProxyConfig proxyConfig = null;
    public transient TagLocSDR tagLocSDR = null;
    public transient String mbName;
    public transient String fwType;
    private static transient AES_CBC_128 aes = new AES_CBC_128();
    private static byte[] iv = new byte[]{8, 2, 2, 6, 3, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static SORT_TYPE sortType = SORT_TYPE.IP;
    public static boolean isAscending = true;

    public void setType(int type) {
        this.type = type;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String pw) {
        this.password = pw;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public void setPrivilege(byte privilege) {
        this.privilege = privilege;
    }

    public void setCipherSuiteID(byte cipherSuiteID) {
        this.cipherSuiteID = cipherSuiteID;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public int getType() {
        return this.type;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRetry() {
        return this.retry;
    }

    public byte getPrivilege() {
        return this.privilege;
    }

    public byte getCipherSuiteID() {
        return this.cipherSuiteID;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.userName = this.encode(this.ip, this.userName);
        this.password = this.encode(this.ip, this.password);
        stream.defaultWriteObject();
        this.userName = this.decode(this.ip, this.userName);
        this.password = this.decode(this.ip, this.password);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.userName = this.decode(this.ip, this.userName);
        this.password = this.decode(this.ip, this.password);
    }

    public String decode(String hostname, String value) {
        if (value == null) {
            return null;
        }
        byte[] key = new byte[16];
        int hostNameLength = hostname.getBytes().length;
        System.arraycopy(hostname.getBytes(), 0, key, 0, hostNameLength > 16 ? 16 : hostNameLength);
        String encryptedStr = value.substring(value.indexOf(",") + 1, value.length());
        byte[] input = null;
        try {
            input = ByteUtility.toBinArray(encryptedStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return value;
        }
        byte[] decrypted = aes.decrypt(iv, key, input);
        if (decrypted == null) {
            return value;
        }
        return new String(decrypted).trim();
    }

    public String encode(String hostname, String value) {
        byte[] key = new byte[16];
        int hostNameLength = hostname.getBytes().length;
        System.arraycopy(hostname.getBytes(), 0, key, 0, hostNameLength > 16 ? 16 : hostNameLength);
        byte[] input = new byte[value.getBytes().length + (16 - value.getBytes().length % 16)];
        System.arraycopy(value.getBytes(), 0, input, 0, value.getBytes().length);
        byte[] encryptedBytes = aes.encrypt(iv, key, input);
        String encodeStr = ByteUtility.bytesToHexNoSpace(encryptedBytes);
        return encodeStr;
    }

    public void getTagLocInBackGround() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                IPMIInterfaceConfig config = new IPMIInterfaceConfig();
                config.setIp(IPMIInterfaceConfig.this.ip);
                config.setUserName(IPMIInterfaceConfig.this.userName);
                config.setPassword(IPMIInterfaceConfig.this.password);
                config.setPrivilege((byte)4);
                try {
                    IPMIInterfaceConfig.this.fwType = StatusPrompt.getFWType(config);
                }
                catch (Exception ex2) {
                    return;
                }
                if (IPMIInterfaceConfig.this.fwType.equals("UNKNOWN")) {
                    IPMIInterfaceConfig.this.fwType = "";
                }
                for (int i = 0; i < 5 && HostSyncAccess.getInsatnce().isHostAccessingNow(IPMIInterfaceConfig.this.ip); ++i) {
                    if (i == 4) {
                        return;
                    }
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                IPMIOEMLocCommand ipmiOEMLocCommand = new IPMIOEMLocCommand(null);
                IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
                ISessionController sessionController = null;
                try {
                    sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiOEMLocCommand);
                    if (sessionController == null) {
                        return;
                    }
                }
                catch (Exception ex1) {
                    return;
                }
                int count = 0;
                while (true) {
                    try {
                        TagLocSDR aTagLocSDR;
                        ipmiOEMCommand.setIPMIInterface(ipmiOEMLocCommand.getIPMIInterface());
                        IPMIInterfaceConfig.this.mbName = ipmiOEMCommand.getBoardModel();
                        IPMIInterfaceConfig.this.tagLocSDR = aTagLocSDR = ipmiOEMLocCommand.getTagLocSDR();
                    }
                    catch (IPMIException ex) {
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (InterruptedException ex2) {
                            // empty catch block
                        }
                        if (count++ != 5) continue;
                    }
                    break;
                }
                sessionController.closeSession();
                HostSyncAccess.getInsatnce().release(IPMIInterfaceConfig.this.ip);
            }
        };
        thread.start();
    }

    public int compareTo(Object o) {
        int value = 0;
        if (sortType == SORT_TYPE.IP) {
            value = this.compareToIP(o);
        } else if (sortType == SORT_TYPE.BOARD) {
            value = this.compareToBoard(o);
        } else if (sortType == SORT_TYPE.LOC) {
            value = this.compareToLoc(o);
        } else if (sortType == SORT_TYPE.DC) {
            value = this.compareToDC(o);
        } else if (sortType == SORT_TYPE.ROOM) {
            value = this.compareToRoom(o);
        } else if (sortType == SORT_TYPE.ROW) {
            value = this.compareToRow(o);
        } else if (sortType == SORT_TYPE.NUM) {
            value = this.compareToNum(o);
        } else if (sortType == SORT_TYPE.TYPE) {
            value = this.compareToType(o);
        } else if (sortType == SORT_TYPE.BMC) {
            value = this.compareToBMC(o);
        } else if (sortType == SORT_TYPE.ORG) {
            value = this.compareToOrg(o);
        }
        if (!isAscending) {
            if (value == 1) {
                value = -1;
            } else if (value == -1) {
                value = 1;
            }
        }
        return value;
    }

    public int compareToOrg(Object o) {
        return 0;
    }

    public int compareToIP(Object o) {
        IPMIInterfaceConfig config2 = (IPMIInterfaceConfig)o;
        byte[] ip1 = ByteUtility.ipToBytes(this.ip);
        byte[] ip2 = ByteUtility.ipToBytes(config2.getIp());
        for (int i = 0; i < ip1.length; ++i) {
            if ((ip1[i] & 0xFF) == (ip2[i] & 0xFF)) continue;
            if ((ip1[i] & 0xFF) > (ip2[i] & 0xFF)) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public int compareToBoard(Object o) {
        IPMIInterfaceConfig config2 = (IPMIInterfaceConfig)o;
        if (this.mbName == null) {
            return -1;
        }
        if (config2.mbName == null) {
            return 1;
        }
        return this.mbName.compareTo(config2.mbName);
    }

    public int compareToLoc(Object o) {
        int value = 0;
        value = this.compareToDC(o);
        if (value != 0) {
            return value;
        }
        value = this.compareToRoom(o);
        if (value != 0) {
            return value;
        }
        value = this.compareToRow(o);
        if (value != 0) {
            return value;
        }
        value = this.compareToRack(o);
        if (value != 0) {
            return value;
        }
        value = this.compareToNum(o);
        if (value != 0) {
            return value;
        }
        return value;
    }

    public int compareToDC(Object o) {
        IPMIInterfaceConfig config2 = (IPMIInterfaceConfig)o;
        if (this.tagLocSDR == null) {
            return -1;
        }
        if (config2.tagLocSDR == null) {
            return 1;
        }
        if (this.tagLocSDR.tagLoc.dataCenter == config2.tagLocSDR.tagLoc.dataCenter) {
            return 0;
        }
        if (this.tagLocSDR.tagLoc.dataCenter > config2.tagLocSDR.tagLoc.dataCenter) {
            return 1;
        }
        return -1;
    }

    public int compareToRoom(Object o) {
        IPMIInterfaceConfig config2 = (IPMIInterfaceConfig)o;
        if (this.tagLocSDR == null) {
            return -1;
        }
        if (config2.tagLocSDR == null) {
            return 1;
        }
        if (this.tagLocSDR.tagLoc.room == config2.tagLocSDR.tagLoc.room) {
            return 0;
        }
        if (this.tagLocSDR.tagLoc.room > config2.tagLocSDR.tagLoc.room) {
            return 1;
        }
        return -1;
    }

    public int compareToRow(Object o) {
        IPMIInterfaceConfig config2 = (IPMIInterfaceConfig)o;
        if (this.tagLocSDR == null) {
            return -1;
        }
        if (config2.tagLocSDR == null) {
            return 1;
        }
        if (this.tagLocSDR.tagLoc.row == config2.tagLocSDR.tagLoc.row) {
            return 0;
        }
        if (this.tagLocSDR.tagLoc.row > config2.tagLocSDR.tagLoc.row) {
            return 1;
        }
        return -1;
    }

    public int compareToRack(Object o) {
        IPMIInterfaceConfig config2 = (IPMIInterfaceConfig)o;
        if (this.tagLocSDR == null) {
            return -1;
        }
        if (config2.tagLocSDR == null) {
            return 1;
        }
        if (this.tagLocSDR.tagLoc.rack == config2.tagLocSDR.tagLoc.rack) {
            return 0;
        }
        if (this.tagLocSDR.tagLoc.rack > config2.tagLocSDR.tagLoc.rack) {
            return 1;
        }
        return -1;
    }

    public int compareToNum(Object o) {
        IPMIInterfaceConfig config2 = (IPMIInterfaceConfig)o;
        if (this.tagLocSDR == null) {
            return -1;
        }
        if (config2.tagLocSDR == null) {
            return 1;
        }
        if (this.tagLocSDR.tagLoc.majorNumber == config2.tagLocSDR.tagLoc.majorNumber) {
            if (this.tagLocSDR.tagLoc.minorNumber == config2.tagLocSDR.tagLoc.minorNumber) {
                return 0;
            }
            if (this.tagLocSDR.tagLoc.minorNumber > config2.tagLocSDR.tagLoc.minorNumber) {
                return 1;
            }
            return 0;
        }
        if (this.tagLocSDR.tagLoc.majorNumber > config2.tagLocSDR.tagLoc.majorNumber) {
            return 1;
        }
        return -1;
    }

    public int compareToType(Object o) {
        IPMIInterfaceConfig config2 = (IPMIInterfaceConfig)o;
        if (this.tagLocSDR == null) {
            return -1;
        }
        if (config2.tagLocSDR == null) {
            return 1;
        }
        if (this.tagLocSDR.tagLoc.mbType == config2.tagLocSDR.tagLoc.mbType) {
            return 0;
        }
        if (this.tagLocSDR.tagLoc.mbType > config2.tagLocSDR.tagLoc.mbType) {
            return 1;
        }
        return -1;
    }

    public int compareToBMC(Object o) {
        IPMIInterfaceConfig config2 = (IPMIInterfaceConfig)o;
        if (this.fwType == null) {
            return -1;
        }
        if (config2.fwType == null) {
            return 1;
        }
        return this.fwType.compareTo(config2.fwType);
    }

    public static enum SORT_TYPE {
        ORG,
        IP,
        BOARD,
        LOC,
        DC,
        ROOM,
        ROW,
        RACK,
        NUM,
        TYPE,
        BMC;

    }
}

