/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.KIRAConfiguration;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.algo.AES_CBC_128;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class IPMIOEMCommand
extends IPMICommand {
    static AES_CBC_128 aes = new AES_CBC_128();
    static byte[] iv = new byte[16];
    static byte[] key = new byte[16];
    public static final byte SIM_LAN_TYPE_DEDICATED = 0;
    public static final byte SIM_LAN_TYPE_SHARED = 1;
    public static final byte SIM_LAN_ETH0 = 1;
    public static final byte SIM_LAN_ETH1 = 2;
    public static final byte SIM_LAN_TCO_FML = 3;
    public static final byte SIM_LAN_MCP55 = 4;
    public static final byte SIM_LAN_ECO_I2C = 5;
    public static String[][] idToBoard = new String[][]{{"X10SLM-F", "08", "11"}, {"X9DRH-if-NV", "07", "24"}, {"AOC-STG-B4S", "06", "58"}, {"C7Z87-OCE", "06", "57"}, {"X10SLD", "08", "10"}, {"AOC-SGP-i2", "06", "56"}, {"LSI3108", "08", "09"}, {"LSI3008", "08", "08"}, {"X10SLE", "08", "07"}, {"X10SLM-LN4F", "08", "06"}, {"AOC-XEH-IN2", "06", "55"}, {"C7Q87", "06", "54"}, {"C7Z87", "06", "53"}, {"X10SAE", "08", "05"}, {"H8SME-F", "D1", "11"}, {"X10SL7-f", "08", "04"}, {"X9DRL-7F/EF", "07", "23"}, {"AOC-CGP-i2", "06", "52"}, {"H8QG7", "D0", "11"}, {"X9DB3-TPF", "07", "22"}, {"X9DBS-F", "07", "21"}, {"X9SBAA", "06", "51"}, {"X9SPV-M4", "06", "50"}, {"X9DRW-7TPF+", "07", "20"}, {"X10SLH", "08", "03"}, {"X10SLA", "08", "02"}, {"X10SLL", "08", "01"}, {"X9SCE-F", "06", "47"}, {"H8SML-7/i(F)", "CF", "11"}, {"B9DRP", "07", "19"}, {"x9DRFF-7G+", "07", "18"}, {"X9DRFF-7+/i+", "07", "17"}, {"C7B75", "06", "48"}, {"X9SCAA", "06", "47"}, {"X9DBU-3F-AI034", "07", "16"}, {"X9SCFF", "06", "46"}, {"X9DRAW-7TPF", "07", "15"}, {"X9SRH-7F", "07", "14"}, {"X9DRFF-7", "07", "13"}, {"B9DRG-X", "07", "12"}, {"C7H61", "06", "45"}, {"X9DRG-HTF+", "07", "11", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRG-HTF.cfm"}, {"X9SRE", "07", "10", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRE-F.cfm"}, {"X9QR7-TF", "07", "0F"}, {"X9DAX-7", "07", "0E"}, {"B9DR7", "07", "0D"}, {"x9SAE", "06", "44"}, {"X9SRD-CD", "07", "0C"}, {"X9SRL-CF", "07", "0B"}, {"X9DRF-F", "07", "0A"}, {"X9DA7/E", "07", "09"}, {"X9DRT-F", "07", "08"}, {"X9QR7-TF+", "07", "07"}, {"X9SPU", "07", "43"}, {"X9DRT-HF+", "07", "06"}, {"X9DR7/E-LN4F", "07", "05"}, {"X9DR7/E-TF+", "07", "04"}, {"X9DBL-6F", "07", "03"}, {"X9DRT-HIBQF-AI034", "07", "01", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRT-HIBQF.cfm"}, {"X9DRT-HF-AI034", "07", "00"}, {"X9DRW-LN4F+-AI034", "06", "6f"}, {"X9DR6-LN4F+-AI034", "06", "6e"}, {"X9DR6+-F-AI034", "06", "6d"}, {"B9DRG", "06", "6C"}, {"X9SRL-F", "06", "6b"}, {"C7Q67-H", "06", "42"}, {"B9DRT", "06", "6A"}, {"X9DRX+-F", "06", "69", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRX_-F.cfm"}, {"X9SRD", "06", "68"}, {"X9DRL-3/iF", "06", "67", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRL-3F.cfm"}, {"X9DRT-D-SG007", "06", "66"}, {"X9DRG-QF", "06", "65", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRG-QF.cfm"}, {"X9SCV-LN4F+", "06", "41"}, {"X9SCL/SCM-II", "06", "40", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCL-F.cfm"}, {"X9DRH-7F", "06", "64", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRH-7F.cfm"}, {"X9SRW", "06", "63", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRW-F.cfm"}, {"X9DRG-QF+", "06", "62"}, {"X9SRG", "06", "61", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRG-F.cfm"}, {"2308", "06", "91"}, {"2208", "06", "90"}, {"X9DRD-3/iF", "06", "60", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRD-iF.cfm"}, {"X8QB6-LF", "06", "38", "http://www.supermicro.com/products/motherboard/Xeon7000/7500/X8QB6-LF.cfm"}, {"X9DBU-3F", "06", "37"}, {"X9DRW-3F", "06", "36", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRW-3F.cfm"}, {"X9DAL-6/i", "06", "35"}, {"H8DCT-HLN4F", "CE", "11"}, {"X9SCD", "06", "34", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCD-F.cfm"}, {"X9SCV-Q", "06", "33"}, {"X8DTG-QF+", "06", "32", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTG-QF_.cfm"}, {"X9SCA/X9SCI", "06", "31", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCA-F.cfm"}, {"X9DRW-3TF+", "06", "30", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRW-3TF_.cfm"}, {"X9DRT-HF", "06", "2F", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRT-HF.cfm"}, {"H8DCL-6F", "CD", "11"}, {"X8STE-DS018", "06", "2E"}, {"X8SIL-SIOM-FI005", "06", "2D"}, {"H8DGT-CM", "CB", "11"}, {"X9DAi", "06", "2C", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DAi.cfm"}, {"X9SRi", "06", "2B", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRi-F.cfm"}, {"X9SRA", "06", "2A", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRA.cfm"}, {"X9SRT-F", "06", "29"}, {"X9DR3/i-F", "06", "28", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DR3-F.cfm"}, {"H8QGL", "CA", "11"}, {"X7SPT-DF-D525", "06", "27"}, {"X9DR3-LN4F+", "06", "26", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DR3-LN4F_.cfm"}, {"B9DRi", "06", "25"}, {"X9SCM", "06", "24", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCM-F.cfm"}, {"H8DME-EX-LS006", "BF", "11"}, {"C7Q67", "06", "23"}, {"C7P67", "06", "22"}, {"X8OBN", "06", "21", "http://www.supermicro.com/products/motherboard/Xeon7000/7500/X8OBN-F.cfm"}, {"H8DCT", "BE", "11"}, {"H8DGT-C", "BD", "11"}, {"BHQG6/E", "BC", "11"}, {"B8DTG", "06", "20"}, {"B8DTP", "06", "1F"}, {"X9SCL", "06", "1E"}, {"H8DCT-IBQF", "BD", "11"}, {"H8DG6/i(-F)", "BC", "11"}, {"C7SIA", "06", "1D"}, {"BHDGT", "BB", "11"}, {"H8SCM-F", "BA", "11"}, {"B8DTT-AI034", "06", "1E"}, {"B8DT6-AI034", "06", "1C"}, {"H8DGU-LN4F+-AI034", "AF", "11"}, {"H8QGI-F-AI034", "AE", "11"}, {"H8DGT-HIBQF-AI034", "AD", "11"}, {"H8DGU-LN4", "AC", "11"}, {"H8QG6", "AB", "11"}, {"X8DTT-HA", "06", "1B"}, {"X8SIU", "06", "1A", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIU.cfm?IPMI=Y"}, {"X8DTU-6TF+", "06", "0D", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU_.cfm?TYP=SAS&LAN=10"}, {"X8DTU-LN4F+", "06", "0C", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU_.cfm"}, {"H8DGT", "AA", "11"}, {"H8DGG-QF", "A9", "11"}, {"H8DGU", "A8", "11"}, {"X8DTU-F-AI034", "06", "14", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU-F.cfm"}, {"X8DTT-C-SG007", "06", "13"}, {"B8DTT", "06", "12"}, {"AOC-STGN-I2S", "06", "11"}, {"X8QB6/E", "06", "10", "http://www.supermicro.com/products/motherboard/Xeon7000/7500/X8QB6.cfm?SAS=Y"}, {"X8DTN+-F", "06", "0F"}, {"X8SIT", "06", "0E", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIT.cfm?IPMI=Y"}, {"X8DTU+", "06", "0C"}, {"X8SIA", "06", "0B", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIA.cfm?IPMI=Y"}, {"H8DGU", "A8", "11"}, {"X7SPA", "06", "0A"}, {"H8SGL", "A7", "11"}, {"BHQIE", "A6", "11"}, {"X8SII/X8SI6", "04", "0D", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIE.cfm?IPMI=Y&TYP=SAS"}, {"X8DT6/E", "04", "04", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DT6-F.cfm?IPMI=N&SAS=Y"}, {"B8DTL", "01", "01"}, {"X8DTS", "06", "09"}, {"X8DTG-DF", "06", "08", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTG-DF.cfm"}, {"X8DTW-6+/i+", "04", "0B"}, {"X8DTL-6/L", "04", "10", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTL-6.cfm"}, {"X8DA6/i-X", "04", "03"}, {"H8QI6/E(+)(-F)", "04", "09"}, {"C2G41", "06", "07"}, {"X8DTG-4", "06", "06"}, {"X8SIL", "06", "05", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIL.cfm?IPMI=Y"}, {"winbond IPMI (Aten)", "06", "04"}, {"C2SEM-Q", "06", "03"}, {"X7SLA", "06", "02"}, {"X8DTH-6/i", "04", "00", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTH-6F.cfm"}, {"x8DAL-3/i", "06", "01"}, {"X8DTU", "06", "00", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU.cfm"}, {"B8DT3", "00", "0A"}, {"X8DTH-RC014", "04", "01"}, {"X8STi-3/-LN4", "00", "09", "http://www.supermicro.com/products/motherboard/Xeon3000/X58/X8STi-3F.cfm"}, {"H8DI3+", "A5", "11"}, {"X7SLM-L", "ba", "80"}, {"X8DAH+", "01", "00", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DAH_.cfm"}, {"H8DME-2-LS006", "25", "11"}, {"X8DTT-B-SG", "00", "08"}, {"X8DTT-IBX", "00", "07", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTT-IBXF.cfm"}, {"X8DTL-3/i", "00", "06", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTL-3F.cfm"}, {"X8DTW-3/i/-LN4", "00", "03"}, {"C2SLM-OC012", "00", "02"}, {"X8ST3", "F5", "80", "http://www.supermicro.com/products/motherboard/Xeon3000/X58/X8ST3-F.cfm"}, {"X8SAX", "F3", "80"}, {"X8DT3/i/-LN4", "00", "01", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DT3-F.cfm"}, {"Winbond IPMI (AMI)", "B9", "80"}, {"H8QM3-EX", "A3", "11"}, {"H8DMT-IBX", "24", "11"}, {"X7DCX", "F4", "80"}, {"X7SB3", "A9", "80"}, {"BHDME", "23", "11"}, {"X8DA3/i", "A8", "80"}, {"X8DTN+", "F2", "80", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTN_.cfm?IPMI=O"}, {"X7DWT-CD-SG007", "B7", "80"}, {"AOC-USASLP-H8iR", "C3", "80"}, {"C2SEA", "B8", "80"}, {"X7SBU", "F1", "80"}, {"X7SBT", "F0", "80"}, {"B7DC3", "A7", "80"}, {"H8DMT", "22", "11"}, {"B7DCE", "BB", "80"}, {"X7DWE", "DF", "80"}, {"X7DWT-C-SG007", "AA", "80"}, {"X7DCT-10G", "DE", "80"}, {"X7DCA-3/i", "A6", "80"}, {"X7SBX", "DD", "80"}, {"X7DCA-L", "DC", "80"}, {"X7DCU", "DB", "80"}, {"C2SBM-Q", "DA", "80"}, {"X7DWP", "D0", "80"}, {"X7DWU", "AC", "80"}, {"B7DW3", "C2", "80"}, {"PDSMP-JN001", "AE", "80"}, {"AOC-UTG-I2", "AF", "80"}, {"X7SBF", "D5", "80"}, {"BHQME", "AD", "11"}, {"X7SBi-LN4", "D4", "80"}, {"C2SBM-Q", "AB", "80"}, {"C2SBi", "BF", "80"}, {"C2SBC", "BE", "80"}, {"X7SBL-LN1/LN2", "AA", "80"}, {"AOC-USAS-H8i", "C1", "80"}, {"AOC-USAS-H4i", "C0", "80"}, {"C2SBC", "BE", "80"}, {"C2SBM", "BD", "80"}, {"X7DWT/-INF", "BC", "80"}, {"X7SBA", "D3", "80"}, {"M8QME", "21", "11"}, {"X7SB4/E", "D2", "80"}, {"C2SBX", "BA", "80"}, {"X7DCA-3/i", "D6", "80"}, {"X7DCL-3", "A4", "80"}, {"H8QM3-2", "A2", "11"}, {"X7QC3", "A3", "80"}, {"X7SBi", "D1", "80"}, {"C2SBA", "B7", "80"}, {"AOC-USAS-L8I", "A5", "80"}, {"X7DGT-ATOKAP", "B6", "80"}, {"PDSBM-LN2", "B5", "80"}, {"X7DW3+", "A2", "80"}, {"AOC-UG-i4", "B4", "80"}, {"X7DWN", "B3", "80"}, {"X7DVL-L", "B2", "80"}, {"H8SMU", "20", "11"}, {"H8DA3-2", "A1", "11"}, {"H8DMU", "19", "11"}, {"X7DBI+", "B1", "80"}, {"H8DM3-2", "A0", "11"}, {"H8SSL-I2", "18", "11"}, {"B7DBE", "B0", "80"}, {"X7DBT", "99", "80"}, {"PDSMU+", "98", "80"}, {"X7DVL-3", "A0", "80"}, {"X7DBU", "97", "80"}, {"X7DBN", "96", "80"}, {"X6QT8", "95", "80"}, {"H8SMI-2", "17", "11"}, {"H8DM8-2", "16", "11"}, {"H8DMR-82", "15", "11"}, {"H8DA8-2", "14", "11"}, {"H8QM8-2", "13", "11"}, {"X7DAL-E", "94", "80"}, {"PDSLM", "93", "80"}, {"X7DBR-3", "92", "80"}, {"PDSME+", "91", "80"}, {"X7DB8-X", "90", "80"}, {"X7DBP-8", "89", "80"}, {"X7DBX", "88", "80"}, {"PDSBA", "87", "80"}, {"X7DVL", "86", "80"}, {"H8DC8", "12", "11"}, {"PDSML", "85", "80"}, {"H8DCR-3", "11", "11"}, {"X7DBR-8+", "84", "80"}, {"X7DBP-X", "83", "80"}, {"PDSMI-LN4", "82", "80"}, {"X7DA8", "81", "80"}, {"X7DB8", "80", "80"}};

    public IPMIOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void CMD____________() {
    }

    public IPMIMessage clearChassisIntrusionCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)3, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage gracefulPowerControlCommand(byte param) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)4, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isUIDPresentCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)16, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableUIDLEDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)13, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage disableUIDLEDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)14, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSensorsCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)17, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getProductIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)33, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setProductIDCommand(byte[] productID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0, 0, 2, 0, 0, 0, 0, 0};
        data[0] = productID[1];
        data[1] = productID[0];
        ipmiMessage.setCommandAndData((byte)-64, (byte)32, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSIMxxLanDriverCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)20, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage checkNoVMandWebCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)39, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isOEMCommandSupported(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)41, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isOfficeBladeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)65, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isBackupAndRestoreFuncExistCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)40, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFanSpeedModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)69, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setFanSpeedModeCommand(byte value) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, value};
        ipmiMessage.setCommandAndData((byte)-64, (byte)69, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFanSpeedModeCapabilityCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2};
        ipmiMessage.setCommandAndData((byte)-64, (byte)69, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void API____________() {
    }

    public boolean gracefulPowerCycle() {
        byte command = 3;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerCycle");
        return false;
    }

    public boolean gracefulPowerReset() {
        byte command = 2;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerReset");
        return false;
    }

    public boolean gracefulPowerShutDown() {
        byte command = 1;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerShutDown");
        return false;
    }

    public boolean clearChassisIntrusion() {
        IPMIMessage resMessage = this.clearChassisIntrusionCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute clear chassis intrusion command");
        return false;
    }

    public boolean enableUIDLED() {
        IPMIMessage resMessage = this.enableUIDLEDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute enable UID LED");
        return false;
    }

    public boolean disableUIDLED() {
        IPMIMessage resMessage = this.disableUIDLEDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute disable UID LED");
        return false;
    }

    public boolean isUIDPresent() {
        IPMIMessage resMessage = this.isUIDPresentCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isUIDPresent");
        return false;
    }

    public byte[] getProductID() {
        IPMIMessage resMessage = this.getProductIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] bytes = new byte[]{resMessage.data[0], resMessage.data[1]};
                return bytes;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Product ID");
        return null;
    }

    public byte[] getSystemMACAddress() {
        IPMIMessage resMessage = this.getProductIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] bytes = new byte[]{resMessage.data[4], resMessage.data[5], resMessage.data[6], resMessage.data[7], resMessage.data[8], resMessage.data[9]};
                return bytes;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get System MAC address");
        return null;
    }

    public boolean setProductID(byte[] productID) {
        IPMIMessage resMessage = this.setProductIDCommand(productID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set Product ID");
        return false;
    }

    public byte[] getBoardModelByte() {
        byte[] productID = this.getProductID();
        return productID;
    }

    public static String getBoardModel(byte[] productID) {
        int i;
        boolean flag = false;
        if (productID != null) {
            for (i = 0; i < idToBoard.length; ++i) {
                if (ByteUtility.hexToBytes(idToBoard[i][1])[0] != productID[1] || ByteUtility.hexToBytes(idToBoard[i][2])[0] != productID[0]) continue;
                flag = true;
                return idToBoard[i][0];
            }
        } else {
            return null;
        }
        if (!flag) {
            for (i = 0; i < idToBoard.length; ++i) {
                if (ByteUtility.hexToBytes(idToBoard[i][1])[0] != productID[0] || ByteUtility.hexToBytes(idToBoard[i][2])[0] != productID[1]) continue;
                flag = true;
                return idToBoard[i][0];
            }
        }
        return null;
    }

    public String getBoardModel() {
        byte[] productID = this.getProductID();
        return IPMIOEMCommand.getBoardModel(productID);
    }

    public String getBoardModelWebLink() {
        byte[] productID = this.getProductID();
        return this.getBoardModelLink(productID);
    }

    public String getBoardModelLink(byte[] productID) {
        int i;
        boolean flag = false;
        if (productID != null) {
            for (i = 0; i < idToBoard.length; ++i) {
                if (ByteUtility.hexToBytes(idToBoard[i][1])[0] != productID[0] || ByteUtility.hexToBytes(idToBoard[i][2])[0] != productID[1]) continue;
                flag = true;
                if (idToBoard[i].length == 4) {
                    return idToBoard[i][3];
                }
                return null;
            }
        } else {
            return null;
        }
        if (!flag) {
            for (i = 0; i < idToBoard.length; ++i) {
                if (ByteUtility.hexToBytes(idToBoard[i][1])[0] != productID[1] || ByteUtility.hexToBytes(idToBoard[i][2])[0] != productID[0]) continue;
                flag = true;
                if (idToBoard[i].length == 4) {
                    return idToBoard[i][3];
                }
                return null;
            }
        }
        return null;
    }

    public byte[] getSensors() {
        IPMIMessage resMessage = this.getSensorsCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Sensors");
        return null;
    }

    public byte[] getSIMxxLanDriver() {
        IPMIMessage resMessage = this.getSIMxxLanDriverCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get getSIMxxLanDriver");
        return null;
    }

    public boolean checkNoVMAndWeb() {
        IPMIMessage resMessage = this.checkNoVMandWebCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute checkNoVMandWebCommand");
        return false;
    }

    public boolean isOfficeBlade() {
        IPMIMessage resMessage = this.isOfficeBladeCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isOfficeBlade");
        return false;
    }

    public boolean isBackupAndRestoreFuncExist() {
        IPMIMessage resMessage = this.isBackupAndRestoreFuncExistCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isBackupAndRestoreFuncExist");
        return false;
    }

    public boolean backupConfiguration(File selFile, boolean isEncrypt) throws IPMIException, IOException {
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        byte[] configData = config.backupConfiguration();
        byte[] configCRC = config.getconfigCRC();
        byte[] data = new byte[configData.length + configCRC.length];
        System.arraycopy(configData, 0, data, 0, configData.length);
        System.arraycopy(configCRC, 0, data, configData.length, configCRC.length);
        if (isEncrypt) {
            data = config.encrypt(data);
        }
        FileChannel wChannel = new FileOutputStream(selFile, false).getChannel();
        wChannel.write(ByteBuffer.wrap(data));
        wChannel.close();
        return true;
    }

    public boolean restoreConfiguration(File selFile, boolean isDecrypt, byte restoreOption) throws IPMIException, IOException {
        int offset;
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        if (selFile.length() > Integer.MAX_VALUE) {
            throw new IOException("File size is more than Integer.MAX_VALUE" + selFile.length());
        }
        byte[] inputs = new byte[(int)selFile.length()];
        byte[] configCRC = null;
        byte[] configData = null;
        int numRead = 0;
        FileInputStream is = new FileInputStream(selFile);
        for (offset = 0; offset < inputs.length && (numRead = ((InputStream)is).read(inputs, offset, inputs.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < inputs.length) {
            throw new IOException("Could not completely read file " + selFile.getName());
        }
        if (isDecrypt) {
            inputs = config.decrypt(inputs);
        }
        configCRC = new byte[4];
        configData = new byte[inputs.length - 4];
        System.arraycopy(inputs, 0, configData, 0, configData.length);
        System.arraycopy(inputs, inputs.length - 4, configCRC, 0, 4);
        return config.restoreConfiguration(configData, configCRC, true, restoreOption);
    }

    public void listDecryptedConfigurationFile(File selFile) throws IPMIException, IOException {
        int offset;
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        if (selFile.length() > Integer.MAX_VALUE) {
            throw new IOException("File size is more than Integer.MAX_VALUE" + selFile.length());
        }
        byte[] inputs = new byte[(int)selFile.length()];
        byte[] configCRC = null;
        byte[] configData = null;
        int numRead = 0;
        FileInputStream is = new FileInputStream(selFile);
        for (offset = 0; offset < inputs.length && (numRead = ((InputStream)is).read(inputs, offset, inputs.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < inputs.length) {
            throw new IOException("Could not completely read file " + selFile.getName());
        }
        inputs = config.decrypt(inputs);
        configCRC = new byte[4];
        configData = new byte[inputs.length - 4];
        System.arraycopy(inputs, 0, configData, 0, configData.length);
        System.arraycopy(inputs, inputs.length - 4, configCRC, 0, 4);
        System.out.println(new String(configData));
        System.out.println("CRC= " + ByteUtility.bytesToHex(configCRC));
    }

    public boolean syncCMMCoinfiguration() throws IPMIException {
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        return config.syncCMMConfiguration();
    }

    public boolean isVLANCommandSupported() {
        IPMIMessage resMessage = this.isOEMCommandSupported((byte)1);
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[0] == 1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isOEMCommandSupported");
        return false;
    }

    public NetworkInfo createNetworkInfo() {
        return new NetworkInfo();
    }

    public byte getFANSpeedMode() throws IPMIException {
        IPMIMessage resMessage = this.getFanSpeedModeCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getFanSpeedModeCommand failed");
    }

    public void setFANSpeedMode(byte value) throws IPMIException {
        IPMIMessage resMessage = this.setFanSpeedModeCommand(value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setFanSpeedModeCommand failed");
    }

    public byte getFANSpeedModeCapability() throws IPMIException {
        IPMIMessage resMessage = this.getFanSpeedModeCapabilityCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data != null && resMessage.data.length == 1) {
                    return resMessage.data[0];
                }
                throw new IPMIException("Call getFanSpeedModeCommand failed (Not supported Command)");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getFanSpeedModeCommand failed");
    }

    public IPMIMessage getAllNetworkInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)43, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setAllNetworkInfoCommand(byte[] networkRawData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + networkRawData.length];
        data[0] = 1;
        System.arraycopy(networkRawData, 0, data, 1, networkRawData.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)43, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public NetworkInfo getAllNetworkInfo() throws IPMIException {
        IPMIMessage resMessage = this.getAllNetworkInfoCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            NetworkInfo networkInfo = new NetworkInfo();
            networkInfo.fromRaw(resMessage.data);
            return networkInfo;
        }
        throw new IPMIException("Call getAllNetworkInfoCommand failed");
    }

    public void setAllNetworkInfo(NetworkInfo networkInfo) throws IPMIException {
        IPMIMessage resMessage = this.setAllNetworkInfoCommand(networkInfo.toRaw());
        if (resMessage != null && resMessage.completionCode == 0) {
            return;
        }
        throw new IPMIException("Call setAllNetworkInfoCommand failed");
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.16");
        config.setUserName("ADMIN");
        config.setPassword("23456");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiOEMCommand.setIPMIInterface(rmcp);
        byte[] boardModelByte = ipmiOEMCommand.getBoardModelByte();
        String boardModel = ipmiOEMCommand.getBoardModel();
        System.out.println("board model is " + ByteUtility.bytesToHex(boardModelByte) + "[" + boardModel + "]");
        System.out.println("is UID present ? " + ipmiOEMCommand.isUIDPresent());
        System.out.println("is vlan command support ? " + ipmiOEMCommand.isVLANCommandSupported());
        try {
            NetworkInfo networkInfo = ipmiOEMCommand.getAllNetworkInfo();
            System.out.println(networkInfo.toString());
        }
        catch (IPMIException ex) {
            // empty catch block
        }
    }

    public static void main_(String[] args) {
        byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        KIRAConfiguration k = new KIRAConfiguration(null);
        byte[] encData = k.encrypt(data);
        System.out.println("encdata =" + ByteUtility.bytesToHex(encData));
        byte[] decData = k.decrypt(encData);
        System.out.println("decdata =" + ByteUtility.bytesToHex(decData));
    }

    public class NetworkInfo {
        public byte ipSource;
        public String ip;
        public String subnet;
        public String gateway;
        public boolean isVLANEnabled;
        public int vLanID;
        byte[] raw;

        public void fromRaw(byte[] data) {
            this.ipSource = data[0];
            this.ip = (data[1] & 0xFF) + "." + (data[2] & 0xFF) + "." + (data[3] & 0xFF) + "." + (data[4] & 0xFF);
            this.subnet = (data[5] & 0xFF) + "." + (data[6] & 0xFF) + "." + (data[7] & 0xFF) + "." + (data[8] & 0xFF);
            this.gateway = (data[9] & 0xFF) + "." + (data[10] & 0xFF) + "." + (data[11] & 0xFF) + "." + (data[12] & 0xFF);
            this.vLanID = (data[13] & 0xFF) + ((data[14] & 0xF) << 8);
            if ((byte)(data[14] & 0x80) == -128) {
                this.isVLANEnabled = true;
            }
            this.raw = data;
        }

        public byte[] toRaw() {
            int index = 0;
            byte[] raw = new byte[15];
            raw[index] = this.ipSource;
            System.arraycopy(ByteUtility.ipToBytes(this.ip), 0, raw, ++index, 4);
            System.arraycopy(ByteUtility.ipToBytes(this.subnet), 0, raw, index += 4, 4);
            System.arraycopy(ByteUtility.ipToBytes(this.gateway), 0, raw, index += 4, 4);
            raw[index += 4] = (byte)this.vLanID;
            raw[++index] = (byte)(this.vLanID >> 8);
            if (this.isVLANEnabled) {
                raw[index] = (byte)(raw[index] | 0x80);
            }
            return raw;
        }

        public String toString() {
            String result = "";
            result = result + "\n IP Source = 0X" + ByteUtility.byteToHex(this.ipSource);
            result = result + "\n IP = " + this.ip;
            result = result + "\n Subnet = " + this.subnet;
            result = result + "\n gateway  = " + this.gateway;
            result = result + "\n vLanID  = " + this.vLanID;
            result = result + "\n isVlanEnable  = " + this.isVLANEnabled;
            result = result + "\n raw  = " + ByteUtility.bytesToHex(this.raw);
            return result;
        }
    }
}

