/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IIPMIMessage;

public class SOLMessage
implements IIPMIMessage {
    private byte packetSequenceNumber;
    private byte packetACKandNACKSequenceNumber;
    private byte characterCount;
    private byte operation;
    public byte[] data;

    public static SOLMessage fromRaw(byte[] raw) {
        SOLMessage solMessage = new SOLMessage();
        solMessage.packetSequenceNumber = raw[0];
        solMessage.packetACKandNACKSequenceNumber = raw[1];
        solMessage.characterCount = raw[2];
        solMessage.operation = raw[3];
        solMessage.data = new byte[raw.length - 4];
        System.arraycopy(raw, 4, solMessage.data, 0, solMessage.data.length);
        return solMessage;
    }

    @Override
    public byte[] raw() {
        int dataSize = this.data == null ? 0 : this.data.length;
        byte[] bytes = new byte[4 + dataSize];
        bytes[0] = this.packetSequenceNumber;
        bytes[1] = this.packetACKandNACKSequenceNumber;
        bytes[2] = this.characterCount;
        bytes[3] = this.operation;
        if (this.data != null) {
            System.arraycopy(this.data, 0, bytes, 4, this.data.length);
        }
        return bytes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("packetSequenceNumber =" + ByteUtility.byteToHex(this.packetSequenceNumber) + "\n");
        sb.append("packetACKandNACKSequenceNumber =" + ByteUtility.byteToHex(this.packetACKandNACKSequenceNumber) + "\n");
        sb.append("characterCount =" + ByteUtility.byteToHex(this.characterCount) + "\n");
        sb.append("operation =" + ByteUtility.byteToHex(this.operation) + "\n");
        if (this.data != null) {
            sb.append("data =" + new String(this.data) + "\n");
        }
        return sb.toString();
    }

    public void setPacketSequenceNumber(byte packetSequenceNumber) {
        this.packetSequenceNumber = packetSequenceNumber;
    }

    public void setPacketACKandNACKSequenceNumber(byte packetACKandNACKSequenceNumber) {
        this.packetACKandNACKSequenceNumber = packetACKandNACKSequenceNumber;
    }

    public void setCharacterCount(byte characterCount) {
        this.characterCount = characterCount;
    }

    public void setOperation(byte operation) {
        this.operation = operation;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte getPacketSequenceNumber() {
        return this.packetSequenceNumber;
    }

    public byte getPacketACKandNACKSequenceNumber() {
        return this.packetACKandNACKSequenceNumber;
    }

    public byte getCharacterCount() {
        return this.characterCount;
    }

    public byte getOperation() {
        return this.operation;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public byte[] humanReadRaw() {
        return null;
    }
}

