/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;

public class CommandForGettingDeviceInfo
extends Command {
    public static String DEVICE_INFO_OBJECT = "DEVICE_INFO_OBJECT";

    @Override
    public Result execute(Host host) {
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        Result result = new Result(this, host);
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiGlobalCommand.setIPMIInterface(rmcp);
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        if (deviceInfo != null) {
            result.booleanResult = true;
            result.description = result.description + "\n";
            result.description = result.description + deviceInfo.toReadableString();
            result.setSingleData(DEVICE_INFO_OBJECT, deviceInfo);
        } else {
            result.booleanResult = false;
            result.description = "Get Device Info failed";
        }
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Get Device Info";
    }
}

