/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMITimeoutException;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.RMCPPlus;
import com.supermicro.ipmi.RMCPPlusSessionController;
import com.supermicro.ipmi.SessionInfo;
import com.supermicro.ipmi.text.BIOSAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.io.File;

public class BIOSUpdateCommand
extends BIOSAbstractCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("BIOS filename is needed");
            this.usage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        String filename;
        File biosFile;
        String options = "";
        int optionFlag = 1;
        int sessions = 1;
        boolean multiSessionUploadEnabled = false;
        boolean longDistance = false;
        boolean debug = false;
        boolean forceReboot = false;
        if (!this.checkIfSupportBIOSUpdate()) {
            MOut.G(this).println("This device doesn't support BIOS commands");
            MOut.G(this).println("BIOS commands only support X9 series montherboards");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfProudctNotActivated()) {
            MOut.G(this).println("The product key needs to be activated for this device");
            this.statusCode = 153;
            return;
        }
        if (this.parameters.length > 1) {
            for (int i = 1; i < this.parameters.length; ++i) {
                options = options + this.parameters[i] + " ";
            }
            if (options.toLowerCase().indexOf("-forcereboot") != -1) {
                MOut.G(this).println("Option: Reboot");
                forceReboot = true;
            }
            if (options.toLowerCase().indexOf("-n") != -1) {
                MOut.G(this).println("Option: NVRAM overwrite");
                optionFlag = 0;
            } else {
                optionFlag = 1;
            }
            if (options.toLowerCase().indexOf("-mer") != -1) {
                MOut.G(this).println("Option: ME region");
                optionFlag |= 2;
            }
            if (options.toLowerCase().indexOf("-r") != -1) {
                MOut.G(this).println("Option: SMBIOS preserve");
                optionFlag |= 8;
            }
            if (options.toLowerCase().indexOf("-s2") != -1) {
                sessions = 2;
            }
            if (options.toLowerCase().indexOf("-s4") != -1) {
                sessions = 4;
            }
            if (options.toLowerCase().indexOf("-s8") != -1) {
                sessions = 8;
            }
            if (options.toLowerCase().indexOf("-s16") != -1) {
                sessions = 16;
            }
            if (options.toLowerCase().indexOf("-s32") != -1) {
                sessions = 32;
            }
            if (options.toLowerCase().indexOf("-d") != -1) {
                debug = true;
            }
        }
        if (!(biosFile = new File(filename = this.parameters[0])).isFile()) {
            MOut.G(this).println("File is not found");
            this.usage();
            this.statusCode = 147;
            return;
        }
        try {
            this.ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            int chunksize = 1024;
            try {
                multiSessionUploadEnabled = this.ipmiX9BIOSOEMCommand.ifMultiSessionUploadSupported();
            }
            catch (Exception ex1) {
                // empty catch block
            }
            int time = this.ipmiX9BIOSOEMCommand.speedTest();
            if (time > 50) {
                longDistance = true;
            }
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            RMCPPlus rmcpPlus = ((RMCPPlusSessionController)this.sessionController).getRMCPPlus();
            SessionInfo sessionInfo = ipmiMessagingCommand.getCurrentlySessionInfo(rmcpPlus.getRmcpPlusSession().getSessionID());
            byte maxSession = sessionInfo.getNumberOfPossibleActiveSessions();
            byte currSession = sessionInfo.getNumberOfCurrentlyActiveSession();
            int availableSession = maxSession - currSession;
            if (sessions == 1) {
                if (longDistance && multiSessionUploadEnabled) {
                    if (availableSession > 32) {
                        sessions = 8;
                    } else if (availableSession > 16) {
                        sessions = 8;
                    } else if (availableSession > 8) {
                        sessions = 8;
                    } else if (availableSession > 4) {
                        sessions = 4;
                    } else if (availableSession > 2) {
                        sessions = 2;
                    }
                }
            } else {
                if (sessions > availableSession) {
                    sessions = 1;
                }
                if (!multiSessionUploadEnabled) {
                    sessions = 1;
                }
            }
            if (options.toLowerCase().indexOf("-s1") != -1) {
                sessions = 1;
            }
            if (debug) {
                MOut.G(this).println("Multi Session Upload Enabled ? " + multiSessionUploadEnabled);
                MOut.G(this).println("Speed             = " + time + "ms");
                MOut.G(this).println("Available Session = " + availableSession);
                MOut.G(this).println("Use Session       = " + sessions + " session(s)");
            }
            this.ipmiX9BIOSOEMCommand.setMOut(MOut.G(this));
            this.statusCode = this.ipmiX9BIOSOEMCommand.flashBIOSNew(chunksize, optionFlag, filename, sessions, forceReboot) ? 0 : 149;
        }
        catch (IPMITimeoutException ie) {
            MOut.G(this).println(ie.getMessage());
            this.statusCode = 145;
        }
        catch (IPMIException ie) {
            MOut.G(this).println(ie.getMessage());
            this.statusCode = 82;
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
        }
    }

    public void usage() {
        MOut.G(this).println("Usage: bios update <filename> [options...]");
        MOut.G(this).println("Options: ");
        MOut.G(this).println("           -N: Program NVRAM");
        MOut.G(this).println("           -R: Preserve SMBIOS");
        MOut.G(this).println("         -MER: Program ME Firmware ME Region");
        MOut.G(this).println(" -FORCEREBOOT: Force Reboot After BIOS Flash Successfully");
        MOut.G(this).println("");
        MOut.G(this).println("* BIOS update supports X9 series montherboards");
        MOut.G(this).println("* This function needs to activate product key");
    }
}

