/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CMMDateTimeCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            MOut.G(this).println("CMM Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isConnectToCMM(cmmIndex - 1)) {
            MOut.G(this).println("This function is only available for the CMM connected");
            this.statusCode = 152;
            return;
        }
        if (this.parameters != null) {
            Calendar c = Calendar.getInstance();
            String inputDTime = this.parameters[0];
            try {
                SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                f.setLenient(false);
                Date date = f.parse(inputDTime);
                c.setTime(date);
            }
            catch (ParseException ex1) {
                MOut.G(this).println("Format error! " + ex1.getMessage());
                MOut.G(this).println("Format: MM/dd/yyyy HH:mm:ss");
                MOut.G(this).println("Example:\"05/07/2007 17:17:06\" (with double quote)");
                this.statusCode = 147;
                return;
            }
            boolean b = this.ipmiCMMOEMCommand.setCMMTime(c);
            if (b) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        } else {
            MOut.G(this).println(this.ipmiCMMOEMCommand.getCMMTime());
            MOut.G(this).println("\n(Data time format for setting: \"MM/dd/yyyy HH:mm:ss\")");
            this.statusCode = 0;
        }
    }
}

