/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMStatusCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            MOut.G(this).println("CMM Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryCMMModuleEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        CMMModuleEntity cmm = bladeSystem.getCmmModules()[cmmIndex - 1];
        if (cmm.getPresent() == 0) {
            MOut.G(this).println("CMM " + cmmIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        MOut.G(this).print(cmm.toFormatedHeader());
        MOut.G(this).println(cmm.toFormatedString());
        for (int i = 0; i < bladeSystem.getCmmModules().length; ++i) {
            if (!bladeSystem.getCmmModules()[i].isConnected()) continue;
            MOut.G(this).println("CMM " + (i + 1) + " is being managed now");
        }
        this.statusCode = 0;
    }
}

