/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class GBBootCommand
extends SuperBladeCommand {
    private byte gbIndex = 0;
    private byte bootImage = 0;

    @Override
    public boolean preValidate() {
        this.gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (this.gbIndex < 1 || this.gbIndex > 4) {
            MOut.G(this).println("Gigabit switch Index out of range");
            return false;
        }
        this.bootImage = 0;
        if (this.parameters != null) {
            this.bootImage = Byte.parseByte(this.parameters[0]);
            if (this.bootImage < 1 || this.bootImage > 2) {
                MOut.G(this).println("Parameter invalid");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        block7: {
            if (!this.isMaster) {
                this.printSlaveCMMUnavailableMessage();
                this.statusCode = 150;
                return;
            }
            if (!this.isGigabitPresent(this.gbIndex)) {
                MOut.G(this).println("Gigabit Switch " + this.gbIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
            if (this.bootImage != 0) {
                try {
                    boolean result = this.ipmiCMMOEMCommand.setGBBootUpImage(this.gbIndex, this.bootImage);
                    boolean result2 = this.ipmiCMMOEMCommand.setGBCommit(this.gbIndex);
                    if (result && result2) {
                        MOut.G(this).println("Done");
                        this.statusCode = 0;
                        break block7;
                    }
                    MOut.G(this).println("Failed");
                    this.statusCode = 149;
                }
                catch (IPMIException ex) {
                    MOut.G(this).println("set GB boot failed");
                    this.statusCode = 149;
                }
            } else {
                this.showBootImage();
            }
        }
    }

    private void showBootImage() {
        try {
            byte ipMode = this.ipmiCMMOEMCommand.getGBBootUpImage(this.gbIndex);
            switch (ipMode) {
                case 1: {
                    MOut.G(this).println("Main image");
                    break;
                }
                case 2: {
                    MOut.G(this).println("fallback image");
                    break;
                }
                default: {
                    MOut.G(this).println("Unknown");
                    break;
                }
            }
        }
        catch (IPMIException ex) {
            MOut.G(this).println("Get GB Boot Image failed");
            this.statusCode = 149;
        }
    }
}

