/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIPowerCommand
extends SuperBladeCommand {
    private SubCommand subCommand = SubCommand.NO_COMMAND;
    private GlobalDefine.BootDevice bootDevice = GlobalDefine.BootDevice.BIOS;
    private byte cycleInterval = 0;

    @Override
    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"status", "up", "down", "softshutdown", "reset", "cycle", "diag"};
    }

    @Override
    public boolean preValidate() {
        boolean passValidate = false;
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("status")) {
                this.subCommand = SubCommand.STATUS;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("up")) {
                this.subCommand = SubCommand.ON;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("down")) {
                this.subCommand = SubCommand.OFF;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("softshutdown")) {
                this.subCommand = SubCommand.GRACEFULSHUTDOWN;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("reset")) {
                this.subCommand = SubCommand.RESET;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("cycle")) {
                this.subCommand = SubCommand.CYCLE;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("diag")) {
                this.subCommand = SubCommand.DIAG;
                passValidate = true;
            }
        } else {
            this.subCommand = SubCommand.NO_COMMAND;
            passValidate = true;
        }
        block0 : switch (this.subCommand) {
            case OFF: 
            case GRACEFULSHUTDOWN: 
            case RESET: {
                switch (this.parameters.length) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        if (this.parameters[1].equalsIgnoreCase("PXE")) {
                            this.bootDevice = GlobalDefine.BootDevice.PXE;
                            break block0;
                        }
                        passValidate = false;
                        break block0;
                    }
                }
                passValidate = false;
                break;
            }
        }
        block7 : switch (this.subCommand) {
            case CYCLE: {
                switch (this.parameters.length) {
                    case 1: {
                        break block7;
                    }
                    case 2: {
                        if (ByteUtility.isNumeric(this.parameters[1])) {
                            this.cycleInterval = Byte.valueOf(this.parameters[1]);
                            break block7;
                        }
                        if (this.parameters[1].equalsIgnoreCase("PXE")) {
                            this.bootDevice = GlobalDefine.BootDevice.PXE;
                            break block7;
                        }
                        passValidate = false;
                        break block7;
                    }
                    case 3: {
                        if (!this.parameters[1].equalsIgnoreCase("PXE")) {
                            passValidate = false;
                            break block7;
                        }
                        this.bootDevice = GlobalDefine.BootDevice.PXE;
                        if (ByteUtility.isNumeric(this.parameters[2])) {
                            this.cycleInterval = Byte.valueOf(this.parameters[2]);
                            break block7;
                        }
                        passValidate = false;
                        break block7;
                    }
                }
                passValidate = false;
                break;
            }
        }
        if (!passValidate) {
            this.printUsage();
            return false;
        }
        return true;
    }

    public void printUsage() {
        MOut.G(this).println("Available commands:");
        MOut.G(this).println("status                   power status");
        MOut.G(this).println("up                       power up system");
        MOut.G(this).println("down                     power down system");
        MOut.G(this).println("softshutdown             power softshotdown");
        MOut.G(this).println("reset [PXE]              power reset");
        MOut.G(this).println("cycle [interval]         power cycle");
        MOut.G(this).println("diag                     pulse diagnostic interrupt");
        MOut.G(this).println("");
        MOut.G(this).println("");
        MOut.G(this).println("");
        MOut.G(this).println("PXE option means that force boot device as PXE in next boot only");
        MOut.G(this).println("Ex: set power cycle interval as 10 seconds and execute power cycle");
        MOut.G(this).println("IPMI>ipmi power cycle 10");
    }

    @Override
    public void runCommand() throws Exception {
        boolean boolResult;
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        switch (this.bootDevice) {
            case PXE: {
                boolResult = ipmiChassisCommand.setBootDeviceOption(this.bootDevice);
                if (!boolResult) {
                    MOut.G(this).println("Set boot device failed");
                    this.statusCode = 149;
                    return;
                }
                boolResult = ipmiChassisCommand.keepBootFlagValidBit();
                if (boolResult) break;
                MOut.G(this).println("Can't keep boot flag valid bit");
                this.statusCode = 149;
                return;
            }
        }
        switch (this.subCommand) {
            case STATUS: {
                ACPIInfo acpi1 = ipmiGlobalCommand.getACPI();
                MOut.G(this).println("ACPI Power Status: " + acpi1.getSystemStateInfo() + " (" + acpi1.getSystemStateDescription() + ")");
                this.statusCode = 0;
                break;
            }
            case ON: {
                boolResult = ipmiChassisCommand.powerUp();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case OFF: {
                boolResult = ipmiChassisCommand.powerDown();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case GRACEFULSHUTDOWN: {
                boolResult = ipmiChassisCommand.softShutdown();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case RESET: {
                boolResult = ipmiChassisCommand.reset();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case CYCLE: {
                if (this.cycleInterval > 0 && !(boolResult = ipmiChassisCommand.setPowerCycleInterval(this.cycleInterval))) {
                    MOut.G(this).println("Set power cycle interval fail");
                    break;
                }
                boolResult = ipmiChassisCommand.powerCycle();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case DIAG: {
                boolResult = ipmiChassisCommand.injectNMI();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case NO_COMMAND: {
                ACPIInfo acpi = ipmiGlobalCommand.getACPI();
                MOut.G(this).println("ACPI Power Status: " + acpi.getSystemStateInfo() + " (" + acpi.getSystemStateDescription() + ")");
                this.printUsage();
                this.statusCode = 0;
            }
        }
    }

    static enum SubCommand {
        STATUS,
        ON,
        OFF,
        GRACEFULSHUTDOWN,
        RESET,
        CYCLE,
        NO_COMMAND,
        DIAG;

    }
}

