/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.IBFDREntity;
import com.supermicro.ipmi.blade.IBQDREntity;
import com.supermicro.ipmi.blade.InfiniBandEntity;
import com.supermicro.ipmi.blade.TenGSwitchEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class InfinibandStatusCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        byte ibIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (ibIndex < 1 || ibIndex > 2) {
            MOut.G(this).println("Infiniband Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryInfiniBandEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        InfiniBandEntity ib = bladeSystem.getInfiniBands()[index - 1];
        TenGSwitchEntity tenG = bladeSystem.getTenGSwitches()[index - 1];
        IBQDREntity ibQDR = bladeSystem.getIBQDRs()[index - 1];
        IBFDREntity ibFDR = bladeSystem.getIBFDRs()[index - 1];
        if (ib.getPresent() == 0) {
            MOut.G(this).println("InfiniBand " + index + " is not presented");
            this.statusCode = 151;
            return;
        }
        if (ib.getPresent() > 0 && ib.getReserve3() == 0 && (ib.getFlag() & 0xFE) == 0 && !tenG.is10GSwitch() && ib.getInitialized() == 1) {
            MOut.G(this).print(ib.toFormatedHeader());
            MOut.G(this).print(ib.toFormatedString());
        } else if (ibQDR.getPresent() > 0 && (ibQDR.isIBQDR() || ibQDR.isIBQDRPassThru())) {
            MOut.G(this).print(ibQDR.toFormatedHeader());
            MOut.G(this).print(ibQDR.toFormatedString());
        } else if (ibFDR.getPresent() > 0 && ibFDR.isIBFDR()) {
            MOut.G(this).print(ibFDR.toFormatedHeader());
            MOut.G(this).print(ibFDR.toFormatedString());
        }
        this.statusCode = 0;
    }
}

