/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20GetPolicyCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        if (this.parameters == null || this.parameters.length < 2) {
            MOut.G(this).println("getPolicy <domain ID> <policy ID>");
            MOut.G(this).println("Domain ID:");
            MOut.G(this).println("0 \u2013 Entire platform");
            MOut.G(this).println("1 \u2013 CPU subsystem");
            MOut.G(this).println("2 \u2013 Memory subsystem");
            return;
        }
        byte did = -1;
        try {
            did = (byte)Integer.parseInt(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            return;
        }
        byte pid = -1;
        try {
            pid = (byte)Integer.parseInt(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            return;
        }
        IPMINM20Command.NodeManagerPolicy policy = null;
        try {
            policy = this.ipmiNM20Command.getNodeManagerPolicy(did, pid);
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            return;
        }
        if (policy == null) {
            MOut.G(this).println("Call getNodeManagerPolicy failed");
        }
        NM20GetPolicyCommand.printPolicy(policy, MOut.G(this));
    }

    public static void printPolicy(IPMINM20Command.NodeManagerPolicy policy, MOut mOut) {
        mOut.println("Values: ");
        mOut.println("Power Limit                 = " + ByteUtility.twoBytesToIntLSB(policy.powerLimit) + " w");
        mOut.println("Correction Time limit       = " + ByteUtility.fourBytesToIntByLSBFirst(policy.correctionTimeLimit) + " ms");
        mOut.println("Statistics Reporting Period = " + ByteUtility.twoBytesToIntLSB(policy.statisticsReportingPeriod) + " s");
        mOut.println("Policy Trigger Limit        = " + ByteUtility.twoBytesToIntLSB(policy.policyTriggerLimit));
        mOut.println("Domain ID:");
        if ((policy.domainIDAndPolicyState & 0xF) == 0) {
            mOut.println("    Entire platform");
        } else if ((policy.domainIDAndPolicyState & 0xF) == 1) {
            mOut.println("    CPU subsystem");
        } else if ((policy.domainIDAndPolicyState & 0xF) == 2) {
            mOut.println("    Memory subsystem");
        }
        mOut.println("Policy state:");
        if ((policy.domainIDAndPolicyState & 0x10) == 16) {
            mOut.print("    Policy(Enabled)  ");
        } else {
            mOut.print("    Policy(Disabled)  ");
        }
        if ((policy.domainIDAndPolicyState & 0x20) == 32) {
            mOut.print("Domain(Enabled)  ");
        } else {
            mOut.print("Domain(Disabled)  ");
        }
        if ((policy.domainIDAndPolicyState & 0x40) == 64) {
            mOut.println("Global(Enabled)");
        } else {
            mOut.println("Global(Disabled)");
        }
        if ((policy.domainIDAndPolicyState & 0xFFFFFF80) == -128) {
            mOut.println("    Policy is created and managed by other management client");
        }
        mOut.println("Policy Trigger Type:");
        if ((policy.policyAndTriggerType & 0xF) == 0) {
            mOut.println("    No Policy Trigger");
        } else if ((policy.policyAndTriggerType & 0xF) == 1) {
            mOut.println("    Inlet Temperature Limit Policy Trigger in [Celsius]");
        } else if ((policy.policyAndTriggerType & 0xF) == 2) {
            mOut.println("    Missing Power Reading Timeout in 1/10th of second");
        } else if ((policy.policyAndTriggerType & 0xF) == 3) {
            mOut.println("    Time After Host Reset Trigger in 1/10th of second");
        }
        mOut.println("Aggressive CPU Power correction:");
        if ((policy.policyAndTriggerType & 0x60) == 0) {
            mOut.println("    Backward compatible with NMV1.5");
        } else if ((policy.policyAndTriggerType & 0x60) == 32) {
            mOut.println("    NM is not allowed to use T-states");
        } else if ((policy.policyAndTriggerType & 0x60) == 64) {
            mOut.println("    NM is allowed to use T-states");
        }
        mOut.println("Policy Exception action state:");
        if ((policy.policyException & 1) == 1) {
            mOut.println("    Send alert");
        }
        if ((policy.policyException & 2) == 2) {
            mOut.println("    Shutdown system");
        }
        mOut.println("raw = " + ByteUtility.bytesToHex(policy.raw));
    }
}

