/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMAddPolicyCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        int limit;
        byte id;
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        if (this.parameters == null || this.parameters.length < 4) {
            MOut.G(this).println("addPolicy <id> <limit> <correction time(ms)> <report period(s)>");
            return;
        }
        int correctionTime = 60000;
        int reportingPeriod = 1;
        try {
            id = Byte.parseByte(this.parameters[0]);
            limit = Integer.parseInt(this.parameters[1]);
            correctionTime = Integer.parseInt(this.parameters[2]);
            reportingPeriod = Integer.parseInt(this.parameters[3]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            return;
        }
        IPMIDCMOEMCommand.NodeManagerPolicySetting policySetting = ipmiDCMOEMCommand.createNodeManagerPolicySetting();
        policySetting.domainID = 0;
        policySetting.policyID = id;
        policySetting.policyConfig = (byte)16;
        policySetting.PolicyException = 1;
        ByteUtility.intTo2Bytes(policySetting.powerLimit, 0, limit);
        ByteUtility.intTo4Bytes(policySetting.correctionTimeLimit, 0, correctionTime);
        ByteUtility.intTo2Bytes(policySetting.policyTriggerLimit, 0, 0);
        ByteUtility.intTo2Bytes(policySetting.statisticsReportingPeriod, 0, reportingPeriod);
        try {
            ipmiDCMOEMCommand.setNodeManagerPolicy(policySetting);
            ipmiDCMOEMCommand.enableDisableNodeManagerPolicyControl((byte)5, (byte)0, id);
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            return;
        }
        MOut.G(this).println("Done");
    }
}

