/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.FRU;
import IPMIView20.FRUPanel_jUpdateFRUButton_actionAdapter;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.MyDocument;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class FRUPanel
extends JPanel {
    FRU fru = new FRU();
    UDPSocket udpSocket;
    CSession Session;
    JLabel Message;
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    Font borderFont = new Font("default", 0, 11);
    TitledBorder titledBorder1;
    JPanel jBoardPanel = new JPanel();
    JPanel jProductPanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jBoardManufacturerLabel = new JLabel();
    JLabel jBoardProductNameLabel = new JLabel();
    JLabel jBoardSerialNumberLabel = new JLabel();
    JLabel jPartNumberLabel = new JLabel();
    JTextField jLanguageCodeTextField = new JTextField();
    JTextField jMfgDateTimeTextField = new JTextField();
    JTextField jBoardManufacturerTextField = new JTextField();
    JTextField jBoardProductNameTextField = new JTextField();
    JTextField jBoardSerialNumberTextField = new JTextField();
    JTextField jBoardPartNumberTextField = new JTextField();
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel jProductNameLabel = new JLabel();
    JTextField jProductVersionTextField = new JTextField();
    JLabel jProductVersionLabel = new JLabel();
    JLabel jLabel10 = new JLabel();
    JLabel jManufacturerLabel = new JLabel();
    JTextField jProductLanguageCodeTextField = new JTextField();
    JTextField jProductManufacturerTextField = new JTextField();
    JTextField jProductPartModelNumberTextField = new JTextField();
    JTextField jProductNameTextField = new JTextField();
    JLabel jProductPartModelNumberLabel = new JLabel();
    JTextField jProductSerialNumberTextField = new JTextField();
    JLabel jProductSerialNumberLabel = new JLabel();
    JPanel jToolBarPanel = new JPanel();
    JButton jUpdateFRUButton = new JButton();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    Border border1 = BorderFactory.createEtchedBorder();
    Border border2 = new TitledBorder(this.border1, L.t("fru.FRU_Information"), 0, 2, this.borderFont, Color.BLUE);
    Border border3 = BorderFactory.createEtchedBorder();
    Border border4 = new TitledBorder(this.border3, L.t("fru.Board_Info"), 0, 2, this.borderFont, Color.BLUE);
    Border border5 = BorderFactory.createEtchedBorder();
    Border border6 = new TitledBorder(this.border5, L.t("fru.Product_Info"), 0, 2, this.borderFont, Color.BLUE);
    JPanel jPanel2 = new JPanel();
    TitledBorder titledBorder2 = new TitledBorder("");
    TitledBorder titledBorder3 = new TitledBorder("");
    TitledBorder titledBorder4 = new TitledBorder("");
    FRUInfo fruInfo = null;

    public FRUPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void preset(UDPSocket xSocket, CSession iSession, JLabel xMessage) {
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
        if (this.Session.MaxLevel[0] == 4) {
            this.jUpdateFRUButton.setVisible(true);
        } else {
            this.jUpdateFRUButton.setVisible(false);
        }
    }

    void myInit() {
        this.jLanguageCodeTextField.setDocument(new MyDocument(this.jLanguageCodeTextField));
        this.jMfgDateTimeTextField.setDocument(new MyDocument(this.jMfgDateTimeTextField));
        this.jBoardManufacturerTextField.setDocument(new MyDocument(this.jBoardManufacturerTextField));
        this.jBoardProductNameTextField.setDocument(new MyDocument(this.jBoardProductNameTextField));
        this.jBoardSerialNumberTextField.setDocument(new MyDocument(this.jBoardSerialNumberTextField));
        this.jBoardPartNumberTextField.setDocument(new MyDocument(this.jBoardPartNumberTextField));
        this.jProductVersionTextField.setDocument(new MyDocument(this.jProductVersionTextField));
        this.jProductLanguageCodeTextField.setDocument(new MyDocument(this.jProductLanguageCodeTextField));
        this.jProductManufacturerTextField.setDocument(new MyDocument(this.jProductManufacturerTextField));
        this.jProductPartModelNumberTextField.setDocument(new MyDocument(this.jProductPartModelNumberTextField));
        this.jProductNameTextField.setDocument(new MyDocument(this.jProductNameTextField));
        this.jProductSerialNumberTextField.setDocument(new MyDocument(this.jProductSerialNumberTextField));
        this.jLabel1.setVisible(false);
        this.jLabel2.setVisible(false);
        this.jLabel10.setVisible(false);
        this.jLanguageCodeTextField.setVisible(false);
        this.jMfgDateTimeTextField.setVisible(false);
        this.jProductLanguageCodeTextField.setVisible(false);
    }

    void jbInit() throws Exception {
        this.titledBorder4 = new TitledBorder(L.t("fru.Product_Info"));
        this.titledBorder3 = new TitledBorder(L.t("fru.Board_Info"));
        this.titledBorder2 = new TitledBorder(L.t("fru.FRU_Information"));
        Font borderFont = new Font("default", 0, 11);
        this.setBorder(this.titledBorder2);
        this.setDebugGraphicsOptions(0);
        this.setMinimumSize(new Dimension(105, 245));
        this.setPreferredSize(new Dimension(464, 245));
        this.setLayout(this.borderLayout1);
        this.jBoardPanel.setLayout(null);
        this.jLabel1.setToolTipText("");
        this.jLabel1.setText("Language Code");
        this.jLabel1.setBounds(new Rectangle(25, 26, 119, 17));
        this.jLabel2.setHorizontalTextPosition(11);
        this.jLabel2.setText("Mfg. Date/Time");
        this.jLabel2.setBounds(new Rectangle(297, 28, 123, 17));
        this.jBoardManufacturerLabel.setToolTipText("");
        this.jBoardManufacturerLabel.setText(L.t("fru.Manufacturer"));
        this.jBoardManufacturerLabel.setBounds(new Rectangle(17, 30, 125, 17));
        this.jBoardProductNameLabel.setText(L.t("fru.Name"));
        this.jBoardProductNameLabel.setBounds(new Rectangle(18, 63, 124, 17));
        this.jBoardSerialNumberLabel.setToolTipText("");
        this.jBoardSerialNumberLabel.setText(L.t("fru.Serial_Number"));
        this.jBoardSerialNumberLabel.setBounds(new Rectangle(18, 94, 123, 17));
        this.jPartNumberLabel.setToolTipText("");
        this.jPartNumberLabel.setText(L.t("fru.Part_Number"));
        this.jPartNumberLabel.setBounds(new Rectangle(17, 126, 123, 17));
        this.jLanguageCodeTextField.setEditable(false);
        this.jLanguageCodeTextField.setText("");
        this.jLanguageCodeTextField.setBounds(new Rectangle(146, 23, 94, 22));
        this.jMfgDateTimeTextField.setEditable(false);
        this.jMfgDateTimeTextField.setText("");
        this.jMfgDateTimeTextField.setBounds(new Rectangle(421, 23, 95, 22));
        this.jBoardManufacturerTextField.setText("");
        this.jBoardManufacturerTextField.setBounds(new Rectangle(124, 26, 135, 22));
        this.jBoardProductNameTextField.setText("");
        this.jBoardProductNameTextField.setBounds(new Rectangle(124, 61, 135, 22));
        this.jBoardSerialNumberTextField.setText("");
        this.jBoardSerialNumberTextField.setBounds(new Rectangle(124, 92, 135, 22));
        this.jBoardPartNumberTextField.setSelectionStart(0);
        this.jBoardPartNumberTextField.setText("");
        this.jBoardPartNumberTextField.setBounds(new Rectangle(124, 124, 135, 22));
        this.jProductPanel.setLayout(null);
        this.jProductNameLabel.setBounds(new Rectangle(16, 61, 117, 17));
        this.jProductNameLabel.setText(L.t("fru.Name"));
        this.jProductVersionTextField.setText("");
        this.jProductVersionTextField.setBounds(new Rectangle(129, 126, 135, 22));
        this.jProductVersionLabel.setBounds(new Rectangle(14, 126, 126, 17));
        this.jProductVersionLabel.setText(L.t("fru.Version"));
        this.jProductVersionLabel.setToolTipText("");
        this.jLabel10.setBounds(new Rectangle(15, 26, 120, 17));
        this.jLabel10.setText(L.t("fru.Language_Code"));
        this.jLabel10.setToolTipText("");
        this.jManufacturerLabel.setBounds(new Rectangle(16, 29, 146, 17));
        this.jManufacturerLabel.setText(L.t("fru.Manufacturer"));
        this.jProductLanguageCodeTextField.setEditable(false);
        this.jProductLanguageCodeTextField.setText("");
        this.jProductLanguageCodeTextField.setBounds(new Rectangle(136, 23, 94, 22));
        this.jProductManufacturerTextField.setText("");
        this.jProductManufacturerTextField.setBounds(new Rectangle(129, 26, 135, 22));
        this.jProductPartModelNumberTextField.setText("");
        this.jProductPartModelNumberTextField.setBounds(new Rectangle(129, 94, 135, 22));
        this.jProductNameTextField.setText("");
        this.jProductNameTextField.setBounds(new Rectangle(129, 60, 135, 22));
        this.jProductPartModelNumberLabel.setBounds(new Rectangle(16, 94, 128, 17));
        this.jProductPartModelNumberLabel.setPreferredSize(new Dimension(130, 17));
        this.jProductPartModelNumberLabel.setText(L.t("fru.Part_Model_Number"));
        this.jProductSerialNumberTextField.setBounds(new Rectangle(129, 159, 135, 22));
        this.jProductSerialNumberLabel.setToolTipText("");
        this.jProductSerialNumberLabel.setText(L.t("fru.Serial_Number"));
        this.jProductSerialNumberLabel.setBounds(new Rectangle(16, 158, 122, 17));
        this.jUpdateFRUButton.setText(L.t("fru.Update_FRU"));
        this.jUpdateFRUButton.addActionListener(new FRUPanel_jUpdateFRUButton_actionAdapter(this));
        this.jToolBarPanel.setLayout(this.borderLayout2);
        this.jPanel1.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.jBoardPanel.setBorder(this.titledBorder3);
        this.jProductPanel.setBorder(this.titledBorder4);
        this.jPanel2.setBounds(new Rectangle(30, 48, 10, 10));
        this.jProductPanel.add((Component)this.jLabel10, null);
        this.jProductPanel.add((Component)this.jProductLanguageCodeTextField, null);
        this.jProductPanel.add((Component)this.jManufacturerLabel, null);
        this.jProductPanel.add((Component)this.jProductNameLabel, null);
        this.jProductPanel.add((Component)this.jProductManufacturerTextField, null);
        this.jProductPanel.add((Component)this.jProductNameTextField, null);
        this.jProductPanel.add((Component)this.jProductPartModelNumberTextField, null);
        this.jProductPanel.add((Component)this.jProductPartModelNumberLabel, null);
        this.jProductPanel.add((Component)this.jProductVersionTextField, null);
        this.jProductPanel.add((Component)this.jProductVersionLabel, null);
        this.jProductPanel.add((Component)this.jProductSerialNumberTextField, null);
        this.jProductPanel.add((Component)this.jProductSerialNumberLabel, null);
        this.jPanel1.add(this.jBoardPanel);
        this.jBoardPanel.add((Component)this.jLabel1, null);
        this.jBoardPanel.add((Component)this.jMfgDateTimeTextField, null);
        this.jBoardPanel.add((Component)this.jLabel2, null);
        this.jBoardPanel.add((Component)this.jLanguageCodeTextField, null);
        this.jBoardPanel.add(this.jPanel2);
        this.jBoardPanel.add((Component)this.jBoardManufacturerLabel, null);
        this.jBoardPanel.add((Component)this.jBoardProductNameLabel, null);
        this.jBoardPanel.add((Component)this.jBoardSerialNumberLabel, null);
        this.jBoardPanel.add((Component)this.jPartNumberLabel, null);
        this.jBoardPanel.add((Component)this.jBoardManufacturerTextField, null);
        this.jBoardPanel.add((Component)this.jBoardSerialNumberTextField, null);
        this.jBoardPanel.add((Component)this.jBoardPartNumberTextField, null);
        this.jBoardPanel.add((Component)this.jBoardProductNameTextField, null);
        this.jPanel1.add(this.jProductPanel);
        this.add((Component)this.jToolBarPanel, "North");
        this.add((Component)this.jPanel1, "Center");
        this.jToolBarPanel.add((Component)this.jUpdateFRUButton, "West");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFRUInventoryAreaInfo() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{0};
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        int size = -1;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(reqdata);
            String SIP = this.Session.SIP;
            this.Message.setText(L.t("fru.Getting_FRU_Inventory_Device"));
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)16, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] byte1 = (byte[])this.rmcpPacket.retValue.get(0);
                    byte[] byte2 = (byte[])this.rmcpPacket.retValue.get(1);
                    byte[] byte3 = (byte[])this.rmcpPacket.retValue.get(2);
                    size = byte2[0];
                    size <<= 8;
                    size += byte1[0];
                    if (byte3[0] == 1) {
                        size *= 2;
                    }
                } else {
                    this.Message.setText(L.t("fru.Getting_FRU_Inventory_Device_failed"));
                }
            } else {
                this.Message.setText(L.t("fru.Getting_FRU_Inventory_Device_failed"));
            }
            this.Session.releaselock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFRUData(byte ls, byte ms) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{0, 0, 0, 22};
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        byte[] result = null;
        reqdata[1] = ls;
        reqdata[2] = ms;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(reqdata);
            String SIP = this.Session.SIP;
            int offset = ms;
            int offset_ls = ls & 0xFF;
            offset <<= 8;
            offset &= 0xFF00;
            this.Message.setText(L.t("fru.Reading_FRU_data_Offset") + (offset += offset_ls));
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)17, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] data;
                    byte[] count = (byte[])this.rmcpPacket.retValue.get(0);
                    result = data = (byte[])this.rmcpPacket.retValue.get(1);
                } else {
                    Logger.writeLog("Reading FRU data failed , complete code =" + this.rmcpPacket.compeletecode);
                    this.Message.setText(L.t("fru.Reading_FRU_data_failed"));
                }
            } else {
                this.Message.setText(L.t("fru.Reading_FRU_data_failed"));
            }
            this.Session.releaselock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeFRUData(byte ls, byte ms, byte[] data) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[3 + data.length];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object result = null;
        reqdata[0] = 0;
        reqdata[1] = ls;
        reqdata[2] = ms;
        System.arraycopy(data, 0, reqdata, 3, data.length);
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(reqdata);
            String SIP = this.Session.SIP;
            int offset = ms;
            int offset_ls = ls & 0xFF;
            offset <<= 8;
            offset &= 0xFF00;
            this.Message.setText(L.t("fru.Writing_FRU_data_Offset") + (offset += offset_ls));
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)18, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode != 0) {
                    Logger.writeLog("Writing FRU data failed , complete code =" + this.rmcpPacket.compeletecode);
                    this.Message.setText(L.t("fru.Writing_FRU_data_failed"));
                }
            } else {
                this.Message.setText(L.t("fru.Writing_FRU_data_failed"));
            }
            this.Session.releaselock();
        }
        return this.rmcpPacket.compeletecode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enableLockFRU(boolean isLock) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[1];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object result = null;
        reqdata[0] = isLock ? (byte)1 : 0;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(reqdata);
            String SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)-64, (byte)6, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode != 0) {
                    Logger.writeLog((isLock ? "Lock" : "UnLock") + " FRU failed , complete code =" + this.rmcpPacket.compeletecode);
                    this.Message.setText((isLock ? "Lock" : "UnLock") + " FRU failed , complete code =" + this.rmcpPacket.compeletecode);
                }
            } else {
                this.Message.setText((isLock ? L.t("fru.Lock") : L.t("fru.UnLock")) + " " + L.t("fru.FRU_failed"));
            }
            this.Session.releaselock();
        }
        return this.rmcpPacket.compeletecode;
    }

    public void writeBinaryFile(String filename, byte[] raw) {
        try {
            File file = new File(filename);
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));
            dos.write(raw);
            dos.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseFRUData(byte[] data) {
        if (IPMIView20.getInstance().DEBUG) {
            this.writeBinaryFile("fru_original.bin", data);
        }
        this.setFRUnknow();
        if (data[0] != 1) {
            return;
        }
        byte commonHeaderVersion = data[0];
        byte internalUseAreaStringOffset = data[1];
        byte chassisInfoAreaStringOffset = data[2];
        byte boardInfoAreaStringOffset = data[3];
        byte productInfoAreaStringOffset = data[4];
        byte multiRecordAreaStringOffset = data[5];
        this.fru.common.formatVersion = data[0];
        this.fru.common.internalUserArea = data[1];
        this.fru.common.chassisInfoArea = data[2];
        this.fru.common.boardInfoArea = data[3];
        this.fru.common.productInfoArea = data[4];
        this.fru.common.multiRecordArea = data[5];
        if (internalUseAreaStringOffset != 0) {
            // empty if block
        }
        if (chassisInfoAreaStringOffset != 0) {
            // empty if block
        }
        if (boardInfoAreaStringOffset != 0) {
            this.parseFRUBoardInfo(boardInfoAreaStringOffset, data);
        }
        if (productInfoAreaStringOffset != 0) {
            this.parseFRUProductInfo(productInfoAreaStringOffset, data);
        }
        if (multiRecordAreaStringOffset != 0) {
            // empty if block
        }
    }

    private void parseFRUBoardInfo(int offset, byte[] data) {
        int index = offset * 8;
        byte languageCode = data[index + 2];
        String mfgDataTime = "" + data[index + 3] + "" + data[index + 4] + "" + data[index + 5];
        this.fru.board.formatVesion = data[index];
        this.fru.board.length = data[index + 1];
        this.fru.board.languageCode = data[index + 2];
        this.fru.board.mfgDateTime[0] = data[index + 3];
        this.fru.board.mfgDateTime[1] = data[index + 4];
        this.fru.board.mfgDateTime[2] = data[index + 5];
        byte[] tempBytes = new byte[data[index + 6] & 0x3F];
        System.arraycopy(data, index + 7, tempBytes, 0, tempBytes.length);
        String manufacturerName = new String(tempBytes);
        this.fru.board.boardManufacturer = tempBytes;
        int accIndex = index + 6 + tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productName = new String(tempBytes);
        this.fru.board.boardProductName = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String boardSerialNumber = new String(tempBytes);
        this.fru.board.boardSerialNumber = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String boardPartNumber = new String(tempBytes);
        this.fru.board.boardPartNumber = tempBytes;
        Logger.writeLog("languageCode = " + languageCode);
        Logger.writeLog("mfgDataTime = " + mfgDataTime);
        Logger.writeLog("manufacturerName = " + manufacturerName);
        Logger.writeLog("productName = " + productName);
        Logger.writeLog("boardSerialNumber = " + boardSerialNumber);
        Logger.writeLog("boardPartNumber = " + boardPartNumber);
        this.jLanguageCodeTextField.setText("" + languageCode);
        this.jMfgDateTimeTextField.setText(mfgDataTime);
        this.jBoardManufacturerTextField.setText(manufacturerName);
        this.jBoardProductNameTextField.setText(productName);
        this.jBoardSerialNumberTextField.setText(boardSerialNumber);
        this.jBoardPartNumberTextField.setText(boardPartNumber);
    }

    private void parseFRUProductInfo(int offset, byte[] data) {
        int index = offset * 8;
        byte languageCode = data[index + 2];
        this.fru.product.formatVesion = data[index];
        this.fru.product.length = data[index + 1];
        this.fru.product.languageCode = data[index + 2];
        byte[] tempBytes = new byte[data[index + 3] & 0x3F];
        System.arraycopy(data, index + 4, tempBytes, 0, tempBytes.length);
        String productManufacturerName = new String(tempBytes);
        this.fru.product.productManufacturerName = tempBytes;
        int accIndex = index + 3 + tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productName = new String(tempBytes);
        this.fru.product.productName = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productPartModelNumber = new String(tempBytes);
        this.fru.product.productPartModelNumber = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productVersion = new String(tempBytes);
        this.fru.product.productVersion = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productSerialNumber = new String(tempBytes);
        this.fru.product.productSerialNumber = tempBytes;
        Logger.writeLog("languageCode = " + languageCode);
        Logger.writeLog("productManufacturerName = " + productManufacturerName);
        Logger.writeLog("productName = " + productName);
        Logger.writeLog("productPartModelNumber = " + productPartModelNumber);
        Logger.writeLog("productVersion = " + productVersion);
        Logger.writeLog("productSerialNumber = " + productSerialNumber);
        this.jProductLanguageCodeTextField.setText("" + languageCode);
        this.jProductManufacturerTextField.setText(productManufacturerName);
        this.jProductNameTextField.setText(productName);
        this.jProductPartModelNumberTextField.setText(productPartModelNumber);
        this.jProductVersionTextField.setText(productVersion);
        this.jProductSerialNumberTextField.setText(productSerialNumber);
    }

    private void setFRUnknow() {
        this.jLanguageCodeTextField.setText("");
        this.jMfgDateTimeTextField.setText("");
        this.jBoardManufacturerTextField.setText("");
        this.jBoardProductNameTextField.setText("");
        this.jBoardSerialNumberTextField.setText("");
        this.jBoardPartNumberTextField.setText("");
        this.jProductLanguageCodeTextField.setText("");
        this.jProductManufacturerTextField.setText("");
        this.jProductNameTextField.setText("");
        this.jProductPartModelNumberTextField.setText("");
        this.jProductVersionTextField.setText("");
        this.jProductSerialNumberTextField.setText("");
    }

    void jRefreshButton_actionPerformed(ActionEvent e2) {
        this.refreshFRU();
    }

    public void refreshFRUWithThread() {
        Thread th = new Thread(){

            @Override
            public void run() {
                FRUPanel.this.refreshFRU();
            }
        };
        th.start();
    }

    public void refreshFRU() {
        if (this.Session.isOSA) {
            this.refreshFRU_OSA();
        } else {
            this.refreshFRUByIPMILib();
        }
    }

    public void refreshFRU_OSA() {
        this.jUpdateFRUButton.setEnabled(false);
        byte[] data = null;
        int size = this.getFRUInventoryAreaInfo();
        if (size <= 0) {
            return;
        }
        data = new byte[size];
        boolean count = false;
        for (int i2 = 0; i2 < size - 22; i2 += 22) {
            byte ls = (byte)(i2 & 0xFF);
            byte ms = (byte)((i2 & 0xFF00) >> 8);
            byte[] dataSegment = this.readFRUData(ls, ms);
            System.arraycopy(dataSegment, 0, data, i2, dataSegment.length);
        }
        this.Message.setText(L.t("fru.Read_FRU_Data_succeeded"));
        this.parseFRUData(data);
        this.jUpdateFRUButton.setEnabled(true);
    }

    public void jUpdateFRUButton_actionPerformed(ActionEvent e2) {
        int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("fru.Are_you_sure_to_update_FRU_data"), L.t("fru.Request_Confirmation"), 0);
        if (ret != 0) {
            return;
        }
        Thread th = new Thread(){

            @Override
            public void run() {
                FRUPanel.this.jUpdateFRUButton.setEnabled(false);
                if (FRUPanel.this.Session.isOSA) {
                    FRUPanel.this.updateFRU();
                } else {
                    FRUPanel.this.updateFRUByIPMILib();
                }
                FRUPanel.this.jUpdateFRUButton.setEnabled(true);
            }
        };
        th.start();
    }

    public void updateFRU() {
        this.fru.board.boardManufacturer = this.jBoardManufacturerTextField.getText().getBytes();
        this.fru.board.boardProductName = this.jBoardProductNameTextField.getText().getBytes();
        this.fru.board.boardSerialNumber = this.jBoardSerialNumberTextField.getText().getBytes();
        this.fru.board.boardPartNumber = this.jBoardPartNumberTextField.getText().getBytes();
        this.fru.product.productManufacturerName = this.jProductManufacturerTextField.getText().getBytes();
        this.fru.product.productName = this.jProductNameTextField.getText().getBytes();
        this.fru.product.productPartModelNumber = this.jProductPartModelNumberTextField.getText().getBytes();
        this.fru.product.productVersion = this.jProductVersionTextField.getText().getBytes();
        this.fru.product.productSerialNumber = this.jProductSerialNumberTextField.getText().getBytes();
        byte[] fruRaw = this.fru.toRaw();
        if (IPMIView20.getInstance().DEBUG) {
            this.writeBinaryFile("fru_updated.bin", fruRaw);
        }
        this.writeFRU(fruRaw);
        this.refreshFRU();
    }

    public void writeFRU(byte[] data) {
        int result = this.enableLockFRU(false);
        if (result != 0) {
            this.Message.setText(L.t("fru.Could_not_unlock_FRU_data"));
            return;
        }
        byte[] buffer = new byte[8];
        for (int i2 = 0; i2 < data.length; i2 += 8) {
            byte ls = (byte)(i2 & 0xFF);
            byte ms = (byte)((i2 & 0xFF00) >> 8);
            System.arraycopy(data, i2, buffer, 0, 8);
            int completeCode = this.writeFRUData(ls, ms, buffer);
            if (completeCode == 0) continue;
            this.Message.setText(L.t("fru.Failed_to_Write_FRU_data"));
            return;
        }
        result = this.enableLockFRU(true);
        if (result != 0) {
            this.Message.setText(L.t("fru.Could_not_lock_FRU_data"));
            return;
        }
    }

    public void setEnableUpdate(boolean isEnable) {
        this.jUpdateFRUButton.setEnabled(isEnable);
    }

    public void refreshFRUByIPMILib() {
        IPMIInterfaceConfig config = this.getIPMIConfig();
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(null);
        if (sessionController == null) {
            return;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            return;
        }
        ipmiFRUCommand.setIPMIInterface(rmcp);
        this.fruInfo = ipmiFRUCommand.getFRUData();
        if (this.fruInfo == null) {
            return;
        }
        this.jBoardManufacturerTextField.setText(new String(this.fruInfo.fru.board.boardManufacturer));
        this.jBoardProductNameTextField.setText(new String(this.fruInfo.fru.board.boardProductName));
        this.jBoardSerialNumberTextField.setText(new String(this.fruInfo.fru.board.boardSerialNumber));
        this.jBoardPartNumberTextField.setText(new String(this.fruInfo.fru.board.boardPartNumber));
        this.jProductManufacturerTextField.setText(new String(this.fruInfo.fru.product.productManufacturerName));
        this.jProductNameTextField.setText(new String(this.fruInfo.fru.product.productName));
        this.jProductPartModelNumberTextField.setText(new String(this.fruInfo.fru.product.productPartModelNumber));
        this.jProductVersionTextField.setText(new String(this.fruInfo.fru.product.productVersion));
        this.jProductSerialNumberTextField.setText(new String(this.fruInfo.fru.product.productSerialNumber));
        this.jUpdateFRUButton.setEnabled(true);
        sessionController.closeSession();
    }

    public void updateFRUByIPMILib() {
        IPMIInterfaceConfig config = this.getIPMIConfig();
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(null);
        if (sessionController == null) {
            return;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            return;
        }
        ipmiFRUCommand.setIPMIInterface(rmcp);
        this.fruInfo.fru.board.boardManufacturer = this.jBoardManufacturerTextField.getText().getBytes();
        this.fruInfo.fru.board.boardProductName = this.jBoardProductNameTextField.getText().getBytes();
        this.fruInfo.fru.board.boardSerialNumber = this.jBoardSerialNumberTextField.getText().getBytes();
        this.fruInfo.fru.board.boardPartNumber = this.jBoardPartNumberTextField.getText().getBytes();
        this.fruInfo.fru.product.productManufacturerName = this.jProductManufacturerTextField.getText().getBytes();
        this.fruInfo.fru.product.productName = this.jProductNameTextField.getText().getBytes();
        this.fruInfo.fru.product.productPartModelNumber = this.jProductPartModelNumberTextField.getText().getBytes();
        this.fruInfo.fru.product.productVersion = this.jProductVersionTextField.getText().getBytes();
        this.fruInfo.fru.product.productSerialNumber = this.jProductSerialNumberTextField.getText().getBytes();
        ipmiFRUCommand.unlockFRU();
        boolean result = ipmiFRUCommand.writeFRU(this.fruInfo.fru);
        ipmiFRUCommand.lockFRU();
        sessionController.closeSession();
    }

    private IPMIInterfaceConfig getIPMIConfig() {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.Session.SIP);
        config.setUserName(this.Session.userID);
        config.setPassword(new String(this.Session.UserPassword));
        config.setPrivilege(this.Session.MaxLevel[0]);
        return config;
    }
}

