/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.HistoryMonitor;
import IPMIView20.Readable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class JFanPanel
extends JPanel
implements Readable {
    JFanMeter fanMeter = new JFanMeter();
    HistoryMonitor hm = null;
    JLabel NameLabel = new JLabel();
    JLabel ValueLabel = new JLabel();
    JLabel MaxLabel = new JLabel();
    JLabel MinLabel = new JLabel();
    int SensorNumber;
    int M;
    int B;
    int RExp;
    int BExp;
    int Linearization;
    CSession session;

    public JFanPanel(int sensorNumber, int m, int b2, int rexp, int bexp, int linear, CSession session) {
        this.initComponents();
        this.SensorNumber = sensorNumber;
        this.Linearization = linear;
        this.M = m;
        this.B = b2;
        this.RExp = rexp;
        this.BExp = bexp;
        this.session = session;
        if (session == null) {
            this.session = new CSession();
            this.session.IPMIVersion = 1;
        }
    }

    public void updateValue(byte value, String valueString) {
        if (this.session.IPMIVersion == 0) {
            this.fanMeter.m_FanReading = value;
        } else if (this.session.IPMIVersion == 1 || this.session.IPMIVersion == 2) {
            this.fanMeter.m_FanReading = 255 - (0xFF & value);
        }
        this.fanMeter.m_ShowString = valueString;
        if (this.fanMeter.m_ShowString.equals("N/A")) {
            this.fanMeter.m_FanReading = 255;
        }
        this.fanMeter.paintBufferImage();
        this.fanMeter.repaint();
        this.hm.updateHistory();
    }

    public void animation() {
    }

    public void init(String labelName, byte value, byte low, String valueString, String lowString) {
        this.fanMeter.setValue(value, low);
        this.fanMeter.setString(valueString, lowString);
        this.fanMeter.setBorder(new EtchedBorder());
        this.NameLabel.setText(labelName);
        this.NameLabel.setBorder(new EtchedBorder());
        this.NameLabel.setForeground(Color.blue);
        this.NameLabel.setHorizontalAlignment(0);
        this.add((Component)this.NameLabel, "South");
        this.hm = new HistoryMonitor(this);
        this.hm.surf.setPreferredSize(new Dimension(90, 90));
        this.add((Component)this.hm, "Center");
        this.add((Component)this.fanMeter, "Center");
    }

    public void showFan() {
        this.add((Component)this.fanMeter, "Center");
    }

    public void showHisotry() {
        this.add((Component)this.hm, "Center");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i2 = offset + length - 1; i2 >= offset; --i2) {
            intdes = (intdes << 8) + (bytesrc[i2] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    @Override
    public float getValue() {
        int value = 0;
        try {
            value = Integer.parseInt(this.fanMeter.m_ShowString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    @Override
    public float maxValue() {
        return 15000.0f;
    }

    @Override
    public float getOffset() {
        return 0.0f;
    }

    @Override
    public String getTitle() {
        return this.NameLabel.getText();
    }

    @Override
    public float highLimit() {
        return -1.0f;
    }

    @Override
    public float lowLimit() {
        int value = 0;
        try {
            value = Integer.parseInt(this.fanMeter.m_HighString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public void showHistory() {
        this.remove(this.fanMeter);
        this.remove(this.hm);
        this.add((Component)this.hm, "Center");
    }

    public void showMeter() {
        this.remove(this.fanMeter);
        this.remove(this.hm);
        this.add((Component)this.fanMeter, "Center");
    }

    public class JFanMeter
    extends JPanel {
        int value;
        Color colorvalue;
        int m_HighLimit = -128;
        int m_FanReading = -48;
        String m_ShowString = "4800";
        String m_HighString = "1777";
        private BufferedImage bimg;

        public JFanMeter() {
            super.setPreferredSize(new Dimension(90, 90));
        }

        public void animation() {
            Thread t = new Thread(){

                @Override
                public void run() {
                    int value1 = 255 - JFanMeter.this.m_FanReading;
                    for (int i2 = 0; i2 < value1; ++i2) {
                        JFanPanel.this.updateValue((byte)i2, JFanMeter.this.m_ShowString);
                        try {
                            Thread.sleep(50L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            t.start();
        }

        public void setValue(byte value, byte high) {
            if (JFanPanel.this.session.IPMIVersion == 0) {
                this.m_FanReading = value;
                this.m_HighLimit = high;
            } else if (JFanPanel.this.session.IPMIVersion == 1 || JFanPanel.this.session.IPMIVersion == 2) {
                this.m_FanReading = 255 - (0xFF & value);
                this.m_HighLimit = 255 - (0xFF & high);
            }
        }

        public void setString(String valueString, String HighString) {
            this.m_ShowString = valueString;
            this.m_HighString = HighString;
        }

        @Override
        public void paintComponent(Graphics g1) {
            if (this.bimg != null) {
                g1.drawImage(this.bimg, 0, 0, this);
            }
        }

        public void paintBufferImage() {
            int iy2;
            int ix2;
            int angle;
            Graphics2D g1;
            Dimension d2 = this.getPreferredSize();
            if (this.bimg == null) {
                this.bimg = (BufferedImage)this.createImage(d2.width, d2.height);
            }
            Graphics2D g2 = g1 = this.bimg.createGraphics();
            RenderingHints hints = new RenderingHints(null);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.addRenderingHints(hints);
            int[] cPointx = new int[180];
            int[] cPointy = new int[180];
            Dimension rcBounds = this.getPreferredSize();
            int m_Radius = (rcBounds.height > rcBounds.width ? rcBounds.width : rcBounds.height) / 2;
            int centerx = (int)((double)rcBounds.width / 2.0);
            int centery = (int)((double)rcBounds.height / 2.0);
            g2.setColor(Color.lightGray);
            int xleft = 0;
            int xtop = 0;
            int xright = rcBounds.width - 1;
            int xbottom = rcBounds.height - 2;
            GradientPaint comet = new GradientPaint(xleft, xtop, Color.gray, 0.0f, xbottom, Color.gray);
            g2.setPaint(comet);
            g2.fillRect(0, 0, xright, xbottom);
            g2.setColor(Color.white);
            g2.drawLine(xright, xtop, xright, xbottom);
            g2.drawLine(xright, xbottom, xleft, xbottom);
            g2.setColor(Color.red);
            cPointx[0] = centerx;
            cPointy[0] = centery;
            int i2 = 1;
            for (angle = 225; angle >= -45 + (int)((double)(this.m_HighLimit & 0xFF) * 270.0 / 256.0); angle -= 10) {
                cPointx[i2] = centerx + (int)((double)m_Radius * 0.8 * Math.cos((double)angle / 180.0 * 3.141596));
                cPointy[i2] = centery - (int)((double)m_Radius * 0.8 * Math.sin((double)angle / 180.0 * 3.141596));
                ++i2;
            }
            cPointx[i2] = centerx + (int)((double)m_Radius * 0.8 * Math.cos((-45.0 + (double)(this.m_HighLimit & 0xFF) * 270.0 / 256.0) / 180.0 * 3.141596));
            cPointy[i2] = centery - (int)((double)m_Radius * 0.8 * Math.sin((-45.0 + (double)(this.m_HighLimit & 0xFF) * 270.0 / 256.0) / 180.0 * 3.141596));
            cPointx[++i2] = centerx;
            cPointy[i2] = centery;
            g2.fillPolygon(cPointx, cPointy, i2);
            g2.setColor(Color.black);
            angle = -45;
            int ix1 = centerx + (int)((double)m_Radius * 0.8 * Math.cos((double)angle / 180.0 * 3.141596));
            int iy1 = centery - (int)((double)m_Radius * 0.8 * Math.sin((double)angle / 180.0 * 3.141596));
            for (angle = -35; angle < 226; angle += 10) {
                ix2 = centerx + (int)((double)m_Radius * 0.8 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.8 * Math.sin((double)angle / 180.0 * 3.141596));
                g2.drawLine(ix1, iy1, ix2, iy2);
                ix1 = ix2;
                iy1 = iy2;
            }
            for (angle = -45; angle < 226; angle += 10) {
                ix1 = centerx + (int)((double)m_Radius * 0.7 * Math.cos((double)angle / 180.0 * 3.141596));
                iy1 = centery - (int)((double)m_Radius * 0.7 * Math.sin((double)angle / 180.0 * 3.141596));
                ix2 = centerx + (int)((double)m_Radius * 0.8 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.8 * Math.sin((double)angle / 180.0 * 3.141596));
                g2.drawLine(ix1, iy1, ix2, iy2);
            }
            g2.setColor(Color.white);
            angle = -45;
            ix1 = centerx + (int)((double)m_Radius * 0.8 * Math.cos((double)angle / 180.0 * 3.141596));
            iy1 = centery - (int)((double)m_Radius * 0.8 * Math.sin((double)angle / 180.0 * 3.141596));
            for (angle = -35; angle < 226; angle += 10) {
                ix2 = centerx + (int)((double)m_Radius * 0.8 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.8 * Math.sin((double)angle / 180.0 * 3.141596));
                g2.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
                ix1 = ix2;
                iy1 = iy2;
            }
            for (angle = -45; angle < 226; angle += 10) {
                ix1 = centerx + (int)((double)m_Radius * 0.7 * Math.cos((double)angle / 180.0 * 3.141596));
                iy1 = centery - (int)((double)m_Radius * 0.7 * Math.sin((double)angle / 180.0 * 3.141596));
                ix2 = centerx + (int)((double)m_Radius * 0.8 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.8 * Math.sin((double)angle / 180.0 * 3.141596));
                g2.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
            }
            g2.setColor(Color.black);
            angle = (int)(225.0 - (double)(255 - (this.m_FanReading & 0xFF)) / 256.0 * 270.0);
            cPointx[0] = centerx + (int)((double)m_Radius * 0.85 * Math.cos((double)angle / 180.0 * 3.141596));
            cPointy[0] = centery - (int)((double)m_Radius * 0.85 * Math.sin((double)angle / 180.0 * 3.141596));
            cPointx[1] = centerx + (int)((double)m_Radius * 0.1 * Math.cos((double)(90 + angle) / 180.0 * 3.141596));
            cPointy[1] = centery - (int)((double)m_Radius * 0.1 * Math.sin((double)(90 + angle) / 180.0 * 3.141596));
            cPointx[2] = centerx + (int)((double)m_Radius * 0.1 * Math.cos((double)(180 + angle) / 180.0 * 3.141596));
            cPointy[2] = centery - (int)((double)m_Radius * 0.1 * Math.sin((double)(180 + angle) / 180.0 * 3.141596));
            cPointx[3] = centerx + (int)((double)m_Radius * 0.1 * Math.cos((double)(270 + angle) / 180.0 * 3.141596));
            cPointy[3] = centery - (int)((double)m_Radius * 0.1 * Math.sin((double)(270 + angle) / 180.0 * 3.141596));
            g2.fillPolygon(cPointx, cPointy, 4);
            g2.setColor(Color.white);
            angle = (int)(225.0 - (double)(255 - (this.m_FanReading & 0xFF)) / 256.0 * 270.0);
            cPointx[0] = centerx + (int)((double)m_Radius * 0.85 * Math.cos((double)angle / 180.0 * 3.141596)) - 1;
            cPointy[0] = centery - (int)((double)m_Radius * 0.85 * Math.sin((double)angle / 180.0 * 3.141596)) - 1;
            cPointx[1] = centerx + (int)((double)m_Radius * 0.1 * Math.cos((double)(90 + angle) / 180.0 * 3.141596)) - 1;
            cPointy[1] = centery - (int)((double)m_Radius * 0.1 * Math.sin((double)(90 + angle) / 180.0 * 3.141596)) - 1;
            cPointx[2] = centerx + (int)((double)m_Radius * 0.1 * Math.cos((double)(180 + angle) / 180.0 * 3.141596)) - 1;
            cPointy[2] = centery - (int)((double)m_Radius * 0.1 * Math.sin((double)(180 + angle) / 180.0 * 3.141596)) - 1;
            cPointx[3] = centerx + (int)((double)m_Radius * 0.1 * Math.cos((double)(270 + angle) / 180.0 * 3.141596)) - 1;
            cPointy[3] = centery - (int)((double)m_Radius * 0.1 * Math.sin((double)(270 + angle) / 180.0 * 3.141596)) - 1;
            g2.fillPolygon(cPointx, cPointy, 4);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.addRenderingHints(hints);
            g2.setColor(Color.white);
            Font mFont = new Font("New Times Roman", 1, 11);
            FontMetrics fm = g2.getFontMetrics(mFont);
            int fwidth = fm.stringWidth("RPM");
            g2.setColor(Color.black);
            g2.drawString("RPM", centerx - (int)((double)fwidth / 2.0) + 2 + 1, centery - (int)((double)m_Radius * 0.8 / 2.0) + 6 + 1);
            g2.setColor(Color.white);
            g2.drawString("RPM", centerx - (int)((double)fwidth / 2.0) + 2, centery - (int)((double)m_Radius * 0.8 / 2.0) + 6);
            g2.setColor(Color.yellow);
            mFont = new Font("New Times Roman", 0, 13);
            fm = g2.getFontMetrics(mFont);
            fwidth = fm.stringWidth(this.m_ShowString);
            g2.setColor(Color.black);
            g2.drawString(this.m_ShowString, centerx - (int)((double)fwidth / 2.0) + 1, centery + (int)((double)m_Radius * 0.8) - 6 + 1);
            g2.setColor(Color.yellow);
            g2.drawString(this.m_ShowString, centerx - (int)((double)fwidth / 2.0), centery + (int)((double)m_Radius * 0.8) - 6);
            mFont = new Font("New Times Roman", 0, 11);
            fm = g2.getFontMetrics(mFont);
            fwidth = fm.stringWidth(this.m_HighString);
            g2.setColor(Color.black);
            g2.drawString(this.m_HighString, 2, xbottom - 3 + 1);
            g2.setColor(Color.red);
            g2.drawString(this.m_HighString, 1, xbottom - 3);
        }
    }
}

