/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.HistoryMonitor;
import IPMIView20.Readable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class JTempPanel
extends JPanel
implements Readable {
    JTempMeter tempMeter = new JTempMeter();
    HistoryMonitor hm = null;
    JLabel NameLabel = new JLabel();
    JLabel ValueLabel = new JLabel();
    JLabel MaxLabel = new JLabel();
    JLabel MinLabel = new JLabel();
    int SensorNumber;
    int M;
    int B;
    int RExp;
    int BExp;

    public JTempPanel(int sensorNumber, int m, int b2, int rexp, int bexp) {
        this.initComponents();
        this.SensorNumber = sensorNumber;
        this.M = m;
        this.B = b2;
        this.RExp = rexp;
        this.BExp = bexp;
    }

    public void updateValue(byte value, String valueString) {
        this.tempMeter.m_TempReading = value;
        this.tempMeter.m_ShowString = valueString;
        this.tempMeter.paintBufferImage();
        this.tempMeter.repaint();
        this.hm.updateHistory();
    }

    public void init(String labelName, byte value, byte low, String valueString, String lowString) {
        this.tempMeter.setValue(value, low);
        this.tempMeter.setString(valueString, lowString);
        this.tempMeter.setBorder(new EtchedBorder());
        this.add((Component)this.tempMeter, "Center");
        this.NameLabel.setText(labelName);
        this.NameLabel.setBorder(new EtchedBorder());
        this.NameLabel.setForeground(Color.blue);
        this.NameLabel.setHorizontalAlignment(0);
        this.add((Component)this.NameLabel, "South");
        this.hm = new HistoryMonitor(this);
        this.hm.surf.setPreferredSize(new Dimension(150, 90));
        this.add((Component)this.hm, "Center");
        this.add((Component)this.tempMeter, "Center");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i2 = offset + length - 1; i2 >= offset; --i2) {
            intdes = (intdes << 8) + (bytesrc[i2] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    @Override
    public float maxValue() {
        return 100.0f;
    }

    @Override
    public float getValue() {
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.tempMeter.m_ShowString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    @Override
    public float getOffset() {
        return 0.0f;
    }

    @Override
    public String getTitle() {
        return this.NameLabel.getText();
    }

    @Override
    public float highLimit() {
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.tempMeter.m_HighString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    @Override
    public float lowLimit() {
        return -1.0f;
    }

    public void showHistory() {
        this.remove(this.tempMeter);
        this.remove(this.hm);
        this.add((Component)this.hm, "Center");
    }

    public void showMeter() {
        this.remove(this.tempMeter);
        this.remove(this.hm);
        this.add((Component)this.tempMeter, "Center");
    }

    public class JTempMeter
    extends JPanel {
        int value;
        Color colorvalue;
        byte m_HighLimit = (byte)-128;
        byte m_TempReading = (byte)-48;
        String m_ShowString = "33";
        String m_HighString = "75";
        private BufferedImage bimg;

        public JTempMeter() {
            super.setPreferredSize(new Dimension(150, 35));
        }

        public void setValue(byte value, byte high) {
            this.m_TempReading = value;
            this.m_HighLimit = high;
        }

        public void setString(String valueString, String HighString) {
            this.m_ShowString = valueString;
            this.m_HighString = HighString;
        }

        @Override
        public void paintComponent(Graphics g1) {
            if (this.bimg != null) {
                g1.drawImage(this.bimg, 0, 0, this);
            }
        }

        public void paintBufferImage() {
            int m_Radius;
            Dimension d2 = this.getPreferredSize();
            if (this.bimg == null) {
                this.bimg = (BufferedImage)this.createImage(d2.width, d2.height);
            }
            Graphics2D g1 = this.bimg.createGraphics();
            super.paintComponent(g1);
            Graphics2D g2 = g1;
            RenderingHints hints = new RenderingHints(null);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.addRenderingHints(hints);
            int[] cPointx = new int[180];
            int[] cPointy = new int[180];
            Dimension rcBounds = this.getPreferredSize();
            g2.setColor(Color.lightGray);
            int xleft = 0;
            int xtop = 0;
            int xright = rcBounds.width - 1;
            int xbottom = rcBounds.height - 2;
            GradientPaint comet = new GradientPaint(xleft, xtop, Color.gray, 0.0f, xbottom, Color.gray);
            g2.setPaint(comet);
            g2.fillRect(0, 0, xright, xbottom);
            g2.setColor(Color.white);
            g2.drawLine(xright + 1, xtop + 1, xright + 1, xbottom + 1);
            g2.drawLine(xright + 1, xbottom + 1, xleft + 1, xbottom + 1);
            g2.setColor(Color.white);
            g2.drawLine(xright, xtop, xright, xbottom);
            g2.drawLine(xright, xbottom, xleft, xbottom);
            int centerx = m_Radius = (int)((double)xbottom * 0.8 / 2.0);
            int centery = m_Radius;
            g2.setColor(Color.black);
            g2.fillOval(2, 2, m_Radius * 2 - 1 + 1, m_Radius * 2 - 1 + 1);
            g2.fillOval(xright - m_Radius + 1 + 1, (int)((double)m_Radius / 2.0) + 1, m_Radius - 3 + 1, m_Radius + 1);
            g2.fillRect(1 + m_Radius + 1, (int)((double)m_Radius / 2.0) + 1, (int)((double)xright - (double)m_Radius * 1.5 - 1.0) + 1, m_Radius + 1);
            g2.setColor(Color.white);
            g2.fillOval(1, 1, m_Radius * 2 - 1, m_Radius * 2 - 1);
            g2.fillOval(xright - m_Radius + 1, (int)((double)m_Radius / 2.0), m_Radius - 3, m_Radius);
            g2.fillRect(1 + m_Radius, (int)((double)m_Radius / 2.0), (int)((double)xright - (double)m_Radius * 1.5 - 1.0), m_Radius);
            g2.setColor(Color.red);
            g2.fillOval((int)(1.0 + (double)m_Radius / 3.0), (int)(1.0 + (double)m_Radius / 3.0), (int)((double)m_Radius * 1.35 - 1.0), (int)((double)m_Radius * 1.35 - 1.0));
            g2.fillRect(1 + m_Radius, (int)((double)m_Radius * 0.75), m_Radius - 1, (int)((double)m_Radius * 0.5));
            g2.setColor(Color.lightGray);
            g2.fillRect(m_Radius * 2, (int)((double)m_Radius * 0.75), (int)((double)xright - (double)m_Radius * 2.5 - 2.0), (int)((double)m_Radius * 0.5));
            int Band1 = (int)((double)xright - (double)m_Radius / 2.0 - 2.0 - (double)(m_Radius * 2));
            int diff = (int)((double)m_Radius * 0.75 - (double)m_Radius / 2.0);
            g2.setColor(Color.red);
            g2.fillRect(m_Radius * 2, (int)((double)m_Radius * 0.75), (int)((double)(128 + this.m_TempReading) / 256.0 * (double)Band1), (int)((double)m_Radius * 0.5));
            g2.setColor(Color.black);
            for (int i2 = 0; i2 < 256; i2 += 20) {
                int ix1 = (int)((double)(m_Radius * 2) + (double)i2 / 256.0 * (double)Band1);
                g2.drawLine(ix1, (int)((double)m_Radius * 0.5), ix1, m_Radius);
            }
            g2.setColor(Color.red);
            cPointx[0] = (int)((double)(m_Radius * 2) + (double)(128 + this.m_HighLimit) / 256.0 * (double)Band1);
            cPointy[0] = (int)((double)m_Radius * 0.75);
            cPointx[1] = cPointx[0] + diff * 2;
            cPointy[1] = cPointy[0] - diff * 2;
            cPointx[2] = cPointx[0];
            cPointy[2] = cPointy[0] - diff * 2;
            g2.fillPolygon(cPointx, cPointy, 3);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.addRenderingHints(hints);
            Font mFont = new Font("New Times Roman", 0, 13);
            FontMetrics fm = g2.getFontMetrics(mFont);
            String tempValue = "";
            if ((this.m_TempReading & 0xFF) == 128) {
                tempValue = "N/A";
            } else {
                try {
                    double c2 = Double.parseDouble(this.m_ShowString);
                    long f2 = Math.round(1.8 * c2 + 32.0);
                    tempValue = c2 + "C / " + f2 + "F";
                }
                catch (NumberFormatException ex) {
                    tempValue = "N/A";
                }
            }
            int fwidth = fm.stringWidth(tempValue);
            g2.setColor(Color.black);
            g2.drawString(tempValue, m_Radius * 2 + 10 + 1, xbottom - 1 + 1);
            g2.setColor(Color.yellow);
            g2.drawString(tempValue, m_Radius * 2 + 10, xbottom - 1);
            mFont = new Font("New Times Roman", 0, 11);
            fm = g2.getFontMetrics(mFont);
            fwidth = fm.stringWidth(this.m_HighString);
            g2.setColor(Color.black);
            g2.drawString(this.m_HighString, xright - fwidth - 4 + 1, xbottom - 1 + 1);
            g2.setColor(Color.red);
            g2.drawString(this.m_HighString, xright - fwidth - 4, xbottom - 1);
        }
    }
}

