/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.KeepSessionTimerTask;
import IPMIView20.Logger;
import IPMIView20.UOLDebug;
import IPMIView20.UOLMessage;
import IPMIView20.UOLMessageFactory;
import IPMIView20.UOLOutputInterface;
import IPMIView20.UOLSession;
import IPMIView20.UOLUDPSocket;
import java.util.Timer;
import java.util.TimerTask;

public class UOLKeepSessionWatchDog {
    UOLUDPSocket socket;
    UOLSession session;
    Timer timer;
    UOLOutputInterface output;
    int timeDelay = 0;

    public UOLKeepSessionWatchDog(int timeDelay, UOLUDPSocket socket, UOLSession session, UOLOutputInterface output) {
        this.socket = socket;
        this.session = session;
        this.timeDelay = timeDelay;
        this.output = output;
    }

    public void start() {
        KeepSessionTimerTask t = new KeepSessionTimerTask(this);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)t, (long)this.timeDelay * 1000L);
    }

    public void stop() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceKeepSession() {
        UOLSession uOLSession = this.session;
        synchronized (uOLSession) {
            if (UOLDebug.debugLevel == 1) {
                Logger.writeLog("Send keep session by watchDog (Forced):");
            }
            UOLMessage message = UOLMessageFactory.keepSessionMessage(this.session);
            this.session.setSendKeepSession(true);
            this.socket.sendPacket(message.toByteArray());
        }
    }
}

