/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.IPMIView20;
import IPMIView20.Logger;
import IPMIView20.blade.LabelBladeComponent;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class LabelBlade
extends LabelBladeComponent {
    ImageIcon labelBlade = new ImageIcon(this.getClass().getResource("/images/labelBlade.jpg"));
    ImageIcon labelBlade_BHQME = new ImageIcon(this.getClass().getResource("/images/labelBlade-BHQME.jpg"));
    ImageIcon labelBlade_B7DW3 = new ImageIcon(this.getClass().getResource("/images/labelBlade-B7DW3.jpg"));
    ImageIcon labelBlade_B7DCE = new ImageIcon(this.getClass().getResource("/images/labelBlade-B7DCE.jpg"));
    ImageIcon labelBlade_B7DC3 = new ImageIcon(this.getClass().getResource("/images/labelBlade-B7DC3.jpg"));
    ImageIcon labelBlade_B7DC3_14b = new ImageIcon(this.getClass().getResource("/images/labelBlade-B7DC3-14b.jpg"));
    ImageIcon labelBlade_B7DCL = new ImageIcon(this.getClass().getResource("/images/labelBlade-B7DCL.jpg"));
    ImageIcon labelBlade_B7DCL_14b = new ImageIcon(this.getClass().getResource("/images/labelBlade-B7DCL-14b.jpg"));
    ImageIcon labelBlade_B8DTT_UP = new ImageIcon(this.getClass().getResource("/images/labelBlade-B8DTT-UP.jpg"));
    ImageIcon labelBlade_B8DTT_DOWN = new ImageIcon(this.getClass().getResource("/images/labelBlade-B8DTT-DOWN.jpg"));
    ImageIcon labelBlade_B8DT6_A = new ImageIcon(this.getClass().getResource("/images/labelBlade-B8DT6E-A.jpg"));
    ImageIcon labelBlade_B8DTG = new ImageIcon(this.getClass().getResource("/images/labelBlade-B8DTG.jpg"));
    ImageIcon labelBlade_BHQG6 = new ImageIcon(this.getClass().getResource("/images/labelBlade-BHQG6.jpg"));
    ImageIcon labelBlade_B9DRP = new ImageIcon(this.getClass().getResource("/images/labelBlade-B9DRP.jpg"));
    ImageIcon labelBlade_B9DRP_14b = new ImageIcon(this.getClass().getResource("/images/labelBlade-B9DRP-14b.jpg"));
    ImageIcon labelBlade_B9DRGE = new ImageIcon(this.getClass().getResource("/images/labelBlade-B9DRGE.jpg"));
    ImageIcon kvmIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentKVM.gif"));
    ImageIcon managementIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentManagement.gif"));
    int kvmIconX = 0;
    int kvmIconY = 0;
    int managementIconX = 0;
    int managementIconY = 0;
    BladeSystemEntity bladeSystemEntity = null;

    public LabelBlade() {
        this.setIcon(this.labelBlade);
        this.setSize(this.labelBlade.getIconWidth(), this.labelBlade.getIconHeight());
        this.powerIconX = 5;
        this.powerIconY = 16;
        this.uidIconX = 5;
        this.uidIconY = 26;
        this.kvmIconX = 5;
        this.kvmIconY = 36;
        this.managementIconX = 5;
        this.managementIconY = 46;
        this.alertIconX = 5;
        this.alertIconY = 56;
        this.icons = new ImageIcon[2];
        this.iconsX = new int[2];
        this.iconsY = new int[2];
        this.iconsVisible = new boolean[2];
        this.icons[0] = this.kvmIcon;
        this.icons[1] = this.managementIcon;
        this.iconsX[0] = this.kvmIconX;
        this.iconsY[0] = this.kvmIconY;
        this.iconsX[1] = this.managementIconX;
        this.iconsY[1] = this.managementIconY;
        this.iconsVisible[0] = false;
        this.iconsVisible[1] = false;
        this.setPowerStatus(1);
        this.setPowerVisible(true);
        this.setModuleName("Blade");
    }

    public void setKVMVisible(boolean kvmVisible) {
        this.iconsVisible[0] = kvmVisible;
    }

    public void setManagementVisible(boolean managementVisible) {
        this.iconsVisible[1] = managementVisible;
    }

    public boolean getKVMVisible() {
        return this.iconsVisible[0];
    }

    public void setNetworkVisible(boolean networkVisible) {
        this.iconsVisible[1] = networkVisible;
    }

    public boolean getNetworkVisible() {
        return this.iconsVisible[1];
    }

    @Override
    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[LabelBlade] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LabelBlade.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        BladeEntity blade = this.bladeSystemEntity.getBlades()[this.number - 1];
        boolean powerSupply = true;
        if (blade.isV12vEnable() && blade.isV3_3v() && powerSupply) {
            this.setPowerStatus(0);
        } else if (!blade.isV12vEnable() && !blade.isV3_3v()) {
            this.setPowerStatus(1);
        } else if (blade.isV12vEnable() && !blade.isV3_3v() && powerSupply) {
            this.setPowerStatus(1);
        } else if (!powerSupply) {
            this.setPowerStatus(1);
        }
        this.setPowerVisible(true);
        if (blade.getKvmEnable() > 0) {
            this.setKVMVisible(true);
        } else {
            this.setKVMVisible(false);
        }
        if (blade.isSimCardDetectPin()) {
            this.setManagementVisible(true);
        } else {
            this.setManagementVisible(false);
        }
        if (blade.getUidEnable() > 0) {
            this.setUidVisible(true);
        } else {
            this.setUidVisible(false);
        }
        if (blade.isError1LED()) {
            this.setAlertVisible(true);
        } else {
            this.setAlertVisible(false);
        }
        if (blade.getPresent() == 0) {
            this.setVisible(false);
            if (this.labelBladeGroup.labelBladeComponentIndicatorOn == this) {
                this.labelBladeGroup.labelBladeComponentIndicatorOn = null;
            }
        } else {
            this.setVisible(true);
        }
        this.setBladeIcon(blade.getMBModel(), this.bladeSystemEntity.getBlades().length);
        this.repaint();
    }

    public void setBladeIcon(int bladeType, int bladeSize) {
        switch (bladeType) {
            case 0: 
            case 9: 
            case 10: {
                this.setIcon(this.labelBlade);
                this.setSize(this.labelBlade.getIconWidth(), this.labelBlade.getIconHeight());
                break;
            }
            case 1: 
            case 11: 
            case 22: {
                this.setIcon(this.labelBlade_BHQME);
                this.setSize(this.labelBlade_BHQME.getIconWidth(), this.labelBlade_BHQME.getIconHeight());
                break;
            }
            case 2: {
                this.setIcon(this.labelBlade_B7DW3);
                this.setSize(this.labelBlade_B7DW3.getIconWidth(), this.labelBlade_B7DW3.getIconHeight());
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 23: {
                if (bladeSize == 14) {
                    this.setIcon(this.labelBlade_B7DC3_14b);
                    this.setSize(this.labelBlade_B7DC3_14b.getIconWidth(), this.labelBlade_B7DC3_14b.getIconHeight());
                    this.adjust14BLocations();
                    break;
                }
                if (IPMIView20.acer || IPMIView20.gateway) {
                    this.setIcon(this.labelBlade_B8DT6_A);
                    this.setSize(this.labelBlade_B8DT6_A.getIconWidth(), this.labelBlade_B8DT6_A.getIconHeight());
                    break;
                }
                this.setIcon(this.labelBlade_B7DC3);
                this.setSize(this.labelBlade_B7DC3.getIconWidth(), this.labelBlade_B7DC3.getIconHeight());
                break;
            }
            case 24: {
                if (bladeSize == 14) {
                    this.setIcon(this.labelBlade_B9DRP_14b);
                    this.setSize(this.labelBlade_B9DRP_14b.getIconWidth(), this.labelBlade_B9DRP_14b.getIconHeight());
                    this.adjust14BLocations();
                    break;
                }
                this.setIcon(this.labelBlade_B9DRP);
                this.setSize(this.labelBlade_B9DRP.getIconWidth(), this.labelBlade_B9DRP.getIconHeight());
                break;
            }
            case 7: {
                if (bladeSize == 14) {
                    this.setIcon(this.labelBlade_B7DCL_14b);
                    this.setSize(this.labelBlade_B7DCL_14b.getIconWidth(), this.labelBlade_B7DCL_14b.getIconHeight());
                    this.adjust14BLocations();
                    break;
                }
                this.setIcon(this.labelBlade_B7DCL);
                this.setSize(this.labelBlade_B7DCL.getIconWidth(), this.labelBlade_B7DCL.getIconHeight());
                break;
            }
            case 5: {
                this.setIcon(this.labelBlade);
                this.setSize(this.labelBlade.getIconWidth(), this.labelBlade.getIconHeight());
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 20: {
                if (this.number <= 10) {
                    this.setIcon(this.labelBlade_B8DTT_UP);
                    this.setSize(this.labelBlade_B8DTT_UP.getIconWidth(), this.labelBlade_B8DTT_UP.getIconHeight());
                } else {
                    this.setIcon(this.labelBlade_B8DTT_DOWN);
                    this.setSize(this.labelBlade_B8DTT_DOWN.getIconWidth(), this.labelBlade_B8DTT_DOWN.getIconHeight());
                }
                this.adjust20BLocations();
                break;
            }
            case 18: {
                this.setIcon(this.labelBlade_B8DTG);
                this.setSize(this.labelBlade_B8DTG.getIconWidth(), this.labelBlade_B8DTG.getIconHeight());
                break;
            }
            case 17: {
                this.setIcon(this.labelBlade_BHQG6);
                this.setSize(this.labelBlade_BHQG6.getIconWidth(), this.labelBlade_BHQG6.getIconHeight());
                break;
            }
            case 19: {
                if (bladeSize == 14) {
                    this.setIcon(this.labelBlade_B7DCL_14b);
                    this.setSize(this.labelBlade_B7DCL_14b.getIconWidth(), this.labelBlade_B7DCL_14b.getIconHeight());
                    this.adjust14BLocations();
                    break;
                }
                this.setIcon(this.labelBlade_B7DCL);
                this.setSize(this.labelBlade_B7DCL.getIconWidth(), this.labelBlade_B7DCL.getIconHeight());
                break;
            }
            case 21: {
                this.setIcon(this.labelBlade_B8DTG);
                this.setSize(this.labelBlade_B8DTG.getIconWidth(), this.labelBlade_B8DTG.getIconHeight());
                break;
            }
            case 25: {
                this.setIcon(this.labelBlade_B9DRGE);
                this.setSize(this.labelBlade_B9DRGE.getIconWidth(), this.labelBlade_B9DRGE.getIconHeight());
                break;
            }
        }
    }

    private void adjust14BLocations() {
        this.powerIconX = 3;
        this.uidIconX = 3;
        this.alertIconX = 3;
        this.iconsX[0] = 3;
        this.iconsX[1] = 3;
        this.numberX = 3;
    }

    private void adjust20BLocations() {
        if (this.number > 10) {
            this.numberY = this.getHeight() - 1;
        }
    }
}

