/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.Logger;
import IPMIView20.blade.LabelBladeComponent;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.IBFDREntity;
import com.supermicro.ipmi.blade.IBQDREntity;
import com.supermicro.ipmi.blade.InfiniBandEntity;
import com.supermicro.ipmi.blade.TenGSwitchEntity;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class LabelInfiniBand
extends LabelBladeComponent {
    ImageIcon labelIB = new ImageIcon(this.getClass().getResource("/images/labelInfiniband.jpg"));
    BladeSystemEntity bladeSystemEntity = null;

    public LabelInfiniBand() {
        this.powerIconX = 15;
        this.powerIconY = 4;
        this.alertIconX = 39;
        this.alertIconY = 4;
        this.setIcon(this.labelIB);
        this.setSize(21, 144);
        this.setPowerStatus(1);
        this.setPowerVisible(true);
        this.setModuleName("InfiniBand");
    }

    @Override
    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[LabelInfiniBand] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LabelInfiniBand.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        if (this.bladeSystemEntity.getInfiniBands().length == 0) {
            this.setVisible(false);
            return;
        }
        InfiniBandEntity infiniBandEntity = this.bladeSystemEntity.getInfiniBands()[this.number - 1];
        IBQDREntity ibQDREntity = this.bladeSystemEntity.getIBQDRs()[this.number - 1];
        IBFDREntity ibFDREntity = this.bladeSystemEntity.getIBFDRs()[this.number - 1];
        TenGSwitchEntity tenGSwitchEntity = this.bladeSystemEntity.getTenGSwitches()[this.number - 1];
        if (!(infiniBandEntity.getPresent() == 0 || infiniBandEntity.getReserve3() != 0 || ibFDREntity.isIBFDR() || ibQDREntity.isIBQDR() || ibQDREntity.isIBQDRPassThru() || tenGSwitchEntity.is10GSwitch() || infiniBandEntity.getInitialized() != 1)) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
            if (this.labelBladeGroup.labelBladeComponentIndicatorOn == this) {
                this.labelBladeGroup.labelBladeComponentIndicatorOn = null;
            }
        }
        if (infiniBandEntity.isPowerOn()) {
            this.setPowerStatus(0);
        } else {
            this.setPowerStatus(1);
        }
    }
}

