/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.group;

import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.group.FilterCondition;
import IPMIView20.group.PPanel;
import IPMIView20.group.SELMessageCenterObserver;
import IPMIView20.group.SELPanel_jClearButton_actionAdapter;
import IPMIView20.group.SELPanel_jHostComboBox_itemAdapter;
import IPMIView20.group.SELPanel_jSaveButton_actionAdapter;
import IPMIView20.group.SEL_JCheckBox1_actionAdapter;
import IPMIView20.group.SEL_JComboBox1_itemAdapter;
import IPMIView20.group.SEL_JQueryButton_actionAdapter;
import IPMIView20.group.TableSorter;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.group.CommandForGettingSELRecords;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class SELPanel
extends PPanel
implements Observer {
    Timer timer;
    FilterCondition hostFilter = null;
    TableSorter ts;
    DefaultTableModel dtm;
    CommandForGettingSELRecords commandForGettingSELRecords;
    Icon listIcon = new ImageIcon(this.getClass().getResource("/images/list.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon deleteIcon = new ImageIcon(this.getClass().getResource("/images/delete.gif"));
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JButton jQueryButton = new JButton();
    BorderLayout borderLayout2 = new BorderLayout();
    JTable jTable = new JTable();
    TitledBorder titledBorder1 = new TitledBorder("");
    JPanel jPanel3 = new JPanel();
    public JComboBox jComboBox1 = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    public JCheckBox jCheckBox1 = new JCheckBox();
    JPanel jPanel5 = new JPanel();
    JLabel jLastUpdateLabel = new JLabel();
    JPanel jPanel6 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JComboBox jHostComboBox = new JComboBox();
    BorderLayout borderLayout4 = new BorderLayout();
    Host host = null;
    Result result = null;
    static boolean isRunning = false;
    JToolBar jToolBar1 = new JToolBar();
    BorderLayout borderLayout5 = new BorderLayout();
    JButton jSaveButton = new JButton();
    JButton jClearButton = new JButton();
    String pathName;
    static JFileChooser fileChooser;

    public SELPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(L.t("group.sel.SEL"));
        this.setLayout(this.borderLayout1);
        this.jQueryButton.setToolTipText(L.t("group.table.toolbar.Get"));
        this.jQueryButton.setIcon(this.listIcon);
        this.jQueryButton.addActionListener(new SEL_JQueryButton_actionAdapter(this));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setBorder(this.titledBorder1);
        this.jLabel2.setText(L.t("group.sel.seconds"));
        this.jPanel4.setLayout(this.borderLayout3);
        this.jCheckBox1.setText(L.t("group.sel.Refresh_every"));
        this.jCheckBox1.addActionListener(new SEL_JCheckBox1_actionAdapter(this));
        this.jComboBox1.addItemListener(new SEL_JComboBox1_itemAdapter(this));
        this.jTable.setAutoResizeMode(0);
        this.jLabel1.setText(L.t("group.sel.Host_colon") + "  ");
        this.jPanel6.setLayout(this.borderLayout4);
        this.jHostComboBox.addItemListener(new SELPanel_jHostComboBox_itemAdapter(this));
        this.jPanel2.setLayout(this.borderLayout5);
        this.jToolBar1.setFloatable(false);
        this.jSaveButton.setToolTipText(L.t("group.table.toolbar.Save"));
        this.jSaveButton.setIcon(this.saveIcon);
        this.jSaveButton.addActionListener(new SELPanel_jSaveButton_actionAdapter(this));
        this.jClearButton.setToolTipText(L.t("group.table.toolbar.Clear"));
        this.jClearButton.setIcon(this.deleteIcon);
        this.jClearButton.addActionListener(new SELPanel_jClearButton_actionAdapter(this));
        this.add((Component)this.jPanel1, "Center");
        this.jToolBar1.add(this.jQueryButton);
        this.jToolBar1.add(this.jClearButton);
        this.jToolBar1.add(this.jSaveButton);
        this.jScrollPane1.getViewport().add(this.jTable);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add(this.jCheckBox1);
        this.jPanel3.add(this.jComboBox1);
        this.jPanel3.add(this.jLabel2);
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.jPanel3, "West");
        this.jPanel4.add((Component)this.jPanel5, "East");
        this.jPanel5.add(this.jLastUpdateLabel);
        this.jPanel1.add((Component)this.jPanel6, "North");
        this.jPanel6.add((Component)this.jHostComboBox, "Center");
        this.jPanel6.add((Component)this.jLabel1, "West");
        this.add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.jToolBar1, "Center");
    }

    private void myInit() {
        this.jComboBox1.addItem("10");
        this.jComboBox1.addItem("20");
        this.jComboBox1.addItem("30");
        this.jComboBox1.addItem("45");
        this.jComboBox1.addItem("60");
        this.jComboBox1.addItem("90");
        this.jComboBox1.addItem("120");
        this.jComboBox1.setSelectedIndex(4);
        this.showHeader();
    }

    public void initialTableFilterCondition(TableSorter ts) {
        ts.removeAllFilterCondition();
        this.hostFilter = new FilterCondition();
        this.hostFilter.filterOperator = 0;
        this.hostFilter.filterColumnIndex = 0;
        this.hostFilter.filterValue = "All";
        ts.addFilterCondition(this.hostFilter);
    }

    public void showHeader() {
        ArrayList headerList = this.getHeader();
        DefaultTableModel dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(dtm);
        this.jTable.setModel(this.ts);
    }

    public ArrayList getHeader() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(L.t("group.sel.Host") + "   ");
        headerList.add(L.t("group.sel.IP") + "   ");
        headerList.add(L.t("group.sel.Time_Stamp") + "    ");
        headerList.add(L.t("group.sel.Type"));
        headerList.add(L.t("group.sel.Sensor"));
        headerList.add(L.t("group.sel.Event_Type") + " ");
        return headerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doQuery() {
        if (!this.isShowMeNow()) {
            return;
        }
        this.jQueryButton.setEnabled(false);
        this.jClearButton.setEnabled(false);
        this.jSaveButton.setEnabled(false);
        this.jHostComboBox.removeAllItems();
        if (!this.initialData()) {
            this.jQueryButton.setEnabled(true);
            this.jClearButton.setEnabled(true);
            this.jSaveButton.setEnabled(true);
            return;
        }
        ((TableSorter)this.jTable.getModel()).cancelFilter();
        ((TableSorter)this.jTable.getModel()).filterConditions.clear();
        if (this.ts == null) {
            ArrayList headerList = this.getHeader();
            this.dtm = new DefaultTableModel(headerList.toArray(), 0);
            this.ts = new TableSorter(this.dtm);
            this.initialTableFilterCondition(this.ts);
        } else {
            int rowCount = this.ts.getTableModel().getRowCount();
            for (int i2 = 0; i2 < rowCount; ++i2) {
                ((DefaultTableModel)this.ts.getTableModel()).removeRow(0);
            }
            this.initialTableFilterCondition(this.ts);
        }
        SELMessageCenterObserver selMessageCenterObserver = new SELMessageCenterObserver(this);
        MessageCenter.getInstance().addObserver(selMessageCenterObserver);
        this.hostManager.addObserver(this);
        this.commandForGettingSELRecords = new CommandForGettingSELRecords();
        try {
            this.hostManager.run(this.commandForGettingSELRecords);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            MessageCenter.getInstance().deleteObserver(selMessageCenterObserver);
            this.hostManager.deleteObserver(this);
            this.jQueryButton.setEnabled(true);
            this.jClearButton.setEnabled(true);
            this.jSaveButton.setEnabled(true);
            this.setLastUpdate();
            this.jHostComboBox.addItem(L.t("group.sel.All"));
            this.jHostComboBox.setSelectedItem(L.t("group.sel.All"));
            this.xMessage.setText(L.t("group.sel.Finish"));
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof Host) {
            this.host = (Host)arg;
            this.xMessage.setText(L.t("group.sel.Getting_SEL_data_from") + " " + this.host.getIp() + " ...");
            return;
        }
        if (arg instanceof Result) {
            this.result = (Result)arg;
            if (this.result.booleanResult) {
                for (int i2 = 0; i2 < this.host.selRecords.size(); ++i2) {
                    ArrayList raw = this.makeFormatedData(this.host, (SELRecord)this.host.selRecords.get(i2));
                    ((DefaultTableModel)this.ts.getTableModel()).addRow(raw.toArray());
                }
                this.jTable.setModel(this.ts);
                this.ts.setTableHeader(this.jTable.getTableHeader());
                this.jTable.getColumnModel().getColumn(0).setPreferredWidth(100);
                this.jTable.getColumnModel().getColumn(1).setPreferredWidth(100);
                this.jTable.getColumnModel().getColumn(2).setPreferredWidth(140);
                this.jTable.getColumnModel().getColumn(3).setPreferredWidth(50);
                this.jTable.getColumnModel().getColumn(4).setPreferredWidth(50);
                this.jTable.getColumnModel().getColumn(5).setPreferredWidth(300);
                this.jTable.invalidate();
                this.jHostComboBox.addItem(this.host.getHostname());
                this.ts.fireTableDataChanged();
            } else {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), this.result.description + "\n" + this.result.host.getIp());
            }
        }
    }

    public ArrayList makeFormatedData(Host host, SELRecord selRecord) {
        ArrayList<String> raw = new ArrayList<String>();
        raw.add(host.getHostname());
        raw.add(host.getIp());
        raw.add(ByteUtility.fourByteToDate(selRecord.getTimeStamp()));
        raw.add(GlobalDefine.getSensorType(selRecord.getSensorType() & 0xFF));
        raw.add((String)SDRRecord.sensorNumberToSensorName.get("" + (selRecord.getSensorNumber() & 0xFF)));
        raw.add(GlobalDefine.getEventType((byte)(selRecord.getEventDir() | selRecord.getEventType()), selRecord.getSensorType(), selRecord.getEventData1(), selRecord.getEventData2(), selRecord.getEventData3(), host.productID));
        return raw;
    }

    public void jQueryButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                SELPanel.this.doQuery();
            }
        };
        thread.start();
    }

    public void jCheckBox1_actionPerformed(ActionEvent e2) {
        this.setReflashTimer();
    }

    private void setReflashTimer() throws NumberFormatException {
        String flashRateStr = (String)this.jComboBox1.getSelectedItem();
        int flashRate = Integer.parseInt(flashRateStr);
        if (this.jCheckBox1.isSelected()) {
            TimerTask tt = new TimerTask(){

                @Override
                public void run() {
                    Thread th = new Thread(){

                        @Override
                        public void run() {
                            if (SELPanel.this.loginID == null || SELPanel.this.loginID.length() == 0 || SELPanel.this.loginPassword == null || SELPanel.this.loginPassword.length() == 0) {
                                return;
                            }
                            if (isRunning) {
                                return;
                            }
                            isRunning = true;
                            SELPanel.this.doQuery();
                            isRunning = false;
                        }
                    };
                    th.start();
                }
            };
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = new Timer();
            this.timer.schedule(tt, flashRate * 1000, (long)(flashRate * 1000));
        } else {
            this.timer.cancel();
        }
    }

    public void setLastUpdate() {
        SimpleDateFormat f2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        this.jLastUpdateLabel.setText(L.t("group.sel.last_update_colon") + f2.format(Calendar.getInstance().getTime()) + " (" + this.ts.getTableModel().getRowCount() + ")");
    }

    public void jComboBox1_itemStateChanged(ItemEvent e2) {
        if (this.jCheckBox1.isSelected()) {
            this.setReflashTimer();
        }
    }

    public void handleMessageCenterObserver(Observable o, Object arg) {
        MessageCenter.ClassMessage classMessage = (MessageCenter.ClassMessage)arg;
        if (classMessage.from.equals("com.supermicro.ipmi.IPMISELCommand") || classMessage.from.equals("com.supermicro.ipmi.IPMISDRCommand")) {
            this.xMessage.setText(classMessage.content);
        }
    }

    public void jHostComboBox_itemStateChanged(ItemEvent e2) {
        String host = (String)this.jHostComboBox.getSelectedItem();
        if (host == null) {
            return;
        }
        String value = "";
        value = host.equals(L.t("group.sel.All")) ? "*" : host;
        this.hostFilter.filterValue = value;
        ((TableSorter)this.jTable.getModel()).filter();
    }

    public void jClearButton_actionPerformed(ActionEvent e2) {
        this.ts.cancelFilter();
        this.ts.filterConditions.clear();
        this.ts.removeAllFilterCondition();
        int rowCount = this.ts.getTableModel().getRowCount();
        for (int i2 = 0; i2 < rowCount; ++i2) {
            ((DefaultTableModel)this.ts.getTableModel()).removeRow(0);
        }
        this.jHostComboBox.removeAllItems();
    }

    public void jSaveButton_actionPerformed(ActionEvent e2) {
        int rowCount;
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        if ((rowCount = this.jTable.getModel().getRowCount()) == 0) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.No_data"));
            return;
        }
        boolean save = false;
        if (fileChooser.showSaveDialog(null) == 0) {
            this.pathName = fileChooser.getSelectedFile().getAbsolutePath();
            File xfi = new File(this.pathName);
            if (xfi.exists()) {
                int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.Do_you_want_to_overwrite_it"), L.t("group.table.toolbar.Request_Confirmation"), 0);
                if (ret == 0) {
                    save = true;
                }
            } else {
                save = true;
            }
        }
        if (!save) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int i2;
                StringBuffer sb = new StringBuffer();
                ArrayList list = SELPanel.this.getHeader();
                for (i2 = 0; i2 < list.size(); ++i2) {
                    sb.append(list.get(i2));
                    if (i2 == list.size() - 1) continue;
                    sb.append(",");
                }
                sb.append("\n");
                for (i2 = 0; i2 < SELPanel.this.jTable.getRowCount(); ++i2) {
                    for (int j2 = 0; j2 < SELPanel.this.jTable.getColumnCount(); ++j2) {
                        sb.append((String)((TableSorter)SELPanel.this.jTable.getModel()).getValueAt(i2, j2));
                        if (j2 == SELPanel.this.jTable.getColumnCount() - 1) continue;
                        sb.append(",");
                    }
                    sb.append("\n");
                }
                try {
                    FileWriter fout = new FileWriter(SELPanel.this.pathName);
                    PrintWriter pw = new PrintWriter(fout);
                    pw.println(sb.toString());
                    fout.close();
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.save_to") + " " + SELPanel.this.pathName + " " + L.t("group.table.toolbar.completed"));
                }
                catch (IOException e2) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.Cannot_save_to_file_It_probably_is_locked_or_read-only"), L.t("group.table.toolbar.Warning"), 0);
                }
            }
        };
        thread.start();
    }
}

