/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap;

import IPMIView20.trap.Trap;
import IPMIView20.trap.TrapDaemonPackage;
import IPMIView20.trap.TrapReceiverPrintStream;
import IPMIView20.trap.TrapReceiverTray;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Properties;

public class TrapReceiverSocket {
    private boolean readLoop = true;
    private static Date newDate;
    private Socket socket;

    public static void main(String[] args) {
        try {
            TrapReceiverPrintStream trapReceiverPrintStream = new TrapReceiverPrintStream(new FileOutputStream("TrapReceiver.log", true));
            System.setErr(trapReceiverPrintStream);
            System.setOut(trapReceiverPrintStream);
            if (args != null && args.length >= 1) {
                Thread.sleep(Integer.parseInt(args[0]) * 1000);
            } else {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
        Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook ......"){

            @Override
            public void run() {
                System.out.println(newDate + ": TrapReceiverSocket closed");
            }
        });
        newDate = new Date();
        new TrapReceiverSocket();
        System.exit(0);
    }

    public TrapReceiverSocket() {
        System.out.println(newDate + ": TrapReceiverSocket starting ...");
        TrapReceiverTray trapReceiverTray = TrapReceiverTray.getInstance();
        if (trapReceiverTray == null) {
            return;
        }
        trapReceiverTray.startReceiver();
        try {
            this.socket = new Socket(InetAddress.getByName("127.0.0.1"), 51000);
            this.socket.setTcpNoDelay(true);
            ObjectInputStream objectInputStream = new ObjectInputStream(this.socket.getInputStream());
            while (this.readLoop) {
                System.out.println("TrapReceiverSocket reading ...");
                TrapDaemonPackage trapDaemonPackage = (TrapDaemonPackage)objectInputStream.readObject();
                switch (trapDaemonPackage.getCode()) {
                    case 100: {
                        Trap trap = (Trap)trapDaemonPackage.getObject();
                        trapReceiverTray.trapView.frame.trapViewController.receiver.getTrapCollector().put(trap);
                        System.out.println(trap);
                        break;
                    }
                    case 101: {
                        System.out.println("Received Properties Package");
                        Properties properties = (Properties)trapDaemonPackage.getObject();
                        trapReceiverTray.setProperties(properties);
                        trapReceiverTray.refreshServiceState();
                        break;
                    }
                    case 102: {
                        String script = (String)trapDaemonPackage.getObject();
                        trapReceiverTray.setScript(script);
                        System.out.println("Received Script Package : " + script);
                        break;
                    }
                    case 103: {
                        Boolean state = (Boolean)trapDaemonPackage.getObject();
                        trapReceiverTray.setTrapReceiverState(state);
                        trapReceiverTray.trapView.frame.jStartButton_actionPerformed(null);
                        System.out.println("Received Trap Receiver State Package : " + state);
                        break;
                    }
                }
            }
            objectInputStream.close();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace(System.err);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void close() {
        this.readLoop = false;
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

