/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.FloppyRedir;
import com.ami.iusb.JListDialog;
import com.ami.iusb.RedirectionException;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class IUSBRedirSession {
    JViewerApp app;
    private String host;
    public static final byte AUTH_SESS_TOKEN_PKT_SIZE = 18;
    public static final byte AUTH_USER_PKT_SIZE = 98;
    public static final byte AUTH_PKT_MAX_SIZE = 98;
    public CDROMRedir cdromSession;
    public FloppyRedir floppySession;
    public static final int DEVICE_REDIR_STATUS_IDLE = 0;
    public static final int DEVICE_REDIR_STATUS_CONNECTED = 1;
    public static final int DEVICE_REDIR_STATUS_TRANSFERING = 2;
    private int cdromRedirStatus = 0;
    private int floppyRedirStatus = 0;
    final int cdserver_port = 5120;
    final int fdserver_port = 5123;

    public IUSBRedirSession(JViewerApp jViewerApp) {
        this.app = jViewerApp;
        this.host = null;
        this.cdromSession = null;
        this.floppySession = null;
    }

    public boolean StartCDROMRedir(String string, int n, boolean bl, String string2, String string3) {
        if (string == null) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_1_IUSBREDIR"));
            return false;
        }
        if (string3.length() == 0) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_2_IUSBREDIR"));
            return false;
        }
        try {
            if (this.cdromSession != null) {
                if (this.cdromSession.isRedirActive()) {
                    this.app.generalErrorMessage(LocaleStrings.GetString("6_3_IUSBREDIR"));
                    return false;
                }
                this.cdromSession = null;
                System.gc();
            }
            this.cdromSession = new CDROMRedir(true, this.app);
            Debug.out.println("CDROMRedir object created");
            if (!this.cdromSession.startRedirection(string, n, bl, string2, string3)) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_4_IUSBREDIR"));
                this.StopCDROMRedir();
                return false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_5_IUSBREDIR"));
            this.StopCDROMRedir();
            return false;
        }
        catch (RedirectionException redirectionException) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_6_IUSBREDIR") + redirectionException.getMessage());
            this.StopCDROMRedir();
            return false;
        }
        this.cdromRedirStatus = 1;
        return true;
    }

    public boolean StopCDROMRedir() {
        if (this.cdromSession != null) {
            if (!this.cdromSession.stopRedirection()) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_7_IUSBREDIR"));
                return false;
            }
            this.cdromSession = null;
            System.gc();
        }
        this.cdromRedirStatus = 0;
        return true;
    }

    public boolean StartISORedir(String string, int n, boolean bl, String string2, String string3) {
        if (string == null) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_8_IUSBREDIR"));
            return false;
        }
        if (string3.length() == 0) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_9_IUSBREDIR"));
            return false;
        }
        try {
            if (this.cdromSession != null) {
                if (this.cdromSession.isRedirActive()) {
                    this.app.generalErrorMessage(LocaleStrings.GetString("6_10_IUSBREDIR"));
                    return false;
                }
                this.cdromSession = null;
                System.gc();
            }
            this.cdromSession = new CDROMRedir(false, this.app);
            if (!this.cdromSession.startRedirection(string, n, bl, string2, string3)) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_11_IUSBREDIR"));
                this.StopISORedir();
                return false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_12_IUSBREDIR"));
            this.StopISORedir();
            return false;
        }
        catch (RedirectionException redirectionException) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_13_IUSBREDIR") + redirectionException.getMessage());
            this.StopISORedir();
            return false;
        }
        this.cdromRedirStatus = 1;
        return true;
    }

    public boolean StopISORedir() {
        return this.StopCDROMRedir();
    }

    public boolean StartFloppyRedir(String string, int n, boolean bl, String string2, String string3) {
        if (string == null) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_14_IUSBREDIR"));
            return false;
        }
        if (string3.length() == 0) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_15_IUSBREDIR"));
            return false;
        }
        try {
            if (this.floppySession != null) {
                if (this.floppySession.isRedirActive()) {
                    this.app.generalErrorMessage(LocaleStrings.GetString("6_16_IUSBREDIR"));
                    return false;
                }
                this.floppySession = null;
                System.gc();
            }
            this.floppySession = new FloppyRedir(true, this.app);
            if (!this.floppySession.startRedirection(string, n, bl, string2, string3)) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_17_IUSBREDIR"));
                this.StopFloppyRedir();
                return false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_18_IUSBREDIR"));
            this.StopFloppyRedir();
            return false;
        }
        catch (RedirectionException redirectionException) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_19_IUSBREDIR") + redirectionException.getMessage());
            this.StopFloppyRedir();
            return false;
        }
        this.floppyRedirStatus = 1;
        return true;
    }

    public boolean StopFloppyRedir() {
        if (this.floppySession != null) {
            if (!this.floppySession.stopRedirection()) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_20_IUSBREDIR"));
                return false;
            }
            this.floppySession = null;
            System.gc();
        }
        this.floppyRedirStatus = 0;
        return true;
    }

    public boolean sendTransferCmdCDROM() {
        if (this.cdromSession == null) {
            return false;
        }
        try {
            this.cdromSession.sendTransferCmd();
        }
        catch (RedirectionException redirectionException) {
            Debug.out.println("Exception while sending Transfer cmd to cdserver");
            return false;
        }
        catch (IOException iOException) {
            Debug.out.println("Exception while sending Transfer cmd to cdserver");
            return false;
        }
        this.cdromRedirStatus = 2;
        return true;
    }

    public boolean sendTransferCmdFloppy() {
        if (this.floppySession == null) {
            return false;
        }
        try {
            this.floppySession.sendTransferCmd();
        }
        catch (RedirectionException redirectionException) {
            Debug.out.println("Exception while sending Transfer cmd to fdserver");
            return false;
        }
        catch (IOException iOException) {
            Debug.out.println("Exception while sending Transfer cmd to fdserver");
            return false;
        }
        this.floppyRedirStatus = 2;
        return true;
    }

    public boolean StartFloppyImageRedir(String string, int n, boolean bl, String string2, String string3) {
        if (string == null) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_21_IUSBREDIR"));
            return false;
        }
        if (string3.length() == 0) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_22_IUSBREDIR"));
            return false;
        }
        try {
            if (this.floppySession != null) {
                if (this.floppySession.isRedirActive()) {
                    this.app.generalErrorMessage(LocaleStrings.GetString("6_23_IUSBREDIR"));
                    return false;
                }
                this.floppySession = null;
                System.gc();
            }
            this.floppySession = new FloppyRedir(false, this.app);
            if (!this.floppySession.startRedirection(string, n, bl, string2, string3)) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_24_IUSBREDIR"));
                this.StopFloppyImageRedir();
                return false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_25_IUSBREDIR"));
            this.StopFloppyImageRedir();
            return false;
        }
        catch (RedirectionException redirectionException) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_26_IUSBREDIR") + redirectionException.getMessage());
            this.StopFloppyImageRedir();
            return false;
        }
        this.floppyRedirStatus = 1;
        return true;
    }

    public boolean StopFloppyImageRedir() {
        return this.StopFloppyRedir();
    }

    public String getLIBCDROMVersion() {
        String string;
        try {
            if (this.cdromSession == null) {
                this.cdromSession = new CDROMRedir(false, this.app);
                string = this.cdromSession.getLIBCDROMVersion();
                this.cdromSession = null;
                System.gc();
            } else {
                string = this.cdromSession.getLIBCDROMVersion();
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            string = "Not present";
        }
        return string;
    }

    public String promptCDROM(String[] stringArray) {
        JFrame jFrame = this.app.getFrame();
        return (String)JListDialog.showDialog(jFrame, jFrame, LocaleStrings.GetString("6_27_IUSBREDIR"), LocaleStrings.GetString("6_28_IUSBREDIR"), stringArray, null);
    }

    public String isoImageSelector() {
        JFrame jFrame = this.app.getFrame();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new IsoImageFilter());
        if (jFileChooser.showOpenDialog(jFrame) == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public String getLIBFLOPPYVersion() {
        String string;
        try {
            if (this.floppySession == null) {
                this.floppySession = new FloppyRedir(false, this.app);
                string = this.floppySession.getLIBFLOPPYVersion();
                this.floppySession = null;
                System.gc();
            } else {
                string = this.floppySession.getLIBFLOPPYVersion();
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            string = "Not present";
        }
        return string;
    }

    public String promptFloppy(String[] stringArray) {
        JFrame jFrame = this.app.getFrame();
        return (String)JListDialog.showDialog(jFrame, jFrame, LocaleStrings.GetString("6_29_IUSBREDIR"), LocaleStrings.GetString("6_30_IUSBREDIR"), LocaleStrings.GetString("6_31_IUSBREDIR"), stringArray, null);
    }

    public String floppyImageSelector() {
        JFrame jFrame = this.app.getFrame();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FloppyImageFilter());
        if (jFileChooser.showOpenDialog(jFrame) == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public int getCDROMRedirStatus() {
        return this.cdromRedirStatus;
    }

    public int getFloppyRedirStatus() {
        return this.floppyRedirStatus;
    }

    public String getCDROMSource() {
        if (this.cdromSession != null) {
            return this.cdromSession.getSourceDrive();
        }
        return new String("");
    }

    public String getFloppySource() {
        if (this.floppySession != null) {
            return this.floppySession.getSourceDrive();
        }
        return new String("");
    }

    public void stopCDROMAbnormal() {
        this.cdromSession = null;
        System.gc();
        this.cdromRedirStatus = 0;
    }

    public void stopFloppyAbnormal() {
        this.floppySession = null;
        System.gc();
        this.floppyRedirStatus = 0;
    }

    public int getCDROMReadBytes() {
        if (this.cdromSession != null) {
            return this.cdromSession.getBytesRedirected();
        }
        return 0;
    }

    public int getFloppyReadBytes() {
        if (this.floppySession != null) {
            return this.floppySession.getBytesRedirected();
        }
        return 0;
    }

    public boolean simpleStartCDROMRedir(String string, String string2, String string3) {
        return this.StartCDROMRedir(string, 5120, false, string2, string3);
    }

    public boolean simpleStartISORedir(String string, String string2, String string3) {
        return this.StartISORedir(string, 5120, false, string2, string3);
    }

    public boolean simpleStartFloppyRedir(String string, String string2, String string3) {
        return this.StartFloppyRedir(string, 5123, false, string2, string3);
    }

    public boolean simpleStartFloppyImageRedir(String string, String string2, String string3) {
        return this.StartFloppyImageRedir(string, 5123, false, string2, string3);
    }

    class FloppyImageFilter
    extends FileFilter {
        FloppyImageFilter() {
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            return string.endsWith(".img") || string.endsWith(".IMG") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.img";
        }
    }

    class IsoImageFilter
    extends FileFilter {
        IsoImageFilter() {
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            return string.endsWith(".iso") || string.endsWith(".ISO") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.iso";
        }
    }
}

