/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.RedirProtocolException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.IUSBHeader;
import com.ami.iusb.protocol.RedirPacket;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public final class IUSBSCSI
extends RedirPacket {
    public int opcode;
    public int connectionStatus = -1;
    public int dataLen;
    private boolean packetRead = false;
    public ByteBuffer data;
    private boolean preBuffered;
    public static final int IUSB_SCSI_PKT_SIZE = 62;
    public String m_otherIP;

    public IUSBSCSI(IUSBHeader iUSBHeader) {
        this.header = iUSBHeader;
        this.dataLen = (int)iUSBHeader.dataPacketLen;
    }

    public IUSBSCSI(ByteBuffer byteBuffer, boolean bl) throws RedirProtocolException {
        this.preBuffered = bl;
        this.header = new IUSBHeader();
        this.header.read(byteBuffer);
        ((IUSBHeader)this.header).dataPacketLen = byteBuffer.limit() - this.header.headerLen;
        this.dataLen = (int)((IUSBHeader)this.header).dataPacketLen;
        this.data = byteBuffer.slice();
    }

    @Override
    public void writePacket(ByteBuffer byteBuffer) {
        ((IUSBHeader)this.header).direction = 128;
        this.header.write(byteBuffer);
        if (this.preBuffered) {
            byteBuffer.limit(this.dataLen + 32);
            byteBuffer.position(byteBuffer.limit());
        } else {
            byteBuffer.put(this.data);
        }
    }

    @Override
    public void readPacket(ByteBuffer byteBuffer) throws RedirectionException, BufferUnderflowException {
        this.header.read(byteBuffer);
        this.readData(byteBuffer);
    }

    @Override
    public void readData(ByteBuffer byteBuffer) throws BufferUnderflowException {
        byte[] byArray = new byte[24];
        this.data = ByteBuffer.allocate(this.dataLen);
        if (byteBuffer.remaining() < this.dataLen) {
            throw new BufferUnderflowException();
        }
        this.data.put(byteBuffer);
        this.opcode = this.data.get(9) & 0xFF;
        if (this.opcode == 241 && this.dataLen > 30) {
            this.connectionStatus = this.data.get(30);
            try {
                this.data.position(31);
                this.data.get(byArray);
                this.m_otherIP = new String(byArray).trim();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                System.err.println(bufferUnderflowException.getMessage());
                this.m_otherIP = new String("");
                throw new BufferUnderflowException();
            }
        } else {
            this.connectionStatus = -1;
        }
    }
}

