/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.EncryptionException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.RedirHeader;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public abstract class RedirPacket {
    public RedirHeader header;
    protected boolean encrypted = false;
    protected Cipher packetCipher;
    protected SecretKeySpec encryptionKey;

    protected RedirPacket() {
    }

    public void setEncryptionMethod(Cipher cipher, SecretKeySpec secretKeySpec) throws EncryptionException {
        try {
            this.encrypted = true;
            this.packetCipher = cipher;
            this.encryptionKey = secretKeySpec;
            cipher.init(1, secretKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            this.encrypted = false;
            throw new EncryptionException(LocaleStrings.GetString("9_1_IUSBREDIR"));
        }
    }

    protected void encryptData(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) throws EncryptionException {
        int n2 = byteBuffer.limit() - this.header.headerLen - n;
        try {
            this.packetCipher.init(1, this.encryptionKey);
            byteBuffer.limit(this.header.headerLen + n);
            byteBuffer2.put(byteBuffer);
            byteBuffer.limit(byteBuffer.capacity());
            this.packetCipher.doFinal(byteBuffer, byteBuffer2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new EncryptionException(LocaleStrings.GetString("9_1_IUSBREDIR"));
        }
        catch (ShortBufferException shortBufferException) {
            throw new EncryptionException(shortBufferException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new EncryptionException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new EncryptionException(badPaddingException.getMessage());
        }
    }

    protected void encryptData(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws EncryptionException {
        this.encryptData(byteBuffer, byteBuffer2, 0);
    }

    public int getPacketStatus() {
        return this.header.status;
    }

    public abstract void writePacket(ByteBuffer var1) throws EncryptionException;

    public abstract void readPacket(ByteBuffer var1) throws RedirectionException, BufferUnderflowException;

    public abstract void readData(ByteBuffer var1) throws BufferUnderflowException;
}

