/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.communication;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLWrapper {
    private SSLEngine engine;
    private SSLSession session;
    private ByteBuffer netIn;
    private ByteBuffer netOut;
    private ByteBuffer appIn;
    private ByteBuffer appOut;
    private SSLEngineResult.HandshakeStatus hsStatus;
    public SocketChannel m_SocketChannel;
    public boolean m_IsSSLInited;

    public SSLWrapper(SocketChannel socketChannel) {
        this.m_SocketChannel = socketChannel;
        this.m_IsSSLInited = false;
        this.session = null;
    }

    public int setupBuffers() {
        int n = 4500000;
        if (this.session != null) {
            this.appIn = ByteBuffer.allocateDirect(n);
            this.appOut = ByteBuffer.allocateDirect(5000);
            this.netIn = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.netOut = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.netIn.order(ByteOrder.LITTLE_ENDIAN);
            this.netOut.order(ByteOrder.LITTLE_ENDIAN);
            Debug.out.println("Allocating SSL network buffers and application buffers");
            Debug.out.println("Allocated netOut buffer of " + this.netOut.capacity() + " bytes");
            Debug.out.println("Allocated appOut buffer of " + this.appOut.capacity() + " bytes");
            Debug.out.println("Allocated netIn buffer of " + this.netIn.capacity() + " bytes");
            Debug.out.println("Allocated appIn buffer of " + this.appIn.capacity() + " bytes");
            return 0;
        }
        return -1;
    }

    public String GetDefaultTrustCertKeyStore_User() {
        String string = System.getProperty("deployment.user.security.trusted.certs");
        if (string == null) {
            String string2 = System.getProperty("os.name");
            String string3 = "";
            if (string2.indexOf("Windows") > -1) {
                string3 = "\\Application Data\\Sun\\Java\\Deployment\\security\\trusted.certs";
            } else if (string2.indexOf("Linux") > -1) {
                string3 = ".java/deployment/security/trusted.certs";
            }
            String string4 = System.getProperty("user.home");
            string = string4 + string3;
        }
        return string;
    }

    public String initSSL() throws IOException {
        Object object;
        SSLContext sSLContext = null;
        try {
            object = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            SSLContext sSLContext2 = SSLContext.getInstance("SSL");
            sSLContext2.init(null, (TrustManager[])object, new SecureRandom());
            sSLContext = sSLContext2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return new String(LocaleStrings.GetString("3_1_SSLWRAPPER") + noSuchAlgorithmException.getMessage());
        }
        catch (KeyManagementException keyManagementException) {
            return new String(LocaleStrings.GetString("3_2_SSLWRAPPER") + keyManagementException.getMessage());
        }
        this.engine = sSLContext.createSSLEngine();
        this.engine.setUseClientMode(true);
        this.session = this.engine.getSession();
        if (this.setupBuffers() != 0) {
            return new String(LocaleStrings.GetString("3_3_SSLWRAPPER"));
        }
        try {
            this.engine.beginHandshake();
            while (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    this.netOut.clear();
                    this.engine.wrap(this.appOut, this.netOut);
                    this.netOut.flip();
                    this.m_SocketChannel.write(this.netOut);
                    continue;
                }
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    if (this.netIn.position() == 0) {
                        this.m_SocketChannel.read(this.netIn);
                    }
                    this.netIn.flip();
                    this.engine.unwrap(this.netIn, this.appIn);
                    this.netIn.compact();
                    continue;
                }
                if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                while ((object = this.engine.getDelegatedTask()) != null) {
                    object.run();
                }
            }
        }
        catch (SSLException sSLException) {
            return new String(LocaleStrings.GetString("3_4_SSLWRAPPER"));
        }
        Debug.out.println("Handshaking is complete!");
        if (this.netIn.position() != 0) {
            Debug.out.println("Extra data along with handshake data " + this.netIn.position());
            this.resetReadBuffer();
            this.decryptData();
        } else {
            this.appIn.position(0);
            this.appIn.limit(0);
        }
        return null;
    }

    public void resetReadBuffer() {
        this.appIn.clear();
    }

    private int decryptData() throws IOException {
        int n = 0;
        if (this.engine != null) {
            boolean bl = false;
            SSLEngineResult sSLEngineResult = null;
            while (!bl) {
                this.netIn.flip();
                sSLEngineResult = this.engine.unwrap(this.netIn, this.appIn);
                this.netIn.compact();
                if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    bl = true;
                } else if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                    if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        this.executeDelegatedTask(this.engine);
                    }
                } else if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    Debug.out.println("unwrap returned BUFFER_OVERFLOW. Need to allocate more memory for appIn");
                } else {
                    throw new IOException(LocaleStrings.GetString("3_5_SSLWRAPPER"));
                }
                if (this.netIn.position() != 0) continue;
                bl = true;
            }
            this.appIn.flip();
        }
        return n;
    }

    public int read() throws IOException {
        this.m_SocketChannel.read(this.netIn);
        return this.decryptData();
    }

    public int GetBytes(ByteBuffer byteBuffer) throws IOException {
        int n = this.appIn.remaining();
        int n2 = byteBuffer.remaining();
        int n3 = this.appIn.limit();
        if (n > n2) {
            this.appIn.limit(this.appIn.position() + n2);
        }
        try {
            byteBuffer.put(this.appIn);
        }
        catch (BufferOverflowException bufferOverflowException) {
            System.out.println("CARE TAKEN TO AVOID THIS EXCEPTION. THIS EXCEPTION SHOULD NOT COME.");
        }
        if (n > n2) {
            this.appIn.limit(n3);
        }
        return n > n2 ? n2 : n;
    }

    public int GetBytesRemaining() {
        return this.appIn.remaining();
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        this.appOut.clear();
        this.netOut.clear();
        if (this.engine != null) {
            while (byteBuffer.hasRemaining()) {
                this.netOut.clear();
                SSLEngineResult sSLEngineResult = this.engine.wrap(byteBuffer, this.netOut);
                this.netOut.flip();
                while (this.netOut.hasRemaining() && this.m_SocketChannel.write(this.netOut) != -1) {
                }
            }
        } else {
            while (this.netOut.hasRemaining() && this.m_SocketChannel.write(this.netOut) != -1) {
            }
        }
        return 0;
    }

    public SSLEngineResult.HandshakeStatus executeDelegatedTask(SSLEngine sSLEngine) {
        Runnable runnable;
        while ((runnable = sSLEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return sSLEngine.getHandshakeStatus();
    }
}

