/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.FSFrame;
import com.ami.kvm.jviewer.gui.FSMenu;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class FSMenuBar
extends JDialog {
    JViewerApp app;
    FSFrame m_frame;
    FSMenu m_fsMenu;
    JPopupMenu m_popupMenu;
    MouseEnterExit m_msEE;
    ButtonListener m_btnListener;
    private int m_slide = 0;
    private Timer m_timer;
    private boolean m_show;
    private JLabel m_idLbl;
    private JButton m_menuBtn;
    private JPanel m_autoPanel;
    private JButton m_autoPin;
    private JButton m_autoUnpin;
    private boolean m_auto;
    private JButton m_close;
    private JButton m_min;
    private JButton m_restore;

    public FSMenuBar(FSFrame fSFrame, JViewerApp jViewerApp) {
        super(fSFrame);
        this.app = jViewerApp;
        this.m_frame = fSFrame;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(dimension.width / 2 - 200, 0, 400, this.m_slide);
        this.setUndecorated(true);
        this.setResizable(false);
        this.m_msEE = new MouseEnterExit();
        this.addMouseListener(this.m_msEE);
        this.addMouseListener(new WindowMouseEvents());
        this.m_btnListener = new ButtonListener();
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setBackground(new Color(250, 250, 250));
        jComponent.setLayout(new BoxLayout(jComponent, 0));
        jComponent.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_autoPin = this.createButton("res/pin.jpg", LocaleStrings.GetString("B_1_FMB"), "Pin");
        this.m_autoUnpin = this.createButton("res/unpin.jpg", LocaleStrings.GetString("B_1_FMB"), "Unpin");
        this.m_autoPanel = new JPanel();
        this.m_autoPanel.setLayout(new BoxLayout(this.m_autoPanel, 0));
        this.m_autoPanel.setPreferredSize(new Dimension(15, 15));
        this.m_autoPanel.setMaximumSize(new Dimension(15, 15));
        this.m_autoPanel.add(this.m_autoPin);
        this.m_auto = false;
        jComponent.add(this.m_autoPanel);
        jComponent.add(Box.createRigidArea(new Dimension(50, 0)));
        this.m_menuBtn = this.createButton("res/menu.jpg", LocaleStrings.GetString("B_2_FMB"), "Menu");
        this.m_fsMenu = new FSMenu(jViewerApp);
        this.m_popupMenu = this.m_fsMenu.getPopupMenu();
        this.m_popupMenu.addPopupMenuListener(new PopupMenuEventListener());
        this.m_menuBtn.addMouseListener(new PopupListener());
        jComponent.add(this.m_menuBtn);
        jComponent.add(Box.createRigidArea(new Dimension(65, 0)));
        this.m_idLbl = new JLabel(LocaleStrings.GetString("B_3_FMB"));
        this.m_idLbl.setForeground(new Color(0, 100, 100));
        this.m_idLbl.setFont(new Font("SansSerif", 0, 12));
        this.m_idLbl.setPreferredSize(new Dimension(150, 15));
        this.m_idLbl.setMaximumSize(new Dimension(150, 15));
        jComponent.add(this.m_idLbl);
        jComponent.add(Box.createRigidArea(new Dimension(48, 0)));
        this.m_min = this.createButton("res/min.jpg", LocaleStrings.GetString("B_4_FMB"), "Minimize");
        jComponent.add(this.m_min);
        jComponent.add(Box.createRigidArea(new Dimension(1, 0)));
        this.m_restore = this.createButton("res/max.jpg", LocaleStrings.GetString("B_5_FMB"), "ToFrame");
        jComponent.add(this.m_restore);
        jComponent.add(Box.createRigidArea(new Dimension(1, 0)));
        this.m_close = this.createButton("res/close.jpg", LocaleStrings.GetString("B_6_FMB"), "Close");
        jComponent.add(this.m_close);
        jComponent.add(Box.createHorizontalGlue());
    }

    public JVMenu getFSMenu() {
        return this.m_fsMenu;
    }

    public void showMenu() {
        this.m_show = true;
        this.m_timer = new Timer();
        this.m_timer.schedule((TimerTask)new SlideTask(), 0L, 20L);
        if (this.app.isPanelMode()) {
            this.m_close.setVisible(false);
            this.m_min.setVisible(false);
        } else {
            this.m_close.setVisible(true);
            this.m_min.setVisible(true);
        }
    }

    public void hideMenu() {
        this.m_show = false;
        this.m_timer = new Timer();
        this.m_timer.schedule((TimerTask)new SlideTask(), 0L, 20L);
    }

    public void setIDLabel(String string) {
        this.m_idLbl.setText(string);
    }

    private void slide() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(dimension.width / 2 - 200, 0, 400, this.m_slide);
        this.setVisible(true);
    }

    private JButton createButton(String string, String string2, String string3) {
        URL uRL = JViewer.class.getResource(string);
        JButton jButton = new JButton();
        if (uRL != null) {
            jButton.setIcon(new ImageIcon(uRL));
        }
        jButton.setToolTipText(string2);
        jButton.setPreferredSize(new Dimension(15, 15));
        jButton.setMaximumSize(new Dimension(15, 15));
        jButton.addMouseListener(this.m_msEE);
        jButton.setActionCommand(string3);
        jButton.addActionListener(this.m_btnListener);
        return jButton;
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JViewerApp jViewerApp = FSMenuBar.this.app;
            String string = actionEvent.getActionCommand();
            if (string.equals("Unpin")) {
                Debug.out.println("Disable Auto hide");
                FSMenuBar.this.m_autoPanel.removeAll();
                FSMenuBar.this.m_autoPanel.add(FSMenuBar.this.m_autoPin);
                FSMenuBar.this.m_autoPanel.repaint();
                FSMenuBar.this.m_auto = false;
                FSMenuBar.this.app.getRCView().requestFocus();
            } else if (string.equals("Pin")) {
                Debug.out.println("Enable Auto hide");
                FSMenuBar.this.m_autoPanel.removeAll();
                FSMenuBar.this.m_autoPanel.add(FSMenuBar.this.m_autoUnpin);
                FSMenuBar.this.m_auto = true;
                FSMenuBar.this.app.getRCView().requestFocus();
            } else if (string.equals("ToFrame")) {
                Debug.out.println("Toggle to frame window");
                FSMenuBar.this.m_auto = false;
                jViewerApp.OnVideoFullScreen(false);
            } else if (string.equals("Minimize")) {
                Debug.out.println("Minimize");
                FSMenuBar.this.m_frame.setState(1);
            } else if (string.equals("Close")) {
                Debug.out.println("Close");
                jViewerApp.OnVideoExit();
            } else if (string.equals("Menu")) {
                Debug.out.println("Menu");
            } else {
                FSMenuBar.this.app.getRCView().requestFocus();
            }
        }
    }

    class PopupMenuEventListener
    implements PopupMenuListener {
        boolean m_autoCanceled = false;

        PopupMenuEventListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            Debug.out.println("Popup canceled");
            if (this.m_autoCanceled) {
                FSMenuBar.this.m_auto = true;
                this.m_autoCanceled = false;
                FSMenuBar.this.hideMenu();
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Debug.out.println("Popup visible");
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_auto = false;
                this.m_autoCanceled = true;
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            Debug.out.println("Popup invisible");
            if (this.m_autoCanceled) {
                FSMenuBar.this.m_auto = true;
                this.m_autoCanceled = false;
                FSMenuBar.this.hideMenu();
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Debug.out.println("Popup event");
            FSMenuBar.this.m_popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class MouseEnterExit
    extends MouseAdapter {
        MouseEnterExit() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_timer.cancel();
                FSMenuBar.this.showMenu();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_timer.cancel();
                FSMenuBar.this.hideMenu();
            }
        }
    }

    class WindowMouseEvents
    extends MouseAdapter {
        WindowMouseEvents() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            FSMenuBar.this.app.getRCView().requestFocus();
        }
    }

    class SlideTask
    extends TimerTask {
        SlideTask() {
        }

        @Override
        public void run() {
            if (FSMenuBar.this.m_show) {
                if (FSMenuBar.this.m_slide < 20) {
                    FSMenuBar.this.m_slide++;
                    FSMenuBar.this.slide();
                } else {
                    FSMenuBar.this.m_timer.cancel();
                    FSMenuBar.this.app.getRCView().requestFocus();
                }
            } else if (FSMenuBar.this.m_slide > 1) {
                FSMenuBar.this.m_slide--;
                FSMenuBar.this.slide();
            } else {
                FSMenuBar.this.m_timer.cancel();
                FSMenuBar.this.app.getRCView().requestFocus();
            }
        }
    }
}

