/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public abstract class JVMenu {
    public JViewerApp app;
    JMenuItem menuItemMouseModeAbsolute;
    JMenuItem menuItemMouseModeRelative;
    public static final String VIDEO_FULL_SCREEN = "VideoFullScreen";
    public static final String VIDEO_EXIT = "VideoExit";
    public static final String VIDEO_PAUSE = "PauseVideo";
    public static final String VIDEO_RESUME = "ResumeVideo";
    public static final String VIDEO_REFRESH = "RefreshVideo";
    public static final String VIDEO_CAPTURE = "VideoCapture";
    public static final String KEYBOARD_RIGHT_ALT_KEY = "KeyboardHoldRightAltKey";
    public static final String KEYBOARD_LEFT_ALT_KEY = "KeyboardHoldLeftAltKey";
    public static final String KEYBOARD_LEFT_WINKEY_PRESSHOLD = "KeyboardLeftWindowsKeyHoldDown";
    public static final String KEYBOARD_LEFT_WINKEY_PRESSRELEASE = "KeyboardLeftWindowsKeyPressRelease";
    public static final String KEYBOARD_RIGHT_WINKEY_PRESSHOLD = "KeyboardRightWindowsKeyHoldDown";
    public static final String KEYBOARD_RIGHT_WINKEY_PRESSRELEASE = "KeyboardRightWindowsKeyPressRelease";
    public static final String KEYBOARD_CTRL_ALT_DEL = "KeyboardAltCtrlDel";
    public static final String KEYBOARD_ALT_TAB = "KeyboardAltTab";
    public static final String KEYBOARD_ALT_ESC = "KeyboardAltEsc";
    public static final String KEYBOARD_CTRL_ESC = "KeyboardCtrlEsc";
    public static final String KEYBOARD_ALT_SPACE = "KeyboardAltSpace";
    public static final String KEYBOARD_ALT_ENTER = "KeyboardAltEnter";
    public static final String KEYBOARD_ALT_HYPHEN = "KeyboardAltHyphen";
    public static final String KEYBOARD_ALT_F4 = "KeyboardAltF4";
    public static final String KEYBOARD_ALT_PRNTSCRN = "KeyboardAltPrntScrn";
    public static final String KEYBOARD_PRNTSCRN = "KeyboardPrntScrn";
    public static final String KEYBOARD_F1 = "KeyboardF1";
    public static final String KEYBOARD_PAUSE = "KeyboardPause";
    public static final String KEYBOARD_FULL_KEYBOARD = "KeyboardFullKeyboard";
    public static final String KEYBOARD_SOFT_KEYBOARD = "KeyboardSoftKeyboard";
    public static final String MOUSE_SYNC_CURSOR = "MouseSyncCursor";
    public static final String MOUSE_SHOW_CURSOR = "MouseShowCursor";
    public static final String MOUSE_MODE_ABSOLUTE = "MouseModeAbsolute";
    public static final String MOUSE_MODE_RELATIVE = "MouseModeRelative";
    public static final String DEVICE_MEDIA_DIALOG = "DeviceMediaDialog";
    public static final String OPTIONS_COLORMODE_15BIT = "15-Bit";
    public static final String OPTIONS_COLORMODE_7BIT = "7-Bit";
    public static final String OPTIONS_COLORMODE_4BIT_COLOR = "4-Bit color";
    public static final String OPTIONS_COLORMODE_4BIT_GREY = "4-Bit grey";
    public static final String OPTIONS_COLORMODE_3BIT_GREY = "3-Bit grey";
    public static final String HELP_ABOUT_RCONSOLE = "HelpAboutJViewer";
    protected static JVMenuListener m_menuListener;
    protected static JVMenuStatusListener m_menuStatus;
    protected static JVMenuItemStatusListener m_itemStatus;
    protected Hashtable<String, JMenuItem> m_menuItems;
    protected static boolean m_stateRedir;
    protected static boolean m_stateFullScr;
    protected static boolean m_stateRAlt;
    protected static boolean m_stateLAlt;
    protected static boolean m_stateRWinDown;
    protected static boolean m_stateLWinDown;
    protected static boolean m_stateMouseRedir;
    protected static boolean m_stateShowCursor;
    protected static byte m_stateColorMode;

    public JVMenu(JViewerApp jViewerApp) {
        this.app = jViewerApp;
        m_menuListener = new JVMenuListener(jViewerApp);
        m_menuStatus = new JVMenuStatusListener(jViewerApp);
        m_itemStatus = new JVMenuItemStatusListener(jViewerApp);
        this.m_menuItems = new Hashtable();
    }

    public JMenuItem getMenuItem(String string) {
        return this.m_menuItems.get(string);
    }

    public void notifyFullScreen(boolean bl) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(VIDEO_FULL_SCREEN).setSelected(bl);
            m_stateFullScr = bl;
        }
    }

    public void notifyRAlt(boolean bl) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(KEYBOARD_RIGHT_ALT_KEY).setSelected(bl);
            m_stateRAlt = bl;
        }
    }

    public void notifyLAlt(boolean bl) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(KEYBOARD_LEFT_ALT_KEY).setSelected(bl);
            m_stateLAlt = bl;
        }
    }

    public void notifyRWinDown(boolean bl) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(KEYBOARD_RIGHT_WINKEY_PRESSHOLD).setSelected(bl);
            m_stateRWinDown = bl;
        }
    }

    public void notifyLWinDown(boolean bl) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(KEYBOARD_LEFT_WINKEY_PRESSHOLD).setSelected(bl);
            m_stateLWinDown = bl;
        }
    }

    public void notifyMouseRedir(boolean bl) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(MOUSE_SYNC_CURSOR).setSelected(bl);
            m_stateMouseRedir = bl;
        }
    }

    public void notifyColorMode(byte by) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            if (by == 8) {
                this.getMenuItem(OPTIONS_COLORMODE_15BIT).setSelected(true);
            } else if (by == 9) {
                this.getMenuItem(OPTIONS_COLORMODE_7BIT).setSelected(true);
            } else if (by == 10) {
                this.getMenuItem(OPTIONS_COLORMODE_4BIT_COLOR).setSelected(true);
            } else if (by == 3) {
                this.getMenuItem(OPTIONS_COLORMODE_4BIT_GREY).setSelected(true);
            } else if (by == 2) {
                this.getMenuItem(OPTIONS_COLORMODE_3BIT_GREY).setSelected(true);
            }
            m_stateColorMode = by;
        }
    }

    public void notifyShowCursor(boolean bl) {
        if (bl) {
            this.getMenuItem(MOUSE_SHOW_CURSOR).setSelected(false);
        } else {
            this.getMenuItem(MOUSE_SHOW_CURSOR).setSelected(true);
        }
    }

    public void refreshMenu() {
        this.notifyFullScreen(m_stateFullScr);
        this.notifyRAlt(m_stateRAlt);
        this.notifyLAlt(m_stateLAlt);
        this.notifyRWinDown(m_stateRWinDown);
        this.notifyLWinDown(m_stateLWinDown);
        this.notifyMouseRedir(m_stateMouseRedir);
        this.notifyColorMode(m_stateColorMode);
        this.notifyShowCursor(!JViewerApp.showCursor);
    }

    protected JMenu constructVideoMenu() {
        JMenu jMenu = new JMenu(LocaleStrings.GetString("F_1_JVM"));
        jMenu.addMouseListener(m_menuStatus);
        jMenu.setMnemonic('V');
        JMenuItem jMenuItem = new JMenuItem(LocaleStrings.GetString("F_2_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(VIDEO_PAUSE);
        jMenuItem.setMnemonic('P');
        jMenu.add(jMenuItem);
        this.m_menuItems.put(VIDEO_PAUSE, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_3_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(VIDEO_RESUME);
        jMenuItem.setMnemonic('R');
        jMenu.add(jMenuItem);
        this.m_menuItems.put(VIDEO_RESUME, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_4_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(VIDEO_REFRESH);
        jMenuItem.setMnemonic('s');
        jMenu.add(jMenuItem);
        this.m_menuItems.put(VIDEO_REFRESH, jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_5_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(VIDEO_CAPTURE);
        jMenuItem.setMnemonic('C');
        jMenu.add(jMenuItem);
        this.m_menuItems.put(VIDEO_CAPTURE, jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_6_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setMnemonic('F');
        jMenuItem.setActionCommand(VIDEO_FULL_SCREEN);
        jMenu.add(jMenuItem);
        this.m_menuItems.put(VIDEO_FULL_SCREEN, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_7_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(VIDEO_EXIT);
        jMenuItem.setMnemonic('E');
        this.m_menuItems.put(VIDEO_EXIT, jMenuItem);
        return jMenu;
    }

    protected JMenu constructKeyboardMenu() {
        JMenu jMenu = new JMenu(LocaleStrings.GetString("F_8_JVM"));
        jMenu.addMouseListener(m_menuStatus);
        jMenu.setMnemonic('K');
        JMenuItem jMenuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_9_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setMnemonic('A');
        jMenuItem.setActionCommand(KEYBOARD_RIGHT_ALT_KEY);
        jMenu.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_RIGHT_ALT_KEY, jMenuItem);
        jMenuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_10_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setMnemonic('l');
        jMenuItem.setActionCommand(KEYBOARD_LEFT_ALT_KEY);
        jMenu.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_LEFT_ALT_KEY, jMenuItem);
        JMenu jMenu2 = new JMenu(LocaleStrings.GetString("F_11_JVM"));
        jMenu2.addMouseListener(m_menuStatus);
        jMenuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_12_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_LEFT_WINKEY_PRESSHOLD);
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_LEFT_WINKEY_PRESSHOLD, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_13_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_LEFT_WINKEY_PRESSRELEASE);
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_LEFT_WINKEY_PRESSRELEASE, jMenuItem);
        jMenu.add(jMenu2);
        jMenu2 = new JMenu(LocaleStrings.GetString("F_14_JVM"));
        jMenu2.addMouseListener(m_menuStatus);
        jMenuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_12_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_RIGHT_WINKEY_PRESSHOLD);
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_RIGHT_WINKEY_PRESSHOLD, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_13_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_RIGHT_WINKEY_PRESSRELEASE);
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_RIGHT_WINKEY_PRESSRELEASE, jMenuItem);
        jMenu.add(jMenu2);
        jMenu2 = new JMenu(LocaleStrings.GetString("F_15_JVM"));
        jMenu2.setMnemonic('M');
        jMenu2.addMouseListener(m_itemStatus);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_16_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_CTRL_ALT_DEL);
        jMenuItem.setMnemonic('D');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_CTRL_ALT_DEL, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_17_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_ALT_TAB);
        jMenuItem.setMnemonic('T');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_ALT_TAB, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_18_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_ALT_ESC);
        jMenuItem.setMnemonic('E');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_ALT_ESC, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_19_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_CTRL_ESC);
        jMenuItem.setMnemonic('C');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_CTRL_ESC, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_20_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_ALT_SPACE);
        jMenuItem.setMnemonic('S');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_ALT_SPACE, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_21_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_ALT_ENTER);
        jMenuItem.setMnemonic('n');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_ALT_ENTER, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_22_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_ALT_HYPHEN);
        jMenuItem.setMnemonic('H');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_ALT_HYPHEN, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_23_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_ALT_F4);
        jMenuItem.setMnemonic('4');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_ALT_F4, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_24_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_ALT_PRNTSCRN);
        jMenuItem.setMnemonic('P');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_ALT_PRNTSCRN, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_25_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_PRNTSCRN);
        jMenuItem.setMnemonic('l');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_PRNTSCRN, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_26_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_F1);
        jMenuItem.setMnemonic('1');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_F1, jMenuItem);
        jMenuItem = new JMenuItem(LocaleStrings.GetString("F_27_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_PAUSE);
        jMenuItem.setMnemonic('u');
        jMenu2.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_PAUSE, jMenuItem);
        jMenu.add(jMenu2);
        jMenuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_28_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_FULL_KEYBOARD);
        jMenuItem.setMnemonic('K');
        jMenu.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_FULL_KEYBOARD, jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Soft Keyboard");
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(KEYBOARD_SOFT_KEYBOARD);
        jMenuItem.setMnemonic('S');
        jMenu.add(jMenuItem);
        this.m_menuItems.put(KEYBOARD_SOFT_KEYBOARD, jMenuItem);
        return jMenu;
    }

    protected JMenu constructMouseMenu() {
        JMenu jMenu = new JMenu(LocaleStrings.GetString("F_29_JVM"));
        jMenu.addMouseListener(m_menuStatus);
        jMenu.setMnemonic('u');
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_30_JVM"));
        jCheckBoxMenuItem.addActionListener(m_menuListener);
        jCheckBoxMenuItem.addMouseListener(m_itemStatus);
        jCheckBoxMenuItem.setActionCommand(MOUSE_SYNC_CURSOR);
        jCheckBoxMenuItem.setMnemonic('S');
        jMenu.add(jCheckBoxMenuItem);
        this.m_menuItems.put(MOUSE_SYNC_CURSOR, jCheckBoxMenuItem);
        jMenu.addSeparator();
        this.menuItemMouseModeAbsolute = new JRadioButtonMenuItem(LocaleStrings.GetString("F_SM_01_JVM"));
        this.menuItemMouseModeAbsolute.addActionListener(m_menuListener);
        this.menuItemMouseModeAbsolute.addMouseListener(m_itemStatus);
        this.menuItemMouseModeAbsolute.setActionCommand(MOUSE_MODE_ABSOLUTE);
        jMenu.add(this.menuItemMouseModeAbsolute);
        this.m_menuItems.put(MOUSE_MODE_ABSOLUTE, this.menuItemMouseModeAbsolute);
        this.menuItemMouseModeRelative = new JRadioButtonMenuItem(LocaleStrings.GetString("F_SM_02_JVM"));
        this.menuItemMouseModeRelative.addActionListener(m_menuListener);
        this.menuItemMouseModeRelative.addMouseListener(m_itemStatus);
        this.menuItemMouseModeRelative.setActionCommand(MOUSE_MODE_RELATIVE);
        jMenu.add(this.menuItemMouseModeRelative);
        this.m_menuItems.put(MOUSE_MODE_RELATIVE, this.menuItemMouseModeRelative);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.menuItemMouseModeAbsolute);
        buttonGroup.add(this.menuItemMouseModeRelative);
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Cursor");
        jCheckBoxMenuItem.addActionListener(m_menuListener);
        jCheckBoxMenuItem.addMouseListener(m_itemStatus);
        jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        jCheckBoxMenuItem.setActionCommand(MOUSE_SHOW_CURSOR);
        jMenu.add(jCheckBoxMenuItem);
        this.m_menuItems.put(MOUSE_SHOW_CURSOR, jCheckBoxMenuItem);
        return jMenu;
    }

    protected JMenu constructOptionsMenu() {
        JMenu jMenu = new JMenu(LocaleStrings.GetString("F_31_JVM"));
        jMenu.addMouseListener(m_menuStatus);
        jMenu.setMnemonic('O');
        JMenu jMenu2 = new JMenu(LocaleStrings.GetString("F_32_JVM"));
        jMenu2.addMouseListener(m_menuStatus);
        jMenu2.setMnemonic('C');
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(LocaleStrings.GetString("F_33_JVM"));
        jRadioButtonMenuItem.addActionListener(m_menuListener);
        jRadioButtonMenuItem.addMouseListener(m_itemStatus);
        jRadioButtonMenuItem.setActionCommand(OPTIONS_COLORMODE_15BIT);
        jRadioButtonMenuItem.setSelected(true);
        jRadioButtonMenuItem.setMnemonic('1');
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        this.m_menuItems.put(OPTIONS_COLORMODE_15BIT, jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(LocaleStrings.GetString("F_34_JVM"));
        jRadioButtonMenuItem.addActionListener(m_menuListener);
        jRadioButtonMenuItem.addMouseListener(m_itemStatus);
        jRadioButtonMenuItem.setActionCommand(OPTIONS_COLORMODE_7BIT);
        jRadioButtonMenuItem.setMnemonic('7');
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        this.m_menuItems.put(OPTIONS_COLORMODE_7BIT, jRadioButtonMenuItem);
        jMenu.add(jMenu2);
        return jMenu;
    }

    protected JMenu constructDeviceRedirMenu() {
        JMenu jMenu = new JMenu(LocaleStrings.GetString("F_38_JVM"));
        jMenu.addMouseListener(m_menuStatus);
        jMenu.setMnemonic('e');
        JMenuItem jMenuItem = new JMenuItem(LocaleStrings.GetString("F_39_JVM"));
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(DEVICE_MEDIA_DIALOG);
        jMenuItem.setMnemonic('V');
        jMenu.add(jMenuItem);
        this.m_menuItems.put(DEVICE_MEDIA_DIALOG, jMenuItem);
        return jMenu;
    }

    protected JMenu constructHelpMenu() {
        JMenu jMenu = new JMenu(LocaleStrings.GetString("F_40_JVM"));
        jMenu.setMnemonic('H');
        jMenu.addMouseListener(m_menuStatus);
        JMenuItem jMenuItem = new JMenuItem(LocaleStrings.GetString("F_41_JVM") + " " + LocaleStrings.GetString("A_1_GLOBAL") + "...");
        jMenuItem.addActionListener(m_menuListener);
        jMenuItem.addMouseListener(m_itemStatus);
        jMenuItem.setActionCommand(HELP_ABOUT_RCONSOLE);
        jMenuItem.setMnemonic('A');
        jMenu.add(jMenuItem);
        this.m_menuItems.put(HELP_ABOUT_RCONSOLE, jMenuItem);
        return jMenu;
    }

    public void setMouseMode(byte by) {
        switch (by) {
            case 2: {
                this.menuItemMouseModeAbsolute.setSelected(true);
                this.menuItemMouseModeRelative.setSelected(false);
                break;
            }
            case 1: {
                this.menuItemMouseModeAbsolute.setSelected(false);
                this.menuItemMouseModeRelative.setSelected(true);
                break;
            }
        }
    }

    static {
        m_stateRedir = false;
        m_stateFullScr = false;
        m_stateRAlt = false;
        m_stateLAlt = false;
        m_stateRWinDown = false;
        m_stateLWinDown = false;
        m_stateMouseRedir = false;
        m_stateShowCursor = false;
        m_stateColorMode = (byte)8;
    }

    class GridMenu
    extends JMenu {
        GridMenu(String string, int n, int n2) {
            super(string);
            JPopupMenu jPopupMenu = this.getPopupMenu();
            jPopupMenu.setLayout(new GridLayout(n, n2));
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void setPopupMenuVisible(boolean bl) {
            boolean bl2 = this.isPopupMenuVisible();
            if (bl != bl2) {
                if (bl && this.isShowing()) {
                    int n = this.getWidth();
                    int n2 = 0;
                    this.getPopupMenu().show(this, n, n2);
                } else {
                    this.getPopupMenu().setVisible(false);
                }
            }
        }
    }

    private static class JVMenuItemStatusListener
    extends MouseAdapter {
        JViewerApp app;

        public JVMenuItemStatusListener(JViewerApp jViewerApp) {
            this.app = jViewerApp;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            String string = ((JMenuItem)mouseEvent.getSource()).getActionCommand();
            if (string.equals(JVMenu.VIDEO_FULL_SCREEN)) {
                this.app.setStatus(LocaleStrings.GetString("F_47_JVM"));
            } else if (string.equals(JVMenu.VIDEO_EXIT)) {
                this.app.setStatus(LocaleStrings.GetString("F_7_JVM") + " " + LocaleStrings.GetString("A_1_GLOBAL"));
            } else if (string.equals(JVMenu.VIDEO_PAUSE)) {
                this.app.setStatus(LocaleStrings.GetString("F_48_JVM"));
            } else if (string.equals(JVMenu.VIDEO_RESUME)) {
                this.app.setStatus(LocaleStrings.GetString("F_49_JVM"));
            } else if (string.equals(JVMenu.VIDEO_REFRESH)) {
                this.app.setStatus(LocaleStrings.GetString("F_50_JVM"));
            } else if (string.equals(JVMenu.VIDEO_CAPTURE)) {
                this.app.setStatus(LocaleStrings.GetString("F_51_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_RIGHT_ALT_KEY)) {
                this.app.setStatus(LocaleStrings.GetString("F_52_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_LEFT_ALT_KEY)) {
                this.app.setStatus(LocaleStrings.GetString("F_53_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSHOLD)) {
                this.app.setStatus(LocaleStrings.GetString("F_54_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSRELEASE)) {
                this.app.setStatus(LocaleStrings.GetString("F_55_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSHOLD)) {
                this.app.setStatus(LocaleStrings.GetString("F_56_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSRELEASE)) {
                this.app.setStatus(LocaleStrings.GetString("F_57_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_CTRL_ALT_DEL)) {
                this.app.setStatus(LocaleStrings.GetString("F_58_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_ALT_TAB)) {
                this.app.setStatus(LocaleStrings.GetString("F_59_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_ALT_ESC)) {
                this.app.setStatus(LocaleStrings.GetString("F_60_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_CTRL_ESC)) {
                this.app.setStatus(LocaleStrings.GetString("F_61_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_ALT_SPACE)) {
                this.app.setStatus(LocaleStrings.GetString("F_62_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_ALT_ENTER)) {
                this.app.setStatus(LocaleStrings.GetString("F_63_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_ALT_HYPHEN)) {
                this.app.setStatus(LocaleStrings.GetString("F_64_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_ALT_F4)) {
                this.app.setStatus(LocaleStrings.GetString("F_65_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_ALT_PRNTSCRN)) {
                this.app.setStatus(LocaleStrings.GetString("F_66_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_PRNTSCRN)) {
                this.app.setStatus(LocaleStrings.GetString("F_67_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_F1)) {
                this.app.setStatus(LocaleStrings.GetString("F_68_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_PAUSE)) {
                this.app.setStatus(LocaleStrings.GetString("F_69_JVM"));
            } else if (string.equals(JVMenu.KEYBOARD_FULL_KEYBOARD)) {
                this.app.setStatus(LocaleStrings.GetString("F_70_JVM"));
            } else if (string.equals(JVMenu.MOUSE_SYNC_CURSOR)) {
                this.app.setStatus(LocaleStrings.GetString("F_71_JVM"));
            } else if (string.equals(JVMenu.OPTIONS_COLORMODE_15BIT)) {
                this.app.setStatus(LocaleStrings.GetString("F_82_JVM"));
            } else if (string.equals(JVMenu.OPTIONS_COLORMODE_7BIT)) {
                this.app.setStatus(LocaleStrings.GetString("F_83_JVM"));
            } else if (string.equals(JVMenu.OPTIONS_COLORMODE_4BIT_COLOR)) {
                this.app.setStatus(LocaleStrings.GetString("F_84_JVM"));
            } else if (string.equals(JVMenu.OPTIONS_COLORMODE_4BIT_GREY)) {
                this.app.setStatus(LocaleStrings.GetString("F_85_JVM"));
            } else if (string.equals(JVMenu.OPTIONS_COLORMODE_3BIT_GREY)) {
                this.app.setStatus(LocaleStrings.GetString("F_86_JVM"));
            } else if (string.equals(JVMenu.DEVICE_MEDIA_DIALOG)) {
                this.app.setStatus(LocaleStrings.GetString("F_80_JVM"));
            } else if (string.equals(JVMenu.HELP_ABOUT_RCONSOLE)) {
                this.app.setStatus(LocaleStrings.GetString("F_41_JVM") + " " + LocaleStrings.GetString("A_1_GLOBAL"));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.app.resetStatus();
        }
    }

    private static class JVMenuStatusListener
    extends MouseAdapter {
        JViewerApp app;

        public JVMenuStatusListener(JViewerApp jViewerApp) {
            this.app = jViewerApp;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)mouseEvent.getSource();
            String string = jMenu.getText();
            if (string.equals(LocaleStrings.GetString("F_1_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_42_JVM"));
            } else if (string.equals(LocaleStrings.GetString("F_8_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_43_JVM"));
            } else if (string.equals(LocaleStrings.GetString("F_29_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_44_JVM"));
            } else if (string.equals(LocaleStrings.GetString("F_31_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_45_JVM"));
            } else if (string.equals(LocaleStrings.GetString("F_38_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_79_JVM"));
            } else if (string.equals(LocaleStrings.GetString("F_32_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_81_JVM"));
            } else if (string.equals(LocaleStrings.GetString("F_40_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_46_JVM"));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.app.resetStatus();
        }
    }

    private static class JVMenuListener
    implements ActionListener {
        JViewerApp app;

        public JVMenuListener(JViewerApp jViewerApp) {
            this.app = jViewerApp;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(JVMenu.VIDEO_FULL_SCREEN)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                this.app.OnVideoFullScreen(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.VIDEO_EXIT)) {
                this.app.OnVideoExit();
            } else if (string.equals(JVMenu.VIDEO_PAUSE)) {
                this.app.OnVideoPause();
            } else if (string.equals(JVMenu.VIDEO_RESUME)) {
                this.app.OnVideoResume();
            } else if (string.equals(JVMenu.VIDEO_REFRESH)) {
                this.app.OnVideoRefresh();
            } else if (string.equals(JVMenu.VIDEO_CAPTURE)) {
                this.app.OnVideoCapture();
            } else if (string.equals(JVMenu.KEYBOARD_RIGHT_ALT_KEY)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                this.app.OnKeyboardHoldRightAltKey(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.KEYBOARD_LEFT_ALT_KEY)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                this.app.OnKeyboardHoldLeftAltKey(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSHOLD)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                this.app.OnKeyboardLeftWindowsKeyHoldDown(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSRELEASE)) {
                this.app.OnKeyboardLeftWindowsKeyPressRelease();
            } else if (string.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSHOLD)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                this.app.OnKeyboardRightWindowsKeyHoldDown(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSRELEASE)) {
                this.app.OnKeyboardRightWindowsKeyPressRelease();
            } else if (string.equals(JVMenu.KEYBOARD_CTRL_ALT_DEL)) {
                this.app.OnKeyboardAltCtrlDel();
            } else if (string.equals(JVMenu.KEYBOARD_ALT_TAB)) {
                this.app.OnKeyboardAltTab();
            } else if (string.equals(JVMenu.KEYBOARD_ALT_ESC)) {
                this.app.OnKeyboardAltEsc();
            } else if (string.equals(JVMenu.KEYBOARD_CTRL_ESC)) {
                this.app.OnKeyboardCtrlEsc();
            } else if (string.equals(JVMenu.KEYBOARD_ALT_SPACE)) {
                this.app.OnKeyboardAltSpace();
            } else if (string.equals(JVMenu.KEYBOARD_ALT_ENTER)) {
                this.app.OnKeyboardAltEnter();
            } else if (string.equals(JVMenu.KEYBOARD_ALT_HYPHEN)) {
                this.app.OnKeyboardAltHyphen();
            } else if (string.equals(JVMenu.KEYBOARD_ALT_F4)) {
                this.app.OnKeyboardAltF4();
            } else if (string.equals(JVMenu.KEYBOARD_ALT_PRNTSCRN)) {
                this.app.OnKeyboardAltPrntScrn();
            } else if (string.equals(JVMenu.KEYBOARD_PRNTSCRN)) {
                this.app.OnKeyboardPrntScrn();
            } else if (string.equals(JVMenu.KEYBOARD_F1)) {
                this.app.OnKeyboardF1();
            } else if (string.equals(JVMenu.KEYBOARD_PAUSE)) {
                this.app.OnKeyboardPause();
            } else if (string.equals(JVMenu.KEYBOARD_FULL_KEYBOARD)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                this.app.OnKeyboardFullKeyboard(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.KEYBOARD_SOFT_KEYBOARD)) {
                this.app.OnSoftKeyboard();
            } else if (string.equals(JVMenu.MOUSE_SYNC_CURSOR)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                this.app.OnUSBMouseSyncCursor(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.MOUSE_SHOW_CURSOR)) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                this.app.OnShowCursor(jCheckBoxMenuItem.getState());
            } else if (string.equals(JVMenu.MOUSE_MODE_ABSOLUTE)) {
                this.app.OnMouseModeAbsolute();
            } else if (string.equals(JVMenu.MOUSE_MODE_RELATIVE)) {
                this.app.OnMouseModeRelative();
            } else if (string.equals(JVMenu.HELP_ABOUT_RCONSOLE)) {
                this.app.OnHelpAboutJViewer();
            } else if (string.equals(JVMenu.DEVICE_MEDIA_DIALOG)) {
                this.app.OnvMedia();
            } else if (string.equals(JVMenu.OPTIONS_COLORMODE_15BIT)) {
                this.app.OnChangeColorMode((byte)8);
            } else if (string.equals(JVMenu.OPTIONS_COLORMODE_7BIT)) {
                this.app.OnChangeColorMode((byte)9);
            } else if (string.equals(JVMenu.OPTIONS_COLORMODE_4BIT_COLOR)) {
                this.app.OnChangeColorMode((byte)10);
            } else if (string.equals(JVMenu.OPTIONS_COLORMODE_4BIT_GREY)) {
                this.app.OnChangeColorMode((byte)3);
            } else if (string.equals(JVMenu.OPTIONS_COLORMODE_3BIT_GREY)) {
                this.app.OnChangeColorMode((byte)2);
            }
        }
    }
}

