/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.SSLWrapper;
import com.ami.kvm.jviewer.hid.FragReader;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.hid.KVMReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public class FragNumReader
implements KVMReader {
    private KVMClient m_client;
    private ByteBuffer m_fragNumBuf;
    private int m_fragNumIx;

    public FragNumReader(KVMClient kVMClient) {
        this.m_client = kVMClient;
        this.m_fragNumBuf = ByteBuffer.allocate(2);
        this.m_fragNumBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_fragNumIx = 0;
    }

    @Override
    public void initialize() {
        this.m_fragNumIx = 0;
        this.m_fragNumBuf.clear();
    }

    @Override
    public int read(SocketChannel socketChannel, SSLWrapper sSLWrapper) {
        try {
            this.m_fragNumIx = sSLWrapper != null ? (this.m_fragNumIx += sSLWrapper.GetBytes(this.m_fragNumBuf)) : (this.m_fragNumIx += socketChannel.read(this.m_fragNumBuf));
            if (2 <= this.m_fragNumIx) {
                this.m_client.m_fragNum = this.m_fragNumBuf.getShort(0);
                FragReader fragReader = this.m_client.getFragReader();
                fragReader.initialize();
                this.m_client.setState(fragReader);
            }
        }
        catch (Exception exception) {
            Debug.out.println("ON_READ_FRAG_SZ " + exception);
            return -1;
        }
        return 0;
    }
}

