/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.SSLWrapper;
import com.ami.kvm.jviewer.hid.CtrlReader;
import com.ami.kvm.jviewer.hid.FragNumReader;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.hid.KVMReader;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class HeaderReader
implements KVMReader {
    private KVMClient m_client;
    private byte[] m_hdrBuf;
    private ByteBuffer m_hdrByteBuf;
    private IVTPPktHdr m_pktHdr;
    private int m_hdrIx;

    public HeaderReader(KVMClient kVMClient) {
        this.m_client = kVMClient;
        this.m_hdrBuf = new byte[7];
        this.m_hdrByteBuf = ByteBuffer.wrap(this.m_hdrBuf);
        this.m_pktHdr = new IVTPPktHdr();
        this.m_hdrIx = 0;
    }

    @Override
    public void initialize() {
        this.m_hdrIx = 0;
        this.m_hdrByteBuf.clear();
    }

    @Override
    public int read(SocketChannel socketChannel, SSLWrapper sSLWrapper) {
        try {
            this.m_hdrIx = sSLWrapper != null ? (this.m_hdrIx += sSLWrapper.GetBytes(this.m_hdrByteBuf)) : (this.m_hdrIx += socketChannel.read(this.m_hdrByteBuf));
            if (7 <= this.m_hdrIx) {
                this.m_pktHdr.set(this.m_hdrByteBuf);
                this.m_client.m_pktHdr = this.m_pktHdr;
                if (this.m_pktHdr.type == 3) {
                    FragNumReader fragNumReader = this.m_client.getFragNumReader();
                    fragNumReader.initialize();
                    this.m_client.setState(fragNumReader);
                } else if (this.m_pktHdr.pktSize > 0) {
                    CtrlReader ctrlReader = this.m_client.getCtrlReader();
                    ctrlReader.initialize();
                    this.m_client.setState(ctrlReader);
                } else {
                    this.m_client.onControlMessage();
                    HeaderReader headerReader = this.m_client.getHdrReader();
                    headerReader.initialize();
                    this.m_client.setState(headerReader);
                }
            }
        }
        catch (Exception exception) {
            Debug.out.println("HDR_RDR " + exception);
            return -1;
        }
        return 0;
    }
}

