/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class IVTPPktHdr {
    public static final int HDR_SIZE = 7;
    public static final int MAX_AVICA_PARAMS = 8;
    public static final int MAX_USERNAME_LEN = 32;
    public static final int STD_DIGEST_LEN = 16;
    public static final int MAX_CHALLENGE_LEN = 32;
    public static final byte ADVISER_LOGIN = 1;
    public static final byte DUMMY_LOGIN = 2;
    public static final byte ADVISER_VIDEO_FRAGMENT = 3;
    public static final byte ADVISER_HID_PKT = 4;
    public static final byte ADVISER_REFRESH_VIDEO_SCREEN = 5;
    public static final byte ADVISER_PAUSE_REDIRECTION = 6;
    public static final byte ADVISER_RESUME_REDIRECTION = 7;
    public static final byte ADVISER_BLANK_SCREEN = 8;
    public static final byte ADVISER_STOP_SESSION_IMMEDIATE = 9;
    public static final byte ADVISER_GET_USB_MOUSE_MODE = 10;
    public static final byte ADVISER_SET_COLOR_MODE = 11;
    public static final byte ADVISER_USER_AUTH = 12;
    public static final byte ADVISER_SESS_REQ = 13;
    public static final byte ADVISER_SESS_APPROVAL = 14;
    public static final byte ADVISER_SYNC_KEYBD_LED = 15;
    public static final byte ADVISER_WEB_SESSION = 32;
    public static final byte ADVISER_KEEPALIVE_REQ = 33;
    public static final byte ADVISER_KEEPALIVE_RES = 34;
    public static final short STATUS_SESS_CLOSE_UNKNOWN = 0;
    public static final short STATUS_SESS_CLOSE_MAX_SESS_REACHED = 1;
    public static final short STATUS_SESS_CLOSE_CONF_FILE_CHANGED = 2;
    public static final short STATUS_SESS_CLOSE_WRONG_PORT = 3;
    public static final short STATUS_SESS_CLOSE_REDIR_DISABLED = 4;
    public static final short STATUS_SESS_CLOSE_AUTH_FAILED = 5;
    public static final short STATUS_SESS_CLOSE_PERM_DENIED = 6;
    public static final short STATUS_SESS_WEB_LOGOUT = 7;
    public static final byte AUTH_SESSION_TOKEN = 0;
    public static final byte AUTH_SESS_TOKEN_PKT_SIZE = 18;
    public static final byte AUTH_USER_PKT_SIZE = 99;
    public static final byte AUTH_PKT_MAX_SIZE = 99;
    public static final int ADVISER_CLIENT = 1;
    public static final int ADVISER_SERVER = 0;
    public static final short CAPTURE_FRAME_BIT = 1;
    public static final short CAPTURE_EVEN_FRAME = 0;
    public static final short CAPTURE_ODD_FRAME = 1;
    public static final short CAPTURE_CLEAR_BUFFER = 2;
    public static final short INIT_QLZW = 4;
    public static final short ENCRYPTION_ENABLED = 255;
    public static final byte SESSION_TOKEN_LEN = 16;
    public static final byte HASH_SIZE = 16;
    public byte type;
    public int pktSize;
    public short status;
    private ByteBuffer m_buf;

    public IVTPPktHdr() {
        this(0, 0, 0);
    }

    public IVTPPktHdr(byte by, int n, short s) {
        this.type = by;
        this.pktSize = n;
        this.status = s;
        byte[] byArray = new byte[7];
        this.m_buf = ByteBuffer.wrap(byArray);
        this.m_buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void set(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.flip();
        this.type = byteBuffer.get();
        this.pktSize = byteBuffer.getInt();
        this.status = byteBuffer.getShort();
    }

    public void setSize(int n) {
        this.pktSize = n;
    }

    public void setStatus(short s) {
        this.status = s;
    }

    public byte type() {
        return this.type;
    }

    public int pktSize() {
        return this.pktSize;
    }

    public short status() {
        return this.status;
    }

    public int size() {
        return 7;
    }

    public byte[] array() {
        this.m_buf.position(0);
        this.m_buf.put(this.type);
        this.m_buf.putInt(this.pktSize);
        this.m_buf.putShort(this.status);
        return this.m_buf.array();
    }
}

