/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.FontChooserDialog;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.util.ActionMulticaster;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;

public class FontChooser
implements WindowListener,
Serializable {
    public static final int OK = 1;
    public static final int CANCEL = 8;
    protected FontChooserDialog dialog;
    protected Frame frame;
    protected String title;
    protected Font value;
    protected transient ActionMulticaster actionMulticaster = new ActionMulticaster();
    protected int result;

    public FontChooser(Frame frame, String title, Font value) {
        this.frame = frame;
        this.title = title;
        this.value = value;
        if (frame != null) {
            this.dialog = new FontChooserDialog(frame, title, value);
        }
    }

    public FontChooser(Frame frame, String title) {
        this(frame, title, null);
    }

    public FontChooser(Frame frame) {
        this(frame, "", null);
    }

    public FontChooser() {
        this(null, "", null);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setValue(Font value) {
        this.value = value;
        if (this.dialog != null) {
            this.dialog.setValue(value);
        }
    }

    public Font getValue() {
        if (this.dialog != null) {
            this.value = this.dialog.getValue();
        }
        return this.value;
    }

    public void setResult(int i2) {
        this.result = i2;
        if (this.dialog != null) {
            this.dialog.setResult(this.result);
        }
    }

    public int getResult() {
        if (this.dialog != null) {
            this.result = this.dialog.getResult();
        }
        return this.result;
    }

    public void show() {
        this.setVisible(true);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.dialog == null) {
                if (this.frame == null) {
                    throw new IllegalStateException(Res._NoFrame);
                }
                this.dialog = new FontChooserDialog(this.frame, this.title, this.value);
                this.dialog.setResult(this.result);
                this.dialog.addWindowListener(this);
                this.dialog.addActionListener(this.actionMulticaster);
            }
            this.dialog.setVisible(true);
        } else if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.dialog != null ? this.dialog.isVisible() : false;
    }

    public void addActionListener(ActionListener l) {
        this.actionMulticaster.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionMulticaster.remove(l);
    }

    public void windowOpened(WindowEvent e2) {
    }

    public void windowClosing(WindowEvent e2) {
        this.value = this.dialog.getValue();
        this.result = this.dialog.getResult();
    }

    public void windowClosed(WindowEvent e2) {
        if (this.dialog != null) {
            this.value = this.dialog.getValue();
            this.result = this.dialog.getResult();
        }
        this.dialog = null;
        if (this.frame.isShowing()) {
            if (this.frame.getFocusOwner() != null) {
                this.frame.getFocusOwner().requestFocus();
            } else {
                this.frame.requestFocus();
            }
        }
    }

    public void windowIconified(WindowEvent e2) {
    }

    public void windowDeiconified(WindowEvent e2) {
    }

    public void windowActivated(WindowEvent e2) {
    }

    public void windowDeactivated(WindowEvent e2) {
    }
}

