/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.BeanPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;

public class GroupBox
extends BeanPanel
implements Serializable {
    static final LayoutManager defaultLayout = new FlowLayout();
    protected String label;
    protected String textureName;

    public GroupBox() {
        super(defaultLayout);
        this.label = "";
        this.focusAware = false;
    }

    public GroupBox(String label) {
        super(defaultLayout);
        this.label = label;
        this.focusAware = false;
    }

    public Dimension getPreferredSize() {
        Font f2;
        Dimension ps = super.getPreferredSize();
        if (this.label != null && !this.label.equals("") && (f2 = this.getFont()) != null) {
            FontMetrics fm = this.getFontMetrics(f2);
            ps.width = Math.max(ps.width, fm.stringWidth(this.label) + fm.getHeight() * 2);
        }
        return ps;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setLabel(String label) {
        this.label = label;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String path) {
        if (path != null && !path.equals("")) {
            Image i2 = ImageLoader.load(path, (Component)this);
            if (i2 == null) throw new IllegalArgumentException(path);
            ImageLoader.waitForImage(this, i2);
            this.textureName = path;
            this.setTexture(i2);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public Insets insets() {
        Font f2 = this.getFont();
        int inset = 0;
        if (f2 != null) {
            inset = this.getFontMetrics(f2).getHeight();
        }
        return new Insets(inset, inset, inset, inset);
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Font of = g2.getFont();
        Font f2 = this.getFont();
        g2.setFont(f2);
        FontMetrics fm = g2.getFontMetrics(f2);
        int ascent = fm.getAscent();
        int ww = ascent / 2 + 1;
        Rectangle r = this.getBounds();
        if (r == null) {
            return;
        }
        int xs = ww;
        int ys = ww;
        int xe = r.width - ww - 1;
        int ye = r.height - ww - 1;
        g2.setColor(this.getForeground());
        g2.drawString(this.label, xs + xs, ascent);
        int tw = fm.stringWidth(this.label);
        for (int i2 = 1; i2 >= 0; --i2) {
            g2.setColor(i2 == 0 ? SystemColor.controlShadow : SystemColor.controlLtHighlight);
            g2.drawLine(xs + xs - 1, ys + i2, xs + i2, ys + i2);
            g2.drawLine(xs + i2, ys + i2, xs + i2, ye + i2);
            g2.drawLine(xs + i2, ye + i2, xe + i2, ye + i2);
            g2.drawLine(xe + i2, ye + i2, xe + i2, ys + i2);
            g2.drawLine(xe + i2, ys + i2, xs + xs + tw, ys + i2);
        }
        g2.setFont(of);
    }
}

