/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.editors;

import com.borland.jb.util.FastStringBuffer;
import com.borland.jbcl.editors.StringArrayEditorPanel;
import com.borland.jbcl.editors.StringEditor;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.table.TableCellEditor;

public class StringArrayEditor
implements PropertyEditor {
    static final String NULLSTRING = "null";
    StringArrayEditorPanel editorPanel = new StringArrayEditorPanel();
    PropertyChangeListener listener;
    String[] value;

    public void setValue(Object o) {
        if (this.editorPanel != null) {
            String[] sa = (String[])o;
            this.editorPanel.setItems(sa);
        }
    }

    public Object getValue() {
        if (this.editorPanel != null) {
            if (this.editorPanel.list.isEditing()) {
                TableCellEditor editor = this.editorPanel.list.getCellEditor();
                editor.stopCellEditing();
            }
            int size = this.editorPanel.model.getRowCount();
            this.value = new String[size];
            for (int i2 = 0; i2 < size; ++i2) {
                this.value[i2] = (String)this.editorPanel.list.getValueAt(i2, 0);
            }
        }
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g2, Rectangle box) {
    }

    public String getAsText() {
        return StringEditor.rawTextToDisplay(StringArrayEditor.stringArrayToText(this.value));
    }

    public String getJavaInitializationString() {
        return StringArrayEditor.javaInitializationForArrayOfStrings(this.value);
    }

    public static final String javaInitializationForArrayOfStrings(String[] strings) {
        if (strings == null || strings.length == 0) {
            return NULLSTRING;
        }
        int lineLength = 0;
        FastStringBuffer fsb = new FastStringBuffer("new String[] {");
        for (int i2 = 0; i2 < strings.length; ++i2) {
            fsb.append(StringEditor.textToSource(strings[i2]));
            if (i2 + 1 < strings.length) {
                fsb.append(", ");
            }
            if (strings[i2] == null || (lineLength += strings[i2].length()) <= 92) continue;
            lineLength = 0;
            fsb.append("\n        ");
        }
        fsb.append("}");
        return fsb.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.value = StringArrayEditor.textToStringArray(text);
        this.editorPanel.setItems(this.value);
        this.editorPanel.checkButtons();
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.editorPanel == null) {
            this.editorPanel = new StringArrayEditorPanel();
        }
        this.editorPanel.checkButtons();
        return this.editorPanel;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "StringArrayEditor2???", null, this.value));
        }
    }

    private static final String stringArrayToText(String[] array) {
        FastStringBuffer fsb = new FastStringBuffer("");
        if (array != null) {
            for (int i2 = 0; i2 < array.length; ++i2) {
                fsb.append(array[i2] + "\n");
            }
        }
        return fsb.toString();
    }

    private static final String[] textToStringArray(String text) {
        int end;
        int textLength = text.length();
        int e2 = 0;
        int start = 0;
        while ((end = text.indexOf(10, start)) != -1) {
            start = end + 1;
            ++e2;
        }
        if (start < text.length()) {
            ++e2;
        }
        String[] array = new String[e2];
        start = 0;
        e2 = 0;
        while ((end = text.indexOf(10, start)) != -1) {
            array[e2] = text.substring(start, end);
            start = end + 1;
            ++e2;
        }
        if (start < text.length()) {
            array[e2] = text.substring(start);
        }
        return array;
    }
}

