/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.sql.monitor;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.DriverManager;
import javax.swing.JTextArea;

class TextAreaStream
extends PrintStream {
    JTextArea textArea;
    boolean enabled = false;
    int maxLength = 8096;
    int length = 0;

    public TextAreaStream(JTextArea textArea) {
        super(new ByteArrayOutputStream());
        this.textArea = textArea;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            DriverManager.setLogStream(this);
        } else {
            DriverManager.setLogStream(null);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    void resetLength() {
        this.length = 0;
    }

    public void println(String string) {
        if (this.enabled) {
            int appendLen = string.length() + 1;
            if (this.length + appendLen > this.maxLength) {
                this.textArea.replaceRange("", 0, appendLen);
                this.length = this.maxLength;
            } else {
                this.length += appendLen;
            }
            this.textArea.append(string + "\n");
        }
    }

    public void print(String string) {
        if (this.enabled) {
            int appendLen = string.length();
            if (this.length + appendLen > this.maxLength) {
                this.textArea.replaceRange("", 0, appendLen);
                this.length = this.maxLength;
            } else {
                this.length += appendLen;
            }
            this.textArea.append(string);
        }
    }

    public void print(int i2) {
        this.print(String.valueOf(i2));
    }

    public void print(boolean b2) {
        this.print(b2 ? "true" : "false");
    }

    public void print(float f2) {
        this.print(String.valueOf(f2));
    }

    public void print(char c2) {
        this.print(String.valueOf(c2));
    }

    public void println() {
        this.print("\n");
    }

    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    public void print(double d2) {
        this.print(String.valueOf(d2));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void println(Object x) {
        this.print(x);
        this.println();
    }

    public void write(int b2) {
        this.print(b2);
    }

    public void print(char[] parm1) {
        this.print(new String(parm1));
    }

    public void println(int x) {
        this.print(x);
        this.println();
    }

    public void println(double x) {
        this.print(x);
        this.println();
    }

    public void write(byte[] parm1, int parm2, int parm3) {
        this.print(new String(parm1, parm2, parm3));
    }

    public void println(boolean x) {
        this.print(x);
        this.println();
    }

    public void println(float x) {
        this.print(x);
        this.println();
    }

    public void println(char x) {
        this.print(x);
        this.println();
    }

    public void println(long x) {
        this.print(x);
        this.println();
    }
}

