/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.Variant;
import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.view.BorderItemPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;

public class CheckboxItemPainter
implements ItemPainter,
Serializable {
    public static final int CHECKMARK = 1;
    public static final int XMARK = 2;
    protected BorderItemPainter border = new BorderItemPainter(9);
    protected Dimension boxSize = new Dimension(13, 13);
    protected int checkStyle = 1;
    protected boolean flat = false;
    protected boolean drawBox = true;

    public CheckboxItemPainter() {
    }

    public CheckboxItemPainter(Dimension boxSize) {
        if (boxSize != null) {
            this.boxSize = boxSize;
        }
    }

    public CheckboxItemPainter(Dimension boxSize, int checkStyle) {
        this(boxSize);
        this.checkStyle = checkStyle;
    }

    public CheckboxItemPainter(Dimension boxSize, int checkStyle, boolean flat) {
        this(boxSize, checkStyle);
        this.flat = flat;
    }

    public CheckboxItemPainter(Dimension boxSize, int checkStyle, boolean flat, boolean drawBox) {
        this(boxSize, checkStyle, flat);
        this.drawBox = drawBox;
    }

    public void setBoxSize(Dimension boxSize) {
        if (boxSize == null) {
            throw new IllegalArgumentException();
        }
        this.boxSize = boxSize;
    }

    public Dimension getBoxSize() {
        return new Dimension(this.boxSize.width + 2, this.boxSize.height + 2);
    }

    public void setStyle(int checkStyle) {
        if (checkStyle != 1 && checkStyle != 2) {
            throw new IllegalArgumentException();
        }
        this.checkStyle = checkStyle;
    }

    public int getStyle() {
        return this.checkStyle;
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setDrawBox(boolean drawBox) {
        this.drawBox = drawBox;
    }

    public boolean isDrawBox() {
        return this.drawBox;
    }

    public Dimension getPreferredSize(Object data, Graphics g2, int state, ItemPaintSite site) {
        return new Dimension(this.boxSize);
    }

    protected boolean isChecked(Object data, int state, ItemPaintSite site) {
        boolean checked = false;
        if (data instanceof Boolean) {
            checked = (Boolean)data;
        } else if (data instanceof Variant) {
            checked = ((Variant)data).getType() == 11 ? ((Variant)data).getBoolean() : Boolean.valueOf(data.toString()).booleanValue();
        } else if (data instanceof String) {
            checked = Boolean.valueOf((String)data);
        } else if (data instanceof Integer) {
            checked = !data.equals(new Integer(0));
        }
        return checked;
    }

    public void paint(Object data, Graphics g2, Rectangle rect, int state, ItemPaintSite site) {
        int align;
        Insets m;
        Color oc = g2.getColor();
        Insets insets = m = site != null ? site.getItemMargins() : new Insets(1, 1, 1, 1);
        if (m == null) {
            m = new Insets(1, 1, 1, 1);
        }
        Rectangle boxRect = new Rectangle(rect.x + m.left, rect.y + m.top, this.boxSize.width, this.boxSize.height);
        int n = align = site != null ? site.getAlignment() : 34;
        if (align == 0) {
            align = 34;
        }
        int hAlign = 0xF & align;
        switch (hAlign) {
            case 2: {
                boxRect.x = rect.x + (rect.width - this.boxSize.width) / 2;
                break;
            }
            case 3: {
                boxRect.x = rect.x + rect.width - this.boxSize.width - m.right;
                break;
            }
            case 4: {
                boxRect.width = rect.width - m.left - m.right;
            }
        }
        int vAlign = 0xF0 & align;
        switch (vAlign) {
            case 32: {
                boxRect.y = rect.y + (rect.height - this.boxSize.height) / 2;
                break;
            }
            case 48: {
                boxRect.y = rect.y + rect.height - this.boxSize.height - m.bottom;
                break;
            }
            case 64: {
                boxRect.height = rect.height - m.top - m.bottom;
            }
        }
        if (site != null && !site.isTransparent()) {
            g2.setColor(site.getBackground());
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.drawBox) {
            this.drawBox(g2, boxRect.x, boxRect.y, boxRect.width, boxRect.height, state);
        }
        if (this.isChecked(data, state, site)) {
            if (this.flat) {
                this.drawCheck(g2, boxRect.x + 1, boxRect.y + 1, boxRect.width - 2, boxRect.height - 2, state);
            } else {
                this.drawCheck(g2, boxRect.x + 2, boxRect.y + 2, boxRect.width - 4, boxRect.height - 4, state);
            }
        }
        g2.setColor(oc);
    }

    protected void drawBox(Graphics g2, int x, int y, int w, int h2, int state) {
        if (this.flat) {
            g2.setColor((state & 1) != 0 ? SystemColor.controlShadow : Color.black);
            g2.drawRect(x, y, w - 1, h2 - 1);
        } else {
            if (SystemColor.control.equals(g2.getColor())) {
                this.border.setFlags(4096);
            } else {
                this.border.setFlags(0);
            }
            this.border.paint(null, g2, new Rectangle(x, y, w, h2), 0, null);
        }
        g2.setColor((state & 1) != 0 ? SystemColor.control : SystemColor.window);
        if (this.flat) {
            g2.fillRect(x + 1, y + 1, w - 2, h2 - 2);
        } else {
            g2.fillRect(x + 2, y + 2, w - 4, h2 - 4);
        }
    }

    protected void drawCheck(Graphics g2, int x, int y, int w, int h2, int state) {
        ++x;
        ++y;
        g2.setColor((state & 1) != 0 ? SystemColor.controlShadow : SystemColor.windowText);
        if (this.checkStyle == 1) {
            int thickness = h2 / 3;
            int xbase = x + w / 3 - 1;
            for (int t = 1; t <= thickness; ++t) {
                g2.drawLine(xbase, y + h2 - t - 2, x, y + thickness - t + h2 / 2 - 2);
                g2.drawLine(xbase, y + h2 - t - 2, x + w - 3, y + thickness - t);
            }
        } else if (this.checkStyle == 2) {
            g2.drawLine(x, y, x + w - 3, y + h2 - 3);
            g2.drawLine(x + 1, y, x + w - 3, y + h2 - 4);
            g2.drawLine(x, y + 1, x + w - 4, y + h2 - 3);
            g2.drawLine(x, y + h2 - 3, x + w - 3, y);
            g2.drawLine(x + 1, y + h2 - 3, x + w - 3, y + 1);
            g2.drawLine(x, y + h2 - 4, x + w - 4, y);
        }
    }
}

