/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Date;
import javax.swing.JComboBox;

public class JComboBoxItemEditor
extends JComboBox
implements ItemEditor,
KeyListener,
Serializable {
    public JComboBoxItemEditor() {
        this.setLightWeightPopupEnabled(false);
        this.setBounds(0, 0, 0, 0);
        this.setVisible(false);
        this.addKeyListener(this);
    }

    public JComboBoxItemEditor(String[] items) {
        this();
        this.removeAllItems();
        for (int i2 = 0; i2 < items.length; ++i2) {
            this.addItem(items[i2]);
        }
    }

    public Object getValue() {
        return this.getSelectedItem();
    }

    public Component getComponent() {
        return this;
    }

    public void startEdit(Object data, Rectangle bounds, ItemEditSite site) {
        Point clickPoint;
        if (data != null) {
            this.setSelectedItem(data.toString());
        }
        this.changeBounds(bounds);
        if (site != null) {
            this.setBackground(site.getBackground());
            this.setForeground(site.getForeground());
            this.setFont(site.getFont());
        }
        this.setVisible(true);
        this.requestFocus();
        Point point = clickPoint = site != null ? site.getEditClickPoint() : null;
        if (clickPoint != null) {
            this.dispatchEvent(new MouseEvent(site.getSiteComponent(), 501, new Date().getTime(), 0, 0, 0, 1, false));
        }
    }

    public void changeBounds(Rectangle bounds) {
        FontMetrics fm;
        int height = 0;
        Font f2 = this.getFont();
        Graphics g2 = this.getGraphics();
        FontMetrics fontMetrics = fm = f2 != null && g2 != null ? g2.getFontMetrics(f2) : null;
        if (fm != null) {
            height = fm.getHeight() * (this.getItemCount() < 6 ? this.getItemCount() : 6);
        }
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height < height ? bounds.height : height);
    }

    public boolean canPost() {
        return true;
    }

    public void endEdit(boolean post) {
        this.setBounds(0, 0, 0, 0);
        this.setVisible(false);
    }

    public void keyPressed(KeyEvent e2) {
        int code = e2.getKeyCode();
        int sel = this.getSelectedIndex();
        switch (code) {
            case 40: {
                if (e2.isAltDown()) {
                    return;
                }
                if (sel < this.getItemCount() - 1) {
                    this.setSelectedIndex(sel + 1);
                }
                e2.consume();
                break;
            }
            case 38: {
                if (sel > 0) {
                    this.setSelectedIndex(sel - 1);
                }
                e2.consume();
            }
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void keyTyped(KeyEvent e2) {
        Object item = this.getSelectedItem();
        if (!(item instanceof String)) {
            return;
        }
        String current = item.toString();
        char c2 = e2.getKeyChar();
        char s = current.toLowerCase().charAt(0);
        int[] matches = new int[]{};
        if (c2 != '\uffff') {
            for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
                String value;
                item = this.getItemAt(i2);
                if (!(item instanceof String) || (value = item.toString()).length() <= 0 || value.charAt(0) != c2) continue;
                if (s != c2) {
                    this.setSelectedIndex(i2);
                    return;
                }
                int[] old = matches;
                matches = new int[old.length + 1];
                System.arraycopy(old, 0, matches, 0, old.length);
                matches[matches.length - 1] = i2;
            }
            if (matches.length > 0) {
                int sel = this.getSelectedIndex();
                for (int i3 = 0; i3 < matches.length; ++i3) {
                    if (matches[i3] > sel) {
                        this.setSelectedIndex(matches[i3]);
                        return;
                    }
                    if (i3 != matches.length - 1 || matches[i3] != sel) continue;
                    this.setSelectedIndex(matches[0]);
                    return;
                }
            }
        }
    }
}

