/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.SaslAuthenticator;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class IMAPSaslAuthenticator
implements SaslAuthenticator {
    private IMAPProtocol pr;
    private String name;
    private Properties props;
    private boolean debug;
    private PrintStream out;
    private String host;

    public IMAPSaslAuthenticator(IMAPProtocol iMAPProtocol, String string, Properties properties, boolean bl, PrintStream printStream, String string2) {
        this.pr = iMAPProtocol;
        this.name = string;
        this.props = properties;
        this.debug = bl;
        this.out = printStream;
        this.host = string2;
    }

    public boolean authenticate(String[] stringArray, String string, String string2, String string3, String string4) throws ProtocolException {
        Object object;
        SaslClient saslClient;
        Vector<Response> vector = new Vector<Response>();
        String string5 = null;
        Response response = null;
        boolean bl = false;
        if (this.debug) {
            this.out.print("IMAP SASL DEBUG: Mechanisms:");
            for (int k = 0; k < stringArray.length; ++k) {
                this.out.print(" " + stringArray[k]);
            }
            this.out.println();
        }
        final String string6 = string;
        final String string7 = string3;
        final String string8 = string4;
        CallbackHandler callbackHandler = new CallbackHandler(){

            public void handle(Callback[] callbackArray) {
                if (IMAPSaslAuthenticator.this.debug) {
                    IMAPSaslAuthenticator.this.out.println("IMAP SASL DEBUG: callback length: " + callbackArray.length);
                }
                block0: for (int k = 0; k < callbackArray.length; ++k) {
                    Callback callback;
                    if (IMAPSaslAuthenticator.this.debug) {
                        IMAPSaslAuthenticator.this.out.println("IMAP SASL DEBUG: callback " + k + ": " + callbackArray[k]);
                    }
                    if (callbackArray[k] instanceof NameCallback) {
                        callback = (NameCallback)callbackArray[k];
                        ((NameCallback)callback).setName(string7);
                        continue;
                    }
                    if (callbackArray[k] instanceof PasswordCallback) {
                        callback = (PasswordCallback)callbackArray[k];
                        ((PasswordCallback)callback).setPassword(string8.toCharArray());
                        continue;
                    }
                    if (callbackArray[k] instanceof RealmCallback) {
                        callback = (RealmCallback)callbackArray[k];
                        ((TextInputCallback)callback).setText(string6 != null ? string6 : ((TextInputCallback)callback).getDefaultText());
                        continue;
                    }
                    if (!(callbackArray[k] instanceof RealmChoiceCallback)) continue;
                    callback = (RealmChoiceCallback)callbackArray[k];
                    if (string6 == null) {
                        ((ChoiceCallback)callback).setSelectedIndex(((ChoiceCallback)callback).getDefaultChoice());
                        continue;
                    }
                    String[] stringArray = ((ChoiceCallback)callback).getChoices();
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        if (!stringArray[i2].equals(string6)) continue;
                        ((ChoiceCallback)callback).setSelectedIndex(i2);
                        continue block0;
                    }
                }
            }
        };
        try {
            saslClient = Sasl.createSaslClient(stringArray, string2, this.name, this.host, this.props, callbackHandler);
        }
        catch (SaslException saslException) {
            if (this.debug) {
                this.out.println("IMAP SASL DEBUG: Failed to create SASL client: " + saslException);
            }
            return false;
        }
        if (saslClient == null) {
            if (this.debug) {
                this.out.println("IMAP SASL DEBUG: No SASL support");
            }
            return false;
        }
        if (this.debug) {
            this.out.println("IMAP SASL DEBUG: SASL client " + saslClient.getMechanismName());
        }
        try {
            string5 = this.pr.writeCommand("AUTHENTICATE " + saslClient.getMechanismName(), null);
        }
        catch (Exception exception) {
            if (this.debug) {
                this.out.println("IMAP SASL DEBUG: AUTHENTICATE Exception: " + exception);
            }
            return false;
        }
        OutputStream outputStream = this.pr.getIMAPOutputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[]{13, 10};
        while (!bl) {
            try {
                response = this.pr.readResponse();
                if (response.isContinuation()) {
                    object = response.readByteArray().getNewBytes();
                    if (((Response[])object).length > 0) {
                        object = BASE64DecoderStream.decode((byte[])object);
                    }
                    if (this.debug) {
                        this.out.println("IMAP SASL DEBUG: challenge: " + ASCIIUtility.toString((byte[])object, 0, ((Response[])object).length) + " :");
                    }
                    object = saslClient.evaluateChallenge((byte[])object);
                    bl = saslClient.isComplete();
                    if (object == null) {
                        if (this.debug) {
                            this.out.println("IMAP SASL DEBUG: no response");
                        }
                        bl = true;
                        outputStream.write(byArray);
                        outputStream.flush();
                        byteArrayOutputStream.reset();
                        continue;
                    }
                    if (this.debug) {
                        this.out.println("IMAP SASL DEBUG: response: " + ASCIIUtility.toString((byte[])object, 0, ((Response[])object).length) + " :");
                    }
                    object = BASE64EncoderStream.encode((byte[])object);
                    byteArrayOutputStream.write((byte[])object);
                    byteArrayOutputStream.write(byArray);
                    outputStream.write(byteArrayOutputStream.toByteArray());
                    outputStream.flush();
                    byteArrayOutputStream.reset();
                    continue;
                }
                if (response.isTagged() && response.getTag().equals(string5)) {
                    bl = true;
                    continue;
                }
                if (response.isBYE()) {
                    bl = true;
                    continue;
                }
                vector.addElement(response);
            }
            catch (Exception exception) {
                if (this.debug) {
                    exception.printStackTrace();
                }
                response = Response.byeResponse(exception);
                bl = true;
            }
        }
        if (saslClient.isComplete() && (object = (String)saslClient.getNegotiatedProperty("javax.security.sasl.qop")) != null && (object.equalsIgnoreCase("auth-int") || object.equalsIgnoreCase("auth-conf"))) {
            if (this.debug) {
                this.out.println("IMAP SASL DEBUG: Mechanism requires integrity or confidentiality");
            }
            return false;
        }
        object = new Response[vector.size()];
        vector.copyInto((Object[])object);
        this.pr.notifyResponseHandlers((Response[])object);
        this.pr.handleResult(response);
        return true;
    }
}

