/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.EasySSLProtocolSocketFactory;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.LogFactory;

public class ATENFlash
implements IPMIDCMOEMCommand.Progress {
    MOut mout = MOut.G();
    int preserveConfigFlag = 1;
    public static final String FLASH_VERSION = "V1.3";
    IPMIDCMOEMCommand.Progress progress;
    int valueBak = -1;

    public int getPreserveConfigFlag() {
        return this.preserveConfigFlag;
    }

    public void setPreserveConfigFlag(int preserveConfigFlag) {
        this.preserveConfigFlag = preserveConfigFlag;
    }

    public void setMOut(MOut mout) {
        this.mout = mout;
    }

    private void API____________() {
    }

    public void flashWorker(String ip, String userName, String password, String filename) throws Exception {
        EasySSLProtocolSocketFactory easySSL = null;
        try {
            easySSL = new EasySSLProtocolSocketFactory();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)easySSL, 443);
        Protocol.registerProtocol("https", easyhttps);
        File firmware = new File(filename);
        this.progress.setValue(0);
        HttpClient client = new HttpClient();
        client.getHostConfiguration().setHost(ip, 80, "http");
        client.getParams().setCookiePolicy("compatibility");
        client.getParams().setParameter("http.socket.timeout", new Integer(200000));
        LogFactory.getFactory();
        LogFactory.releaseAll();
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showsdatetime", "false");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire.header", "ERROR");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "ERROR");
        System.setProperty("log4j.logger.org.apache.commons.httpclient", "ERROR");
        GetMethod authGet = new GetMethod("/");
        PostMethod authPost = new PostMethod("/cgi/login.cgi");
        authPost.getParams().setBooleanParameter("http.protocol.expect-continue", false);
        NameValuePair username = new NameValuePair("name", userName);
        NameValuePair passwd = new NameValuePair("pwd", password);
        authPost.setRequestBody(new NameValuePair[]{username, passwd});
        PostMethod filePost = new PostMethod("/cgi/firmware_upload.cgi");
        filePost.getParams().setBooleanParameter("http.protocol.expect-continue", false);
        try {
            boolean result;
            boolean result2;
            int retry;
            InetAddress address = InetAddress.getByName(ip);
            for (retry = 10; retry > 0 && !(result2 = address.isReachable(3000)); --retry) {
            }
            if (retry == 0) {
                this.progress.message("Connect Failed");
                return;
            }
            client.executeMethod(authGet);
            authGet.releaseConnection();
            client.executeMethod(authPost);
            authPost.releaseConnection();
            this.progress.message("Uploading...");
            StringPart f2 = new StringPart("FileType", "3");
            f2.setTransferEncoding(null);
            f2.setContentType(null);
            StringPart f22 = new StringPart("preserve_config", "" + this.preserveConfigFlag);
            f22.setTransferEncoding(null);
            f22.setContentType(null);
            FilePart k = new FilePart("FS_Whatever", firmware);
            k.setCharSet(null);
            k.setTransferEncoding(null);
            Part[] parts = new Part[]{f2, f22, k};
            filePost.setRequestEntity(new MultipartRequestEntity(parts, filePost.getParams()));
            client.executeMethod(filePost);
            InputStream in = filePost.getResponseBodyAsStream();
            int len = in.available();
            int offset = 0;
            int ret = 0;
            byte[] buf = new byte[in.available()];
            while ((ret = in.read(buf, offset, len - offset)) > 0) {
                offset += ret;
            }
            String resp = new String(buf);
            if (resp.indexOf("File type mismatch!") != -1) {
                this.progress.message("File_Mismatch!");
                return;
            }
            if (resp.indexOf("Other user is upgrading!") != -1) {
                this.progress.message("Concurrent Update!");
                return;
            }
            this.progress.setValue(9999);
            filePost.releaseConnection();
            this.progress.message("Updating...");
            client = new HttpClient();
            client.getHostConfiguration().setHost(ip, 80, "http");
            client.getParams().setCookiePolicy("compatibility");
            client.getParams().setParameter("http.socket.timeout", new Integer(200000));
            authPost = new PostMethod("/cgi/login.cgi");
            authPost.getParams().setBooleanParameter("http.protocol.expect-continue", false);
            authPost.setRequestBody(new NameValuePair[]{username, passwd});
            client.executeMethod(authPost);
            authPost.releaseConnection();
            int i2 = 0;
            while (i2 != 100) {
                GetMethod progressGet = new GetMethod("/cgi/upgrade_process.cgi");
                client.executeMethod(progressGet);
                resp = progressGet.getResponseBodyAsString();
                progressGet.releaseConnection();
                i2 = Integer.valueOf(resp.substring(resp.indexOf("<percent>") + "<percent>".length(), resp.indexOf("</percent")).trim());
                this.progress.setValue(i2);
                Thread.sleep(500L);
            }
            this.progress.message("Resetting BMC");
            for (retry = 20; retry > 0 && !(result = address.isReachable(3000)); --retry) {
            }
            if (retry == 0) {
                this.progress.message("BMC IP cannot reach. Please check BMC IP at local");
            } else {
                this.progress.message("Done. (BMC needs 1 minute to restart)");
            }
        }
        catch (HttpException he) {
            this.mout.println("HttpException");
            throw he;
        }
        catch (FileNotFoundException fnfe) {
            this.mout.println("FileNotFoundException");
            throw fnfe;
        }
        catch (IOException ioe) {
            this.mout.println("IOException");
            throw ioe;
        }
        catch (InterruptedException ie) {
            this.mout.println("InterruptedException");
            throw ie;
        }
    }

    public String checkFirmwareVersion(String filename) throws Exception {
        File firmware = new File(filename);
        if (firmware.length() == 0x1000000L) {
            return this.checkFirmwareVersionX9(filename);
        }
        if (firmware.length() > 0x1000000L) {
            return this.checkFirmwareVersionX10(filename);
        }
        throw new Exception("Invalid firmware");
    }

    public String checkFirmwareVersionX9(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte16 = new byte[16];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int i2 = 0;
        while ((long)i2 < firmware.length() / 65536L) {
            raf.seek((i2 + 1) * 65536 - 80);
            int count = raf.read(byte16);
            if (count != byte16.length) {
                raf.close();
                throw new Exception("File error");
            }
            if (byte16[3] == 65 && byte16[4] == 84 && byte16[5] == 69 && byte16[6] == 78) {
                version = byte16[11] + "." + ByteUtility.byteToHex(byte16[12]);
            }
            ++i2;
        }
        raf.close();
        if (version == null) {
            throw new Exception("File invalid");
        }
        if (version.equals("30.30")) {
            version = "00.00";
        }
        return version;
    }

    public String checkFirmwareVersionX10(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte16 = new byte[16];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int i2 = (int)(firmware.length() / 64L / 2L);
        while ((long)i2 < firmware.length() / 64L - 1L) {
            raf.seek((i2 + 1) * 64);
            int count = raf.read(byte16);
            if (count != byte16.length) {
                raf.close();
                throw new Exception("File error");
            }
            if (byte16[0] == 65 && byte16[1] == 84 && byte16[2] == 69 && byte16[3] == 78) {
                version = byte16[8] + "." + ByteUtility.byteToHex(byte16[9]);
                break;
            }
            ++i2;
        }
        raf.close();
        if (version == null) {
            throw new Exception("File invalid");
        }
        return version;
    }

    @Override
    public void setValue(int value) {
        if (value == 9999) {
            this.mout.print("Done");
            return;
        }
        if (value == 0) {
            return;
        }
        if (this.valueBak != value) {
            this.mout.print(".");
            this.valueBak = value;
            if (value == 100) {
                this.mout.print("100%");
            }
        }
    }

    @Override
    public void message(String message) {
        this.mout.print("\n" + message);
    }

    @Override
    public void left(long value) {
    }

    public String getCurrentFWVersion(String ip, String username, String password) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        config.setPrivilege((byte)4);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiGlobalCommand);
        if (sessionController == null) {
            throw new Exception("Connect failed");
        }
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        sessionController.closeSession();
        return "" + ByteUtility.byteToHex(deviceInfo.firmwareRevision1) + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2);
    }

    public void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        this.mout.println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }

    public boolean flash(String ip, String id, String pw, String filename) {
        return this.flash(ip, id, pw, filename, 1);
    }

    public boolean flash(String ip, String id, String pw, String filename, int preserve_config) {
        long start = System.currentTimeMillis();
        ATENFlash atenFlash = new ATENFlash();
        atenFlash.progress = atenFlash;
        atenFlash.setMOut(this.mout);
        atenFlash.setPreserveConfigFlag(preserve_config);
        this.mout.print("Check firmware file...");
        String firmwareVersion = null;
        try {
            firmwareVersion = atenFlash.checkFirmwareVersion(filename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        this.mout.println(" Done (ver:" + firmwareVersion + ")");
        this.mout.print("Check BMC status...");
        String bmcVersion = null;
        try {
            bmcVersion = atenFlash.getCurrentFWVersion(ip, id, pw);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        this.mout.print(" Done (ver:" + bmcVersion + ")");
        try {
            atenFlash.flashWorker(ip, id, pw, filename);
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
            return false;
        }
        this.printTimeString("\nTotal Elapse Time", System.currentTimeMillis() - start);
        return true;
    }

    public static void main(String[] args) throws Exception {
        MessageCenter.getInstance().deleteObservers();
        ATENFlash atenFlash = new ATENFlash();
        atenFlash.progress = atenFlash;
        String firmwareVersion = null;
        try {
            firmwareVersion = atenFlash.checkFirmwareVersionX10("c:\\AST2400_all.bin");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println(" Done (ver:" + firmwareVersion + ")");
    }

    public IPMIDCMOEMCommand.Progress getProgress() {
        return this.progress;
    }

    public void setProgress(IPMIDCMOEMCommand.Progress progress) {
        this.progress = progress;
    }
}

