/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.FRU_Board;
import com.supermicro.ipmi.FRU_Chassis;
import com.supermicro.ipmi.FRU_Common;
import com.supermicro.ipmi.FRU_Internal;
import com.supermicro.ipmi.FRU_MultiRecord;
import com.supermicro.ipmi.FRU_Product;

public class FRU {
    public FRU_Common common = new FRU_Common();
    public FRU_Internal internal = new FRU_Internal();
    public FRU_Chassis chassis = new FRU_Chassis();
    public FRU_Board board = new FRU_Board();
    public FRU_Product product = new FRU_Product();
    public FRU_MultiRecord multiRecord = new FRU_MultiRecord();
    public boolean isInternalExist;
    public boolean isChassisExist;
    public boolean isBoardExist;
    public boolean isProductExist;
    public boolean isMultiRecordExist;

    public byte[] toRaw() {
        byte[] internalRaw = this.internal.toRaw();
        byte[] chassisRaw = this.chassis.toRaw();
        byte[] boardRaw = this.board.toRaw();
        byte[] productRaw = this.product.toRaw();
        byte[] multiRecordRaw = this.multiRecord.toRaw();
        int size = 8 + (this.isInternalExist ? internalRaw.length : 0) + (this.isChassisExist ? chassisRaw.length : 0) + (this.isBoardExist ? boardRaw.length : 0) + (this.isProductExist ? productRaw.length : 0) + (this.isMultiRecordExist ? multiRecordRaw.length : 0);
        if (size % 8 != 0) {
            size += 8 - size % 8;
        }
        byte[] raw = new byte[size];
        byte fieldIndex = 0;
        this.common.internalUseArea = this.isInternalExist ? (fieldIndex = 1) : (byte)0;
        this.common.chassisInfoArea = this.isChassisExist ? (fieldIndex = (byte)(fieldIndex + internalRaw.length / 8)) : (byte)0;
        this.common.boardInfoArea = this.isBoardExist ? (fieldIndex = (byte)(fieldIndex + chassisRaw.length / 8)) : (byte)0;
        this.common.productInfoArea = this.isProductExist ? (fieldIndex = (byte)(fieldIndex + boardRaw.length / 8)) : (byte)0;
        this.common.multiRecordArea = this.isMultiRecordExist ? (fieldIndex = (byte)(fieldIndex + productRaw.length / 8)) : (byte)0;
        byte[] commonRaw = this.common.toRaw();
        int index = 0;
        System.arraycopy(commonRaw, 0, raw, index, commonRaw.length);
        index += commonRaw.length;
        if (this.isInternalExist) {
            System.arraycopy(internalRaw, 0, raw, index, internalRaw.length);
            index += internalRaw.length;
        }
        if (this.isChassisExist) {
            System.arraycopy(chassisRaw, 0, raw, index, chassisRaw.length);
            index += chassisRaw.length;
        }
        if (this.isBoardExist) {
            System.arraycopy(boardRaw, 0, raw, index, boardRaw.length);
            index += boardRaw.length;
        }
        if (this.isProductExist) {
            System.arraycopy(productRaw, 0, raw, index, productRaw.length);
            index += productRaw.length;
        }
        if (this.isMultiRecordExist) {
            System.arraycopy(multiRecordRaw, 0, raw, index, multiRecordRaw.length);
            index += multiRecordRaw.length;
        }
        return raw;
    }
}

